/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsNewObjectWiz;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsNewObjectProvider;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsEventListener;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEventListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class PsNewObjectWizPage2
extends WizPage
implements MandatoryAttributeEventListener,
InvalidCharsEventListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsNewObjectWizPage2.java";
    private PropertyControl propertyControl = null;
    private PsNewObjectWiz wizard = null;
    private UiMQObject uiMQObject = null;
    private NewObjectProvider newObjectProvider = null;
    private static final int NUM_COLS = 1;
    private Hashtable<Integer, MandatoryAttributeEvent> missingMandatoryAttrEvents = new Hashtable();
    private Hashtable<String, InvalidCharsAttributeEvent> invalidCharsAttrEvents = new Hashtable();
    private Message msgFile;

    public PsNewObjectWizPage2(Trace t, String pageName) {
        super(pageName);
    }

    public PsNewObjectWizPage2(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private void setHeadingsInfo(Trace t) {
        this.msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_NewObject");
        this.wizard = (PsNewObjectWiz)this.getWizard();
        int index = this.wizard.getPageIndex((IWizardPage)this);
        this.newObjectProvider = this.wizard.getNewObjectProvider();
        String title = ((PsNewObjectProvider)this.newObjectProvider).getWizardPageTitle(t, null, index);
        String description = ((PsNewObjectProvider)this.newObjectProvider).getWizardPageDescription(t, null, index);
        super.setHeadings(title, description);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.setHeadingsInfo(t);
        this.propertyControl = new PropertyControl(t, parent, 0, false, false, false);
        this.propertyControl.addMandatoryAttributeEventListener(t, (MandatoryAttributeEventListener)this);
        this.propertyControl.addInvalidCharsEventListener(t, (InvalidCharsEventListener)this);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.propertyControl.setLayoutData((Object)gridData);
        this.propertyControl.layout();
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        DmObject dmObject = (DmObject)this.uiMQObject.getDmObject();
        boolean result = this.wizard.createObject(t, dmObject, this.propertyControl);
        return result;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean isEnableNext = false;
        boolean isEnableFinish = this.missingMandatoryAttrEvents.isEmpty() && this.invalidCharsAttrEvents.isEmpty();
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons(t);
    }

    public void nextPressed() {
    }

    public void setVisible(boolean visible) {
        UiMQObject uiMQObj;
        super.setVisible(visible);
        Trace t = Trace.getDefault();
        if (visible && (uiMQObj = this.wizard.getNewUiMQObject()) != this.uiMQObject) {
            this.uiMQObject = uiMQObj;
            this.propertyControl.setObject(t, this.uiMQObject, -1);
        }
    }

    public void attributeValueMissing(MandatoryAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.addToMissingMandatoryAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }

    public void attributeValuePresent(MandatoryAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.removeFromMissingMandatoryAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }

    private void addToMissingMandatoryAttrEvents(Trace t, MandatoryAttributeEvent event) {
        Integer key = event.getAttributeId();
        if (!this.missingMandatoryAttrEvents.containsKey(key)) {
            this.missingMandatoryAttrEvents.put(key, event);
        }
    }

    private void removeFromMissingMandatoryAttrEvents(Trace t, MandatoryAttributeEvent event) {
        Integer key = event.getAttributeId();
        if (this.missingMandatoryAttrEvents.containsKey(key)) {
            this.missingMandatoryAttrEvents.remove(key);
        }
    }

    private void updateErrorMessage(Trace t) {
        if (!this.invalidCharsAttrEvents.isEmpty()) {
            Enumeration<String> keys = this.invalidCharsAttrEvents.keys();
            String key = keys.nextElement();
            InvalidCharsAttributeEvent event = this.invalidCharsAttrEvents.get(key);
            this.setErrorMessage(Message.format((String)this.msgFile.getMessage(t, "UI.NewObject.Wizard.InvalidChars"), (String)event.getAttributeName()));
        } else if (this.missingMandatoryAttrEvents.isEmpty()) {
            this.setErrorMessage(null);
        } else {
            Enumeration<Integer> keys = this.missingMandatoryAttrEvents.keys();
            Integer key = keys.nextElement();
            MandatoryAttributeEvent event = this.missingMandatoryAttrEvents.get(key);
            this.setErrorMessage(Message.format((String)this.msgFile.getMessage(t, "UI.NewObject.Wizard.ValueRequired"), (String)event.getAttributeName()));
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    private void addToInvalidCharsAttrEvents(Trace t, InvalidCharsAttributeEvent event) {
        String key = event.getAttributeName();
        if (!this.invalidCharsAttrEvents.containsKey(key)) {
            this.invalidCharsAttrEvents.put(key, event);
        }
    }

    private void removeFromInvalidCharsAttrEvents(Trace t, InvalidCharsAttributeEvent event) {
        String key = event.getAttributeName();
        if (this.invalidCharsAttrEvents.containsKey(key)) {
            this.invalidCharsAttrEvents.remove(key);
        }
    }

    public void invalidCharsPresent(InvalidCharsAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.addToInvalidCharsAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }

    public void invalidCharsAbsent(InvalidCharsAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.removeFromInvalidCharsAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }
}

