/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsNewObjectProvider;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.CreateDmObject;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizDlg;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class PsNewObjectWiz
extends Wizard {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsNewObjectWiz.java";
    private NewObjectProvider newObjectProvider = null;
    private boolean enableFinish = false;
    private NewObjectWizDlg newObjectWizDlg = null;
    private WizPage[] pages;
    private UiMQObject newUiMQObject = null;
    private int[] mandatoryAttrIds = null;

    public PsNewObjectWiz(Trace t, NewObjectProvider newObjProvider) {
        this.newObjectProvider = newObjProvider;
        if (this.newObjectProvider instanceof PsNewObjectProvider) {
            this.pages = ((PsNewObjectProvider)this.newObjectProvider).getPages(t);
        }
        String title = this.newObjectProvider.getWizardTitle(t, null);
        this.mandatoryAttrIds = this.newObjectProvider.getMandatoryAttributeIds(t, null);
        this.setWindowTitle(title);
    }

    public boolean performFinish() {
        WizPage page = (WizPage)this.newObjectWizDlg.getCurrentPage();
        return page.performFinish();
    }

    public void updateButtons(Trace t) {
        if (this.newObjectWizDlg == null) {
            this.newObjectWizDlg = (NewObjectWizDlg)this.getContainer();
        }
        this.newObjectWizDlg.updateButtons();
    }

    public void addPages() {
        int i = 0;
        while (i < this.pages.length) {
            this.addPage((IWizardPage)this.pages[i]);
            ++i;
        }
        this.setNeedsProgressMonitor(true);
    }

    public UiMQObject getNewUiMQObject() {
        return this.newUiMQObject;
    }

    public void setNewUiMQObject(UiMQObject object) {
        this.newUiMQObject = object;
    }

    public NewObjectProvider getNewObjectProvider() {
        return this.newObjectProvider;
    }

    public int getPageIndex(IWizardPage page) {
        int index = -1;
        int i = 0;
        while (i < this.pages.length) {
            if (this.pages[i] == page) {
                index = i;
                return index;
            }
            ++i;
        }
        return index;
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public boolean createObject(Trace t, DmObject dmObject, PropertyControl propertyControl) {
        boolean result = false;
        DmActionEvent dmActionEvent = null;
        String taskName = "";
        taskName = this.newObjectProvider.getWizardCreatingTaskText(t, null);
        CreateDmObject createDmObject = new CreateDmObject(t, (IDmObject)dmObject, propertyControl, taskName);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)createDmObject);
            dmActionEvent = createDmObject.getDmActionEvent();
            if (dmActionEvent.getReasonCode() == 0) {
                MessageBox.showSystemMessageById((Trace)t, (Shell)this.getShell(), (String)"AMQ4148");
                result = true;
            } else {
                String error = null;
                error = PsError.getErrorMsg(t, dmActionEvent.getReasonCode());
                if (error != null) {
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)error);
                } else {
                    DmCoreException dmCoreException = dmActionEvent.getException();
                    if (dmCoreException != null) {
                        MessageBox.showExceptionMessage((Trace)t, (Shell)this.getShell(), (DmCoreException)dmCoreException);
                    } else {
                        String sysMsgId = CommonServices.getSystemMessageId((Trace)t, (int)dmActionEvent.getReasonCode());
                        String sysMsg = CommonServices.getSystemMessage((Trace)t, (String)sysMsgId);
                        MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)sysMsg, (String)sysMsgId);
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            t.FFST(66, "PsNewObjectWiz.createObject", 10, 50037, 0, 0, "InvocationTragetException", e.getMessage(), null);
        }
        catch (InterruptedException e) {
            t.FFST(66, "PsNewObjectWiz.createObject", 20, 50038, 0, 0, "InterruptedException", e.getMessage(), null);
        }
        return result;
    }

    public int[] getMandatoryAttrIds() {
        return this.mandatoryAttrIds;
    }
}

