/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsBrokerListener;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsEvent;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.internal.base.PsIcons;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.ui.internal.attr.details.PsTopicObjectAttributeOrderRegistrations;
import com.ibm.mq.explorer.pubsub.ui.internal.attr.details.PsTopicObjectFilterRegistrations;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBroker;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiTopicFilterProvider;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.views.MQContentView;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class PsTopicsContentPage
extends ContentPage
implements PsBrokerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/content/PsTopicsContentPage.java";
    private MQExtObject object = null;
    private static final int NUM_COLS = 12;
    private ContentTitleBar contentTitleBar = null;
    private PsBroker psBroker = null;
    protected ExplorerTable explorerTable = null;
    private ArrayList<Action> toolbarActions = null;
    private ArrayList<Action> menuActions = null;
    protected FilterProvider filterProvider = new PsUiTopicFilterProvider();
    private int listenDmObjectId = -1;
    private boolean showSystemObjectsChanged = false;
    private Label status = null;
    private Label imageLabel = null;
    private PsBroker listenPsBroker = null;
    private int listenObjectId = -1;
    private PsObject listenPsObject = null;
    private String listenTopicName = null;
    private boolean listenExactMatch = false;
    private FilterManager filterManager = UiPlugin.getFilterManager();
    private String instanceId = "";

    public PsTopicsContentPage(Composite parent, int style) {
        super(parent, style);
    }

    public void init() {
        Trace t = Trace.getDefault();
        AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
        PsTopicObjectAttributeOrderRegistrations.register(t, attrOrderManager);
        PsTopicObjectFilterRegistrations.register(t, UiPlugin.getFilterManager());
        PsTopicsContentPage parent = this;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 12;
        gridLayout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)gridLayout);
        this.contentTitleBar = new ContentTitleBar((Composite)parent, 0);
        this.contentTitleBar.setText(this.getPageTitle(t, this.object));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.contentTitleBar.setLayoutData((Object)gridData);
        Label padding = new Label((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 50;
        padding.setLayoutData((Object)gridData);
        this.imageLabel = new Label((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.heightHint = 22;
        gridData.widthHint = 24;
        this.imageLabel.setLayoutData((Object)gridData);
        this.status = new Label((Composite)parent, 0);
        this.status.setText("");
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.status.setLayoutData((Object)gridData);
        this.explorerTable = new ExplorerTable(t, (Composite)parent, 0, this.getGenericObjectName(), this.getFilterId() != null, true, true, true, (Object)this.getId());
        this.explorerTable.setViewPart(t, (ViewPart)this.getViewPart());
        this.explorerTable.setFilterId(t, this.getFilterId());
        this.explorerTable.setAttributeOrderId(t, this.getAttributeOrderId());
        this.explorerTable.setFilterProvider(t, this.getFilterProvider(t));
        this.toolbarActions = this.getToolbarActions(t);
        this.menuActions = this.getMenuActions(t);
        ArrayList<ViewerFilter> viewerFilters = this.getViewerFilters(t);
        if (viewerFilters != null) {
            int i = 0;
            while (i < viewerFilters.size()) {
                this.explorerTable.addViewerFilter(t, viewerFilters.get(i));
                ++i;
            }
        }
        gridData = new GridData(1808);
        gridData.horizontalSpan = 12;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.explorerTable.setLayoutData((Object)gridData);
    }

    public void setObject(MQExtObject object) {
        Trace t = Trace.getDefault();
        if (object != this.object && this.explorerTable != null) {
            if (this.explorerTable.isListening(t)) {
                this.stopListeningToDataModelForChanges(t, this.listenPsBroker);
                this.stopListeningToBrokerForChanges(t, this.listenPsBroker);
                this.explorerTable.removeAll(t);
            }
            this.listenDmObjectId = this.getDataModelObjectType(t);
            this.psBroker = this.getListenPsBroker(t, object);
            if (this.psBroker != null) {
                this.instanceId = this.psBroker.getQueueManager().getTreeName(t);
                this.explorerTable.setInstance(t, this.instanceId, false);
                UiMQObjectFactory factoryClass = this.getUiMQObjectFactory(t, object);
                if (this.listenDmObjectId != -1 && this.psBroker != null && factoryClass != null) {
                    UiMQObject uiMQObject = (UiMQObject)object.getInternalObject();
                    this.explorerTable.setUiMQObjectFactoryClass(t, (IUiMQObjectFactory)factoryClass, uiMQObject);
                } else if (Trace.isTracing) {
                    if (this.listenDmObjectId == -1) {
                        t.data(66, "PsTopicsContentPage.setObject", 900, "unable to listen for objects - listenDmObjectId is invalid");
                    } else if (this.psBroker == null) {
                        t.data(66, "PsTopicsContentPage.setObject", 900, "unable to listen for objects - psBroker is invalid");
                    } else if (factoryClass == null) {
                        t.data(66, "PsTopicsContentPage.setObject", 900, "unable to listen for objects - factoryClass is invalid");
                    }
                }
                this.startListeningToBrokerForChanges(t, this.psBroker);
            }
        }
        this.object = object;
    }

    public void updatePage() {
        Trace t = Trace.getDefault();
        this.contentTitleBar.setText(this.getPageTitle(t, this.object));
    }

    public void setActive(boolean isActive) {
        int i;
        IToolBarManager manager;
        Trace t = Trace.getDefault();
        if (this.explorerTable != null) {
            this.explorerTable.setShowListenerExceptions(isActive);
            if (isActive) {
                if (!this.explorerTable.isListening(t)) {
                    this.startListeningToDataModel(t, this.psBroker, this.listenDmObjectId, null, null, false);
                } else if (this.showSystemObjectsChanged && this.explorerTable != null) {
                    this.explorerTable.refresh();
                    this.showSystemObjectsChanged = false;
                }
            }
        }
        if (this.toolbarActions != null) {
            manager = this.getViewPart().getViewSite().getActionBars().getToolBarManager();
            if (isActive) {
                i = 0;
                while (i < this.toolbarActions.size()) {
                    manager.appendToGroup("com.ibm.mq.explorer.contentview.toolbar", (IAction)this.toolbarActions.get(i));
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.toolbarActions.size()) {
                    manager.remove(this.toolbarActions.get(i).getId());
                    ++i;
                }
            }
            manager.update(true);
        }
        if (this.menuActions != null) {
            manager = this.getViewPart().getViewSite().getActionBars().getMenuManager();
            if (isActive) {
                i = 0;
                while (i < this.menuActions.size()) {
                    manager.appendToGroup("com.ibm.mq.explorer.contentview.menu", (IAction)this.menuActions.get(i));
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.menuActions.size()) {
                    manager.remove(this.menuActions.get(i).getId());
                    ++i;
                }
            }
            manager.update(true);
        }
    }

    public void refresh() {
        if (this.explorerTable != null) {
            this.explorerTable.refresh();
            try {
                Trace t = Trace.getDefault();
                this.psBroker.getStatusMonitor(t).refresh(t);
            }
            catch (DmCoreException dmCoreException) {}
        }
    }

    public void repaint() {
        if (this.explorerTable != null) {
            this.explorerTable.repaint();
        }
    }

    public void showSystemObjects(boolean show) {
        this.showSystemObjectsChanged = true;
    }

    public void setMenuActions(Trace t, boolean enable) {
        MQContentView mqContentView = (MQContentView)this.getViewPart();
        mqContentView.enableRefreshAction(true);
        mqContentView.enableSystemObjectsAction(enable);
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return true;
    }

    public String getId() {
        return "com.ibm.mq.explorer.pubsub.ui.internal.content.topics";
    }

    public void instanceDeleted(Object o) {
    }

    public String getPageTitle(Trace t, Object obj) {
        String title = PsPlugin.getMessage(t, "Ps.Topics.Title");
        return title;
    }

    public ArrayList<Action> getToolbarActions(Trace t) {
        return null;
    }

    public String getFilterId() {
        return "com.ibm.mq.explorer.pubsub.filterid.topics";
    }

    public String getGenericObjectName() {
        return null;
    }

    public String getObjectId() {
        return "com.ibm.mq.explorer.pubsub.topic.topic";
    }

    public String getAttributeOrderId() {
        return "com.ibm.mq.explorer.pubsub.orderid.topics";
    }

    public ArrayList<Action> getMenuActions(Trace t) {
        return null;
    }

    public ArrayList<ViewerFilter> getViewerFilters(Trace t) {
        return null;
    }

    public FilterProvider getFilterProvider(Trace t) {
        return this.filterProvider;
    }

    public boolean isListenToDataModelForObjects(Trace t) {
        return true;
    }

    public PsBroker getListenPsBroker(Trace t, MQExtObject mqExtObject) {
        PsBroker broker = null;
        UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        if (uiMQObject instanceof PsUiBroker) {
            broker = (PsBroker)uiMQObject.getDmObject();
        } else if (Trace.isTracing) {
            t.data(66, "PsTopicsContentPage.getListenPsBroker", 900, "Not called from a psBroker context - No PsBroker will be returned");
        }
        return broker;
    }

    public int getDataModelObjectType(Trace t) {
        return 1501;
    }

    public UiMQObjectFactory getUiMQObjectFactory(Trace t, MQExtObject mqExtObject) {
        UiMQObjectFactory uiMQObjectFactory = null;
        UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        if (uiMQObject instanceof PsUiBroker) {
            uiMQObjectFactory = ((PsUiBroker)uiMQObject).getFactoryClass(t, this.getObjectId());
        } else if (Trace.isTracing) {
            t.data(66, "PsTopicsContentPage.getUiMQObjectFactory", 900, "Not called from a psBroker context - No PsBroker will be returned");
        }
        return uiMQObjectFactory;
    }

    public boolean startListeningToDataModel(Trace t, PsBroker broker, int dmObjectId, PsObject psObject, String topicName, boolean exactMatches) {
        this.listenPsBroker = broker;
        this.listenPsObject = psObject;
        this.listenObjectId = dmObjectId;
        this.listenTopicName = topicName;
        this.listenExactMatch = exactMatches;
        return this.startListeningToBrokerForChanges(t, broker);
    }

    @Override
    public void psBrokerRunning(PsEvent event) {
        Shell shell = UiPlugin.getShell();
        if (shell != null && !shell.isDisposed()) {
            UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t1 = Trace.getDefault();
                    PsTopicsContentPage.this.setMenuActions(t1, true);
                    PsTopicsContentPage.this.imageLabel.setImage(null);
                    PsTopicsContentPage.this.status.setText("");
                    PsTopicsContentPage.this.explorerTable.setEnabled(true);
                    if (!PsTopicsContentPage.this.explorerTable.isListening(t1) && PsTopicsContentPage.this.listenPsBroker != null) {
                        PsTopicsContentPage.this.startListeningToDataModelForChanges(t1, PsTopicsContentPage.this.listenPsBroker, PsTopicsContentPage.this.listenObjectId, PsTopicsContentPage.this.listenPsObject, PsTopicsContentPage.this.listenTopicName, PsTopicsContentPage.this.listenExactMatch);
                        if (Trace.isTracing) {
                            t1.data(66, "PsTopicsContentPage.psBrokerRunning", 300, "Broker running, will now listen to datamodel for changes");
                        }
                    }
                }
            });
        }
    }

    @Override
    public void psBrokerStopped(PsEvent event) {
        Shell shell = UiPlugin.getShell();
        if (shell != null && !shell.isDisposed()) {
            UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t1 = Trace.getDefault();
                    PsTopicsContentPage.this.stopListeningToDataModelForChanges(t1, PsTopicsContentPage.this.listenPsBroker);
                    PsTopicsContentPage.this.explorerTable.removeAll(t1);
                    PsTopicsContentPage.this.explorerTable.setEnabled(false);
                    PsTopicsContentPage.this.setMenuActions(t1, false);
                    PsTopicsContentPage.this.imageLabel.setImage(PsIcons.get(t1, PsIcons.iconkeyExclamation));
                    PsTopicsContentPage.this.status.setText(PsPlugin.getMessage(t1, "Ps.Status.Broker.Down"));
                    if (Trace.isTracing) {
                        t1.data(66, "PsTopicsContentPage.psBrokerStopped", 300, "Broker stopped, will no longer listen to datamodel for changes");
                    }
                }
            });
        }
    }

    public boolean startListeningToBrokerForChanges(Trace t, PsBroker broker) {
        return broker.addStatusListener(t, this);
    }

    public boolean stopListeningToBrokerForChanges(Trace t, PsBroker broker) {
        return broker.removeStatusListener(t, this);
    }

    public boolean startListeningToDataModelForChanges(Trace t, PsBroker broker, int dmObjectId, PsObject psObject, String topicName, boolean exactMatches) {
        boolean startedListen = false;
        Filter filter = null;
        if (this.filterProvider != null && this.getFilterId() != null) {
            filter = this.filterManager.getRegisteredCurrentFilter(t, this.getFilterId(), null);
        }
        PCFFilter pcfFilter = null;
        String name = null;
        if (filter != null) {
            DmObjectFilter dmObjectFilter = filter.getDmObjectFilter(t);
            pcfFilter = dmObjectFilter.getFilter();
            name = dmObjectFilter.getName();
        }
        if (name == null && topicName != null) {
            name = topicName;
        }
        PsObjectFilter psFilter = null;
        psFilter = name != null ? new PsObjectFilter(t, psObject, name, dmObjectId, pcfFilter, exactMatches) : new PsObjectFilter(t, psObject, dmObjectId, pcfFilter, exactMatches);
        startedListen = this.explorerTable.startListener(t, (IDmObservable)this.psBroker, (DmObjectFilter)psFilter);
        if (Trace.isTracing) {
            if (startedListen) {
                t.data(66, "PsTopicsContentPage.startListeningToDataModelForChanges", 300, "Started listening to the psBroker for changes");
            } else {
                t.data(66, "PsTopicsContentPage.startListeningToDataModelForChanges", 900, "Failed to start listening to the psBroker for changes - objectView not initialised");
            }
        }
        this.listenPsBroker = broker;
        this.listenPsObject = psObject;
        this.listenObjectId = dmObjectId;
        this.listenTopicName = name;
        this.listenExactMatch = exactMatches;
        return startedListen;
    }

    public boolean stopListeningToDataModelForChanges(Trace t, PsBroker broker) {
        boolean result = false;
        if (this.explorerTable != null && this.explorerTable.isListening(t)) {
            this.explorerTable.stopListener(t, (IDmObservable)this.listenPsBroker);
        }
        return result;
    }
}

