/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.attr.details;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublication;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsStream;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsTopic;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.ui.internal.attr.details.PsTopicObjectAttributeDetails;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;

public class PsTopicObjectAttributeOrderRegistrations {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/attr/details/PsTopicObjectAttributeOrderRegistrations.java";
    public static final String DEFAULT_ORDERID_BROKERS = "com.ibm.mq.explorer.pubsub.orderid.brokers";
    public static final String DEFAULT_ORDERID_SUBSCRIBERS = "com.ibm.mq.explorer.pubsub.orderid.subscribers";
    public static final String DEFAULT_ORDERID_PUBLISHERS = "com.ibm.mq.explorer.pubsub.orderid.publishers";
    public static final String DEFAULT_ORDERID_TOPICS = "com.ibm.mq.explorer.pubsub.orderid.topics";
    public static final String DEFAULT_ORDERID_STREAMS = "com.ibm.mq.explorer.pubsub.orderid.streams";
    public static final String DEFAULT_ORDERID_SUBSCRIPTIONS = "com.ibm.mq.explorer.pubsub.orderid.subscriptions";
    public static final String DEFAULT_ORDERID_PUBLICATIONS = "com.ibm.mq.explorer.pubsub.orderid.publications";
    private static PsTopicObjectAttributeDetails attrDetails = null;

    private PsTopicObjectAttributeOrderRegistrations() {
    }

    public static void register(Trace t, AttributeOrderManager aom) {
        attrDetails = new PsTopicObjectAttributeDetails();
        PsTopicObjectAttributeOrderRegistrations.registerBroker(t, aom);
        PsTopicObjectAttributeOrderRegistrations.registerTopic(t, aom);
        PsTopicObjectAttributeOrderRegistrations.registerPublisher(t, aom);
        PsTopicObjectAttributeOrderRegistrations.registerSubscriber(t, aom);
        PsTopicObjectAttributeOrderRegistrations.registerStream(t, aom);
        PsTopicObjectAttributeOrderRegistrations.registerSubscription(t, aom);
        PsTopicObjectAttributeOrderRegistrations.registerPublication(t, aom);
    }

    public static void registerBroker(Trace t, AttributeOrderManager aom) {
        String orderNameRoot = PsPlugin.getMessage(t, "Ps.Schemes.Default.Broker");
        int[] allAttributes = PsBroker.getAllAttributesByType(t);
        int[] orderDistributed = PsBroker.getDisplayColumnSequence(t, allAttributes, false);
        String[] names = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            names[i] = PsBroker.getAttributeTitle(t, allAttributes[i]);
            ++i;
        }
        if (!aom.register(t, (IAttributeDetails)attrDetails, DEFAULT_ORDERID_BROKERS, orderNameRoot, "com.ibm.mq.explorer.pubsub.topic.broker", allAttributes, names, orderDistributed) && Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeOrderRegistrations.registerBroker", 900, "Error: failed to register Attribute Order for Broker (IBM MQ)");
        }
    }

    public static void registerTopic(Trace t, AttributeOrderManager aom) {
        String orderNameRoot = PsPlugin.getMessage(t, "Ps.Schemes.Default.Topic");
        int[] allAttributes = PsTopic.getAllAttributesByType(t);
        int[] orderDistributed = PsTopic.getDisplayColumnSequence(t, allAttributes, false);
        String[] names = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            names[i] = PsTopic.getAttributeTitle(t, allAttributes[i]);
            ++i;
        }
        if (!aom.register(t, (IAttributeDetails)attrDetails, DEFAULT_ORDERID_TOPICS, orderNameRoot, "com.ibm.mq.explorer.pubsub.topic.topic", allAttributes, names, orderDistributed) && Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeOrderRegistrations.registerTopic", 900, "Error: failed to register Attribute Order for Topic (IBM MQ)");
        }
    }

    public static void registerPublisher(Trace t, AttributeOrderManager aom) {
        String orderNameRoot = PsPlugin.getMessage(t, "Ps.Schemes.Default.Publisher");
        int[] allAttributes = PsPublisher.getAllAttributesByType(t);
        int[] orderDistributed = PsPublisher.getDisplayColumnSequence(t, allAttributes, false);
        String[] names = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            names[i] = PsPublisher.getAttributeTitle(t, allAttributes[i]);
            ++i;
        }
        if (!aom.register(t, (IAttributeDetails)attrDetails, DEFAULT_ORDERID_PUBLISHERS, orderNameRoot, "com.ibm.mq.explorer.pubsub.topic.publisher", allAttributes, names, orderDistributed) && Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeOrderRegistrations.registerPublisher", 900, "Error: failed to register Attribute Order for Publisher (IBM MQ)");
        }
    }

    public static void registerSubscriber(Trace t, AttributeOrderManager aom) {
        String orderNameRoot = PsPlugin.getMessage(t, "Ps.Schemes.Default.Subscriber");
        int[] allAttributes = PsSubscriber.getAllAttributesByType(t);
        int[] orderDistributed = PsSubscriber.getDisplayColumnSequence(t, allAttributes, false);
        String[] names = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            names[i] = PsSubscriber.getAttributeTitle(t, allAttributes[i]);
            ++i;
        }
        if (!aom.register(t, (IAttributeDetails)attrDetails, DEFAULT_ORDERID_SUBSCRIBERS, orderNameRoot, "com.ibm.mq.explorer.pubsub.topic.subscriber", allAttributes, names, orderDistributed) && Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeOrderRegistrations.registerSubscriber", 900, "Error: failed to register Attribute Order for Subscriber (IBM MQ)");
        }
    }

    public static void registerStream(Trace t, AttributeOrderManager aom) {
        String orderNameRoot = PsPlugin.getMessage(t, "Ps.Schemes.Default.Stream");
        int[] allAttributes = PsStream.getAllAttributesByType(t);
        int[] orderDistributed = PsStream.getDisplayColumnSequence(t, allAttributes, false);
        String[] names = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            names[i] = PsStream.getAttributeTitle(t, allAttributes[i]);
            ++i;
        }
        if (!aom.register(t, (IAttributeDetails)attrDetails, DEFAULT_ORDERID_STREAMS, orderNameRoot, "com.ibm.mq.explorer.pubsub.topic.stream", allAttributes, names, orderDistributed) && Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeOrderRegistrations.registerStream", 900, "Error: failed to register Attribute Order for Stream (IBM MQ)");
        }
    }

    public static void registerSubscription(Trace t, AttributeOrderManager aom) {
        String orderNameRoot = PsPlugin.getMessage(t, "Ps.Schemes.Default.Subscription");
        int[] allAttributes = PsSubscription.getAllAttributesByType(t);
        int[] orderDistributed = PsSubscription.getDisplayColumnSequence(t, allAttributes, false);
        String[] names = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            names[i] = PsSubscription.getAttributeTitle(t, allAttributes[i]);
            ++i;
        }
        if (!aom.register(t, (IAttributeDetails)attrDetails, DEFAULT_ORDERID_SUBSCRIPTIONS, orderNameRoot, "com.ibm.mq.explorer.pubsub.topic.subscription", allAttributes, names, orderDistributed) && Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeOrderRegistrations.registerSubscription", 900, "Error: failed to register Attribute Order for Subscription (IBM MQ)");
        }
    }

    public static void registerPublication(Trace t, AttributeOrderManager aom) {
        String orderNameRoot = PsPlugin.getMessage(t, "Ps.Schemes.Default.Publication");
        int[] allAttributes = PsPublication.getAllAttributesByType(t);
        int[] orderDistributed = PsPublication.getDisplayColumnSequence(t, allAttributes, false);
        String[] names = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            names[i] = PsPublication.getAttributeTitle(t, allAttributes[i]);
            ++i;
        }
        if (!aom.register(t, (IAttributeDetails)attrDetails, DEFAULT_ORDERID_PUBLICATIONS, orderNameRoot, "com.ibm.mq.explorer.pubsub.topic.publication", allAttributes, names, orderDistributed) && Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeOrderRegistrations.registerPublication", 900, "Error: failed to register Attribute Order for Publication (IBM MQ)");
        }
    }
}

