/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.attr.details;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublication;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsStream;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsTopic;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;

public class PsTopicObjectAttributeDetails
implements IAttributeDetails {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/attr/details/PsTopicObjectAttributeDetails.java";

    public String getAttributeName(String objectId, int attrId) {
        Trace t = Trace.getDefault();
        String attrName = "";
        if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.subscriber") == 0) {
            attrName = PsSubscriber.getAttributeTitle(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.topic") == 0) {
            attrName = PsTopic.getAttributeTitle(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.publisher") == 0) {
            attrName = PsPublisher.getAttributeTitle(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.stream") == 0) {
            attrName = PsStream.getAttributeTitle(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.subscription") == 0) {
            attrName = PsSubscription.getAttributeTitle(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.publication") == 0) {
            attrName = PsPublication.getAttributeTitle(t, attrId);
        } else if (Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeDetails.getAttributeName", 900, "Unsupported objectId " + objectId);
        }
        return attrName;
    }

    public boolean isAttributeRepeating(String objectId, int attrId) {
        Trace t = Trace.getDefault();
        boolean isRepeating = false;
        if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.subscriber") == 0) {
            isRepeating = PsSubscriber.isAttributeRepeating(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.topic") == 0) {
            isRepeating = PsTopic.isAttributeRepeating(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.publisher") == 0) {
            isRepeating = PsPublisher.isAttributeRepeating(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.stream") == 0) {
            isRepeating = PsStream.isAttributeRepeating(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.subscription") == 0) {
            isRepeating = PsSubscription.isAttributeRepeating(t, attrId);
        } else if (objectId.compareTo("com.ibm.mq.explorer.pubsub.topic.publication") == 0) {
            isRepeating = PsPublication.isAttributeRepeating(t, attrId);
        } else if (Trace.isTracing) {
            t.data(66, "PsTopicObjectAttributeDetails.isAttributeRepeating", 900, "Unsupported objectId " + objectId);
        }
        return isRepeating;
    }
}

