/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.pcf.internal.admin;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.pubsub.pcf.internal.admin.PsPCFMonitorAgent;
import com.ibm.mq.pcf.event.PCFEvent;
import com.ibm.mq.pcf.event.PCFListener;
import com.ibm.mq.pcf.event.PCFMonitorAgent;
import com.ibm.mq.pcf.event.PCFQuery;
import java.util.Set;

public class PsStreamCacheListener
extends Thread
implements PCFListener {
    public static final String COPYRIGHT = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/pcf/internal/admin/PsStreamCacheListener.java";
    Set streamCache = null;
    PCFMonitorAgent monitorAgent = null;

    public PsStreamCacheListener(Set cache, PCFMonitorAgent agent) {
        this.streamCache = cache;
        this.monitorAgent = agent;
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        this.monitorAgent.addPCFListener(t, (PCFListener)this, new PCFQuery(PsPCFMonitorAgent.INTERNAL_INQUIRE_STREAM));
        this.monitorAgent.refresh(t);
        this.monitorAgent.start(t);
    }

    public void handleEvent(PCFEvent event) {
        Trace t = Trace.getDefault();
        int eventType = event.getType();
        if (eventType == 1 || eventType == 2) {
            String objectName = event.getObjectName().trim();
            if (eventType == 1) {
                this.streamCache.add(objectName);
                if (Trace.isTracing) {
                    t.data(66, "PsStreamCacheListener.handleEvent", Integer.MIN_VALUE, "stream added:" + objectName);
                }
            } else {
                this.streamCache.remove(objectName);
                if (Trace.isTracing) {
                    t.data(66, "PsStreamCacheListener.handleEvent", Integer.MIN_VALUE, "stream removed:" + objectName);
                }
            }
        }
    }
}

