/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.pcf.internal.admin;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.util.ArrayList;
import java.util.Enumeration;

public class PsPCFParameterGrouper {
    public static final String COPYRIGHT = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/pcf/internal/admin/PsPCFParameterGrouper.java";
    private int[] parmId = null;
    private PCFParameter[] parmObj = null;
    private int groupCount = 0;
    private int[] groupOffset = null;
    private int[] groupSize = null;

    private PsPCFParameterGrouper() {
    }

    public PsPCFParameterGrouper(Trace t, PCFMessage message, int delimiter) throws PCFException {
        int parmCount = message.getParameterCount();
        int applCount = 0;
        int brokerCount = 0;
        try {
            applCount = message.getIntParameterValue(1089);
        }
        catch (PCFException pCFException) {
            applCount = 0;
        }
        try {
            brokerCount = message.getIntParameterValue(1088);
        }
        catch (PCFException pCFException) {
            brokerCount = 0;
        }
        this.groupCount = applCount + brokerCount;
        if (this.groupCount == 0) {
            throw new PCFException(2, 3008, (Object)message);
        }
        this.parmId = new int[parmCount];
        this.parmObj = new PCFParameter[parmCount];
        this.groupOffset = new int[this.groupCount + 1];
        this.groupSize = new int[this.groupCount + 1];
        int parmCounter = 0;
        int groupCounter = 0;
        this.groupOffset[0] = 0;
        this.groupSize[0] = 0;
        Enumeration e = message.getParameters();
        while (e.hasMoreElements()) {
            this.parmObj[parmCounter] = (PCFParameter)e.nextElement();
            this.parmId[parmCounter] = this.parmObj[parmCounter].getParameter();
            if (this.parmId[parmCounter] == delimiter) {
                this.groupOffset[++groupCounter] = parmCounter;
            }
            int n = groupCounter;
            this.groupSize[n] = this.groupSize[n] + 1;
            ++parmCounter;
        }
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public int getHeaderSize() {
        return this.groupSize[0];
    }

    public int getGroupSize(int groupNum) {
        return this.groupSize[groupNum + 1];
    }

    public int[] getHeaderParamIds(Trace t) {
        return this.internalGetGroupParamIds(t, 0);
    }

    public int[] getGroupParamIds(Trace t, int groupNum) {
        return this.internalGetGroupParamIds(t, groupNum + 1);
    }

    public String generateGroupIdentifier(Trace t, int groupNum, int[] keys) {
        String groupIdentifier = "";
        int start = this.getGroupOffset(groupNum);
        int end = start + this.getGroupSize(groupNum);
        int i = 0;
        while (i < keys.length) {
            int j = start;
            while (j < end) {
                if (keys[i] == this.parmId[j]) {
                    groupIdentifier = String.valueOf(groupIdentifier) + this.parmObj[j].getStringValue();
                    break;
                }
                ++j;
            }
            ++i;
        }
        return groupIdentifier;
    }

    public String getStringValueFromHeader(Trace t, int key) {
        return this.internalGetStringValueFromGroup(t, 0, key);
    }

    public String getStringValueFromGroup(Trace t, int groupNum, int key) {
        return this.internalGetStringValueFromGroup(t, groupNum + 1, key);
    }

    public void addParametersToMsgFromGroup(Trace t, int groupNum, PCFMessage msg, int[] keysToIgnore, int[] keysToConvertToList) {
        int start = this.getGroupOffset(groupNum);
        int end = start + this.getGroupSize(groupNum);
        int i = start;
        while (i < end) {
            int j;
            boolean process = true;
            if (keysToIgnore != null) {
                j = 0;
                while (j < keysToIgnore.length) {
                    if (keysToIgnore[j] == this.parmId[i]) {
                        process = false;
                        break;
                    }
                    ++j;
                }
            }
            if (keysToConvertToList != null) {
                j = 0;
                while (j < keysToConvertToList.length) {
                    if (keysToConvertToList[j] == this.parmId[i]) {
                        process = false;
                        break;
                    }
                    ++j;
                }
            }
            if (process) {
                msg.addParameter(this.parmObj[i]);
            }
            ++i;
        }
        if (keysToConvertToList != null) {
            int j = 0;
            while (j < keysToConvertToList.length) {
                ArrayList<String> strList = new ArrayList<String>();
                int i2 = start;
                while (i2 < end) {
                    if (keysToConvertToList[j] == this.parmId[i2]) {
                        strList.add(this.parmObj[i2].getStringValue());
                    }
                    ++i2;
                }
                if (strList.size() > 0) {
                    String[] theList = strList.toArray(new String[strList.size()]);
                    msg.addParameter(keysToConvertToList[j], theList);
                }
                ++j;
            }
        }
    }

    protected int getGroupOffset(int groupNum) {
        return this.groupOffset[groupNum + 1];
    }

    protected int[] internalGetGroupParamIds(Trace t, int groupNum) {
        int size = this.groupSize[groupNum];
        int offset = this.groupOffset[groupNum];
        int[] ids = new int[size];
        System.arraycopy(this.parmId, offset, ids, 0, size);
        return ids;
    }

    protected String internalGetStringValueFromGroup(Trace t, int groupNum, int key) {
        String stringValue = null;
        int start = this.groupOffset[groupNum];
        int end = start + this.groupSize[groupNum];
        int j = start;
        while (j < end) {
            if (key == this.parmId[j]) {
                stringValue = this.parmObj[j].getStringValue().trim();
                break;
            }
            ++j;
        }
        return stringValue;
    }
}

