/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.pcf.internal.admin;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.pubsub.internal.util.PsHexString;
import com.ibm.mq.explorer.pubsub.internal.util.PsPaddedString;
import com.ibm.mq.explorer.pubsub.internal.util.PsTopicMatcher;
import com.ibm.mq.explorer.pubsub.pcf.internal.admin.PsPCFParameterGrouper;
import com.ibm.mq.explorer.pubsub.pcf.internal.admin.PsStreamCacheListener;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFMonitorAgent;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.PCFQueryTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class PsPCFMonitorAgent
extends PCFMonitorAgent {
    public static final String COPYRIGHT = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/pcf/internal/admin/PsPCFMonitorAgent.java";
    MQQueue controlQueue;
    MQQueue subscriberQueue;
    private int mode;
    private byte[] correlid;
    protected MQPutMessageOptions psPmo;
    protected MQGetMessageOptions psGmo;
    protected static final int MTID_SUBSCRIBERS = 1;
    protected static final int MTID_PUBLISHERS = 2;
    protected static final int MTID_STREAMS = 3;
    protected static final int MTID_PUBLISHERS_IDENTITIES = 4;
    protected static final int MTID_SUBSCRIBERS_IDENTITIES = 5;
    protected static final int MTID_PUBLISHERS_ALL_IDENTITIES = 6;
    protected static final int MTID_SUBSCRIBERS_ALL_IDENTITIES = 7;
    protected static final int MTID_SUBSCRIBERS_SHORT = 8;
    public static final int UNMODIFIED_EXPIRY = -2;
    private static final String MATCH_ALL = "*";
    protected static final String SYSTEM_TOPIC_PREFIX = "MQ/";
    protected static final String TOPIC_PREFIX = "S/";
    protected static final String TOPIC_PREFIX_ALL = "SA/";
    protected static final String TOPIC_DELIMITER = "/";
    protected static final String TOPICS_ALL = "*";
    protected static final String TOPIC_PUB_ALL_IDS = "/Publishers/AllIdentities";
    protected static final String TOPIC_PUB_IDS = "/Publishers/Identities";
    protected static final String TOPIC_SUB_ALL_IDS = "/Subscribers/AllIdentities";
    protected static final String TOPIC_SUB_IDS = "/Subscribers/Identities";
    protected static final String TOPIC_STREAMS = "/StreamSupport";
    protected static final String TOPIC_SUB_TOPICS = "/Subscribers/Summary";
    protected static final String TOPIC_PUB_TOPICS = "/Publishers/Summary";
    protected static final String TOPIC_SUB_TOPICS_SHORT = "/Subscribers/Topics";
    protected static final String TOPIC_PUB_TOPICS_SHORT = "/Publishers/Topics";
    private static final PCFMessage[] EMPTY_RESPONSES = new PCFMessage[0];
    protected static final int MQCMD_INTERNAL_INQUIRE_STREAM = 9997;
    public static PCFQueryTemplate INTERNAL_INQUIRE_STREAM = new PCFQueryTemplate(9997, new PCFParameter[]{new MQCFST(3030, "*")}, 2085);
    protected static final int[] idTemplate = new int[]{3044, 3043, 3042};
    protected static final int[] ignoreTemplate = new int[]{3038, 1091, 3055, 3057, 3053};
    protected static final int[] convertToListTemplate = new int[]{3055};
    protected static boolean useCachedStreamNames = true;
    protected PCFQuery internalStreamQuery;
    protected Set streamCache;
    PsStreamCacheListener streamCacheListener;

    public PsPCFMonitorAgent(Trace t, MQQueueManager qmgr) throws MQException {
        super(t, qmgr);
        this.qmanager_level = 531;
    }

    public synchronized void connect(MQQueueManager qmgr) throws MQException {
        Trace t = Trace.getDefault();
        super.open(qmgr, false);
        this.psPmo = new MQPutMessageOptions();
        this.psGmo = new MQGetMessageOptions();
        this.open(t, qmgr);
        if (useCachedStreamNames) {
            this.streamCache = Collections.synchronizedSet(new HashSet(10));
            this.streamCacheListener = new PsStreamCacheListener(this.streamCache, this);
            this.streamCacheListener.start();
        }
    }

    public synchronized void disconnect() throws MQException {
        if (this.controlQueue != null) {
            this.controlQueue.close();
        }
        if (this.subscriberQueue != null) {
            this.subscriberQueue.close();
        }
        super.disconnect();
    }

    public PCFMessage[] update(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        PCFMessage[] responses = this.send(t, request);
        this.refresh(t);
        return responses;
    }

    public PCFMessage[] send(PCFMessage request) throws PCFException, MQException, IOException {
        Trace t = Trace.getDefault();
        PCFMessage[] responses = this.send(t, request);
        return responses;
    }

    public PCFMessage[] send(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        PCFMessage[] responses = EMPTY_RESPONSES;
        int command = request.getCommand();
        try {
            switch (command) {
                case 11002: {
                    responses = this.sendInquireSubscriber(t, request);
                    break;
                }
                case 11003: {
                    responses = this.sendInquireSubscription(t, request);
                    break;
                }
                case 11001: {
                    responses = this.sendInquirePublisher(t, request);
                    break;
                }
                case 11004: {
                    responses = this.sendInquirePublication(t, request);
                    break;
                }
                case 9997: {
                    responses = this.sendInquireStream(t, request, command);
                    break;
                }
                case 11005: {
                    responses = this.sendInquireStream(t, request, command);
                    break;
                }
                case 11000: {
                    responses = this.sendInquireTopics(t, request);
                    break;
                }
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    responses = this.sendCommand(t, request);
                    break;
                }
                default: {
                    responses = super.send(request);
                    break;
                }
            }
        }
        catch (IOException e) {
            if (Trace.isTracing) {
                t.data(66, "PsPCFMonitorAgent.send", 900, "PsPCFMonitorAgent.sendCommand IOException:" + e.toString());
            }
        }
        catch (MQException e) {
            if (Trace.isTracing) {
                t.data(66, "PsPCFMonitorAgent.send", 900, "PsPCFMonitorAgent.sendCommand MQException:" + e.toString());
            }
            throw e;
        }
        return responses;
    }

    protected synchronized void open(Trace t, MQQueueManager qmanager) throws MQException {
        this.psPmo.options = 128;
        this.psGmo.options = 24577;
        this.psGmo.waitInterval = this.waitInterval;
        String subscriberQueueName = "SYSTEM.MQEXPLORER.BROKER.REPLY.QUEUE";
        PCFMessage request = new PCFMessage(11);
        request.addParameter(2016, subscriberQueueName);
        request.addParameter(20, 1);
        request.addParameter(2013, "Subscription queue");
        request.addParameter(1006, 1);
        try {
            this.send(request);
        }
        catch (IOException e) {
            throw new MQException(2, 2195, (Object)e);
        }
        this.controlQueue = qmanager.accessQueue("SYSTEM.BROKER.CONTROL.QUEUE", 8208, null, null, "mqm");
        this.subscriberQueue = qmanager.accessQueue(subscriberQueueName, 8194, null, null, "mqm");
    }

    protected MQMessage setRequestMQMD(Trace t, MQMessage message) throws MQException {
        MQMessage md = super.setRequestMQMD(message);
        if (this.mode != 0) {
            this.mode = 0;
            if (this.correlid != null) {
                md.report = 64;
                md.correlationId = this.correlid;
                this.psPmo.options = 0;
                this.correlid = null;
            } else {
                System.err.println("should never reach here (i don't think)");
                this.psPmo.options = 128;
            }
            md.messageType = 1;
            md.format = "MQPCF   ";
        } else {
            this.psPmo.options = 128;
        }
        return md;
    }

    protected synchronized PCFMessage[] send(Trace t, PCFMessage request, byte[] correlId, int msgExpiry) throws MQException, IOException {
        PCFMessage[] responses = null;
        this.mode = request.getCommand();
        this.correlid = correlId;
        responses = this.psSend(t, request, msgExpiry);
        return responses;
    }

    protected PCFMessage[] sendInquireTopics(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        PCFMessage[] response = null;
        String[] streams = null;
        String stream = this.getFilterString(t, request, 3030);
        String topic = this.getFilterString(t, request, 3031);
        int topicMatchCriteriaFilter = this.getTopicMatchCriteriaFilter(t, request);
        streams = this.getStreamsAsStringList(t, stream);
        response = this.getTopics(t, streams, topic, topicMatchCriteriaFilter);
        return response;
    }

    protected PCFMessage[] sendInquirePublisher(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        PCFMessage[] response = null;
        String[] streams = null;
        String stream = this.getFilterString(t, request, 3030);
        String topic = this.getFilterString(t, request, 10031);
        int topicMatchCriteriaFilter = this.getTopicMatchCriteriaFilter(t, request);
        streams = this.getStreamsAsStringList(t, stream);
        response = this.getIdentities(t, 6, streams, topic, topicMatchCriteriaFilter);
        return response;
    }

    protected PCFMessage[] sendInquireSubscriber(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        PCFMessage[] response = null;
        String[] streams = null;
        String stream = this.getFilterString(t, request, 3030);
        String topic = this.getFilterString(t, request, 10031);
        int topicMatchCriteriaFilter = this.getTopicMatchCriteriaFilter(t, request);
        streams = this.getStreamsAsStringList(t, stream);
        response = this.getIdentities(t, 7, streams, topic, topicMatchCriteriaFilter);
        return response;
    }

    protected PCFMessage[] sendInquireSubscription(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        PCFMessage[] response = null;
        String[] streams = null;
        String stream = this.getFilterString(t, request, 3030);
        String topic = this.getFilterString(t, request, 10031);
        int topicMatchCriteriaFilter = this.getTopicMatchCriteriaFilter(t, request);
        String correlid = this.getFilterString(t, request, 3044);
        String qname = this.getFilterString(t, request, 3043);
        String qmname = this.getFilterString(t, request, 3042);
        this.getFilterString(t, request, 3053);
        streams = this.getStreamsAsStringList(t, stream);
        response = this.getInstances(t, 7, streams, topic, topicMatchCriteriaFilter, correlid, "*", qname, qmname);
        return response;
    }

    protected PCFMessage[] sendInquirePublication(Trace t, PCFMessage request) throws PCFException, MQException, IOException {
        PCFMessage[] response = null;
        String[] streams = null;
        String stream = this.getFilterString(t, request, 3030);
        String topic = this.getFilterString(t, request, 10031);
        int topicMatchCriteriaFilter = this.getTopicMatchCriteriaFilter(t, request);
        String correlid = this.getFilterString(t, request, 3044);
        String qname = this.getFilterString(t, request, 3043);
        String qmname = this.getFilterString(t, request, 3042);
        streams = this.getStreamsAsStringList(t, stream);
        response = this.getInstances(t, 6, streams, topic, topicMatchCriteriaFilter, correlid, "*", qname, qmname);
        return response;
    }

    protected PCFMessage[] sendInquireStream(Trace t, PCFMessage request, int command) throws PCFException, MQException, IOException {
        PCFMessage[] response = null;
        ArrayList<PCFMessage> list = new ArrayList<PCFMessage>();
        String[] streamStrings = this.getAllStreamsAsStringList(t);
        int s = 0;
        while (s < streamStrings.length) {
            PCFMessage newResponse = new PCFMessage(2, command, 1, true);
            newResponse.addParameter(3030, streamStrings[s]);
            list.add(newResponse);
            ++s;
        }
        response = list.toArray(new PCFMessage[list.size()]);
        return response;
    }

    protected PCFMessage[] sendCommand(Trace t, PCFMessage request) throws MQException, IOException {
        int msgExpiry;
        PCFMessage[] responses = EMPTY_RESPONSES;
        PCFMessage rebuiltRequest = null;
        String strCorrelId = null;
        boolean rebuild = false;
        try {
            strCorrelId = request.getStringParameterValue(10023);
            rebuild = true;
        }
        catch (PCFException pCFException) {
            strCorrelId = Long.toString(System.currentTimeMillis());
        }
        try {
            msgExpiry = request.getIntParameterValue(10024);
            rebuild = true;
        }
        catch (PCFException pCFException) {
            msgExpiry = -2;
        }
        if (rebuild) {
            rebuiltRequest = new PCFMessage(request.getCommand());
            Enumeration e = request.getParameters();
            while (e.hasMoreElements()) {
                PCFParameter p = (PCFParameter)e.nextElement();
                int id = p.getParameter();
                if (id == 10023 || id == 10024) continue;
                rebuiltRequest.addParameter(p);
            }
        }
        byte[] correlid = PsHexString.parseHex(strCorrelId);
        responses = this.send(t, rebuiltRequest != null ? rebuiltRequest : request, correlid, msgExpiry);
        return responses;
    }

    protected PCFMessage[] getTopics(Trace t, String[] streams, String topicFilter, int topicMatchCriteriaFilter) throws MQException, IOException {
        PCFMessage[] topics = null;
        boolean bMatchExactTopic = topicMatchCriteriaFilter == 0;
        ArrayList<PCFMessage> responseList = new ArrayList<PCFMessage>(100);
        ArrayList<Integer> subscriberCountList = new ArrayList<Integer>(100);
        ArrayList<Integer> publisherCountList = new ArrayList<Integer>(100);
        ArrayList<Integer> subAnonCountList = new ArrayList<Integer>(100);
        ArrayList<Integer> subBrokerCountList = new ArrayList<Integer>(100);
        ArrayList<Integer> pubAnonCountList = new ArrayList<Integer>(100);
        ArrayList<Integer> pubBrokerCountList = new ArrayList<Integer>(100);
        int counter = 0;
        String subMetatopic = this.getMetaTopicString(t, 1);
        int subMetatopicLength = subMetatopic.length() + 1;
        subMetatopic = String.valueOf(subMetatopic) + "/*";
        int s = 0;
        while (s < streams.length) {
            HashMap<String, Integer> uniqueMap = new HashMap<String, Integer>();
            PCFMessage[] subResponses = this.getMetaTopicInfo(t, streams[s], subMetatopic);
            int i = 0;
            while (i < subResponses.length) {
                String topic = subResponses[i].getStringParameterValue(3031);
                String realTopicName = topic.substring(subMetatopicLength);
                if (!bMatchExactTopic || realTopicName.compareTo(topicFilter) == 0) {
                    PCFMessage newResponse = new PCFMessage(2, 11000, 1, true);
                    newResponse.addParameter(3031, realTopicName);
                    newResponse.addParameter(3030, streams[s]);
                    Enumeration e = subResponses[i].getParameters();
                    while (e.hasMoreElements()) {
                        PCFParameter p = (PCFParameter)e.nextElement();
                        int id = p.getParameter();
                        if (id == 3031 || id == 3030 || id == 1082 || id == 3034 || id == 1089 || id == 1088 || id == 1090) continue;
                        newResponse.addParameter(p);
                    }
                    subscriberCountList.add(subResponses[i].getIntParameterValue(1089));
                    subAnonCountList.add(subResponses[i].getIntParameterValue(1090));
                    subBrokerCountList.add(subResponses[i].getIntParameterValue(1088));
                    publisherCountList.add(0);
                    pubAnonCountList.add(0);
                    pubBrokerCountList.add(0);
                    responseList.add(newResponse);
                    uniqueMap.put(realTopicName, counter++);
                }
                ++i;
            }
            String pubMetatopic = this.getMetaTopicString(t, 2);
            int pubMetatopicLength = pubMetatopic.length() + 1;
            pubMetatopic = String.valueOf(pubMetatopic) + "/*";
            PCFMessage[] pubResponses = this.getMetaTopicInfo(t, streams[s], pubMetatopic);
            int i2 = 0;
            while (i2 < pubResponses.length) {
                String topic = pubResponses[i2].getStringParameterValue(3031);
                String realTopicName = topic.substring(pubMetatopicLength);
                if (!bMatchExactTopic || realTopicName.compareTo(topicFilter) == 0) {
                    int pubApplCount = pubResponses[i2].getIntParameterValue(1089);
                    int pubAnonCount = pubResponses[i2].getIntParameterValue(1090);
                    int pubBrokerCount = pubResponses[i2].getIntParameterValue(1088);
                    if (!uniqueMap.containsKey(realTopicName)) {
                        PCFMessage newResponse = new PCFMessage(2, 11000, 1, true);
                        newResponse.addParameter(3031, realTopicName);
                        newResponse.addParameter(3030, streams[s]);
                        Enumeration e = pubResponses[i2].getParameters();
                        while (e.hasMoreElements()) {
                            PCFParameter p = (PCFParameter)e.nextElement();
                            int id = p.getParameter();
                            if (id == 3031 || id == 3030 || id == 1082 || id == 3034 || id == 1089 || id == 1088 || id == 1090) continue;
                            newResponse.addParameter(p);
                        }
                        responseList.add(newResponse);
                        publisherCountList.add(pubApplCount);
                        pubAnonCountList.add(pubAnonCount);
                        pubBrokerCountList.add(pubBrokerCount);
                        subscriberCountList.add(0);
                        subAnonCountList.add(0);
                        subBrokerCountList.add(0);
                        uniqueMap.put(realTopicName, counter++);
                    } else {
                        Integer index = (Integer)uniqueMap.get(realTopicName);
                        publisherCountList.set(index, pubApplCount);
                        pubAnonCountList.set(index, pubAnonCount);
                        pubBrokerCountList.set(index, pubBrokerCount);
                    }
                }
                ++i2;
            }
            ++s;
        }
        int i = 0;
        while (i < responseList.size()) {
            PCFMessage currentResponse = (PCFMessage)responseList.get(i);
            int subscriberCount = 0;
            int publisherCount = 0;
            int anonymousSubscriberCount = 0;
            int anonymousPublisherCount = 0;
            int brokerSubscriberCount = 0;
            int brokerPublisherCount = 0;
            Integer integerSubscriberCount = (Integer)subscriberCountList.get(i);
            Integer integerPublisherCount = (Integer)publisherCountList.get(i);
            Integer integerAnonymousSubscriberCount = (Integer)subAnonCountList.get(i);
            Integer integerBrokerSubscriberCount = (Integer)subBrokerCountList.get(i);
            Integer integerAnonymousPublisherCount = (Integer)pubAnonCountList.get(i);
            Integer integerBrokerPublisherCount = (Integer)pubBrokerCountList.get(i);
            if (integerSubscriberCount != null) {
                subscriberCount = integerSubscriberCount;
            }
            if (integerPublisherCount != null) {
                publisherCount = integerPublisherCount;
            }
            if (integerAnonymousSubscriberCount != null) {
                anonymousSubscriberCount = integerAnonymousSubscriberCount;
            }
            if (integerAnonymousPublisherCount != null) {
                anonymousPublisherCount = integerAnonymousPublisherCount;
            }
            if (integerBrokerSubscriberCount != null) {
                brokerSubscriberCount = integerBrokerSubscriberCount;
            }
            if (integerBrokerPublisherCount != null) {
                brokerPublisherCount = integerBrokerPublisherCount;
            }
            currentResponse.addParameter(10025, subscriberCount);
            currentResponse.addParameter(10027, publisherCount);
            currentResponse.addParameter(1089, subscriberCount + publisherCount);
            currentResponse.addParameter(1090, anonymousSubscriberCount + anonymousPublisherCount);
            currentResponse.addParameter(1088, brokerSubscriberCount + brokerPublisherCount);
            ++i;
        }
        topics = responseList.toArray(new PCFMessage[responseList.size()]);
        return topics;
    }

    protected PCFMessage[] getInstances(Trace t, int instanceType, String[] streams, String topicFilter, int topicMatchCriteriaFilter, String correlidFilter, String subnameFilter, String qnameFilter, String qmnameFilter) throws MQException, IOException {
        PsTopicMatcher matcher = null;
        if (topicMatchCriteriaFilter == 1) {
            matcher = new PsTopicMatcher(t, topicFilter);
            topicFilter = this.trimWildcardCharsFromFilter(t, topicFilter);
        }
        ArrayList<PCFMessage> list = new ArrayList<PCFMessage>();
        String trimmedCorrelidFilter = correlidFilter.trim();
        String trimmedSubnameFilter = subnameFilter.trim();
        String trimmedQnameFilter = qnameFilter.trim();
        String trimmedQMnameFilter = qmnameFilter.trim();
        boolean correlidMatched = trimmedCorrelidFilter.compareTo("*") == 0;
        boolean subnameMatched = trimmedSubnameFilter.compareTo("*") == 0 || trimmedSubnameFilter.length() == 0;
        boolean qnameMatched = trimmedQnameFilter.compareTo("*") == 0 || trimmedQnameFilter.length() == 0;
        boolean qmnameMatched = trimmedQMnameFilter.compareTo("*") == 0 || trimmedQMnameFilter.length() == 0;
        int responseType = instanceType == 6 ? 11004 : 11003;
        String metatopic = this.getMetaTopicString(t, instanceType);
        int metatopiclength = metatopic.length() + 1;
        if (topicFilter != null) {
            metatopic = String.valueOf(metatopic) + TOPIC_DELIMITER + topicFilter;
        }
        int s = 0;
        while (s < streams.length) {
            PCFMessage[] responses = this.getMetaTopicInfo(t, streams[s], metatopic);
            int r = 0;
            while (r < responses.length) {
                PsPCFParameterGrouper msgParamGrouper;
                try {
                    msgParamGrouper = new PsPCFParameterGrouper(t, responses[r], 3042);
                }
                catch (Exception exception) {
                    msgParamGrouper = null;
                }
                if (msgParamGrouper != null) {
                    String topic = msgParamGrouper.getStringValueFromHeader(t, 3031);
                    String realTopicName = topic.substring(metatopiclength);
                    boolean isMatchingTopic = false;
                    isMatchingTopic = matcher == null ? topicFilter.compareTo(realTopicName) == 0 : matcher.matches(t, realTopicName);
                    if (isMatchingTopic) {
                        int groupnum = 0;
                        while (groupnum < msgParamGrouper.getGroupCount()) {
                            boolean fqmnMatched;
                            boolean foundMatch = false;
                            String trimmedCorrelid = msgParamGrouper.getStringValueFromGroup(t, groupnum, 3044);
                            String trimmedSubname = msgParamGrouper.getStringValueFromGroup(t, groupnum, 3053);
                            String trimmedQname = msgParamGrouper.getStringValueFromGroup(t, groupnum, 3043);
                            String trimmedQMname = msgParamGrouper.getStringValueFromGroup(t, groupnum, 3042);
                            if (correlidMatched && subnameMatched && qnameMatched && qmnameMatched) {
                                foundMatch = true;
                            }
                            boolean fcidMatched = correlidMatched || trimmedCorrelid != null && trimmedCorrelid.compareTo(trimmedCorrelidFilter) == 0 || trimmedCorrelid == null && trimmedCorrelidFilter.length() == 0;
                            boolean fsnMatched = subnameMatched || trimmedSubname != null && trimmedSubname.compareTo(trimmedSubnameFilter) == 0;
                            boolean fqnMatched = qnameMatched || trimmedQname != null && trimmedQname.compareTo(trimmedQnameFilter) == 0;
                            boolean bl = fqmnMatched = qmnameMatched || trimmedQMname != null && trimmedQMname.compareTo(trimmedQMnameFilter) == 0;
                            if (fcidMatched && fsnMatched && fqnMatched && fqmnMatched) {
                                foundMatch = true;
                            }
                            if (foundMatch) {
                                PCFMessage newResponse = new PCFMessage(2, responseType, 1, true);
                                newResponse.addParameter(3030, streams[s]);
                                newResponse.addParameter(3031, realTopicName);
                                msgParamGrouper.addParametersToMsgFromGroup(t, groupnum, newResponse, null, convertToListTemplate);
                                list.add(newResponse);
                            }
                            ++groupnum;
                        }
                    }
                }
                ++r;
            }
            ++s;
        }
        PCFMessage[] instances = list.toArray(new PCFMessage[list.size()]);
        return instances;
    }

    protected PCFMessage[] getIdentities(Trace t, int identityType, String[] streams, String topicFilter, int topicMatchCriteriaFilter) throws MQException, IOException {
        int responseType = identityType == 6 ? 11001 : 11002;
        PsTopicMatcher matcher = null;
        if (topicMatchCriteriaFilter == 1) {
            matcher = new PsTopicMatcher(t, topicFilter);
            topicFilter = this.trimWildcardCharsFromFilter(t, topicFilter);
        }
        ArrayList<PCFMessage> identityList = new ArrayList<PCFMessage>(100);
        ArrayList<Integer> referenceList = new ArrayList<Integer>(100);
        HashMap<String, Integer> uniqueMap = new HashMap<String, Integer>();
        int counter = 0;
        String metatopic = this.getMetaTopicString(t, identityType);
        int metatopiclength = metatopic.length() + 1;
        if (topicFilter != null) {
            metatopic = String.valueOf(metatopic) + TOPIC_DELIMITER + topicFilter;
        }
        int s = 0;
        while (s < streams.length) {
            PCFMessage[] responses = this.getMetaTopicInfo(t, streams[s], metatopic);
            int r = 0;
            while (r < responses.length) {
                PsPCFParameterGrouper msgParamGrouper;
                try {
                    msgParamGrouper = new PsPCFParameterGrouper(t, responses[r], 3042);
                }
                catch (Exception exception) {
                    msgParamGrouper = null;
                }
                if (msgParamGrouper != null) {
                    String topic = msgParamGrouper.getStringValueFromHeader(t, 3031);
                    String realTopicName = topic.substring(metatopiclength);
                    boolean isMatchingTopic = false;
                    isMatchingTopic = matcher == null ? topicFilter.compareTo(realTopicName) == 0 : matcher.matches(t, realTopicName);
                    if (isMatchingTopic) {
                        int groupnum = 0;
                        while (groupnum < msgParamGrouper.getGroupCount()) {
                            String identifier = msgParamGrouper.generateGroupIdentifier(t, groupnum, idTemplate);
                            if (!uniqueMap.containsKey(identifier)) {
                                uniqueMap.put(identifier, counter++);
                                PCFMessage newResponse = new PCFMessage(2, responseType, 1, true);
                                newResponse.addParameter(3030, streams[s]);
                                newResponse.addParameter(10029, String.valueOf(streams[s]) + identifier);
                                msgParamGrouper.addParametersToMsgFromGroup(t, groupnum, newResponse, ignoreTemplate, null);
                                identityList.add(newResponse);
                                referenceList.add(1);
                            } else {
                                int index = (Integer)uniqueMap.get(identifier);
                                int refCount = (Integer)referenceList.get(index);
                                referenceList.set(index, ++refCount);
                            }
                            ++groupnum;
                        }
                    }
                }
                ++r;
            }
            ++s;
        }
        int counterParam = responseType == 11001 ? 10028 : 10026;
        int i = 0;
        while (i < identityList.size()) {
            PCFMessage currentResponse = (PCFMessage)identityList.get(i);
            int refCount = (Integer)referenceList.get(i);
            currentResponse.addParameter(counterParam, refCount);
            ++i;
        }
        PCFMessage[] identities = identityList.toArray(new PCFMessage[identityList.size()]);
        return identities;
    }

    protected PCFMessage[] getMetaTopicInfo(Trace t, String stream, String metatopic) throws MQException, IOException {
        PCFMessage[] responses = EMPTY_RESPONSES;
        byte[] correlid = PsPaddedString.pad(Long.toString(System.currentTimeMillis()), 24).getBytes();
        try {
            this.subscribe(t, metatopic, stream, correlid, this.qmanager_name, this.subscriberQueue.name, 289);
        }
        catch (MQException e) {
            t.data(66, "PsPCFMonitorAgent.getMetaTopicInfo", Integer.MIN_VALUE, "PsPCFMonitorAgent.getMetaTopicInfo subscribe Exception:" + e.toString());
            throw e;
        }
        try {
            try {
                responses = this.requestUpdate(t, metatopic, stream, correlid, this.qmanager_name, this.subscriberQueue.name, 1);
            }
            catch (MQException e) {
                if (Trace.isTracing) {
                    t.data(66, "PsPCFMonitorAgent.getMetaTopicInfo", 900, "PsPCFMonitorAgent.getMetaTopicInfo requestUpdate Exception:" + e.toString());
                }
                if (e.reasonCode != 3077) {
                    throw e;
                }
                try {
                    this.unsubscribe(t, metatopic, stream, correlid, this.qmanager_name, this.subscriberQueue.name, 1);
                }
                catch (MQException e2) {
                    if (Trace.isTracing) {
                        t.data(66, "PsPCFMonitorAgent.getMetaTopicInfo", 900, "PsPCFMonitorAgent.getMetaTopicInfo unsubscribe exception:" + e2.toString());
                    }
                    throw e2;
                }
            }
        }
        finally {
            try {
                this.unsubscribe(t, metatopic, stream, correlid, this.qmanager_name, this.subscriberQueue.name, 1);
            }
            catch (MQException e) {
                if (Trace.isTracing) {
                    t.data(66, "PsPCFMonitorAgent.getMetaTopicInfo", 900, "PsPCFMonitorAgent.getMetaTopicInfo unsubscribe exception:" + e.toString());
                }
                throw e;
            }
        }
        return responses;
    }

    protected void subscribe(Trace t, String topic, String stream, byte[] correlid, String qmanager, String queue, int options) throws MQException, IOException {
        PCFMessage request = new PCFMessage(65);
        request.addParameter(3031, topic);
        if (stream != null) {
            request.addParameter(3030, stream);
        }
        if (qmanager != null) {
            request.addParameter(2015, qmanager);
        }
        if (queue != null) {
            request.addParameter(2016, queue);
        }
        if (options != 0) {
            request.addParameter(1081, options);
        }
        this.send(t, request, correlid, -1);
    }

    protected PCFMessage[] requestUpdate(Trace t, String topic, String stream, byte[] correlid, String qmanager, String queue, int options) throws MQException, IOException {
        PCFMessage request = new PCFMessage(66);
        request.addParameter(3031, topic);
        if (stream != null) {
            request.addParameter(3030, stream);
        }
        if (qmanager != null) {
            request.addParameter(2015, qmanager);
        }
        if (queue != null) {
            request.addParameter(2016, queue);
        }
        if (options != 0) {
            request.addParameter(1081, options);
        }
        this.send(t, request, correlid, -1);
        PCFMessage[] responses = this.getUpdates(t, correlid);
        return responses;
    }

    protected PCFMessage[] getUpdates(Trace t, byte[] correlid) throws MQException, IOException {
        MQMessage message = new MQMessage();
        Vector<PCFMessage> v = new Vector<PCFMessage>();
        int exceptionReason = 3008;
        boolean failed = false;
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        gmo.options = 24576;
        try {
            while (true) {
                message.messageId = null;
                message.correlationId = correlid;
                message.encoding = this.encoding;
                message.characterSet = this.defaultCharacterSet;
                this.subscriberQueue.get(message, gmo);
                PCFMessage response = new PCFMessage(message);
                v.addElement(response);
                if (!this.check || response.getCompCode() != 2) continue;
                if (response.getReason() == 3008) {
                    failed = true;
                    continue;
                }
                if (exceptionReason != 3008) continue;
                exceptionReason = response.getReason();
            }
        }
        catch (MQException e) {
            if (e.reasonCode != 2033) {
                throw e;
            }
            Object[] responses = new PCFMessage[v.size()];
            v.copyInto(responses);
            if (failed) {
                throw new PCFException(2, exceptionReason, (Object)responses);
            }
            if (this.check && responses.length == 1 && responses[0].getCompCode() == 2) {
                throw new PCFException(2, responses[0].getReason(), (Object)responses);
            }
            return responses;
        }
    }

    protected void unsubscribe(Trace t, String topic, String stream, byte[] correlid, String qmanager, String queue, int options) throws MQException, IOException {
        PCFMessage request = new PCFMessage(62);
        if (topic != null) {
            request.addParameter(3031, topic);
        }
        if (stream != null) {
            request.addParameter(3030, stream);
        }
        if (qmanager != null) {
            request.addParameter(2015, qmanager);
        }
        if (queue != null) {
            request.addParameter(2016, queue);
        }
        if (options != 0) {
            request.addParameter(1081, options);
        }
        this.send(t, request, correlid, -1);
    }

    protected PCFMessage[] psSend(Trace t, PCFMessage request, int msgExpiry) throws PCFException, MQException, IOException {
        PCFMessage response;
        if (this.controlQueue == null) {
            throw new MQException(2, 6124, (Object)this);
        }
        MQQueue publishQueue = null;
        if (this.mode == 60 || this.mode == 63) {
            PCFParameter p = request.getParameter(3030);
            if (p == null) {
                throw new MQException(2, 6124, (Object)this);
            }
            String pub_queue_name = p.getStringValue();
            publishQueue = this.qmanager.accessQueue(pub_queue_name, 8208, null, null, "mqm");
        }
        MQMessage message = this.setRequestMQMD(t, new MQMessage());
        if (msgExpiry == -1) {
            message.expiry = -1;
        } else if (msgExpiry != -2) {
            message.expiry = msgExpiry * 10;
        }
        request.write(message);
        if (publishQueue == null) {
            this.controlQueue.put(message, this.psPmo);
        } else {
            publishQueue.put(message, this.psPmo);
        }
        Vector<PCFMessage> v = new Vector<PCFMessage>();
        int exceptionReason = 3008;
        boolean failed = false;
        do {
            message.messageId = null;
            message.encoding = this.encoding;
            message.characterSet = this.defaultCharacterSet;
            this.replyQueue.get(message, this.psGmo);
            response = new PCFMessage(message);
            v.addElement(response);
            if (!this.check || response.getCompCode() != 2) continue;
            if (response.getReason() == 3008) {
                failed = true;
                continue;
            }
            if (exceptionReason != 3008) continue;
            exceptionReason = response.getReason();
        } while (response.getControl() != 1);
        Object[] responses = new PCFMessage[v.size()];
        v.copyInto(responses);
        if (failed) {
            throw new PCFException(2, exceptionReason, (Object)responses);
        }
        if (this.check && responses.length == 1 && responses[0].getCompCode() == 2) {
            throw new PCFException(2, responses[0].getReason(), (Object)responses);
        }
        if (publishQueue != null) {
            publishQueue.close();
        }
        return responses;
    }

    protected String[] getStreamsAsStringList(Trace t, String stream) {
        String[] streams;
        if (stream.compareTo("*") == 0) {
            if (useCachedStreamNames) {
                streams = this.getCachedStreamNamesAsStringList(t);
            } else {
                try {
                    streams = this.getAllStreamsAsStringList(t);
                }
                catch (Exception exception) {
                    streams = this.getCachedStreamNamesAsStringList(t);
                }
            }
        } else {
            streams = new String[]{stream};
        }
        return streams;
    }

    private String[] getAllStreamsAsStringList(Trace t) throws MQException, IOException {
        String metatopic = this.getMetaTopicString(t, 3);
        String stream = "SYSTEM.BROKER.ADMIN.STREAM";
        PCFMessage[] responses = this.getMetaTopicInfo(t, stream, metatopic);
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < responses.length) {
            Enumeration e = responses[i].getParameters();
            while (e.hasMoreElements()) {
                PCFParameter p = (PCFParameter)e.nextElement();
                int id = p.getParameter();
                if (id != 3036) continue;
                set.add(p.getStringValue());
            }
            ++i;
        }
        return set.toArray(new String[set.size()]);
    }

    private String[] getCachedStreamNamesAsStringList(Trace t) {
        String[] stream_names = null;
        stream_names = this.streamCache != null && this.streamCache.size() > 0 ? this.streamCache.toArray(new String[this.streamCache.size()]) : new String[]{"SYSTEM.BROKER.DEFAULT.STREAM"};
        return stream_names;
    }

    private String getMetaTopicString(Trace t, int metaTopicIdentifier) {
        String metatopic = null;
        String mtPrefix = null;
        String mtSuffix = null;
        switch (metaTopicIdentifier) {
            case 6: {
                mtPrefix = TOPIC_PREFIX_ALL;
                mtSuffix = TOPIC_PUB_ALL_IDS;
                break;
            }
            case 7: {
                mtPrefix = TOPIC_PREFIX_ALL;
                mtSuffix = TOPIC_SUB_ALL_IDS;
                break;
            }
            case 4: {
                mtPrefix = TOPIC_PREFIX;
                mtSuffix = TOPIC_PUB_IDS;
                break;
            }
            case 5: {
                mtPrefix = TOPIC_PREFIX;
                mtSuffix = TOPIC_SUB_IDS;
                break;
            }
            case 1: {
                mtPrefix = TOPIC_PREFIX;
                mtSuffix = TOPIC_SUB_TOPICS;
                break;
            }
            case 8: {
                mtPrefix = TOPIC_PREFIX;
                mtSuffix = TOPIC_SUB_TOPICS_SHORT;
                break;
            }
            case 2: {
                mtPrefix = TOPIC_PREFIX;
                mtSuffix = TOPIC_PUB_TOPICS;
                break;
            }
            case 3: {
                mtPrefix = "";
                mtSuffix = TOPIC_STREAMS;
                break;
            }
        }
        if (mtPrefix != null && mtSuffix != null) {
            metatopic = SYSTEM_TOPIC_PREFIX + mtPrefix + PsPaddedString.pad(this.qmanager_name, 48) + mtSuffix;
        }
        return metatopic;
    }

    private String getFilterString(Trace t, PCFMessage request, int filterId) {
        String filterString = "*";
        PCFParameter filterParam = request.getParameter(filterId);
        if (filterParam != null) {
            filterString = filterParam.getStringValue();
        }
        return filterString;
    }

    private int getTopicMatchCriteriaFilter(Trace t, PCFMessage request) {
        int topicMatchCriteriaFilter;
        try {
            topicMatchCriteriaFilter = request.getIntParameterValue(10032);
        }
        catch (PCFException pCFException) {
            topicMatchCriteriaFilter = 1;
        }
        return topicMatchCriteriaFilter;
    }

    private String trimWildcardCharsFromFilter(Trace t, String topicFilter) {
        int index = topicFilter.indexOf(42);
        if (index != -1) {
            topicFilter = topicFilter.substring(0, index);
        }
        if ((index = topicFilter.indexOf(63)) != -1) {
            topicFilter = topicFilter.substring(0, index);
        }
        topicFilter = String.valueOf(topicFilter) + "*";
        return topicFilter;
    }
}

