/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.internal.util;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.regex.Pattern;

public class PsTopicMatcher {
    public static final String COPYRIGHT = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/internal/util/PsTopicMatcher.java";
    public static final char WILDCARD_CHAR_ANY_SINGLE_CHARACTER = '?';
    public static final char WILDCARD_CHAR_ANY_CHARACTER_GROUP = '*';
    private static final char MATCH_CHAR_EXPLICIT_PERIOD = '.';
    private static final char REPLACE_CHAR_ANY_SINGLE_CHARACTER = '.';
    private static final String REPLACE_STRING_ANY_CHARACTER_GROUP = ".*";
    private static final String REPLACE_STRING_EXPLICIT_PERIOD = "\\.";
    String originalTopic = null;
    Pattern pattern = null;

    public PsTopicMatcher(Trace t, String topic) {
        this.originalTopic = topic;
        this.pattern = this.toRegex(t, topic);
    }

    public boolean matches(Trace t, String topicToMatch) {
        boolean isMatch = false;
        isMatch = this.pattern.matcher(topicToMatch).matches();
        return isMatch;
    }

    private Pattern toRegex(Trace t, String topic) {
        int length = topic.length();
        StringBuffer sb = new StringBuffer(length + 8);
        int i = 0;
        while (i < length) {
            char c = topic.charAt(i);
            switch (c) {
                case '?': {
                    sb.append('.');
                    break;
                }
                case '*': {
                    sb.append(REPLACE_STRING_ANY_CHARACTER_GROUP);
                    break;
                }
                case '.': {
                    sb.append(REPLACE_STRING_EXPLICIT_PERIOD);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return Pattern.compile(new String(sb));
    }
}

