/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.internal.util;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.explorer.pubsub.internal.util.MQRFH2NameValuePair;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PsMQRFH {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/internal/util/PsMQRFH.java";
    static final String[] pads = new String[]{"", " ", "  ", "   ", ""};
    public static String strucId = "RFH ";
    public int version = 1;
    public int strucLength = 32;
    public int encoding = 0;
    public int codedCharSetId = 0;
    public String format = "        ";
    public int flags = 0;
    Vector contents = new Vector();

    public static NameValuePair createNameValuePair(String name, String value) {
        return new MQRFH2NameValuePair(name, value);
    }

    public PsMQRFH() {
        this.setNameValueString("");
    }

    public PsMQRFH(String nameValueString) {
        this.setNameValueString(nameValueString);
    }

    public PsMQRFH(NameValuePair[] items) {
        this.setNameValuePairs(items);
    }

    public PsMQRFH(MQMessage message) throws MQException, IOException {
        this.initialize(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(MQMessage message) throws IOException {
        Vector vector = this.contents;
        synchronized (vector) {
            message.writeString("");
            message.writeString(strucId);
            message.writeInt(1);
            message.writeInt(this.size());
            message.writeInt(this.encoding);
            message.writeInt(this.codedCharSetId);
            message.writeString(this.format);
            message.writeInt(this.flags);
            Enumeration e = this.contents.elements();
            int size = 32;
            while (e.hasMoreElements()) {
                size += ((MQRFH2NameValuePair)e.nextElement()).write(message);
            }
            message.writeString("\u0000");
            int padLength = this.getPadLength(++size);
            message.writeString(pads[padLength]);
            return size + padLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(MQMessage message) throws MQException, IOException {
        if (!strucId.equals(message.readString(4))) {
            throw new MQException(2, 2334, (Object)this);
        }
        this.version = message.readInt();
        if (this.version != 1) {
            throw new MQException(2, 2334, (Object)this);
        }
        this.strucLength = message.readInt();
        if (this.strucLength < 32) {
            throw new MQException(2, 2334, (Object)this);
        }
        this.encoding = message.readInt();
        this.codedCharSetId = message.readInt();
        this.format = message.readString(8);
        this.flags = message.readInt();
        Vector vector = this.contents;
        synchronized (vector) {
            int remaining = this.strucLength - 32;
            StringTokenizer st = new StringTokenizer(message.readString(remaining), " \n\r\t\u0000");
            this.contents.clear();
            while (st.hasMoreTokens()) {
                this.contents.addElement(new MQRFH2NameValuePair(st));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 32;
        Vector vector = this.contents;
        synchronized (vector) {
            Enumeration e = this.contents.elements();
            while (e.hasMoreElements()) {
                size += ((MQRFH2NameValuePair)e.nextElement()).size();
            }
        }
        return size + this.getPadLength(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValuePair[] getNameValuePairs() throws IOException {
        Vector vector = this.contents;
        synchronized (vector) {
            Object[] array = new MQRFH2NameValuePair[this.contents.size()];
            this.contents.copyInto(array);
            return array;
        }
    }

    public String getNamedValue(String name) {
        NameValuePair nvp = this.getNameValuePair(name);
        return nvp == null ? null : nvp.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValuePair getNameValuePair(String name) {
        MQRFH2NameValuePair match = null;
        Vector vector = this.contents;
        synchronized (vector) {
            Enumeration e = this.contents.elements();
            while (match == null && e.hasMoreElements()) {
                MQRFH2NameValuePair nvp = (MQRFH2NameValuePair)e.nextElement();
                if (!name.equals(nvp.getName())) continue;
                match = nvp;
            }
        }
        return match;
    }

    public void addNameValuePair(NameValuePair item) {
        if (item != null) {
            MQRFH2NameValuePair nv = item.getClass() == MQRFH2NameValuePair.class ? (MQRFH2NameValuePair)item : new MQRFH2NameValuePair(item.getName(), item.getValue());
            this.contents.addElement(nv);
            this.strucLength = this.size();
        }
    }

    public void addNameValuePair(String name, String value) {
        this.addNameValuePair(new MQRFH2NameValuePair(name, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameValueString(String string) {
        Vector vector = this.contents;
        synchronized (vector) {
            this.contents.clear();
            this.strucLength = 32;
            StringTokenizer st = new StringTokenizer(string);
            while (st.hasMoreTokens()) {
                this.addNameValuePair(new MQRFH2NameValuePair(st));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameValuePairs(NameValuePair[] items) {
        Vector vector = this.contents;
        synchronized (vector) {
            this.contents.clear();
            this.strucLength = 32;
            int i = 0;
            while (i < items.length) {
                this.addNameValuePair(items[i]);
                ++i;
            }
        }
    }

    private int getPadLength(String string) {
        return string == null ? 0 : this.getPadLength(string.length());
    }

    private int getPadLength(int length) {
        int pad = length % 4;
        return pad > 0 ? 4 - pad : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.getClass().getName()) + " (size " + this.size() + " bytes): " + "\n   - strucId: " + strucId + "\n   - version: " + this.version + "\n   - strucLength: " + this.strucLength + "\n   - encoding: " + this.encoding + "\n   - codedCharSetId: " + this.codedCharSetId + "\n   - format: " + this.format + "\n   - flags: " + this.flags + "\n   - content: ");
        try {
            NameValuePair[] contents = this.getNameValuePairs();
            int i = 0;
            while (i < contents.length) {
                sb.append(contents[i]);
                sb.append(", ");
                ++i;
            }
            if (contents.length > 0) {
                sb.setLength(sb.length() - 2);
            }
        }
        catch (IOException ioe) {
            sb.append(ioe.getMessage());
        }
        return new String(sb);
    }

    public static interface NameValuePair {
        public String getName();

        public String getValue();
    }
}

