/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.internal.util;

import com.ibm.mq.explorer.pubsub.internal.util.PsPaddedString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PsHexString {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/internal/util/PsHexString.java";
    protected static char NON_PRINTABLE = (char)46;

    private PsHexString() {
    }

    static final char getChar(int b, boolean upperCase) {
        return upperCase ? Character.toUpperCase(Character.forDigit(b, 16)) : Character.toLowerCase(Character.forDigit(b, 16));
    }

    public static byte[] parseHex(String string) throws NumberFormatException {
        int lsd;
        int msd;
        byte[] bytes;
        int bytesLength;
        int b = 0;
        int s = 0;
        int stringLength = string.length();
        if (string.startsWith("0x") || string.startsWith("0X")) {
            s = 2;
            stringLength -= 2;
        }
        if ((stringLength & 1) == 1) {
            bytesLength = stringLength + 1 >> 1;
            bytes = new byte[bytesLength];
            msd = 0;
            if ((lsd = Character.digit(string.charAt(s++), 16)) < 0) {
                throw new NumberFormatException(String.valueOf(PsHexString.class.getName()) + ": Non-hexadecimal character in input");
            }
            bytes[b++] = (byte)(msd << 4 | lsd);
        } else {
            bytesLength = stringLength >> 1;
            bytes = new byte[bytesLength];
        }
        while (b < bytesLength) {
            msd = Character.digit(string.charAt(s++), 16);
            lsd = Character.digit(string.charAt(s++), 16);
            if (msd < 0 || lsd < 0) {
                throw new NumberFormatException(String.valueOf(PsHexString.class.getName()) + ": Non-hexadecimal character in input");
            }
            bytes[b++] = (byte)(msd << 4 | lsd);
        }
        return bytes;
    }

    public static String hexString(char c) {
        return PsHexString.hexString(c, false);
    }

    public static String hexString(char c, boolean upperCase) {
        StringBuffer sb = new StringBuffer(4);
        sb.append(PsHexString.getChar(c >> 12 & 0xF, upperCase));
        sb.append(PsHexString.getChar(c >> 8 & 0xF, upperCase));
        sb.append(PsHexString.getChar(c >> 4 & 0xF, upperCase));
        sb.append(PsHexString.getChar(c & 0xF, upperCase));
        return new String(sb);
    }

    public static String hexString(byte b) {
        return PsHexString.hexString(b, false);
    }

    public static String hexString(byte b, boolean upperCase) {
        StringBuffer sb = new StringBuffer(4);
        sb.append(PsHexString.getChar(b >> 4 & 0xF, upperCase));
        sb.append(PsHexString.getChar(b & 0xF, upperCase));
        return new String(sb);
    }

    public static String hexString(short s) {
        return PsHexString.hexString(s, false);
    }

    public static String hexString(short s, boolean upperCase) {
        StringBuffer sb = new StringBuffer(6);
        sb.append(PsHexString.getChar(s >> 12 & 0xF, upperCase));
        sb.append(PsHexString.getChar(s >> 8 & 0xF, upperCase));
        sb.append(PsHexString.getChar(s >> 4 & 0xF, upperCase));
        sb.append(PsHexString.getChar(s & 0xF, upperCase));
        return new String(sb);
    }

    public static String hexString(int i) {
        return PsHexString.hexString(i, false);
    }

    public static String hexString(int i, boolean upperCase) {
        StringBuffer sb = new StringBuffer(10);
        sb.append(PsHexString.getChar(i >> 28 & 0xF, upperCase));
        sb.append(PsHexString.getChar(i >> 24 & 0xF, upperCase));
        sb.append(PsHexString.getChar(i >> 20 & 0xF, upperCase));
        sb.append(PsHexString.getChar(i >> 16 & 0xF, upperCase));
        sb.append(PsHexString.getChar(i >> 12 & 0xF, upperCase));
        sb.append(PsHexString.getChar(i >> 8 & 0xF, upperCase));
        sb.append(PsHexString.getChar(i >> 4 & 0xF, upperCase));
        sb.append(PsHexString.getChar(i & 0xF, upperCase));
        return new String(sb);
    }

    public static String hexString(long l) {
        return PsHexString.hexString(l, false);
    }

    public static String hexString(long l, boolean upperCase) {
        StringBuffer sb = new StringBuffer(18);
        sb.append(PsHexString.getChar((int)(l >> 60 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 56 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 52 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 48 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 44 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 40 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 36 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 32 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 28 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 24 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 20 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 16 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 12 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 8 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l >> 4 & 0xFL), upperCase));
        sb.append(PsHexString.getChar((int)(l & 0xFL), upperCase));
        return new String(sb);
    }

    public static String hexString(byte[] bytes, char separator, int interval, boolean upperCase) {
        return PsHexString.hexString(bytes, 0, bytes.length, separator, interval, upperCase);
    }

    public static String hexString(byte[] bytes, int offset, int length, char separator, int interval, boolean upperCase) {
        StringBuffer sb = new StringBuffer(length * 2 + length % interval);
        length += offset;
        int i = offset;
        while (i < length) {
            if (i > 0 && i % interval == 0) {
                sb.append(separator);
            }
            sb.append(PsHexString.getChar(bytes[i] >> 4 & 0xF, upperCase));
            sb.append(PsHexString.getChar(bytes[i] & 0xF, upperCase));
            ++i;
        }
        return new String(sb);
    }

    public static String hexString(byte[] bytes) {
        return PsHexString.hexString(bytes, 0, bytes.length, false);
    }

    public static String hexString(byte[] bytes, boolean upperCase) {
        return PsHexString.hexString(bytes, 0, bytes.length, upperCase);
    }

    public static String hexString(byte[] bytes, int offset, int length) {
        return PsHexString.hexString(bytes, offset, length, false);
    }

    public static String hexString(byte[] bytes, int offset, int length, boolean upperCase) {
        StringBuffer sb = new StringBuffer(length * 2);
        length += offset;
        int i = offset;
        while (i < length) {
            sb.append(PsHexString.getChar(bytes[i] >> 4 & 0xF, upperCase));
            sb.append(PsHexString.getChar(bytes[i] & 0xF, upperCase));
            ++i;
        }
        return new String(sb);
    }

    public static String printPrintableChars(byte[] bytes) {
        return PsHexString.printPrintableChars(bytes, 0, bytes.length);
    }

    public static String printPrintableChars(byte[] bytes, int offset, int length) {
        char[] chars = new char[length];
        int i = offset;
        while (i < length) {
            chars[i] = bytes[i] < 32 || bytes[i] > 127 ? NON_PRINTABLE : (char)bytes[i];
            ++i;
        }
        return new String(chars);
    }

    public static int displayHexStream(InputStream input, OutputStream output) throws IOException {
        return PsHexString.displayHexStream(input, output, false);
    }

    public static int displayHexStream(InputStream input, OutputStream output, boolean indexed) throws IOException {
        int bufferSize = 20;
        int bytes = 0;
        int total = 0;
        byte[] buffer = new byte[bufferSize];
        byte[] newline = File.separatorChar == '\\' ? new String("\r\n").getBytes() : new String("\n").getBytes();
        while ((bytes = input.read(buffer)) >= 0) {
            if (indexed) {
                output.write(PsPaddedString.lead(total, '0', 10).getBytes());
                output.write(58);
                output.write(32);
            }
            if (bytes == bufferSize) {
                output.write(PsHexString.hexString(buffer, ' ', 4, true).getBytes());
            } else {
                output.write(PsPaddedString.pad(PsHexString.hexString(buffer, 0, bytes, ' ', 4, true), 44).getBytes());
            }
            output.write(32);
            output.write(39);
            output.write(PsHexString.printPrintableChars(buffer, 0, bytes).getBytes());
            output.write(39);
            output.write(newline);
            total += bytes;
        }
        return total;
    }
}

