/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.internal.util;

import com.ibm.mq.MQMessage;
import com.ibm.mq.explorer.pubsub.internal.util.PsMQRFH;
import java.io.IOException;
import java.util.StringTokenizer;

class MQRFH2NameValuePair
implements PsMQRFH.NameValuePair {
    final String name;
    final String value;

    public MQRFH2NameValuePair(String name, String value) {
        this.name = name;
        this.value = value;
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Name must be a non-null, non-empty string");
        }
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("Value must be a non-null, non-empty string");
        }
    }

    public MQRFH2NameValuePair(StringTokenizer st) {
        this(st.nextToken(), st.nextToken());
    }

    public int size() {
        return this.name.length() + this.value.length() + 2;
    }

    public int write(MQMessage message) throws IOException {
        message.writeString(this.getNameValueString());
        message.writeString(" ");
        return this.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getNameValueString() {
        return String.valueOf(this.name) + ' ' + this.value;
    }

    public String toString() {
        return String.valueOf(this.name) + '=' + this.value;
    }
}

