/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.pcf;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQueryTemplate;
import java.util.Hashtable;

public class PsPCFCommands
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/pcf/PsPCFCommands.java";
    public static final String SEPARATOR = "@";
    public static final Hashtable templates = new Hashtable();
    public static final int BASE = 1000;
    public static final int INQUIRE_TOPIC = 1000;
    public static final int INQUIRE_PUBLISHER = 1001;
    public static final int INQUIRE_SUBSCRIBER = 1002;
    public static final int INQUIRE_SUBSCRIPTION = 1003;
    public static final int INQUIRE_PUBLICATION = 1004;
    public static final int INQUIRE_STREAM = 1005;

    public static PCFQueryTemplate createTemplate(Trace t, String uuid, int type, String topic) {
        String key = String.valueOf(uuid) + SEPARATOR + String.valueOf(type) + SEPARATOR + topic;
        return PsPCFCommands.createTemplate(t, type, key);
    }

    public static PCFQueryTemplate createTemplate(Trace t, String uuid, int type) {
        String key = String.valueOf(uuid) + SEPARATOR + String.valueOf(type);
        return PsPCFCommands.createTemplate(t, type, key);
    }

    private static PCFQueryTemplate createTemplate(Trace t, int type, String key) {
        PCFQueryTemplate template = null;
        template = (PCFQueryTemplate)templates.get(key);
        if (template == null) {
            template = PsPCFCommands.createTemplate(t, type);
            templates.put(key, template);
            if (Trace.isTracing) {
                t.data(66, "PsPCFCommands.createTemplate", 300, "Using new template key " + key);
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsPCFCommands.createTemplate", 300, "Reusing template key " + key);
        }
        return template;
    }

    private static PCFQueryTemplate createTemplate(Trace t, int type) {
        PCFQueryTemplate p = null;
        switch (type) {
            case 1000: {
                p = new PCFQueryTemplate(11000, new PCFParameter[]{new MQCFST(3031, "*"), new MQCFIN(10032, 1), new MQCFST(3030, "*")}, 2085);
                p.setKeyAttrs(new int[]{3031, 3030});
                p.setResponseNameId(3031);
                break;
            }
            case 1001: {
                p = new PCFQueryTemplate(11001, new PCFParameter[]{new MQCFST(10031, "*"), new MQCFIN(10032, 1), new MQCFST(3030, "*")}, 2085);
                p.setKeyAttrs(new int[]{10029});
                p.setResponseNameId(3043);
                break;
            }
            case 1002: {
                p = new PCFQueryTemplate(11002, new PCFParameter[]{new MQCFST(10031, "*"), new MQCFIN(10032, 1), new MQCFST(3030, "*")}, 2085);
                p.setKeyAttrs(new int[]{10029});
                p.setResponseNameId(3043);
                break;
            }
            case 1003: {
                p = new PCFQueryTemplate(11003, new PCFParameter[]{new MQCFST(10031, "*"), new MQCFIN(10032, 1), new MQCFST(3030, "*"), new MQCFST(3053, "*"), new MQCFST(3044, "*"), new MQCFST(3043, "*"), new MQCFST(3042, "*")}, 2085);
                p.setKeyAttrs(new int[]{3031, 3030});
                p.setResponseNameId(3031);
                break;
            }
            case 1004: {
                p = new PCFQueryTemplate(11004, new PCFParameter[]{new MQCFST(10031, "*"), new MQCFIN(10032, 1), new MQCFST(3030, "*"), new MQCFST(3044, "*"), new MQCFST(3043, "*"), new MQCFST(3042, "*")}, 2085);
                p.setKeyAttrs(new int[]{3031, 3030});
                p.setResponseNameId(3031);
                break;
            }
            case 1005: {
                p = new PCFQueryTemplate(11005, new PCFParameter[]{new MQCFST(3030, "*")}, 2085);
                p.setKeyAttrs(new int[]{3030});
            }
        }
        return p;
    }
}

