/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class PsPCFAction
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/pcf/PsPCFAction.java";
    private PsObject dmObject = null;
    private PCFMessage request = null;
    private int command = 0;
    private int action = 0;
    private DmActionListener listener = null;
    private int reasonCode = 0;
    private int completionCode = 0;
    private DmCoreException dmCoreException = null;
    public static final String SEPARATOR = "@";

    public PsPCFAction(Trace t, int cmd, PsObject dmo) {
        this.dmObject = dmo;
        this.command = cmd;
        this.request = new PCFMessage(cmd);
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(66, "PsPCFAction.run", 300, "Running asynchronous PsPCFAction " + this.command + " for " + this.dmObject.getTitle());
        }
        this.reasonCode = this.execute(t);
        if (Trace.isTracing) {
            t.data(66, "PsPCFAction.run", 300, "Notifying listener, rc=" + this.reasonCode);
        }
        if (this.reasonCode == 0) {
            this.listener.dmActionDone(new DmActionEvent((Object)this.dmObject, this.command, this.reasonCode));
        } else {
            String msg = ConvertReasonCode.getSystemMessage((Trace)t, (DmObject)this.dmObject, (int)this.command, (int)this.reasonCode, (int)this.completionCode);
            String msgId = CommonServices.getSystemMessageId((Trace)t, (int)this.reasonCode);
            this.dmCoreException = new DmCoreException(t, msg, msgId, this.reasonCode, this.completionCode, 20);
            this.listener.dmActionDone(new DmActionEvent((Object)this.dmObject, this.command, this.reasonCode, this.dmCoreException));
        }
    }

    protected void addParameter(Trace t, PCFParameter parameter) {
        this.request.addParameter(parameter);
    }

    public int execute(Trace t, DmActionListener aListener) {
        return this.execute(t, aListener, 4);
    }

    public int execute(Trace t, DmActionListener _Listener, int _action) {
        int rc = 0;
        this.action = _action;
        if (_Listener == null) {
            rc = this.execute(t);
        } else {
            this.listener = _Listener;
            this.start();
        }
        return rc;
    }

    protected int execute(Trace t) {
        int rc;
        block13: {
            rc = 2149;
            if (Trace.isTracing) {
                t.data(66, "PsPCFAction.execute", 300, "Sending PCF command " + this.command + " for " + this.dmObject.getTitle() + " to " + this.dmObject.getQueueManager().getTitle() + "\n" + this.request.toString());
            }
            if (this.dmObject.getParentBroker().isRunning(t)) {
                try {
                    PCFMessage[] responses = this.dmObject.getParentBroker().getPsMonitorAgent(t).update(t, this.request);
                    if (responses != null && responses.length > 0) {
                        PCFMessage message = responses[0];
                        rc = message.getReason();
                    }
                    break block13;
                }
                catch (MQException mqe) {
                    rc = mqe.reasonCode;
                    if (rc == 2033) {
                        rc = 50054;
                    }
                    if (Trace.isTracing) {
                        t.data(66, "PsPCFAction.execute", 300, mqe.toString());
                    }
                    break block13;
                }
                catch (IOException e) {
                    if (Trace.isTracing) {
                        t.data(66, "PsPCFAction.execute", 300, e.toString());
                    }
                    break block13;
                }
                catch (DmCoreException e) {
                    if (Trace.isTracing) {
                        t.data(66, "PsPCFAction.execute", 300, e.toString());
                    }
                    break block13;
                }
            }
            if (Trace.isTracing) {
                t.data(66, "PsPCFAction.execute", 300, "Pub/sub broker not running");
            }
        }
        if (Trace.isTracing) {
            t.data(66, "PsPCFAction.execute", 300, "Return code = " + rc);
        }
        return rc;
    }

    public PCFMessage getRequest(Trace t) {
        return this.request;
    }
}

