/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.pcf.PsPCFAction;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;

public class PsTopic
extends PsObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/objects/PsTopic.java";
    protected static final String DEFAULT = "SYSTEM/BROKER/DEFAULT/TOPIC";
    private static HashMap allAttributesByType = null;
    private boolean wildcardName = false;

    public PsTopic(Trace t, PsBroker _broker, String _an) {
        super(t, _broker, _an, 1501);
        this.initAttrTypeTable(t, this.getQueueManager().getCommandLevel(), this.getQueueManager().getPlatform());
        this.init(t);
    }

    public static boolean staticInit(Trace t, Bundle bundle) {
        allAttributesByType = PsTopic.initAllAttrTypeTable(t, PsTopic.getClassName((String)PsTopic.class.getName()), allAttributesByType, bundle);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(66, "PsTopic.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 3031, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return PsTopic.getAttributeTitle((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return PsTopic.getAttributeType((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return PsTopic.getAttributeDefaultValue((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return PsTopic.getDisplayColumnSequence((Trace)t, (HashMap)allAttributesByType, (int[])ids, (boolean)zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return PsTopic.isAttributeRepeating((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return PsTopic.getAllAttributesByType((Trace)t, (HashMap)allAttributesByType);
    }

    public String toString(Trace t) {
        return this.getTitle();
    }

    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 61, this);
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        cmd.getRequest(t).addParameter(2015, this.getQueueManagerName(t));
        cmd.getRequest(t).addParameter(2016, this.getQueueName(t));
        this.addDeregistrationOptions(t, parms, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        return rc;
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        return rc;
    }

    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT)) {
            retValue = true;
        }
        return retValue;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    public int[] getMandatoryIds(Trace t) {
        return PsTopic.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{3031};
    }

    public void initialize(Trace t) {
        this.setName(t, 3031);
        this.setDefaultAttribute(t, 3030);
        this.determineWildcardName(t);
    }

    public int actionPublish(Trace t, DmActionListener listener, int pubOptions, int regOptions, String queueManager, String queue, String timestamp, int seq, String sData, int iData, int timeout) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 63, this);
        cmd.getRequest(t).addParameter(3031, this.getTopicName(t));
        if (regOptions != 0) {
            cmd.getRequest(t).addParameter(1081, regOptions);
        }
        if (pubOptions != 0) {
            cmd.getRequest(t).addParameter(1082, pubOptions);
        }
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        if (queueManager != null) {
            cmd.getRequest(t).addParameter(2015, queueManager);
        }
        if (queue != null) {
            cmd.getRequest(t).addParameter(2016, queue);
        }
        if (timestamp != null) {
            cmd.getRequest(t).addParameter(3034, timestamp);
        }
        if (seq != -1) {
            cmd.getRequest(t).addParameter(1079, seq);
        }
        if (sData != null && !sData.equals("")) {
            cmd.getRequest(t).addParameter(3035, sData);
        }
        if (iData != -1) {
            cmd.getRequest(t).addParameter(1080, iData);
        }
        cmd.getRequest(t).addParameter(10024, timeout);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionDeletePublication(Trace t, DmActionListener listener, int option) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 60, this);
        cmd.getRequest(t).addParameter(3031, this.getTopicName(t));
        if (option == 4) {
            cmd.getRequest(t).addParameter(1092, option);
        }
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        rc = cmd.execute(t, listener);
        return rc;
    }

    private void determineWildcardName(Trace t) {
        String name = this.getAttributeValue(t, 3031, 0);
        this.wildcardName = this.checkForWildcard(t, name, "*", "%");
        if (!this.wildcardName) {
            this.wildcardName = this.checkForWildcard(t, name, "?", "%");
        }
    }

    private boolean checkForWildcard(Trace t, String name, String wildcard, String escape) {
        String token = null;
        String prevToken = null;
        boolean found = false;
        if (name.indexOf(wildcard) > -1) {
            StringTokenizer st = new StringTokenizer(name, wildcard, true);
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals(wildcard) && (prevToken == null || !prevToken.endsWith(escape))) {
                    found = true;
                    break;
                }
                prevToken = token;
            }
        }
        return found;
    }

    public boolean isWildcardName() {
        return this.wildcardName;
    }

    public void removePublisherCount(Trace t) {
        if (this.wildcardName) {
            AttrKey attrKey = new AttrKey(10027, 0);
            this.getAttributesTable(t).remove(attrKey);
        }
    }
}

