/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.pcf.PsPCFAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class PsSubscriber
extends PsObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/objects/PsSubscriber.java";
    protected static final String DEFAULT = "SYSTEM???";
    private static HashMap allAttributesByType = null;

    public PsSubscriber(Trace t, PsBroker _broker, String _an) {
        super(t, _broker, _an, 1502);
        this.initAttrTypeTable(t, this.getQueueManager().getCommandLevel(), this.getQueueManager().getPlatform());
        this.init(t);
    }

    public static boolean staticInit(Trace t, Bundle bundle) {
        allAttributesByType = PsSubscriber.initAllAttrTypeTable(t, PsSubscriber.getClassName((String)PsSubscriber.class.getName()), allAttributesByType, bundle);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(66, "PsSubscriber.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public boolean init(Trace t) {
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return PsSubscriber.getAttributeTitle((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return PsSubscriber.getAttributeType((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return PsSubscriber.getAttributeDefaultValue((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return PsSubscriber.getDisplayColumnSequence((Trace)t, (HashMap)allAttributesByType, (int[])ids, (boolean)zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return PsSubscriber.isAttributeRepeating((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return PsSubscriber.getAllAttributesByType((Trace)t, (HashMap)allAttributesByType);
    }

    public String toString(Trace t) {
        return this.getTitle();
    }

    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 62, this);
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        cmd.getRequest(t).addParameter(2015, this.getQueueManagerName(t));
        cmd.getRequest(t).addParameter(2016, this.getQueueName(t));
        this.addDeregistrationOptions(t, parms, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 65, this);
        cmd.getRequest(t).addParameter(3031, this.getTitle());
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        int regOptions = this.getRegistrationOptions(t, job);
        if (regOptions != 0) {
            cmd.getRequest(t).addParameter(1081, regOptions);
            if ((regOptions & 1) != 0) {
                cmd.getRequest(t).addParameter(10023, this.getCorrelId(t, job));
            }
        }
        cmd.getRequest(t).addParameter(10024, this.getMessageTimeOut(t, job));
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        return rc;
    }

    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT)) {
            retValue = true;
        }
        return retValue;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    public int[] getMandatoryIds(Trace t) {
        return PsSubscriber.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{3031};
    }

    public void initialize(Trace t) {
        this.setDefaultAttribute(t, 3030);
        this.setDefaultAttribute(t, 3044);
    }

    public int actionDeregister(Trace t, DmActionListener listener, int options, String stream, String topic, String subName, String subId, String queueManager, String queue, String correlid, int timeout) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 62, this);
        cmd.getRequest(t).addParameter(1081, options);
        if (stream != null) {
            cmd.getRequest(t).addParameter(3030, stream);
        }
        if (queueManager != null) {
            cmd.getRequest(t).addParameter(2015, queueManager);
        }
        if (queue != null) {
            cmd.getRequest(t).addParameter(2016, queue);
        }
        if (subName != null) {
            cmd.getRequest(t).addParameter(3052, subName);
        }
        if (subId != null) {
            cmd.getRequest(t).addParameter(3054, subId);
        }
        if ((options & 0x40) == 0) {
            cmd.getRequest(t).addParameter(3031, topic);
        }
        if (correlid != null) {
            cmd.getRequest(t).addParameter(10023, correlid);
        }
        cmd.getRequest(t).addParameter(10024, timeout);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionDeregister(Trace t, DmActionListener listener, int parms, String topic) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 62, this);
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        cmd.getRequest(t).addParameter(2015, this.getQueueManagerName(t));
        cmd.getRequest(t).addParameter(2016, this.getQueueName(t));
        this.addDeregistrationOptions(t, parms, topic, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    public int actionRemoveIdentity(Trace t, DmActionListener listener, int parms, String topic, String id) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 62, this);
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        cmd.getRequest(t).addParameter(2015, this.getQueueManagerName(t));
        cmd.getRequest(t).addParameter(2016, this.getQueueName(t));
        cmd.getRequest(t).addParameter(3054, id);
        this.addDeregistrationOptions(t, parms, topic, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    public int actionRequestUpdate(Trace t, DmActionListener listener, int options, String stream, String topic, String queueManager, String queue, String correlid) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 66, this);
        cmd.getRequest(t).addParameter(1081, options);
        if (stream != null) {
            cmd.getRequest(t).addParameter(3030, stream);
        }
        if (queueManager != null) {
            cmd.getRequest(t).addParameter(2015, queueManager);
        }
        if (queue != null) {
            cmd.getRequest(t).addParameter(2016, queue);
        }
        if (topic != null) {
            cmd.getRequest(t).addParameter(3031, topic);
        }
        if (correlid != null) {
            cmd.getRequest(t).addParameter(10023, correlid);
        }
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    public static int[] getPseudoRegistrationOptions(Trace t) {
        return PsSubscriber.getPseudoRegistrationOptions(t, allAttributesByType);
    }
}

