/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublication;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsStream;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsTopic;

public class PsObjectFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/objects/PsObjectFactory.java";

    private PsObjectFactory() {
    }

    public static PsObject create(Trace t, PsBroker broker, int objectType, String name) {
        PsObject object = null;
        switch (objectType) {
            case 1504: {
                object = new PsPublisher(t, broker, name);
                break;
            }
            case 1508: {
                object = new PsRegisterPublisher(t, broker, name);
                break;
            }
            case 1506: {
                object = new PsPublication(t, broker, name);
                break;
            }
            case 1502: {
                object = new PsSubscriber(t, broker, name);
                break;
            }
            case 1509: {
                object = new PsRegisterSubscriber(t, broker, name);
                break;
            }
            case 1505: {
                object = new PsStream(t, broker, name);
                break;
            }
            case 1503: {
                object = new PsSubscription(t, broker, name);
                break;
            }
            case 1501: {
                object = new PsTopic(t, broker, name);
                break;
            }
            case 1507: {
                object = new PsTopic(t, broker, name);
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(66, "PsObjectFactory.create", 900, "Invalid Ps object type : " + objectType);
                }
                return null;
            }
        }
        object.initialize(t);
        return object;
    }

    public static PsObject create(Trace t, PsBroker broker, int objectType, String name, String stream) {
        PsObject object = null;
        object = PsObjectFactory.create(t, broker, objectType, name);
        object.replaceAttributeValue(t, 3030, 0, stream, false);
        return object;
    }
}

