/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.explorer.pubsub.core.internal.objects.IPsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublication;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.core.internal.pcf.PsPCFAction;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import org.osgi.framework.Bundle;

public abstract class PsObject
extends DmObject
implements IPsObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/objects/PsObject.java";
    public static final String SYSTEM_NAME = "MQ/";
    public static final String ENABLED = "YES";
    public static final String DISABLED = "NO";
    public static final int DEFAULT_MESSAGE_TIMEOUT = 30;
    public static final int TYPE_BROKER = 1500;
    public static final int TYPE_TOPIC = 1501;
    public static final int TYPE_SUBSCRIBER = 1502;
    public static final int TYPE_SUBSCRIPTION = 1503;
    public static final int TYPE_PUBLISHER = 1504;
    public static final int TYPE_STREAM = 1505;
    public static final int TYPE_PUBLICATION = 1506;
    public static final int TYPE_MESSAGE = 1507;
    public static final int TYPE_REGISTER_PUBLISHER = 1508;
    public static final int TYPE_REGISTER_SUBSCRIBER = 1509;
    public static final int NO_SEQUENCE_NUMBER = -1;
    public static final int NO_INTEGER_DATA = -1;
    protected PsBroker parentBroker = null;
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private static final DateFormat timeFormat = DateFormat.getTimeInstance();
    private Calendar localDate = Calendar.getInstance(Locale.getDefault());

    public PsObject(Trace t, PsBroker _broker, String _name, int _type) {
        super(_name, _type);
        this.queueManager = _broker.getQueueManager();
        this.parentBroker = _broker;
    }

    public PsObject(Trace t, String _name, int _type) {
        super(_name, _type);
    }

    protected static HashMap initAllAttrTypeTable(Trace t, String name, HashMap hm, Bundle bundle) {
        if (hm != null) {
            if (Trace.isTracing) {
                t.data(66, "PsObject.initAllAttrTypeTable", 300, "allAttributesByType table already initialized");
            }
            return hm;
        }
        hm = TableFactory.getHashMap((Trace)t, (String)name, (Bundle)bundle);
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "PsObject.initAllAttrTypeTable", 900, "Error loading allAttributesByType table for " + name);
            }
            return null;
        }
        return hm;
    }

    protected boolean initAttrTypeTable(Trace t, int commandLevel, int platform) {
        if (this.attributesByType != null) {
            if (Trace.isTracing) {
                t.data(66, "PsObject.initAttrTypeTable", 300, "AttrType table already initialized");
            }
            return true;
        }
        this.attributesByType = TableFactory.getHashMap((Trace)t, (String)PsObject.getClassName((String)this.getClass().getName()), (int)commandLevel, (int)platform);
        if (this.attributesByType == null) {
            if (Trace.isTracing) {
                t.data(66, "PsObject.initAttrTypeTable", 900, "Error loading attributesByType table");
            }
            return false;
        }
        return true;
    }

    public PsBroker getParentBroker() {
        return this.parentBroker;
    }

    public static String getTypeName(Trace t, int objectType) {
        switch (objectType) {
            case 1500: {
                return "PsBroker";
            }
            case 1501: {
                return "PsTopic";
            }
            case 1502: {
                return "PsSubscriber";
            }
            case 1509: {
                return "PsRegisterSubscriber";
            }
            case 1503: {
                return "PsSubscription";
            }
            case 1504: {
                return "PsPublisher";
            }
            case 1508: {
                return "PsRegisterPublisher";
            }
            case 1506: {
                return "PsPublication";
            }
            case 1505: {
                return "PsStream";
            }
            case 1507: {
                return "PsMessage";
            }
        }
        if (Trace.isTracing) {
            t.data(66, "PsObject.getTypeName", 900, "Unknown object type, passing to Dm model");
        }
        return DmObject.getTypeName((Trace)t, (int)objectType);
    }

    public static int[] getMandatoryIds(Trace t, int type, int subType) {
        int[] ids = null;
        switch (type) {
            case 1500: {
                ids = PsBroker.getMandatoryIds();
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(66, "PsObject.getMandatoryIds", 900, "Unknown object type : " + type + ", subType = " + subType);
                }
                ids = new int[]{};
            }
        }
        return ids;
    }

    public boolean isMandatoryId(Trace t, int id) {
        boolean retValue = false;
        int type = this.getObjectType(t);
        int subType = this.getObjectSubType(t);
        int[] mandatoryIds = DmQueueManager.getMandatoryIds((Trace)t, (int)type, (int)subType);
        int i = 0;
        while (i < mandatoryIds.length) {
            if (mandatoryIds[i] == id) {
                retValue = true;
                break;
            }
            ++i;
        }
        return retValue;
    }

    protected void setAttributesTable(Trace t, Hashtable newTable) {
        this.attributes.clear();
        this.attributes = newTable;
    }

    protected HashMap getAttributesByType() {
        return this.attributesByType;
    }

    public static synchronized PsObject getPsObject(Trace t, ArrayList al, String name) {
        PsObject retValue = null;
        boolean found = false;
        int index = 0;
        index = 0;
        while (index < al.size()) {
            block8: {
                try {
                    retValue = (PsObject)al.get(index);
                    if (name.equals(retValue.getDmTitle()) || name.equals(retValue.getTitle())) {
                        found = true;
                        break;
                    }
                }
                catch (ClassCastException cce) {
                    if (!Trace.isTracing) break block8;
                    t.data(66, "PsObject.getPsObject", 1000, "Error getting Ps object : " + cce.getMessage());
                }
            }
            ++index;
        }
        if (!found) {
            retValue = null;
        }
        if (Trace.isTracing) {
            if (found) {
                t.data(66, "PsObject.getPsObject", 300, "Title " + name + " found in list");
            } else {
                t.data(66, "PsObject.getPsObject", 300, "Title " + name + " not found in list");
            }
        }
        return retValue;
    }

    public String getStreamName(Trace t) {
        String streamName = this.getAttributeValue(t, 3030, 0);
        return streamName;
    }

    public String getQueueManagerName(Trace t) {
        String qMgrName = this.getAttributeValue(t, 2015, 0);
        if (qMgrName.equals("") || qMgrName.equalsIgnoreCase("[not_found]")) {
            qMgrName = this.getAttributeValue(t, 3042, 0);
        }
        if (qMgrName.equalsIgnoreCase("[not_found]")) {
            qMgrName = "";
        }
        return qMgrName;
    }

    public String getQueueName(Trace t) {
        String queueName = this.getAttributeValue(t, 2016, 0);
        if (queueName.equals("") || queueName.equalsIgnoreCase("[not_found]")) {
            queueName = this.getAttributeValue(t, 3043, 0);
        }
        if (queueName.equalsIgnoreCase("[not_found]")) {
            queueName = "";
        }
        return queueName;
    }

    public String getTopicName(Trace t) {
        String topicName = this.getAttributeValue(t, 3031, 0);
        if (topicName.equals("") || topicName.equalsIgnoreCase("[not_found]")) {
            topicName = this.getAttributeValue(t, 3037, 0);
        }
        if (topicName.equalsIgnoreCase("[not_found]")) {
            topicName = "";
        }
        return topicName;
    }

    protected void setDefaultAttribute(Trace t, int id) {
        AttrType attrType;
        Attr attr = this.getAttribute(t, id, 0);
        if (attr == null && (attrType = PsObject.getAttributeType((Trace)t, (HashMap)this.attributesByType, (int)id)) != null) {
            this.addAttr(t, this.attributesByType, id, 0, attrType.getDefaultValue(t));
        }
    }

    protected String getCorrelId(Trace t, Object job) {
        String retValue = "";
        Hashtable table = this.getUpdateTable(t, job);
        if (table.size() != 0) {
            AttrKey ak = new AttrKey(10023, 0);
            Attr attr = (Attr)table.get(ak);
            if (attr != null) {
                try {
                    retValue = (String)attr.getNewValue(t);
                    if (Trace.isTracing) {
                        t.data(66, "PsObject.getCorrelId", 300, "Found correl id : " + retValue);
                    }
                }
                catch (ClassCastException classCastException) {
                    if (Trace.isTracing) {
                        t.data(66, "PsObject.getCorrelId", 900, "Error getting correl id");
                    }
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsObject.getCorrelId", 300, "No attributes found in update table");
        }
        if (retValue.equals("")) {
            retValue = Long.toString(System.currentTimeMillis());
            if (Trace.isTracing) {
                t.data(66, "PsObject.getCorrelId", 300, "Using generated correl id : " + retValue);
            }
        }
        if (retValue.length() > 48) {
            retValue = retValue.substring(0, 47);
            if (Trace.isTracing) {
                t.data(66, "PsObject.getCorrelId", 300, "Reducing length of correl id : " + retValue);
            }
        }
        return retValue;
    }

    protected int getRegistrationOptions(Trace t, Object job) {
        int retValue = 0;
        int regOptions = 0;
        Hashtable table = this.getUpdateTable(t, job);
        if (table.size() == 0) {
            if (Trace.isTracing) {
                t.data(66, "PsObject.getRegistrationOptions", 300, "No attributes found in update table");
            }
            return retValue;
        }
        Set k = table.keySet();
        for (AttrKey ak : k) {
            Attr attr = (Attr)table.get(ak);
            int option = this.getRealRegistrationOption(t, attr.getAttributeID());
            if (option == 0 || !this.isRegistrationOptionEnabled(t, attr)) continue;
            retValue = regOptions |= option;
        }
        return retValue;
    }

    protected boolean isAttrInJob(Trace t, Object job, int id, int repeating) {
        boolean retValue = false;
        Hashtable table = this.getUpdateTable(t, job);
        if (table.size() == 0) {
            return retValue;
        }
        Attr at = (Attr)table.get(new AttrKey(id, repeating));
        if (at != null) {
            retValue = true;
        }
        return retValue;
    }

    private boolean isRegistrationOptionEnabled(Trace t, Attr attr) {
        String newValue;
        boolean enabled = false;
        if (attr != null && (newValue = (String)attr.getNewValue(t)).equalsIgnoreCase(ENABLED)) {
            enabled = true;
        }
        return enabled;
    }

    public boolean isVariableUseridOptionEnabled(Trace t) {
        String value;
        boolean enabled = false;
        Attr attr = this.getAttribute(t, 10017, 0);
        if (attr != null && (value = (String)attr.getValue(t)).equalsIgnoreCase(ENABLED)) {
            enabled = true;
        }
        return enabled;
    }

    private int getRealRegistrationOption(Trace t, int pseudo) {
        int option = 0;
        switch (pseudo) {
            case 10016: {
                option = 16384;
                break;
            }
            case 10003: {
                option = 2;
                break;
            }
            case 10006: {
                option = 1;
                break;
            }
            case 10005: {
                option = 8;
                break;
            }
            case 10011: {
                option = 512;
                break;
            }
            case 10022: {
                option = 65536;
                break;
            }
            case 10009: {
                option = 128;
                break;
            }
            case 10010: {
                option = 256;
                break;
            }
            case 10019: {
                option = 262144;
                break;
            }
            case 10020: {
                option = 131072;
                break;
            }
            case 10004: {
                option = 4;
                break;
            }
            case 10021: {
                option = 0x200000;
                break;
            }
            case 10007: {
                option = 16;
                break;
            }
            case 10018: {
                option = 32768;
                break;
            }
            case 10012: {
                option = 1024;
                break;
            }
            case 10013: {
                option = 2048;
                break;
            }
            case 10014: {
                option = 4096;
                break;
            }
            case 10015: {
                option = 8192;
                break;
            }
            case 10008: {
                option = 32;
                break;
            }
            case 10017: {
                option = 0x100000;
            }
        }
        return option;
    }

    protected int addDeregistrationOptions(Trace t, Object parms, PsPCFAction cmd) {
        String correlId;
        int options;
        block6: {
            options = 0;
            if (parms != null) {
                try {
                    options = ((int[])parms)[0];
                }
                catch (ClassCastException classCastException) {
                    if (!Trace.isTracing) break block6;
                    t.data(66, "PsObject.addDeregistrationOptions", 900, "Error getting deregistration options, using default");
                }
            }
        }
        if (!(correlId = this.getCorrelId(t)).equals("")) {
            cmd.getRequest(t).addParameter(10023, correlId);
            options |= 1;
        }
        if (this.isVariableUseridOptionEnabled(t)) {
            options |= 0x100000;
        }
        if ((options & 0x40) == 0) {
            cmd.getRequest(t).addParameter(3031, this.getTopicName(t));
        }
        cmd.getRequest(t).addParameter(1081, options);
        cmd.getRequest(t).addParameter(10024, this.getMessageTimeOut(t));
        return options;
    }

    protected int addDeregistrationOptions(Trace t, int options, String topic, PsPCFAction cmd) {
        String correlId = this.getCorrelId(t);
        if (!correlId.equals("")) {
            cmd.getRequest(t).addParameter(10023, correlId);
            options |= 1;
        }
        if (this.isVariableUseridOptionEnabled(t)) {
            options |= 0x100000;
        }
        if ((options & 0x40) == 0) {
            cmd.getRequest(t).addParameter(3031, topic);
        }
        cmd.getRequest(t).addParameter(1081, options);
        cmd.getRequest(t).addParameter(10024, this.getMessageTimeOut(t));
        return options;
    }

    public String getCorrelId(Trace t) {
        String correlId = this.getAttributeValue(t, 3033, 0);
        if (correlId.equals("") || correlId.equalsIgnoreCase("[not_found]")) {
            correlId = this.getAttributeValue(t, 3044, 0);
        }
        if (correlId.equalsIgnoreCase("[not_found]")) {
            correlId = "";
        }
        return correlId;
    }

    public boolean isSystemObject(Trace t) {
        boolean retValue = false;
        if (this.getTitle().startsWith(SYSTEM_NAME)) {
            retValue = true;
        }
        return retValue;
    }

    public int getMessageTimeOut(Trace t) {
        int timeout;
        block4: {
            timeout = 30;
            Attr a = this.getAttribute(t, 10024, 0);
            if (a != null) {
                try {
                    Integer i = (Integer)a.getValue(t);
                    timeout = i;
                }
                catch (ClassCastException classCastException) {
                    if (!Trace.isTracing) break block4;
                    t.data(66, "PsObject.getMessageTimeOut", 900, "Error getting message timeout value");
                }
            }
        }
        if (Trace.isTracing) {
            t.data(66, "PsObject.getMessageTimeOut", 300, "Message timeout : " + timeout);
        }
        return timeout;
    }

    protected int getMessageTimeOut(Trace t, Object job) {
        int timeout = this.getDefaultTimeOut(t);
        Hashtable table = this.getUpdateTable(t, job);
        if (table.size() != 0) {
            AttrKey ak = new AttrKey(10024, 0);
            Attr attr = (Attr)table.get(ak);
            if (attr != null) {
                try {
                    Integer i = (Integer)attr.getNewValue(t);
                    timeout = i;
                }
                catch (ClassCastException classCastException) {
                    if (Trace.isTracing) {
                        t.data(66, "PsObject.getMessageTimeOut", 900, "Error getting message timeout value");
                    }
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsObject.getMessageTimeOut", 300, "No attributes found in update table");
        }
        return timeout;
    }

    protected int getDefaultTimeOut(Trace t) {
        return 30;
    }

    @Override
    public int actionDeregister(Trace t, DmActionListener listener, int parms, String topic) {
        return 0;
    }

    protected void setPseudoRegistrationAttributes(Trace t, Attr regOptionAttr) {
        block9: {
            try {
                int[] authority = this.getPseudoRegistrationOptions(t, this.getObjectType(t));
                int i = 0;
                while (i < authority.length) {
                    AttrType attrType = PsObject.getAttributeType((Trace)t, (HashMap)this.attributesByType, (int)authority[i]);
                    if (attrType != null) {
                        this.addAttr(t, this.attributesByType, authority[i], 0, attrType.getDefaultValue(t));
                    }
                    ++i;
                }
                if (regOptionAttr != null) {
                    Integer listOfAuthorities = (Integer)regOptionAttr.getValue(t);
                    int authorities = listOfAuthorities;
                    int i2 = 0;
                    while (i2 < authority.length) {
                        if ((authorities & this.getRealRegistrationOption(t, authority[i2])) != 0) {
                            this.addAttr(t, this.attributesByType, authority[i2], 0, ENABLED);
                        }
                        ++i2;
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "PsObject.setPseudoRegistrationAttributes", 900, "Attribute registration option not defined for " + this.getTitle());
                }
            }
            catch (Exception exception) {
                if (!Trace.isTracing) break block9;
                t.data(66, "PsObject.setPseudoRegistrationAttributes", 900, "Error getting list of registration option for " + this.getTitle());
            }
        }
    }

    protected void setPseudoDateTimeAttributes(Trace t, Attr regTimeAttr) {
        boolean dateSet;
        block6: {
            dateSet = false;
            try {
                if (regTimeAttr != null) {
                    String regTime = (String)regTimeAttr.getValue(t);
                    this.localDate.set(Integer.parseInt(regTime.substring(0, 4)), Integer.parseInt(regTime.substring(4, 6)) - 1, Integer.parseInt(regTime.substring(6, 8)), Integer.parseInt(regTime.substring(8, 10)), Integer.parseInt(regTime.substring(10, 12)), Integer.parseInt(regTime.substring(12, 14)));
                    this.addAttr(t, this.attributesByType, 10041, 0, dateFormat.format(this.localDate.getTime()));
                    this.addAttr(t, this.attributesByType, 10042, 0, timeFormat.format(this.localDate.getTime()));
                    dateSet = true;
                } else if (Trace.isTracing) {
                    t.data(66, "PsObject.setPseudoDateTimeAttributes", 900, "Attribute message timestamp not defined for " + this.getTitle());
                }
            }
            catch (Exception exception) {
                if (!Trace.isTracing) break block6;
                t.data(66, "PsObject.setPseudoDateTimeAttributes", 900, "Error parsing message timestamp attribute for  " + this.getTitle());
            }
        }
        if (!dateSet) {
            this.addAttr(t, this.attributesByType, 10041, 0, PsPlugin.messages.getMessage("PARAM_UNKNOWN_VALUE.title"));
            this.addAttr(t, this.attributesByType, 10042, 0, PsPlugin.messages.getMessage("PARAM_UNKNOWN_VALUE.title"));
        }
    }

    protected static int[] getPseudoRegistrationOptions(Trace t, HashMap hm) {
        int[] options = null;
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "PsObject.getPseudoRegistrationOptions", 900, "<All> table has not been created");
            }
            return new int[0];
        }
        AttrTypeEnum at = (AttrTypeEnum)PsObject.getAttributeType((Trace)t, (HashMap)hm, (int)10030);
        Integer[] listOfAttrs = at.getEnumerationIds(t);
        options = new int[listOfAttrs.length];
        int i = 0;
        while (i < listOfAttrs.length) {
            options[i] = listOfAttrs[i];
            if (Trace.isTracing) {
                t.data(66, "PsObject.getPseudoRegistrationOptions", 300, "Valid option is " + options[i]);
            }
            ++i;
        }
        return options;
    }

    private int[] getPseudoRegistrationOptions(Trace t, int type) {
        switch (type) {
            case 1506: {
                return PsPublication.getPseudoRegistrationOptions(t);
            }
            case 1504: {
                return PsPublisher.getPseudoRegistrationOptions(t);
            }
            case 1502: {
                return PsSubscriber.getPseudoRegistrationOptions(t);
            }
            case 1503: {
                return PsSubscription.getPseudoRegistrationOptions(t);
            }
            case 1508: {
                return PsRegisterPublisher.getPseudoRegistrationOptions(t);
            }
            case 1509: {
                return PsRegisterSubscriber.getPseudoRegistrationOptions(t);
            }
        }
        return new int[0];
    }

    public String getTitle() {
        return this.name;
    }
}

