/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.objects;

import com.ibm.mq.MQMessage;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.pcf.PsPCFAction;
import com.ibm.mq.explorer.pubsub.internal.base.PsCommon;
import com.ibm.mq.explorer.pubsub.internal.util.PsMQRFH;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.util.Enumeration;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class PsMessage
extends PsObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/objects/PsMessage.java";
    protected static final String DEFAULT = "SYSTEM???";
    private static HashMap allAttributesByType = null;

    public PsMessage(Trace t, PsBroker _broker, String _an) {
        super(t, _broker, _an, 1507);
        this.initAttrTypeTable(t, this.getQueueManager().getCommandLevel(), this.getQueueManager().getPlatform());
        this.init(t);
    }

    public static boolean staticInit(Trace t, Bundle bundle) {
        allAttributesByType = PsMessage.initAllAttrTypeTable(t, PsMessage.getClassName((String)PsMessage.class.getName()), allAttributesByType, bundle);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(66, "PsMessage.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public boolean init(Trace t) {
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return PsMessage.getAttributeTitle((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return PsMessage.getAttributeType((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return PsMessage.getAttributeDefaultValue((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return PsMessage.getDisplayColumnSequence((Trace)t, (HashMap)allAttributesByType, (int[])ids, (boolean)zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return PsMessage.isAttributeRepeating((Trace)t, (HashMap)allAttributesByType, (int)id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return PsMessage.getAllAttributesByType((Trace)t, (HashMap)allAttributesByType);
    }

    public String toString(Trace t) {
        return this.getTitle();
    }

    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        PsPCFAction cmd = new PsPCFAction(t, 60, this);
        cmd.getRequest(t).addParameter(3030, this.getStreamName(t));
        cmd.getRequest(t).addParameter(2015, this.getQueueManagerName(t));
        cmd.getRequest(t).addParameter(2016, this.getQueueName(t));
        this.addDeregistrationOptions(t, parms, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        return rc;
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        return rc;
    }

    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT)) {
            retValue = true;
        }
        return retValue;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    public int[] getMandatoryIds(Trace t) {
        return PsMessage.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{3025};
    }

    public void initialize(Trace t) {
        this.setDefaultAttribute(t, 3030);
        this.setDefaultAttribute(t, 2015);
        this.setDefaultAttribute(t, 2016);
        this.setDefaultAttribute(t, 3031);
    }

    public void initialize(Trace t, PCFMessage message) {
        this.addAttrsFromPCFResponse(t, message);
    }

    public void initialize(Trace t, MQMessage message) {
        block12: {
            if (message != null) {
                block11: {
                    try {
                        if (message.format.equals("MQPCF   ")) {
                            PCFMessage response = new PCFMessage(message);
                            this.addAttrsFromPCFResponse(t, response);
                        } else if (message.format.equals("MQHRF   ")) {
                            PsMQRFH mqrfh = new PsMQRFH(message);
                            this.addAttrsFromRFH(t, mqrfh);
                            this.addAttrsFromMQMessage(t, message);
                        } else if (message.format.equals("MQHRF2  ")) {
                            PsMQRFH mqrfh = new PsMQRFH(message);
                            this.addAttrsFromRFH(t, mqrfh);
                            this.addAttrsFromMQMessage(t, message);
                        } else {
                            this.addAttrsFromMQMessage(t, message);
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.isTracing) break block11;
                        t.data(66, "PsMessage.initialize", 900, "Error reading MQMessage" + PsCommon.NEWLINE_CHAR + e);
                    }
                }
                try {
                    message.seek(0);
                }
                catch (Exception exception) {
                    if (!Trace.isTracing) break block12;
                    t.data(66, "PsMessage.initialize", 300, "Reset to start of message failed");
                }
            }
        }
    }

    private void addAttrsFromPCFResponse(Trace t, PCFMessage pcfMessage) {
        if (Trace.isTracing) {
            t.data(66, "PsMessage.addAttrsFromPCFResponse", 300, "Retrieved " + pcfMessage.getParameterCount() + " attributes for " + this.getTitle());
        }
        Enumeration e = pcfMessage.getParameters();
        while (e.hasMoreElements()) {
            PCFParameter p = (PCFParameter)e.nextElement();
            if (!this.getAttributesByType().containsKey(p.getParameter())) continue;
            this.addAttr(t, this.attributesByType, p);
        }
    }

    private void addAttrsFromRFH(Trace t, PsMQRFH mqrfh) {
        block5: {
            String strucId = PsMQRFH.strucId;
            if (strucId == null) {
                strucId = "";
            }
            this.addAttr(t, this.attributesByType, 10034, 0, strucId);
            long version = mqrfh.version;
            this.addAttr(t, this.attributesByType, 10035, 0, String.valueOf(version));
            long strucLength = mqrfh.strucLength;
            this.addAttr(t, this.attributesByType, 10036, 0, String.valueOf(strucLength));
            long encoding = mqrfh.encoding;
            this.addAttr(t, this.attributesByType, 10037, 0, String.valueOf(encoding));
            long ccsid = mqrfh.codedCharSetId;
            this.addAttr(t, this.attributesByType, 10038, 0, String.valueOf(ccsid));
            String format = mqrfh.format;
            if (format == null) {
                format = "";
            }
            this.addAttr(t, this.attributesByType, 10039, 0, format);
            try {
                PsMQRFH.NameValuePair[] pairs = mqrfh.getNameValuePairs();
                String[] attrValue = new String[pairs.length];
                int i = 0;
                while (i < pairs.length) {
                    attrValue[i] = pairs[i].toString();
                    ++i;
                }
                this.addAttr(t, this.attributesByType, 10040, 0, attrValue);
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block5;
                t.data(66, "PsMessage.addAttrsFromRFH", 900, "Error reading MQMessage" + PsCommon.NEWLINE_CHAR + e);
            }
        }
    }

    private void addAttrsFromMQMessage(Trace t, MQMessage message) {
        block3: {
            byte[] bytes = null;
            try {
                int length = message.getMessageLength();
                if (length > 500) {
                    length = 500;
                }
                bytes = new byte[length];
                message.seek(0);
                message.readFully(bytes, 0, length);
                this.addAttr(t, this.attributesByType, 10033, 0, bytes);
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PsMessage.addAttrsFromMQMessage", 900, "Error reading MQMessage" + PsCommon.NEWLINE_CHAR + e);
            }
        }
    }
}

