/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.objects;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DataModel;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmMQQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.trace.GenerateFFST;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsBrokerListener;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsEvent;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectListView;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectView;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsStatusMonitor;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.pcf.internal.admin.PsPCFMonitorAgent;
import com.ibm.mq.pcf.event.ErrorListener;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFMonitorAgent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.osgi.framework.Bundle;

public class PsBroker
extends PsObject
implements ErrorListener,
PCFMonitorAgent.RefreshListener,
PsBrokerListener,
IDmObservable,
DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/objects/PsBroker.java";
    protected static final String DEFAULT = "SYSTEM.BROKER";
    private static HashMap<Integer, AttrType> allAttributesByType = null;
    private boolean running = false;
    private PsPCFMonitorAgent psMonitorAgent = null;
    private PsStatusMonitor psStatusMonitor = null;
    private boolean connected = false;
    private boolean connecting = false;
    private Hashtable<String, PsObjectView> listOfObservers = new Hashtable(10);
    private Hashtable<String, PsObjectListView> listOfListObservers = new Hashtable(10);
    private Object hashLock = new Object();

    public PsBroker(Trace t, DmQueueManager _qm, String an) {
        super(t, an, 1500);
        this.queueManager = _qm;
        this.parentBroker = this;
        this.initAttrTypeTable(t, this.getQueueManager().getCommandLevel(), this.getQueueManager().getPlatform());
        if (this.psStatusMonitor == null) {
            this.psStatusMonitor = new PsStatusMonitor(t, this.queueManager, this, this.queueManager.getRefreshInterval(t));
        }
        this.init(t);
    }

    private void connect(Trace t) {
        block6: {
            try {
                if (this.psStatusMonitor == null) {
                    this.psStatusMonitor = new PsStatusMonitor(t, this.queueManager, this, this.queueManager.getRefreshInterval(t));
                }
                if (!this.getStatusMonitor(t).isPubSubBroker()) {
                    this.getStatusMonitor(t).notifyAllStatusListeners(t, 1, null);
                } else if (this.queueManager.isConnected() && !this.connected && this.psMonitorAgent == null) {
                    DmMQQueueManager dmmqqm = this.queueManager.getNewConnection(t);
                    dmmqqm.connect(t);
                    dmmqqm.join();
                    MQQueueManager mqqm = dmmqqm.getQueueManager(t);
                    this.psMonitorAgent = new PsPCFMonitorAgent(t, mqqm);
                    this.getPsMonitorAgent(t).setSendSummaryEvents(true);
                    this.getPsMonitorAgent(t).start(t, "PsMonitorAgent for : " + this.queueManager.getTreeName(t));
                    this.getPsMonitorAgent(t).addErrorListener(t, this);
                    this.getPsMonitorAgent(t).setRefreshListener(t, this);
                    this.getPsMonitorAgent(t).setPollInterval(t, this.queueManager.getRefreshInterval(t));
                    this.connected = true;
                    this.connecting = false;
                    this.getStatusMonitor(t).notifyAllStatusListeners(t, 0, null);
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block6;
                t.data(66, "PsBroker.connect", 900, "Error starting PsBroker for " + this.dmTitle + "\n" + e);
            }
        }
    }

    public void disconnect(Trace t) {
        block3: {
            try {
                if (this.connected) {
                    this.connected = false;
                    this.getPsMonitorAgent(t).stop(t);
                    this.getPsMonitorAgent(t).removeErrorListener(t, this);
                    this.psMonitorAgent = null;
                    this.getStatusMonitor(t).close(t);
                    this.psStatusMonitor = null;
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PsBroker.disconnect", 900, "Error starting PsBroker for " + this.dmTitle + "\n" + e);
            }
        }
    }

    public static boolean staticInit(Trace t, Bundle bundle) {
        allAttributesByType = PsBroker.initAllAttrTypeTable(t, PsBroker.getClassName((String)PsBroker.class.getName()), allAttributesByType, bundle);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(66, "PsBroker.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 10000, 0, this.getTitle());
        DataModel dm = new DataModel();
        dm.addObserver(t, (DmObjectListener)this, new DmObjectFilter(t, 2));
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return PsBroker.getAttributeTitle((Trace)t, allAttributesByType, (int)id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return PsBroker.getAttributeType((Trace)t, allAttributesByType, (int)id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return PsBroker.getAttributeDefaultValue((Trace)t, allAttributesByType, (int)id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return PsBroker.getDisplayColumnSequence((Trace)t, allAttributesByType, (int[])ids, (boolean)zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return PsBroker.isAttributeRepeating((Trace)t, allAttributesByType, (int)id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return PsBroker.getAllAttributesByType((Trace)t, allAttributesByType);
    }

    public String toString(Trace t) {
        return this.getTitle();
    }

    public void close(Trace t) {
        block2: {
            this.deleteAllObservers(t);
            try {
                this.getStatusMonitor(t).close(t);
                this.getPsMonitorAgent(t).stop(t);
            }
            catch (DmCoreException e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "PsBroker.close", 900, "Error closing PsBroker for " + this.dmTitle + "\n" + (Object)((Object)e));
            }
        }
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        return rc;
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        return rc;
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        return rc;
    }

    public boolean isSystemDefault(Trace t) {
        return false;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    public int[] getMandatoryIds(Trace t) {
        return PsBroker.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{10000};
    }

    public void initialize(Trace t) {
        this.setName(t, 10000);
    }

    public boolean addStatusListener(Trace t, PsBrokerListener listener) {
        boolean added = false;
        if (this.psStatusMonitor != null) {
            added = this.psStatusMonitor.addStatusListener(t, listener);
        } else if (Trace.isTracing) {
            t.data(66, "PsBroker.addStatusListener", 900, String.valueOf(this.getTitle()) + " has no status monitor");
        }
        return added;
    }

    public boolean removeStatusListener(Trace t, PsBrokerListener listener) {
        boolean added = false;
        if (this.psStatusMonitor != null) {
            added = this.psStatusMonitor.removeStatusListener(t, listener);
        } else if (Trace.isTracing) {
            t.data(66, "PsBroker.removeStatusListener", 900, String.valueOf(this.getTitle()) + " has no status monitor");
        }
        return added;
    }

    public Hashtable<String, PsObjectListView> getListOfObjectListViews(Trace t) {
        return this.listOfListObservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getObjects(Trace t, DmObjectListListener listener, PsObjectFilter filter) {
        PsObjectListView objectView = null;
        String uniqueName = Trace.NO_LISTENER_INFO;
        PsObjectListView addedView = null;
        Object object = this.hashLock;
        synchronized (object) {
            objectView = new PsObjectListView(t, this, listener, filter);
            uniqueName = this.getUniqueObjectName(listener);
            addedView = this.listOfListObservers.put(uniqueName, objectView);
        }
        if (addedView == null) {
            Thread thread = new Thread(objectView);
            thread.setName("WMQ PsBroker - get list of object types " + filter.getType());
            thread.start();
            if (Trace.isTracing) {
                String filterString = filter.toString(t);
                t.data(66, "PsBroker.getObjects", 300, "Added getObjects listener for " + uniqueName + ", add status = true" + "\nfilter = " + filterString);
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsBroker.getObjects", 900, "GetObjects listener already in list for " + uniqueName);
        }
        return true;
    }

    public ArrayList<PsObject> getObjects(Trace t, PsObjectFilter filter) throws DmCoreException {
        PsObjectListView objectView = null;
        ArrayList list = null;
        if (this.isRunning(t)) {
            objectView = new PsObjectListView(t, this, null, filter);
            list = objectView.getList(t);
        } else {
            throw this.createException(t, 0, 50015, 2);
        }
        return list;
    }

    private boolean removeListener(Trace t, Object view) {
        String listenerName = Trace.NO_LISTENER_INFO;
        PsObjectView objectView = null;
        DmObjectListener listener = null;
        boolean retValue = false;
        if (view != null) {
            try {
                objectView = (PsObjectView)view;
                listener = objectView.getListener();
                if (Trace.isTracing) {
                    listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
                    t.data(66, "PsBroker.removeListener", 300, String.valueOf(this.getTitle()) + " remove listener is for " + listenerName);
                }
                objectView.removeListener(t);
            }
            catch (ClassCastException classCastException) {
                if (Trace.isTracing) {
                    t.data(66, "PsBroker.removeListener", 900, "Unable to remove PCF listener - invalid object");
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsBroker.removeListener", 900, "Invalid view object");
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(66, "PsBroker.removeListener", 300, String.valueOf(this.getTitle()) + " listener removed from table : " + listenerName);
            } else {
                t.data(66, "PsBroker.removeListener", 900, String.valueOf(this.getTitle()) + " listener not found in table : " + listenerName);
            }
        }
        this.setRefreshInterval(t);
        return retValue;
    }

    private void deleteAllObservers(Trace t) {
        for (String o : this.listOfObservers.keySet()) {
            PsObjectView view = this.listOfObservers.get(o);
            this.removeListener(t, view);
        }
    }

    public boolean isRunning(Trace t) {
        try {
            this.running = this.getStatusMonitor(t).isRunning();
        }
        catch (DmCoreException dmCoreException) {
            this.running = false;
        }
        return this.running;
    }

    public PsPCFMonitorAgent getPsMonitorAgent(Trace t) throws DmCoreException {
        if (this.psMonitorAgent == null) {
            throw this.createException(t, 0, 50015, 2);
        }
        return this.psMonitorAgent;
    }

    public PsStatusMonitor getStatusMonitor(Trace t) throws DmCoreException {
        if (this.psStatusMonitor == null) {
            throw this.createException(t, 0, 50015, 2);
        }
        return this.psStatusMonitor;
    }

    public DmCoreException createException(Trace t, int cmd, int rc, int cc) {
        String msg = ConvertReasonCode.getSystemMessage((Trace)t, (DmObject)this, (int)cmd, (int)rc, (int)cc);
        String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
        DmCoreException ex = new DmCoreException(t, msg, msgId, rc, cc, 20);
        return ex;
    }

    public void setConnected(boolean b) {
        this.running = b;
    }

    public void setRefreshInterval(Trace t) {
        if (this.queueManager != null && this.psStatusMonitor != null) {
            this.psStatusMonitor.setRefreshInterval(t, this.queueManager.getRefreshInterval(t));
        }
    }

    public boolean refresh(Trace t, Object v) {
        block5: {
            PsObjectView view = null;
            try {
                view = (PsObjectView)v;
            }
            catch (ClassCastException classCastException) {
                if (Trace.isTracing) {
                    t.data(66, "PsBroker.refresh", 900, "View not PsObjectView object");
                }
                return false;
            }
            view.refresh(t, false);
            try {
                this.getStatusMonitor(t).refresh(t);
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block5;
                t.data(66, "PsBroker.refresh", 900, "Error refreshing status monitor");
            }
        }
        return true;
    }

    public void onError(MQException mqe) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(66, "PsBroker.onError", 900, "MQException for " + this.queueManager.getTreeName(t) + ", reason code = " + mqe.reasonCode + ", comp code = " + mqe.completionCode + ", message = " + mqe.getMessage());
        }
        if (!GenerateFFST.ignoreFFST((Trace)t, (int)mqe.reasonCode)) {
            t.FFST(66, "PsBroker.onError", 0, mqe.reasonCode, mqe.getMessage());
        }
    }

    public void refreshStarted() {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(66, "PsBroker.refreshStarted", 300, "Refresh started event for broker " + this.getDmTitle());
        }
        t.eventReceived("PsBroker.refreshStarted", 1, t.formatEventListenerData(t, (Object)this, (Object)this, DmObjectEvent.getNotifyName((Trace)t, (int)104), this.getTitle(), "true"));
    }

    public void refreshComplete() {
        Trace t = Trace.getDefault();
        if (!this.queueManager.isConnected() || this.queueManager.isDisconnecting()) {
            if (Trace.isTracing) {
                t.data(66, "PsBroker.refreshComplete", 300, "Event ignored - broker " + this.getDmTitle() + " disconnected");
            }
            return;
        }
        for (String o : this.listOfObservers.keySet()) {
            try {
                PsObjectView objectView = this.listOfObservers.get(o);
                if (Trace.isTracing) {
                    t.data(66, "PsBroker.refreshComplete", 300, "PsBroker " + this.getDmTitle() + " notifying refresh to " + objectView.getListener());
                }
                objectView.notifyDmObjectListener(t, this, 104, true, null);
            }
            catch (ClassCastException cce) {
                if (!Trace.isTracing) continue;
                t.data(66, "PsBroker.refreshComplete", 900, "Unable to notify listener - invalid object\n" + cce);
            }
        }
    }

    @Override
    public void psBrokerRunning(PsEvent event) {
        block7: {
            Trace t = Trace.getDefault();
            if (!this.connected) {
                if (!this.connecting) {
                    this.connecting = true;
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Trace t1 = Trace.getDefault();
                            PsBroker.this.connect(t1);
                        }
                    });
                    thread.start();
                } else if (Trace.isTracing) {
                    t.data(66, "PsBroker.psBrokerRunning", 300, String.valueOf(this.getTitle()) + " connecting to PsPCFMonitorAgent");
                }
            } else {
                try {
                    this.getStatusMonitor(t).notifyAllStatusListeners(t, 0, null);
                }
                catch (DmCoreException dmCoreException) {
                    if (!Trace.isTracing) break block7;
                    t.data(66, "PsBroker.psBrokerRunning", 900, String.valueOf(this.getTitle()) + " PsStatusMonitor not running");
                }
            }
        }
    }

    @Override
    public void psBrokerStopped(PsEvent event) {
        if (this.connected) {
            Trace t = Trace.getDefault();
            this.disconnect(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addObserver(Trace t, DmObjectListener listener, DmObjectFilter filter) {
        String filterString = null;
        PsObjectView objectView = null;
        boolean added = false;
        if (this.isRunning(t)) {
            Object object = this.hashLock;
            synchronized (object) {
                objectView = new PsObjectView(t, this, listener, this.getPsObjectFilter(t, filter));
                String uniqueName = this.getUniqueObjectName(listener);
                this.listOfObservers.put(uniqueName, objectView);
                if (objectView != null) {
                    added = true;
                }
                if (Trace.isTracing) {
                    if (!added) {
                        t.data(66, "PsBroker.addObserver", 900, String.valueOf(this.getTitle()) + " error adding listener for " + uniqueName);
                    } else {
                        t.data(66, "PsBroker.addObserver", 300, String.valueOf(this.getTitle()) + " adding listener for " + uniqueName + "\nfilter = " + filterString);
                    }
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsBroker.addObserver", 900, String.valueOf(this.getTitle()) + " broker not running");
        }
        this.setRefreshInterval(t);
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteObserver(Trace t, DmObjectListener listener) {
        PsObjectView objectView = null;
        boolean removed = false;
        Object object = this.hashLock;
        synchronized (object) {
            String uniqueName = this.getUniqueObjectName(listener);
            objectView = this.listOfObservers.remove(uniqueName);
            if (objectView != null) {
                removed = true;
                objectView.removeListener(t);
            }
        }
        return removed;
    }

    public String getObservableName() {
        return "The Pub/Sub Datamodel (com.ibm.mq.explorer.pubsub.core)";
    }

    public void refreshObservable(Trace t) {
        for (String o : this.listOfObservers.keySet()) {
            PsObjectView view = this.listOfObservers.get(o);
            this.refresh(t, view);
        }
    }

    public void refreshObservable(Trace t, DmObjectListener listener) {
        for (String o : this.listOfObservers.keySet()) {
            PsObjectView view = this.listOfObservers.get(o);
            this.refresh(t, view);
        }
    }

    private PsObjectFilter getPsObjectFilter(Trace t, DmObjectFilter filter) {
        PsObjectFilter psFilter = null;
        try {
            psFilter = (PsObjectFilter)filter;
        }
        catch (ClassCastException classCastException) {
            String oName = filter.getName();
            int type = filter.getType();
            PCFFilter pcff = filter.getFilter();
            psFilter = oName == null || oName.equals("*") ? new PsObjectFilter(t, null, type, pcff, false) : new PsObjectFilter(t, null, oName, type, pcff, false);
        }
        return psFilter;
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        if (event.getSource().equals(this.getQueueManager())) {
            Thread thread = new Thread("PsBroker connecting to " + this.getQueueManager().getTitle()){

                @Override
                public void run() {
                    Trace t = Trace.getDefault();
                    PsBroker.this.connect(t);
                }
            };
            thread.start();
        }
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        if (event.getSource().equals(this.getQueueManager())) {
            Thread thread = new Thread("PsBroker disconnecting from " + this.getQueueManager().getTitle()){

                @Override
                public void run() {
                    Trace t = Trace.getDefault();
                    PsBroker.this.disconnect(t);
                }
            };
            thread.start();
        }
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }
}

