/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueStatusHandle;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsBrokerListener;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsEvent;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import java.util.ArrayList;

public class PsStatusMonitor
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/event/PsStatusMonitor.java";
    public String MY_NAME = "PsStatusMonitor for ";
    private static final String FUJI_PROCESS_NAME = "amqfcxba";
    private static final String FUJI_PROCESS_NAME_ISERIES = "AMQFCXBA";
    private boolean closing = false;
    private boolean running = false;
    private DmQueueManager dmQueueManager = null;
    private PsBroker psBroker = null;
    private int refreshInterval = 0;
    private ArrayList<PsBrokerListener> statusListeners = new ArrayList(10);
    private boolean fujiBroker = true;

    public PsStatusMonitor(Trace t, DmQueueManager _qm, PsBroker _broker, int _refresh) {
        this.dmQueueManager = _qm;
        this.psBroker = _broker;
        this.setRefreshInterval(t, _refresh);
        this.setDaemon(true);
        this.setName(String.valueOf(this.MY_NAME) + _qm.getTreeName(t));
        this.fujiBroker = this.checkForMessageBroker(t);
        this.start();
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        if (this.running) {
            this.notifyStatusListener(t, 0, null, this.psBroker);
        }
        while (!this.closing) {
            block8: {
                if (Trace.isTracing) {
                    t.data(66, "PsStatusMonitor.run", 300, "PsStatusMonitor sleeping for " + this.refreshInterval + " seconds");
                }
                try {
                    Thread.sleep(this.refreshInterval * 1000);
                }
                catch (InterruptedException interruptedException) {
                    if (!Trace.isTracing) break block8;
                    t.data(66, "PsStatusMonitor.run", 900, "PsStatusMonitor interrupted");
                }
            }
            if (this.closing) {
                this.notifyAllStatusListeners(t, 1, null);
                break;
            }
            this.checkRunningStatus(t);
            if (this.running) {
                this.notifyStatusListener(t, 0, null, this.psBroker);
                continue;
            }
            this.notifyAllStatusListeners(t, 1, null);
        }
        if (Trace.isTracing) {
            t.data(66, "PsStatusMonitor.run", 300, "PsStatusMonitor ended");
        }
    }

    public void close(Trace t) {
        this.closing = true;
        this.interrupt();
    }

    public boolean isClosing(Trace t) {
        return this.closing;
    }

    public void setRefreshInterval(Trace t, int i) {
        this.refreshInterval = i > 0 ? i : 86400;
    }

    public int getRefreshInterval(Trace t) {
        return this.refreshInterval;
    }

    private void checkRunningStatus(Trace t) {
        block12: {
            ArrayList queues = null;
            DmObjectFilter filter = null;
            if (CoreServices.isClosing((Trace)t)) {
                this.closing = true;
            } else if (this.dmQueueManager.isConnected()) {
                filter = new DmObjectFilter(t, "SYSTEM.BROKER.CONTROL.QUEUE", 13);
                try {
                    queues = this.dmQueueManager.getObjects(t, filter);
                    DmQueue queue = (DmQueue)queues.get(0);
                    Attr a = queue.getAttribute(t, 17, 0);
                    if (a != null) {
                        Integer i = (Integer)a.getValue(t);
                        this.running = i > 0;
                        break block12;
                    }
                    if (Trace.isTracing) {
                        t.data(66, "PsStatusMonitor.checkRunningStatus", 900, "Error getting open input count attr for " + this.MY_NAME);
                    }
                    this.running = false;
                }
                catch (Exception exception) {
                    if (Trace.isTracing) {
                        t.data(66, "PsStatusMonitor.checkRunningStatus", 900, "Error getting queue information for " + this.MY_NAME);
                    }
                    this.running = false;
                }
            } else {
                if (Trace.isTracing) {
                    t.data(66, "PsStatusMonitor.checkRunningStatus", 900, "Queue manager not connected : " + this.dmQueueManager.getTitle());
                }
                this.running = false;
            }
        }
        if (this.running) {
            this.fujiBroker = this.checkForMessageBroker(t);
            if (!this.fujiBroker) {
                this.running = false;
            }
        }
    }

    public void refresh(Trace t) {
        this.interrupt();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public String toString() {
        return this.MY_NAME;
    }

    public synchronized boolean addStatusListener(Trace t, PsBrokerListener listener) {
        boolean added = false;
        if (!this.statusListeners.contains(listener)) {
            this.statusListeners.add(listener);
            added = true;
            this.refresh(t);
        }
        return added;
    }

    public synchronized boolean removeStatusListener(Trace t, PsBrokerListener listener) {
        boolean removed = false;
        removed = this.statusListeners.remove(listener);
        return removed;
    }

    private void notifyStatusListener(Trace t, int notifyType, DmCoreException ex, PsBrokerListener listener) {
        if (CoreServices.isClosing((Trace)t)) {
            if (Trace.isTracing) {
                t.data(66, "PsStatusMonitor.notifyStatusListener", 300, "Notification of queue manager " + this.dmQueueManager.getTitle() + " ignored - data model closing");
            }
            return;
        }
        if (listener == null) {
            if (Trace.isTracing) {
                t.data(66, "PsStatusMonitor.notifyStatusListener", 900, "Notification of queue manager " + this.dmQueueManager.getTitle() + " ignored - no listener info");
            }
            return;
        }
        if (this.dmQueueManager == null) {
            if (Trace.isTracing) {
                t.data(66, "PsStatusMonitor.notifyStatusListener", 900, "Notification of queue manager ignored - no queue manager info");
            }
            return;
        }
        switch (notifyType) {
            case 0: {
                if (this.closing) break;
                if (Trace.isTracing) {
                    t.data(66, "PsStatusMonitor.notifyStatusListener", 300, "Notifying " + listener.toString() + " of new queue manager " + this.dmQueueManager.getTitle());
                }
                listener.psBrokerRunning(new PsEvent(this.psBroker, 0, ex));
                break;
            }
            case 1: {
                if (Trace.isTracing) {
                    t.data(66, "PsStatusMonitor.notifyStatusListener", 300, "Notifying " + listener.toString() + " of new queue manager " + this.dmQueueManager.getTitle());
                }
                listener.psBrokerStopped(new PsEvent(this.psBroker, 1, ex));
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(66, "PsStatusMonitor.notifyStatusListener", 900, "Unknown notification type : " + notifyType);
            }
        }
    }

    public void notifyAllStatusListeners(Trace t, int notifyType, DmCoreException ex) {
        block3: {
            try {
                int i = 0;
                while (i < this.statusListeners.size()) {
                    this.notifyStatusListener(t, notifyType, ex, this.statusListeners.get(i));
                    ++i;
                }
            }
            catch (ClassCastException cce) {
                if (!Trace.isTracing) break block3;
                t.data(66, "PsStatusMonitor.notifyAllStatusListeners", 900, "Error notifying status listener\n" + cce);
            }
        }
    }

    private boolean checkForMessageBroker(Trace t) {
        boolean retValue;
        block15: {
            retValue = false;
            ArrayList queueStatus = null;
            DmObjectFilter filter = null;
            if (CoreServices.isClosing((Trace)t)) {
                this.closing = true;
            } else {
                if (this.dmQueueManager.isConnected()) {
                    filter = new DmObjectFilter(t, "SYSTEM.BROKER.CONTROL.QUEUE", 1007);
                    try {
                        queueStatus = this.dmQueueManager.getObjects(t, filter);
                        int i = 0;
                        while (i < queueStatus.size()) {
                            DmQueueStatusHandle queue = (DmQueueStatusHandle)queueStatus.get(i);
                            Attr a = queue.getAttribute(t, 3058, 0);
                            if (a != null) {
                                String s = (String)a.getValue(t);
                                if (s.indexOf(FUJI_PROCESS_NAME) > -1 || s.indexOf(FUJI_PROCESS_NAME_ISERIES) > -1) {
                                    retValue = true;
                                    break block15;
                                }
                            } else if (Trace.isTracing) {
                                t.data(66, "PsStatusMonitor.checkForMessageBroker", 900, "Error getting application name attr for " + this.MY_NAME);
                            }
                            ++i;
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        if (Trace.isTracing) {
                            t.data(66, "PsStatusMonitor.checkForMessageBroker", 900, "Error getting queue information for " + this.MY_NAME);
                        }
                        break block15;
                    }
                }
                if (Trace.isTracing) {
                    t.data(66, "PsStatusMonitor.checkForMessageBroker", 900, "Queue manager not connected : " + this.dmQueueManager.getTitle());
                }
            }
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(66, "PsStatusMonitor.checkForMessageBroker", 900, "Message Broker running");
            } else {
                t.data(66, "PsStatusMonitor.checkForMessageBroker", 900, "Assume Fuji Broker running");
            }
        }
        return retValue;
    }

    public boolean isPubSubBroker() {
        return this.fujiBroker;
    }
}

