/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.event;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.trace.GenerateFFST;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsCommonObjectView;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObjectFactory;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsTopic;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.ErrorListener;
import com.ibm.mq.pcf.event.PCFEvent;
import com.ibm.mq.pcf.event.PCFListener;
import com.ibm.mq.pcf.event.PCFSummaryEvent;
import java.util.ArrayList;

public class PsObjectView
extends PsCommonObjectView
implements PCFListener,
ErrorListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/event/PsObjectView.java";
    private DmObjectListener objectListener = null;
    private boolean active = false;
    private boolean firstSummary = true;

    public PsObjectView(Trace t, PsBroker broker, DmObjectListener listener, PsObjectFilter filter) {
        super(t, broker, filter);
        this.objectListener = listener;
        if (Trace.isTracing) {
            t.data(66, "PsObjectView.PsObjectView", 300, "Getting objects of type " + this.getDmObjectType(t) + "\n" + this.getObjectFilter(t).toString(t));
        }
        if (this.addListener(t)) {
            this.refresh(t, false);
        }
    }

    private boolean addListener(Trace t) {
        boolean added;
        block2: {
            added = false;
            try {
                t.eventListenerAdded("PsObjectView.addListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, PsObject.getTypeName(t, this.getObjectFilter(t).getType())));
                this.getPsbroker(t).getPsMonitorAgent(t).addErrorListener(t, this);
                this.getPsbroker(t).getPsMonitorAgent(t).addPCFListener(t, this, this.getObjectFilter(t).getQuery());
                this.active = true;
                added = true;
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block2;
                t.data(66, "PsObjectView.addListener", 900, "Error adding listener - PsPCFMonitorAgent not defined");
            }
        }
        return added;
    }

    public void removeListener(Trace t) {
        this.active = false;
        t.eventListenerRemoved("PsObjectView.removeListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, PsObject.getTypeName(t, this.getObjectFilter(t).getType())));
        this.removePCFListener(t);
    }

    public void handleEvent(PCFEvent event) {
        Trace t = Trace.getDefault();
        ArrayList list = this.getListOfObjects(t);
        PsObject object = this.getPsbroker(t);
        String title = object.getTitle();
        String key = object.getTitle();
        if (event.getObjectName() == null) {
            t.eventReceived("PsObjectView.handleEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName((Trace)t, (int)event.getType()), String.valueOf(object.getTitle()) + "(" + event.getCommand() + ")", Boolean.toString(event.isLast())));
        } else {
            t.eventReceived("PsObjectView.handleEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName((Trace)t, (int)event.getType()), String.valueOf(event.getObjectName().trim()) + "(" + event.getCommand() + ")", Boolean.toString(event.isLast())));
        }
        if (Trace.isTracing) {
            t.data(66, "PsObjectView.handleEvent", 300, "Event type " + DmObjectEvent.getNotifyName((Trace)t, (int)event.getType()) + ", for " + event.getObjectName());
        }
        if (!this.getPsbroker(t).isRunning(t)) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.handleEvent", 300, "Event ignored - pubsub broker " + this.getPsbroker(t).getTitle() + " disconnected");
            }
            return;
        }
        int objectType = this.getDmObjectType(t);
        int eventObjectType = event.getCommand();
        if (Trace.isTracing) {
            t.data(66, "PsObjectView.handleEvent", 300, "Event object type " + eventObjectType + " (original type " + objectType + ")");
        }
        if (event instanceof PCFSummaryEvent) {
            if (this.firstSummary) {
                this.firstSummary = false;
                if (Trace.isTracing) {
                    t.data(66, "PsObjectView.handleEvent", 300, "First summary event ignored - object has status");
                }
                return;
            }
            this.firstSummary = false;
            int count = ((PCFSummaryEvent)event).getEventCount();
            this.sendSummaryEvent(t, object, eventObjectType, count, null, true);
            return;
        }
        PCFMessage pcfMessage = event.getPCFMessage();
        title = event.getObjectName();
        if (title == null) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.handleEvent", 300, "Ignored event type : " + event.getType() + ", name is null");
            }
            return;
        }
        title = title.trim();
        try {
            key = ((String)this.getObjectFilter(t).getQuery().getTemplate().getKey(pcfMessage)).trim();
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.handleEvent", 900, "Ignoring PCF response for " + title + ", key is null");
            }
            return;
        }
        if (Trace.isTracing) {
            t.data(66, "PsObjectView.handleEvent", 300, "Key = " + key);
        }
        if (title.equals(key)) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.handleEvent", 300, "Looking for object with title = " + title);
            }
            object = PsObject.getPsObject(t, list, title);
        } else {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.handleEvent", 300, "Looking for object with key = " + key);
            }
            object = PsObject.getPsObject(t, list, key);
            title = key;
        }
        switch (event.getType()) {
            case 1: {
                if (object == null) {
                    this.addDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                    break;
                }
                this.changeDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                break;
            }
            case 4: {
                if (object != null) {
                    this.changeDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                    break;
                }
                this.addDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                break;
            }
            case 2: {
                this.deleteDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(66, "PsObjectView.handleEvent", 900, "Unknown event type : " + event.getType() + ", for : " + event.getObjectName());
            }
        }
    }

    public synchronized void notifyDmObjectListener(Trace t, PsObject source, int notifyType, boolean last, DmCoreException ex) {
        if (!this.getPsbroker(t).isRunning(t)) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Event ignored - pubsub broker " + this.getPsbroker(t).getTitle() + " disconnected");
            }
            return;
        }
        if (CoreServices.isClosing((Trace)t)) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Event ignored - data model closing");
            }
            return;
        }
        int dmType = source.getObjectType(t);
        String title = source.getTitle();
        String listenerName = this.objectListener.toString();
        t.eventListenerNotified("PsObjectView.notifyDmObjectListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName((Trace)t, (int)notifyType), String.valueOf(source.getTitle().trim()) + "(" + dmType + ")", Boolean.toString(last)));
        switch (notifyType) {
            case 1: {
                if (Trace.isTracing) {
                    t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for new object : " + title);
                }
                this.objectListener.dmObjectAdded(new DmObjectEvent((Object)source, dmType, last, ex, 1));
                break;
            }
            case 4: {
                if (this.getPsbroker(t).isRunning(t)) {
                    if (Trace.isTracing) {
                        t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for changes to object : " + title);
                    }
                    this.objectListener.dmObjectChanged(new DmObjectEvent((Object)source, dmType, last, ex, 4));
                    break;
                }
                if (!Trace.isTracing) break;
                t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Change notification ignored - queue manager " + this.getPsbroker(t).getTitle() + " not connected");
                break;
            }
            case 2: {
                if (Trace.isTracing) {
                    t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for deleted object : " + title);
                }
                this.objectListener.dmObjectDeleted(new DmObjectEvent((Object)source, dmType, last, ex, 2));
                break;
            }
            case 104: {
                if (Trace.isTracing) {
                    t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for refresh object : " + title);
                }
                this.objectListener.dmRefreshComplete(new DmObjectEvent((Object)source, dmType, last, ex, 104));
                break;
            }
            case 0: {
                if (Trace.isTracing) {
                    t.data(66, "PsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for summary : " + title);
                }
                this.sendSummaryEvent(t, source, dmType, 0, ex, false);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(66, "PsObjectView.notifyDmObjectListener", 900, "Unknown notify type : " + notifyType);
            }
        }
    }

    private void addDmObject(Trace t, PCFMessage pcfMessage, PsObject object, String title, int objectType, ArrayList list, boolean last) {
        boolean notified = false;
        if (object == null && (object = PsObjectFactory.create(t, this.getPsbroker(t), objectType, title)) != null) {
            list.add(object);
            object.addAttrFromPCFResponse(t, pcfMessage);
            object.initialize(t);
            if (objectType == 1501) {
                ((PsTopic)object).removePublisherCount(t);
            }
            if (!notified) {
                this.notifyDmObjectListener(t, object, 1, last, null);
            }
        }
    }

    private void changeDmObject(Trace t, PCFMessage pcfMessage, PsObject object, String title, int objectType, ArrayList list, boolean last) {
        boolean notified = false;
        if (object != null) {
            if (objectType == 1503) {
                object.replaceAttributeValue(t, 3055, 0, new ArrayList(), false);
            }
            object.addAttrFromPCFResponse(t, pcfMessage);
            if (objectType == 1501) {
                ((PsTopic)object).removePublisherCount(t);
            }
            if (!notified) {
                this.notifyDmObjectListener(t, object, 4, last, null);
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsObjectView.changeDmObject", 900, "Object not known " + title);
        }
    }

    private void deleteDmObject(Trace t, PCFMessage pcfMessage, PsObject object, String title, int objectType, ArrayList list, boolean last) {
        boolean removed = false;
        boolean notified = false;
        if (object != null) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectView.deleteDmObject", 300, "Removing object " + object.getTitle());
            }
            if (!notified) {
                this.notifyDmObjectListener(t, object, 2, last, null);
            }
            removed = list.remove(object);
            if (Trace.isTracing) {
                if (removed) {
                    if (Trace.isTracing) {
                        t.data(66, "PsObjectView.deleteDmObject", 300, "Object " + object.getTitle() + " removed from local list");
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "PsObjectView.deleteDmObject", 300, "Object " + object.getTitle() + " not found in local list");
                }
            }
        }
    }

    private void removePCFListener(Trace t) {
        block2: {
            try {
                this.getPsbroker(t).getPsMonitorAgent(t).removeListener(t, this, this.getObjectFilter(t).getQuery());
                this.getPsbroker(t).getPsMonitorAgent(t).removeErrorListener(t, this);
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block2;
                t.data(66, "PsObjectView.removePCFListener", 900, "Error removing listener - PsPCFMonitorAgent not defined");
            }
        }
    }

    public void refresh(Trace t, boolean sync) {
        block8: {
            if (!this.active) {
                if (Trace.isTracing) {
                    t.data(66, "PsObjectView.refresh", 300, "View not active " + this.toString());
                }
                return;
            }
            try {
                if (sync) {
                    if (Trace.isTracing) {
                        t.data(66, "PsObjectView.refresh", 800, "Performing synchronous refresh");
                    }
                    this.getPsbroker(t).getPsMonitorAgent(t).refresh(t, this);
                } else {
                    if (Trace.isTracing) {
                        t.data(66, "PsObjectView.refresh", 800, "Performing asynchronous refresh");
                    }
                    this.getPsbroker(t).getPsMonitorAgent(t).refreshAsync(t, this);
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block8;
                t.data(66, "PsObjectView.refresh", 900, "Error performing refresh\n" + e.toString());
            }
        }
    }

    public void onError(MQException mqe) {
        int cmd;
        int rc;
        PCFMessage pcfMessage;
        Trace t;
        block4: {
            t = Trace.getDefault();
            pcfMessage = null;
            rc = mqe.reasonCode;
            cmd = this.getObjectFilter(t).getQuery().getCommand();
            try {
                PCFMessage[] msgs = (PCFMessage[])mqe.exceptionSource;
                pcfMessage = msgs[0];
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block4;
                t.data(66, "PsObjectView.onError", 900, "Error extracting PCFMessage from MQException : " + e.toString());
            }
        }
        if (!this.ignoreReasonCode(t, cmd, rc, pcfMessage)) {
            DmCoreException ex = this.getPsbroker(t).createException(t, cmd, rc, 2);
            this.sendSummaryEvent(t, this.getPsbroker(t), cmd, 0, ex, true);
        }
        if (!GenerateFFST.ignoreFFST((Trace)t, (int)mqe.reasonCode)) {
            t.FFST(66, "PsObjectView.onError", 0, rc, mqe.getMessage());
        }
    }

    public DmObjectListener getListener() {
        return this.objectListener;
    }

    private void sendSummaryEvent(Trace t, PsObject object, int objectType, int count, DmCoreException ex, boolean log) {
        DmObjectSummaryEvent summaryEvent = new DmObjectSummaryEvent((Object)this.getPsbroker(t), null, count, ex);
        this.objectListener.dmObjectSummary(summaryEvent);
        if (log) {
            t.eventListenerNotified("PsObjectView.sendSummaryEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName((Trace)t, (int)0), String.valueOf(object.getTitle().trim()) + "(" + objectType + "/" + count + ")", "true"));
        }
    }

    private boolean ignoreReasonCode(Trace t, int cmd, int rc, PCFMessage msg) {
        boolean ignore = false;
        switch (rc) {
            case 2009: 
            case 2161: 
            case 2162: {
                ignore = true;
                break;
            }
            default: {
                if (msg != null) {
                    if (cmd == msg.getCommand()) {
                        int errorParmId = -1;
                        try {
                            errorParmId = msg.getIntParameterValue(1012);
                        }
                        catch (PCFException pCFException) {}
                        int filterParmId = this.getObjectFilter(t).getFilter().getParameter();
                        if (errorParmId == filterParmId) {
                            ignore = false;
                            break;
                        }
                        ignore = true;
                        break;
                    }
                    ignore = true;
                    break;
                }
                ignore = true;
            }
        }
        if (Trace.isTracing) {
            t.data(66, "PsObjectView.ignoreReasonCode", 900, "Reason code " + rc + " for " + this.getPsbroker(t).getTitle() + " ignored = " + ignore);
        }
        return ignore;
    }
}

