/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.event;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsCommonObjectView;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObjectFactory;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class PsObjectListView
extends PsCommonObjectView
implements Runnable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/event/PsObjectListView.java";
    private DmObjectListListener objectListener = null;
    private PCFMessage[] responses = null;
    private Hashtable indexTable = new Hashtable();
    private Object hashLock = new Object();

    public PsObjectListView(Trace t, PsBroker broker, DmObjectListListener listener, PsObjectFilter filter) {
        super(t, broker, filter);
        this.objectListener = listener;
        if (this.objectListener != null) {
            t.eventListenerAdded("PsObjectListView.PsObjectListView", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, PsObject.getTypeName(t, this.getObjectFilter(t).getType())));
        }
    }

    public ArrayList getList(Trace t) throws DmCoreException {
        int objectType;
        if (this.getPsbroker(t).isRunning(t)) {
            objectType = this.getDmObjectType(t);
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.getList", 300, "Getting objects of type " + objectType);
            }
        } else {
            throw this.getPsbroker(t).createException(t, 0, 50015, 2);
        }
        this.createList(t, this.getObjectFilter(t).getQuery(), objectType);
        return this.getListOfObjects(t);
    }

    protected void createList(Trace t, PCFQuery query, int dmObjectType) throws DmCoreException {
        int rc = 0;
        int cc = 0;
        if (Trace.isTracing) {
            t.data(66, "PsObjectListView.createList", 300, "Sending snapshot to " + this.getPsbroker(t).getTitle() + "\n" + query.getTemplate().toString());
        }
        try {
            this.responses = this.getPsbroker(t).getPsMonitorAgent(t).snapshot(t, query, true);
            if (this.responses != null && this.responses.length > 0) {
                PCFMessage message = this.responses[0];
                if (!query.getTemplate().isExpected(message.getReason())) {
                    rc = message.getReason();
                    cc = message.getCompCode();
                }
                if (Trace.isTracing) {
                    t.data(66, "PsObjectListView.createList", 300, "Reason code " + rc + ", completion code " + cc);
                }
                if (rc == 0) {
                    if (Trace.isTracing) {
                        t.data(66, "PsObjectListView.createList", 300, String.valueOf(this.responses.length) + " response(s) in the reply");
                    }
                    int i = 0;
                    while (i < this.responses.length) {
                        this.processResponse(t, this.responses[i], dmObjectType);
                        ++i;
                    }
                }
            }
        }
        catch (NullPointerException e) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.createList", 900, "NullPointerException : " + e.getMessage());
            }
        }
        catch (PCFException e) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.createList", 900, "PCFException : " + e.getMessage());
            }
            rc = e.reasonCode;
            cc = e.completionCode;
        }
        catch (IOException e) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.createList", 900, "IOException : " + e.getMessage());
            }
        }
        catch (MQException e) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.createList", 900, "MQException : " + e.getMessage());
            }
            rc = e.reasonCode;
            cc = e.completionCode;
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.createList", 900, "DmCoreException : " + e.getMessage());
            }
            throw e;
        }
        if (rc != 0) {
            String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
            String msg = ConvertReasonCode.getSystemMessage((Trace)t, (DmObject)this.getPsbroker(t), (int)query.getCommand(), (int)rc, (int)cc);
            DmCoreException ex = new DmCoreException(t, msg, msgId, rc, cc, 20);
            this.setException(t, ex);
            throw ex;
        }
    }

    private void processResponse(Trace t, PCFMessage pcfMessage, int dmObjectType) {
        String title = "[not_found]";
        PsObject object = null;
        boolean newObject = false;
        if (pcfMessage.getType() == 17 || pcfMessage.getType() == 19) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.processResponse", 300, "Ignoring PCF response - MQCFT_XR_MSG or MQCFT_XR_SUMMARY");
            }
            return;
        }
        int command = pcfMessage.getCommand();
        try {
            title = (String)this.getObjectFilter(t).getQuery().getTemplate().getKey(pcfMessage);
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.processResponse", 900, "Ignoring PCF response, key is null");
            }
            return;
        }
        if (title != null) {
            title = title.trim();
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.processResponse", 300, "Received object " + title + ", type " + command + " (Dm type " + dmObjectType + ")");
            }
            if (Trace.isTracing) {
                t.data(66, "PsObjectListView.processResponse", 300, "Looking for existing object with title = " + title);
            }
            if ((object = PsObject.getPsObject(t, this.getListOfObjects(t), title)) == null) {
                if (Trace.isTracing) {
                    t.data(66, "PsObjectListView.processResponse", 300, "Creating new object " + title);
                }
                object = PsObjectFactory.create(t, this.getPsbroker(t), dmObjectType, title);
                newObject = true;
            }
            if (object != null) {
                object.addAttrFromPCFResponse(t, pcfMessage);
                object.initialize(t);
                if (newObject) {
                    boolean added = false;
                    added = this.getListOfObjects(t).add(object);
                    if (Trace.isTracing) {
                        if (added) {
                            t.data(66, "PsObjectListView.processResponse", 300, "Object " + title + " added to list");
                        } else {
                            t.data(66, "PsObjectListView.processResponse", 900, "Error adding object " + title + " to list");
                        }
                    }
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsObjectListView.processResponse", 300, "Error getting title from " + pcfMessage.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(Trace t) {
        boolean retValue;
        block8: {
            String uniqueName = Trace.NO_LISTENER_INFO;
            retValue = false;
            Object object = this.hashLock;
            synchronized (object) {
                uniqueName = this.getUniqueObjectName(this.objectListener);
            }
            try {
                this.getPsbroker(t).getListOfObjectListViews(t).remove(uniqueName);
            }
            catch (ClassCastException classCastException) {
                if (!Trace.isTracing) break block8;
                t.data(66, "PsObjectListView.removeListener", 900, "Unable to remove getObjects listener - invalid object");
            }
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(66, "PsObjectListView.removeListener", 300, "Get objects listener removed from table : " + this.objectListener.toString());
            } else {
                t.data(66, "PsObjectListView.removeListener", 900, "Get objects listener not found in table : " + this.objectListener.toString());
            }
        }
        this.indexTable.clear();
    }

    private void notifyListener(Trace t) {
        this.objectListener.dmObjectListDone(new DmObjectListEvent((Object)this.getPsbroker(t), null, this.getListOfObjects(t), this.getException(t)));
        this.removeListener(t);
        t.eventListenerRemoved("PsObjectListView.notifyListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, PsObject.getTypeName(t, this.getObjectFilter(t).getType())));
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        try {
            this.getList(t);
        }
        catch (DmCoreException e) {
            this.setException(t, e);
        }
        this.notifyListener(t);
    }

    protected String getUniqueObjectName(Object object) {
        String uniqueName = String.valueOf(object.getClass().getName()) + "@" + System.identityHashCode(object);
        return uniqueName;
    }
}

