/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.pcf.PsPCFCommands;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.PCFQueryTemplate;

public class PsObjectFilter
extends DmObjectFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/event/PsObjectFilter.java";
    private static final int NOT_SET = -99;
    private int objectType = -99;
    private String objectName = "[not_defined]";
    private PsObject psContextObject = null;
    protected PCFFilter pcfFilter = null;
    protected PCFQuery pcfQuery = null;
    private boolean localFilter = false;
    private int topicMatch = 1;

    public PsObjectFilter(Trace t, PsObject _psObject, String _name, int _dmType, PCFFilter _filter, boolean _exactMatch) {
        this.psContextObject = _psObject;
        this.objectName = _name;
        this.objectType = _dmType;
        this.pcfFilter = _filter;
        if (_exactMatch) {
            this.topicMatch = 0;
        }
    }

    public PsObjectFilter(Trace t, PsObject _psObject, int _dmType, PCFFilter _filter, boolean _exactMatch) {
        this.psContextObject = _psObject;
        this.objectType = _dmType;
        this.pcfFilter = _filter;
        if (_exactMatch) {
            this.topicMatch = 0;
        }
    }

    public String getName() {
        return this.objectName;
    }

    public int getType() {
        return this.objectType;
    }

    public PCFFilter getFilter() {
        return this.pcfFilter;
    }

    public PCFQuery getQuery() {
        return this.pcfQuery;
    }

    public boolean performLocalFilter() {
        return this.localFilter;
    }

    public boolean equals(Object o) {
        Trace t = Trace.getDefault();
        boolean retValue = false;
        if (!(o instanceof PsObjectFilter)) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectFilter.equals", 300, "Not comparing same object types");
            }
            return false;
        }
        boolean filersEqual = false;
        int ot = ((PsObjectFilter)((Object)o)).getType();
        PCFFilter filter = ((PsObjectFilter)((Object)o)).getFilter();
        if (this.pcfFilter == null && filter == null) {
            filersEqual = true;
        }
        if (this.pcfFilter != null && filter != null) {
            filersEqual = this.pcfFilter.equals((Object)filter);
        }
        String name = ((PsObjectFilter)((Object)o)).getName();
        if (this.objectType == ot && filersEqual && this.objectName.equals(name)) {
            retValue = true;
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(66, "PsObjectFilter.equals", 300, "Filters are equal :\n" + this.toString(t));
            } else if (this.pcfFilter == null) {
                t.data(66, "PsObjectFilter.equals", 300, "Filters are not equal :\n" + this.toString(t) + "\n other filter is null");
            } else {
                t.data(66, "PsObjectFilter.equals", 300, "Filters are not equal :\n" + this.toString(t) + "\n" + ((PsObjectFilter)((Object)o)).toString(t));
            }
        }
        return retValue;
    }

    public void generatePCFQuery(Trace t, String uuid) {
        PCFQueryTemplate template = null;
        String topicName = this.getTopicName(t);
        try {
            switch (this.objectType) {
                case 1501: {
                    template = PsPCFCommands.createTemplate(t, uuid, 1000);
                    this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3031, topicName), new MQCFIN(10032, this.topicMatch), new MQCFST(3030, this.getAttributeValue(t, 3030))}, this.pcfFilter);
                    break;
                }
                case 1504: {
                    template = this.psContextObject != null ? PsPCFCommands.createTemplate(t, uuid, 1001, this.psContextObject.getTopicName(t)) : PsPCFCommands.createTemplate(t, uuid, 1001);
                    this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(10031, this.getAttributeValue(t, 3031)), new MQCFIN(10032, this.topicMatch), new MQCFST(3030, this.getAttributeValue(t, 3030))}, this.pcfFilter);
                    break;
                }
                case 1506: {
                    template = this.psContextObject != null ? PsPCFCommands.createTemplate(t, uuid, 1004, topicName) : PsPCFCommands.createTemplate(t, uuid, 1004);
                    this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(10031, topicName), new MQCFIN(10032, this.topicMatch), new MQCFST(3030, this.getAttributeValue(t, 3030)), new MQCFST(3044, this.getAttributeValue(t, 3044)), new MQCFST(3043, this.getAttributeValue(t, 3043)), new MQCFST(3042, this.getAttributeValue(t, 3042))}, this.pcfFilter);
                    break;
                }
                case 1502: {
                    template = this.psContextObject != null ? PsPCFCommands.createTemplate(t, uuid, 1002, this.psContextObject.getTopicName(t)) : PsPCFCommands.createTemplate(t, uuid, 1002);
                    this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(10031, this.getAttributeValue(t, 3031)), new MQCFIN(10032, this.topicMatch), new MQCFST(3030, this.getAttributeValue(t, 3030))}, this.pcfFilter);
                    break;
                }
                case 1503: {
                    template = this.psContextObject != null ? PsPCFCommands.createTemplate(t, uuid, 1003, topicName) : PsPCFCommands.createTemplate(t, uuid, 1003);
                    this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(10031, topicName), new MQCFIN(10032, this.topicMatch), new MQCFST(3030, this.getAttributeValue(t, 3030)), new MQCFST(3044, this.getAttributeValue(t, 3044)), new MQCFST(3043, this.getAttributeValue(t, 3043)), new MQCFST(3042, this.getAttributeValue(t, 3042))}, this.pcfFilter);
                    break;
                }
                case 1505: {
                    template = PsPCFCommands.createTemplate(t, uuid, 1005);
                    this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3030, this.getAttributeValue(t, 3030))}, this.pcfFilter);
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(66, "PsObjectFilter.generatePCFQuery", 900, "Unable to create PCFQuery for object type " + this.objectType);
                    }
                    return;
                }
            }
        }
        catch (Throwable th) {
            if (Trace.isTracing) {
                t.data(66, "PsObjectFilter.generatePCFQuery", 900, th.getMessage());
            }
            return;
        }
        if (Trace.isTracing) {
            t.data(66, "PsObjectFilter.generatePCFQuery", 300, "PsObjectFilter =\n" + this.toString(t));
        }
    }

    private String getAttributeValue(Trace t, int id) {
        String s;
        String value = "*";
        if (this.psContextObject != null && (s = this.psContextObject.getAttributeValue(t, id, 0)) != "[not_found]") {
            value = s;
        }
        return value;
    }

    private String getTopicName(Trace t) {
        String s;
        String value = "*";
        if (!this.objectName.equals("[not_defined]")) {
            value = this.objectName;
        } else if (this.psContextObject != null && (s = this.psContextObject.getAttributeValue(t, 3031, 0)) != "[not_found]") {
            value = s;
        }
        return value;
    }

    public String toString(Trace t) {
        if (this.pcfQuery == null) {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "\n" + " [name=" + this.objectName + ", Ps type=" + this.objectType + ", TopicMatch=" + this.topicMatch + ", PCFFilter=null]\n" + ", PCFQuery=null]";
        }
        if (this.pcfFilter == null) {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "\n" + " [name=" + this.objectName + ", Ps type=" + this.objectType + ", TopicMatch=" + this.topicMatch + ", PCFFilter=null]\n" + this.pcfQuery.toString();
        }
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "\n" + " [name=" + this.objectName + ", Ps type=" + this.objectType + ", TopicMatch=" + this.topicMatch + ", " + this.pcfFilter.toString() + "]\n" + this.pcfQuery.toString();
    }
}

