/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import java.util.ArrayList;

public class PsCommonObjectView {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/event/PsCommonObjectView.java";
    private PsObjectFilter objectFilter = null;
    private DmQueueManager queueManager = null;
    private PsBroker psBroker = null;
    private ArrayList listOfObjects = null;
    private DmCoreException dmCoreException = null;
    private int dmObjectType = -1;
    protected static int NOT_FOUND = -1;

    public PsCommonObjectView(Trace t, PsBroker broker, PsObjectFilter filter) {
        this.objectFilter = filter;
        this.psBroker = broker;
        this.queueManager = broker.getQueueManager();
        this.dmObjectType = filter.getType();
        this.listOfObjects = new ArrayList(10);
        filter.generatePCFQuery(t, this.queueManager.getUUID());
    }

    protected int getObjectTypeFromPCFMessage(Trace t, PCFMessage pcfMessage, int id) {
        int type;
        block2: {
            type = NOT_FOUND;
            try {
                type = pcfMessage.getIntParameterValue(id);
            }
            catch (PCFException pCFException) {
                if (!Trace.isTracing) break block2;
                t.data(66, "PsCommonObjectView.getObjectTypeFromPCFMessage", 1000, "Object type not found in PFCMessage");
            }
        }
        return type;
    }

    protected String getObjectNameFromPCFMessage(Trace t, PCFMessage pcfMessage, int id) {
        String name = "";
        Object o = pcfMessage.getParameterValue(id);
        if (o == null) {
            if (Trace.isTracing) {
                t.data(66, "PsCommonObjectView.getObjectNameFromPCFMessage", 1000, "Object name not found in PFCMessage");
            }
            return "";
        }
        if (o instanceof String) {
            name = (String)o;
        } else if (o instanceof byte[]) {
            name = new String((byte[])o);
        } else if (Trace.isTracing) {
            t.data(66, "PsCommonObjectView.getObjectNameFromPCFMessage", 900, "Unknown object type in PFCMessage");
        }
        return name.trim();
    }

    protected PsObjectFilter getObjectFilter(Trace t) {
        return this.objectFilter;
    }

    protected ArrayList getListOfObjects(Trace t) {
        return this.listOfObjects;
    }

    protected DmQueueManager getQueueManager(Trace t) {
        return this.queueManager;
    }

    protected PsBroker getPsbroker(Trace t) {
        return this.psBroker;
    }

    protected DmCoreException getException(Trace t) {
        return this.dmCoreException;
    }

    public int getDmObjectType(Trace t) {
        return this.dmObjectType;
    }

    protected void setException(Trace t, DmCoreException ex) {
        this.dmCoreException = ex;
    }
}

