/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.core.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsMessage;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublication;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterPublisher;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsStream;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsTopic;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.trace.Names;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.Bundle;

public class PsDataModel {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/core/internal/base/PsDataModel.java";
    public static final String OBSERVABLE_NAME = "The Pub/Sub Datamodel (com.ibm.mq.explorer.pubsub.core)";
    public static final int REFRESH_INTERVAL = 30;
    private static Hashtable listOfBrokers = new Hashtable();

    static {
        CommonServices.registerTraceNames((int)66, (String[])Names.getNames());
    }

    private PsDataModel() {
    }

    public static void init(Trace t) throws DmCoreException {
        Bundle bundle = PsPlugin.getDefault().getBundle();
        PsBroker.staticInit(t, bundle);
        PsTopic.staticInit(t, bundle);
        PsPublisher.staticInit(t, bundle);
        PsSubscriber.staticInit(t, bundle);
        PsRegisterPublisher.staticInit(t, bundle);
        PsRegisterSubscriber.staticInit(t, bundle);
        PsStream.staticInit(t, bundle);
        PsSubscription.staticInit(t, bundle);
        PsPublication.staticInit(t, bundle);
        PsMessage.staticInit(t, bundle);
    }

    public static PsBroker getPsBroker(Trace t, DmQueueManager qm) {
        PsBroker broker = null;
        broker = (PsBroker)listOfBrokers.get(qm);
        if (broker == null) {
            broker = new PsBroker(t, qm, qm.getTreeName(t));
            listOfBrokers.put(qm, broker);
        }
        return broker;
    }

    public static void close(Trace t) {
        Enumeration e = listOfBrokers.keys();
        while (e.hasMoreElements()) {
            DmQueueManager key = (DmQueueManager)e.nextElement();
            PsBroker psBroker = (PsBroker)listOfBrokers.get(key);
            psBroker.close(t);
        }
    }
}

