/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.extensions.IChannelWizardContribution;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.IStep;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.SampleConfigWiz;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SampleConfigWizMainPage
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/wizards/SampleConfigWizMainPage.java";
    private SampleConfigWiz wizard = null;
    private static final int WIDTH_HINT = 500;
    private static final int LINES_EXTRA = 3;
    private static final int LINES_MIN = 10;
    private Map<IChannelWizardContribution, Button> actionButtons = new HashMap<IChannelWizardContribution, Button>();

    public SampleConfigWizMainPage(String pageName) {
        super(pageName, "com.ibm.mq.explorer.telemetry.ui.DefConfig_MainPage");
        super.setHeadings(Messages.SampleConfigWizMainPage_Title, Messages.SampleConfigWizMainPage_Description);
    }

    public void createPageContent(Trace t, Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
            ((GridLayout)layout).horizontalSpacing = 12;
        }
        Text introText = new Text(parent, 66);
        introText.setText(Messages.SampleConfigWizMainPage_IntroText);
        UiUtils.makeTextControlReadOnly((Trace)Trace.getDefault(), (Text)introText, (boolean)true);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.widthHint = 500;
        introText.setLayoutData((Object)gridData);
        StyledText summaryText = new StyledText(parent, 68160);
        summaryText.setEditable(false);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 500;
        summaryText.setLayoutData((Object)gridData);
        this.addStepsText(summaryText);
        int lines = Math.max(summaryText.getLineCount() + 3, 10);
        gridData.heightHint = summaryText.getLineHeight() * lines;
        UiUtils.createBlankLine((Composite)parent, (int)3);
        List<IChannelWizardContribution> list = Activator.getDefault().getFinishWizardActions();
        for (IChannelWizardContribution action : list) {
            Button launch = new Button(parent, 32);
            launch.setText(action.getLaunchName());
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 3;
            launch.setLayoutData((Object)gridData);
            launch.setSelection(true);
            this.actionButtons.put(action, launch);
        }
    }

    private void addStepsText(StyledText text) {
        StyleRange style = new StyleRange();
        style.metrics = new GlyphMetrics(0, 0, 20);
        style.foreground = text.getDisplay().getSystemColor(5);
        Bullet bullet = new Bullet(1, style);
        int currLine = 0;
        this.wizard = (SampleConfigWiz)this.getWizard();
        List<IStep> steps = this.wizard.getSteps();
        int i = 0;
        while (i < steps.size()) {
            IStep step = steps.get(i);
            if (i > 0) {
                text.append("\n");
                ++currLine;
            }
            String title = step.getTitle();
            StyleRange bold = new StyleRange();
            bold.start = text.getText().length();
            bold.length = title.length();
            bold.fontStyle = 1;
            text.append(title);
            text.setLineBullet(currLine, 1, bullet);
            text.setStyleRange(bold);
            text.append("\n");
            ++currLine;
            text.append(step.getDescription());
            ++i;
        }
    }

    public void performHelp() {
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.telemetry.ui.DefConfig_MainPage");
    }

    public void checkIfEnableButtons() {
        this.wizard.setEnableFinish(true);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
    }

    public boolean performFinish() {
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 3);
    }

    public boolean isActionSelected(IChannelWizardContribution action) {
        boolean result = true;
        Button launch = this.actionButtons.get(action);
        if (launch != null && !launch.isDisposed()) {
            result = launch.getSelection();
        }
        return result;
    }
}

