/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.extensions.IChannelWizardContribution;
import com.ibm.mq.explorer.telemetry.ui.internal.DataModelListener;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryContentPage;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNodeObject;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.DefineChannel;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.IStep;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.SampleConfigWizMainPage;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class SampleConfigWiz
extends Wizard
implements IRunnableWithProgress {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/wizards/SampleConfigWiz.java";
    public static final int NUM_COLS = 3;
    public static final String MAIN_PAGE = "MainPage";
    private SampleConfigWizMainPage page1 = null;
    private boolean enableFinish = false;
    private TelemetryContentPage telemetryContentPage;
    private List<IStep> steps;
    private int channelPort;

    public SampleConfigWiz(Trace t, TelemetryContentPage page) {
        this.telemetryContentPage = page;
        this.page1 = new SampleConfigWizMainPage(MAIN_PAGE);
        this.setWindowTitle(Messages.SampleConfigWiz_WindowTitle);
        this.setForcePreviousAndNextButtons(false);
        this.setNeedsProgressMonitor(true);
        DataModelListener defaultConfiguration = this.telemetryContentPage.getDefaultConfiguration();
        this.steps = defaultConfiguration.getSteps();
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)this);
        }
        catch (Exception e) {
            Activator.logException(e);
            t.FFST(67, "SampleConfigWiz.performFinish", 10, 2195, 0, 0, e.getClass().getName(), e.getMessage(), null);
        }
        this.finishActions();
        return true;
    }

    public void run(IProgressMonitor monitor) {
        int total = 0;
        for (IStep step : this.steps) {
            total += step.getWeight();
        }
        monitor.beginTask(Messages.SampleConfigWiz_FinishOperationName, total);
        this.channelPort = 1883;
        int runningTotal = 0;
        for (IStep step : this.steps) {
            step.perform();
            if (step instanceof DefineChannel) {
                this.channelPort = ((DefineChannel)step).getPortUsed();
            }
            monitor.worked(runningTotal += step.getWeight());
        }
        monitor.done();
    }

    private void finishActions() {
        DmQueueManager dmQueueManager;
        MQQmgrExtObject qmgr;
        Object uiObj;
        Trace t = Trace.getDefault();
        List<IChannelWizardContribution> list = Activator.getDefault().getFinishWizardActions();
        TelemetryNodeObject telemetryNodeObject = this.telemetryContentPage.getTelemetryNodeObject();
        String hostname = "localhost";
        if (telemetryNodeObject != null && (uiObj = (qmgr = telemetryNodeObject.getQueueManager()).getInternalObject()) instanceof UiQueueManager && (dmQueueManager = ((UiQueueManager)uiObj).getDmQueueManagerObject()).isClient(t)) {
            DmQueueManagerHandle dmhandle = dmQueueManager.getConnectionHandle();
            QueueManagerHandle connectionHandle = dmhandle.getQueueManagerHandle(t);
            hostname = connectionHandle.getHostName(t);
        }
        final String host = hostname;
        for (IChannelWizardContribution action : list) {
            if (!this.page1.isActionSelected(action)) continue;
            final IChannelWizardContribution ac = action;
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ac.performFinishAction("PlainText", host, SampleConfigWiz.this.channelPort, false);
                    }
                    catch (Exception e) {
                        Activator.logException(e);
                        Trace.getInstance().FFST(67, "SampleConfigWiz.finishActions", 10, 2195, 0, 0, e.getClass().getName(), e.getMessage(), "PlainText", (Throwable)e);
                    }
                }
            });
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
        this.setNeedsProgressMonitor(true);
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public void updateButtons() {
    }

    public TelemetryContentPage getTelemetryContentPage() {
        return this.telemetryContentPage;
    }

    public List<IStep> getSteps() {
        return this.steps;
    }
}

