/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.extensions.IChannelWizardContribution;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWiz;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizAuthenticationPage;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizAuthorizationPage;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizInitialDetailsPage;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizSSLConfigPage;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewChannelWizSummaryPage
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/wizards/NewChannelWizSummaryPage.java";
    private NewChannelWiz wizard = null;
    private Text summaryText;
    private Map<IChannelWizardContribution, Button> actionButtons = new HashMap<IChannelWizardContribution, Button>();

    public NewChannelWizSummaryPage(String pageName) {
        super(pageName, "com.ibm.mq.explorer.telemetry.ui.Channel_SummaryPage");
        super.setHeadings(Messages.NewChannelWizSummaryPage_Title, Messages.NewChannelWizSummaryPage_Description);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.wizard = (NewChannelWiz)this.getWizard();
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
            ((GridLayout)layout).horizontalSpacing = 12;
        }
        Text introText = new Text(parent, 66);
        introText.setText(Messages.NewChannelWizSummaryPage_IntroText);
        UiUtils.makeTextControlReadOnly((Trace)Trace.getDefault(), (Text)introText, (boolean)true);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        introText.setLayoutData((Object)gridData);
        this.summaryText = new Text(parent, 2114);
        this.summaryText.setEditable(false);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.summaryText.getLineHeight() * 4;
        this.summaryText.setLayoutData((Object)gridData);
        UiUtils.createBlankLine((Composite)parent, (int)3);
        List<IChannelWizardContribution> list = Activator.getDefault().getFinishWizardActions();
        for (IChannelWizardContribution action : list) {
            Button launch = new Button(parent, 32);
            launch.setText(action.getLaunchName());
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 3;
            launch.setLayoutData((Object)gridData);
            launch.setSelection(true);
            this.actionButtons.put(action, launch);
        }
        UiUtils.createBlankLine((Composite)parent, (int)3);
        UiUtils.createBlankLine((Composite)parent, (int)3);
    }

    public void performHelp() {
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.telemetry.ui.Channel_SummaryPage");
    }

    public void checkIfEnableButtons() {
        this.wizard.setEnableFinish(true);
        this.wizard.updateButtons();
    }

    public void nextPressed() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String lf = System.getProperty("line.separator");
        IWizardPage page = this.wizard.getPage("InitialDetailsPage");
        if (page instanceof NewChannelWizInitialDetailsPage) {
            NewChannelWizAuthenticationPage page3;
            NewChannelWizInitialDetailsPage page1 = (NewChannelWizInitialDetailsPage)page;
            String cName = page1.getChannelName();
            int cPort = page1.getChannelPort();
            this.summaryText.setText(NLS.bind((String)Messages.NewChannelWizSummaryPage_SummaryText, (Object[])new Object[]{cName, cPort}));
            this.summaryText.append(lf);
            if (page1.isSSLenabled()) {
                NewChannelWizSSLConfigPage page2 = (NewChannelWizSSLConfigPage)this.wizard.getPage("SSLConfigPage");
                String keyfile = page2.getSSLKeyFile();
                if (page2.isAllowAnon()) {
                    this.summaryText.append(NLS.bind((String)Messages.NewChannelWizSummaryPage_SSLSummaryTextAnon, (Object)keyfile));
                } else {
                    this.summaryText.append(NLS.bind((String)Messages.NewChannelWizSummaryPage_SSLSummaryTextCert, (Object)keyfile));
                }
                this.summaryText.append(lf);
            }
            if ((page3 = (NewChannelWizAuthenticationPage)this.wizard.getPage("AuthenticationPage")).isAuthJaas()) {
                this.summaryText.append(NLS.bind((String)Messages.NewChannelWizSummaryPage_AuthenticationSummaryJAAS, (Object)page3.getJaasConfigName()));
            } else {
                this.summaryText.append(Messages.NewChannelWizSummaryPage_AuthenticationSummaryNone);
            }
            this.summaryText.append(lf);
            NewChannelWizAuthorizationPage page4 = (NewChannelWizAuthorizationPage)this.wizard.getPage("AuthorizationPage");
            if (page4.useMQTTClientId()) {
                this.summaryText.append(Messages.NewChannelWizSummaryPage_AuthorizationSummaryClientID);
            } else if (page4.useFixedId()) {
                this.summaryText.append(NLS.bind((String)Messages.NewChannelWizSummaryPage_AuthorizationSummaryFixedID, (Object)page4.getFixedId()));
            } else if (page4.useClientUsername()) {
                this.summaryText.append(Messages.NewChannelWizSummaryPage_AuthorizationSummaryFromClient);
            }
            this.summaryText.append(lf);
            List<IChannelWizardContribution> list = Activator.getDefault().getFinishWizardActions();
            for (IChannelWizardContribution action : list) {
                Button b = this.actionButtons.get(action);
                if (page1.isSSLenabled() && !action.supportsSSLConnections() || page3.isAuthJaas() && !action.supportsJAASConnections()) {
                    b.setVisible(false);
                    continue;
                }
                b.setVisible(true);
            }
        }
    }

    public boolean performFinish() {
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 3);
    }

    public boolean isActionSelected(IChannelWizardContribution action) {
        boolean result = true;
        Button launch = this.actionButtons.get(action);
        if (launch != null && !launch.isDisposed()) {
            result = launch.getSelection() && launch.isVisible();
        }
        return result;
    }
}

