/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.extensions.IChannelWizardContribution;
import com.ibm.mq.explorer.telemetry.ui.internal.InquireChannelAndPerformFinishAction;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNodeObject;
import com.ibm.mq.explorer.telemetry.ui.internal.UiTelemetryChannelNewObjectProvider;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizAuthenticationPage;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizAuthorizationPage;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizDlg;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizInitialDetailsPage;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizSSLConfigPage;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.NewChannelWizSummaryPage;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.CreateDmObject;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.pcf.PCFConstants;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewChannelWiz
extends Wizard
implements IRunnableWithProgress {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/wizards/NewChannelWiz.java";
    public static final int NUM_COLS = 3;
    public static final String INITIAL_DETAILS_PAGE = "InitialDetailsPage";
    public static final String SSL_CONFIG_PAGE = "SSLConfigPage";
    public static final String AUTHENTICATION_PAGE = "AuthenticationPage";
    public static final String AUTHORIZATION_PAGE = "AuthorizationPage";
    public static final String SUMMARY_PAGE = "SummaryPage";
    private NewObjectProvider newObjectProvider = null;
    private String newObjectTypeId = "com.ibm.mq.explorer.channel.mqtt";
    private Message msgFile;
    private NewChannelWizInitialDetailsPage page1 = null;
    private NewChannelWizSSLConfigPage page2 = null;
    private NewChannelWizAuthenticationPage page3 = null;
    private NewChannelWizAuthorizationPage page4 = null;
    private NewChannelWizSummaryPage page5 = null;
    private boolean enableFinish = false;
    private NewChannelWizDlg createQmgrWizDlg = null;
    private TelemetryNodeObject telemetryNodeObject;
    private boolean ssl;
    private String channelName;
    private String channelHostname;
    private int channelPort;
    private String sslKeyFile;
    private String sslPassPhrase;
    private Object sslClientAuth;
    private String jaasConfigName;
    private String fixedUserId;
    private Object useClientId;
    private boolean succeeded = false;

    public NewChannelWiz(Trace t, TelemetryNodeObject object) {
        this.msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_NewObject");
        this.telemetryNodeObject = object;
        this.newObjectProvider = new UiTelemetryChannelNewObjectProvider();
        this.page1 = new NewChannelWizInitialDetailsPage(INITIAL_DETAILS_PAGE);
        this.page2 = new NewChannelWizSSLConfigPage(SSL_CONFIG_PAGE);
        this.page3 = new NewChannelWizAuthenticationPage(AUTHENTICATION_PAGE);
        this.page4 = new NewChannelWizAuthorizationPage(AUTHORIZATION_PAGE);
        this.page5 = new NewChannelWizSummaryPage(SUMMARY_PAGE);
        this.setWindowTitle(Messages.NewChannelWiz_WindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        StringBuffer sb;
        Trace t = Trace.getDefault();
        this.ssl = this.page1.isSSLenabled();
        this.channelName = this.page1.getChannelName();
        this.channelHostname = null;
        this.channelPort = this.page1.getChannelPort();
        if (Trace.isTracing) {
            StringBuffer sb2 = new StringBuffer();
            sb2.append("NewChannelWizard.performFinish: Channel name=");
            sb2.append(this.channelName);
            sb2.append(", Hostname=");
            sb2.append(this.channelHostname);
            sb2.append(", Port=");
            sb2.append(this.channelPort);
            sb2.append(", SSL=");
            sb2.append(this.ssl);
            t.data(67, "NewChannelWiz.performFinish", sb2.toString());
        }
        this.sslKeyFile = null;
        this.sslPassPhrase = null;
        this.sslClientAuth = null;
        if (this.ssl) {
            this.sslKeyFile = this.page2.getSSLKeyFile();
            this.sslPassPhrase = this.page2.getSSLPassPhrase();
            boolean sslAllowAnon = this.page2.isAllowAnon();
            this.sslClientAuth = sslAllowAnon ? 1 : 0;
            if (Trace.isTracing) {
                boolean sslUseCert = this.page2.isUseCert();
                sb = new StringBuffer();
                sb.append("SSL options: key file=");
                sb.append(this.sslKeyFile);
                sb.append(", pass phrase=");
                sb.append(this.sslPassPhrase);
                sb.append(", useCert=");
                sb.append(sslUseCert);
                sb.append(", allowAnon=");
                sb.append(sslAllowAnon);
                t.data(67, "NewChannelWiz.performFinish", sb.toString());
            }
        }
        boolean authJAAS = this.page3.isAuthJaas();
        if (Trace.isTracing) {
            boolean authNone = this.page3.isAuthNone();
            sb = new StringBuffer();
            sb.append("Client authentication options: authNone=");
            sb.append(authNone);
            sb.append(", authJAAS=");
            sb.append(authJAAS);
            t.data(67, "NewChannelWiz.performFinish", sb.toString());
        }
        this.jaasConfigName = null;
        if (authJAAS) {
            this.jaasConfigName = this.page3.getJaasConfigName();
            if (Trace.isTracing) {
                StringBuffer sb3 = new StringBuffer();
                sb3.append("   JAAS config name=");
                sb3.append(this.jaasConfigName);
                t.data(67, "NewChannelWiz.performFinish", sb3.toString());
            }
        }
        boolean useMqttId = this.page4.useMQTTClientId();
        boolean useFixedId = this.page4.useFixedId();
        if (Trace.isTracing) {
            boolean useClientUsername = this.page4.useClientUsername();
            StringBuffer sb4 = new StringBuffer();
            sb4.append("Client authorization options: useMqttId=");
            sb4.append(useMqttId);
            sb4.append(", useFixedId=");
            sb4.append(useFixedId);
            sb4.append(", useClientUsername=");
            sb4.append(useClientUsername);
            t.data(67, "NewChannelWiz.performFinish", sb4.toString());
        }
        this.useClientId = useMqttId ? 1 : 0;
        this.fixedUserId = null;
        if (useFixedId) {
            this.fixedUserId = this.page4.getFixedId();
            if (Trace.isTracing) {
                StringBuffer sb5 = new StringBuffer();
                sb5.append("   Fixed user ID=");
                sb5.append(this.fixedUserId);
                t.data(67, "NewChannelWiz.performFinish", sb5.toString());
            }
        }
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)this);
        }
        catch (Exception e) {
            Activator.logException(e);
            t.FFST(67, "NewChannelWiz.performFinish", 10, 2195, 0, 0, e.getClass().getName(), e.getMessage(), null);
        }
        UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
        if (this.succeeded) {
            this.finishActions();
        }
        return true;
    }

    public void run(IProgressMonitor monitor) {
        final Trace t = Trace.getDefault();
        int units = 30;
        monitor.beginTask(Messages.NewChannelWiz_FinishOperationName, units);
        DmTelemetryChannel likeObject = this.createObject_getLikeObject(t);
        monitor.worked(10);
        int rc = this.createObject_perform(t, likeObject);
        monitor.worked(20);
        if (rc != 0) {
            int compcode;
            String message;
            switch (rc) {
                case 3324: {
                    message = Messages.MQRCCF_PORT_IN_USE;
                    compcode = 1;
                    break;
                }
                case 2067: 
                case 3011: 
                case 3014: 
                case 3034: 
                case 3036: 
                case 3203: 
                case 3228: 
                case 3321: 
                case 3322: 
                case 3323: 
                case 4032: 
                case 4044: 
                case 4092: 
                case 4094: {
                    String key = "AMQ4048";
                    String text = CommonServices.getSystemMessage((Trace)t, (String)key);
                    StringBuffer sb = new StringBuffer();
                    sb.append(rc);
                    sb.append(":");
                    sb.append(MQConstants.lookupReasonCode((int)rc));
                    message = Message.format((String)text, (String)sb.toString());
                    compcode = 2;
                    break;
                }
                default: {
                    String key = CommonServices.getSystemMessageId((Trace)t, (int)rc);
                    message = CommonServices.getSystemMessage((Trace)t, (String)key);
                    compcode = 2;
                }
            }
            if (message != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                Display display = workbench.getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int imgType = 1;
                        switch (compcode) {
                            case 0: {
                                imgType = 2;
                                break;
                            }
                            case 1: {
                                imgType = 4;
                                break;
                            }
                            case 2: {
                                imgType = 1;
                            }
                        }
                        String[] buttons = new String[]{NewChannelWiz.this.msgFile.getMessage(t, "UI.GENERAL.CLOSE")};
                        MessageBox.showMessage((Trace)t, (Shell)NewChannelWiz.this.getShell(), (String)message, (int)imgType, (String[])buttons, (int)0, null);
                    }
                });
            }
        } else {
            this.succeeded = true;
        }
        monitor.done();
    }

    private void finishActions() {
        Trace t = Trace.getDefault();
        List<IChannelWizardContribution> list = Activator.getDefault().getFinishWizardActions();
        for (IChannelWizardContribution action : list) {
            try {
                if (!this.page5.isActionSelected(action)) continue;
                if (this.channelPort == 0) {
                    MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
                    UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
                    DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
                    InquireChannelAndPerformFinishAction deferredAction = new InquireChannelAndPerformFinishAction();
                    deferredAction.setDmQueueManager(dmQueueManager);
                    deferredAction.setChannelName(this.channelName);
                    deferredAction.setFinishWizardAction(action);
                    deferredAction.start();
                    continue;
                }
                action.performFinishAction(this.channelName, this.channelHostname, this.channelPort, false);
            }
            catch (Exception e) {
                Activator.logException(e);
                t.FFST(67, "NewChannelWiz.finishActions", 10, 2195, 0, 0, e.getClass().getName(), e.getMessage(), this.channelName, (Throwable)e);
            }
        }
    }

    private DmTelemetryChannel createObject_getLikeObject(Trace t) {
        MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        String defaultLikeObjectName = this.newObjectProvider.getDefaultLikeObjectName(t, this.newObjectTypeId);
        int dataModelObjectType = this.newObjectProvider.getDataModelObjectType(t, this.newObjectTypeId);
        int dataModelObjectSubType = this.newObjectProvider.getDataModelObjectSubType(t, this.newObjectTypeId);
        DmObject dmCloneObject = DmTelemetryChannel.clone((Trace)t, (DmQueueManager)dmQueueManager, (String)defaultLikeObjectName, (int)dataModelObjectType, (int)dataModelObjectSubType);
        return (DmTelemetryChannel)dmCloneObject;
    }

    private int createObject_perform(Trace t, DmTelemetryChannel likeObject) {
        IDmObject dmObject = likeObject.clone(t, this.channelName);
        DmTelemetryChannel dmTelemetryChannel = (DmTelemetryChannel)dmObject;
        Object job = dmTelemetryChannel.beginUpdate(t);
        int[] attrs = dmTelemetryChannel.getAllAttributes(t);
        int i = 0;
        while (i < attrs.length) {
            int id = attrs[i];
            Object value = null;
            switch (id) {
                case 3501: {
                    value = this.channelName;
                    break;
                }
                case 1522: {
                    value = this.channelPort;
                    break;
                }
                case 1501: {
                    value = 2;
                    break;
                }
                case 1511: {
                    value = 10;
                    break;
                }
                case 3502: {
                    break;
                }
                case 1602: {
                    break;
                }
                case 3527: {
                    value = this.fixedUserId;
                    break;
                }
                case 3520: {
                    break;
                }
                case 1629: {
                    value = this.useClientId;
                    break;
                }
                case 1568: {
                    value = this.sslClientAuth;
                    break;
                }
                case 2049: {
                    value = this.sslKeyFile;
                    break;
                }
                case 3565: {
                    value = this.sslPassPhrase;
                    break;
                }
                case 3569: {
                    break;
                }
                case 3563: {
                    value = this.jaasConfigName;
                    break;
                }
                default: {
                    String message = "Attribute not set in wizard";
                    String attrName = PCFConstants.lookupParameter((int)id);
                    StringBuffer sb = new StringBuffer();
                    sb.append(message);
                    sb.append(": ");
                    sb.append(id);
                    sb.append(":");
                    sb.append(attrName);
                    System.out.println(sb.toString());
                    t.FFST(67, "NewChannelWiz.createObject_perform", 10, 2195, id, 0, message, attrName, null);
                }
            }
            if (value != null) {
                dmTelemetryChannel.setAttributeValue(t, job, id, 0, value);
            }
            ++i;
        }
        int rc = dmTelemetryChannel.actionCreate(t, null, job);
        dmTelemetryChannel.endUpdate(t, job);
        return rc;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
        this.addPage((IWizardPage)this.page4);
        this.addPage((IWizardPage)this.page5);
        this.setNeedsProgressMonitor(true);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.page1 && !this.page1.isSSLenabled()) {
            return this.page3;
        }
        IWizardPage wizardPage = super.getNextPage(page);
        return wizardPage;
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public void updateButtons() {
        if (this.createQmgrWizDlg == null) {
            this.createQmgrWizDlg = (NewChannelWizDlg)this.getContainer();
        }
        this.createQmgrWizDlg.updateButtons();
    }

    public boolean createObject(Trace t, IDmObject dmObject, PropertyControl propertyControl) {
        boolean result = false;
        DmActionEvent dmActionEvent = null;
        String taskName = "";
        String objectName = dmObject.getTitle();
        if (objectName != null && objectName.length() > 0) {
            String taskNameRoot = this.newObjectProvider.getWizardCreatingTaskText(t, this.newObjectTypeId);
            if (taskNameRoot != null && taskNameRoot.length() > 0) {
                taskName = Message.format((String)taskNameRoot, (String)objectName);
            } else if (taskNameRoot == null || taskNameRoot.length() == 0) {
                taskName = this.msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND");
            }
        }
        CreateDmObject createDmObject = new CreateDmObject(t, dmObject, propertyControl, taskName);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)createDmObject);
            dmActionEvent = createDmObject.getDmActionEvent();
            if (dmActionEvent.getReasonCode() == 0) {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)this.newObjectProvider.getSuccessMessage());
                MessageBox.showMessageSuccess((Trace)t, (Shell)this.getShell(), (String)msg, (String)this.newObjectProvider.getSuccessMessage(), null);
                result = true;
            } else {
                DmCoreException dmCoreException = dmActionEvent.getException();
                if (dmCoreException != null) {
                    MessageBox.showExceptionMessage((Trace)t, (Shell)this.getShell(), (DmCoreException)dmCoreException);
                } else {
                    String sysMsgId = CommonServices.getSystemMessageId((Trace)t, (int)dmActionEvent.getReasonCode());
                    String sysMsg = CommonServices.getSystemMessage((Trace)t, (String)sysMsgId);
                    MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)sysMsg);
                }
            }
        }
        catch (InvocationTargetException e) {
            t.FFST(67, "NewChannelWiz.createObject", 10, 50037, 0, 0, "InvocationTragetException", e.getMessage(), null);
        }
        catch (InterruptedException e) {
            t.FFST(67, "NewChannelWiz.createObject", 20, 50038, 0, 0, "InterruptedException", e.getMessage(), null);
        }
        return result;
    }

    public DmQueueManager getDmQueueManager() {
        MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        return uiQueueManager.getDmQueueManagerObject();
    }
}

