/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.steps;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.telemetry.ui.Common;
import com.ibm.mq.explorer.telemetry.ui.internal.DataModelListener;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNodeObject;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.IStep;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class Step
implements IStep,
DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/steps/Step.java";
    private DataModelListener dataModelListener;

    public Step(DataModelListener dataModelListener) {
        this.dataModelListener = dataModelListener;
    }

    @Override
    public DmQueueManager getDmQueueManager() {
        TelemetryNodeObject telemetryNodeObject = this.dataModelListener.getTelemetryNodeObject();
        MQQmgrExtObject qmgr = telemetryNodeObject.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        return dmQueueManager;
    }

    @Override
    public int getWeight() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        this.start();
        Step step = this;
        synchronized (step) {
            try {
                this.wait(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dmActionDone(DmActionEvent event) {
        Trace t = Trace.getDefault();
        int reasonCode = event.getReasonCode();
        switch (reasonCode) {
            case 0: 
            case 2100: 
            case 4001: 
            case 4042: {
                break;
            }
            case 3324: {
                this.handlePortInUseError(t, "Step.dmActionDone", event, reasonCode);
                break;
            }
            default: {
                this.handleUnexpectedError(t, "Step.dmActionDone", event, reasonCode);
            }
        }
        Step step = this;
        synchronized (step) {
            this.notify();
        }
    }

    protected void handlePortInUseError(Trace t, String fid, DmActionEvent event, int reasonCode) {
        this.handleUnexpectedError(t, fid, event, reasonCode);
    }

    protected void handleUnexpectedError(final Trace t, String fid, DmActionEvent event, final int reasonCode) {
        final int command = event.getCommand();
        final String classname = Common.getClassName(this);
        final String commandString = MQConstants.lookup((int)command, (String)"MQCMD.*");
        final String reasonCodeString = MQConstants.lookupReasonCode((int)reasonCode);
        IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Object[] inserts = new Object[]{classname, String.valueOf(Integer.toString(command)) + ":" + commandString, String.valueOf(Integer.toString(reasonCode)) + ":" + reasonCodeString};
                int imgType = 1;
                Message msgFile = UiPlugin.getUIMessages((Trace)t, null);
                String message = MessageFormat.format(Messages.StepFailed, inserts);
                String[] buttons = new String[]{msgFile.getMessage(t, "UI.GENERAL.CLOSE")};
                MessageBox.showMessage((Trace)t, (Shell)display.getActiveShell(), (String)message, (int)imgType, (String[])buttons, (int)0, null);
            }
        });
        t.FFST(67, fid, 10, reasonCode, command, 0, classname, null, null);
    }
}

