/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.steps;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmService;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.internal.services.UiServiceNewObjectProvider;
import com.ibm.mq.explorer.telemetry.ui.internal.DataModelListener;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.Step;
import com.ibm.mq.pcf.PCFConstants;

public class DefineService
extends Step {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/steps/DefineService.java";

    public DefineService(DataModelListener dataModelListener) {
        super(dataModelListener);
    }

    @Override
    public String getTitle() {
        return Messages.SampleConfigWizMainPage_DefineServiceStep_title;
    }

    @Override
    public String getDescription() {
        return Messages.SampleConfigWizMainPage_DefineServiceStep_description;
    }

    @Override
    public void start() {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = this.getDmQueueManager();
        UiServiceNewObjectProvider newObjectProvider = new UiServiceNewObjectProvider();
        String newObjectTypeId = "com.ibm.mq.explorer.service";
        String serviceName = "SYSTEM.MQXR.SERVICE";
        int serviceControl = 0;
        String serviceDescription = "Manages clients using MQXR protocols such as MQTT";
        int serviceType = 1;
        String startCommand = "+MQ_INSTALL_PATH+/mqxr/bin/runMQXRService.sh";
        String startArguments = "-m +QMNAME+ -d \"+MQ_Q_MGR_DATA_PATH+\" -g \"+MQ_DATA_PATH+\"";
        String stopCommand = "+MQ_INSTALL_PATH+/mqxr/bin/endMQXRService.sh";
        String stopArguments = "-m +QMNAME+ -d \"+MQ_Q_MGR_DATA_PATH+\" -g \"+MQ_DATA_PATH+\"";
        String stderrDestination = "+MQ_Q_MGR_DATA_PATH+/mqxr.stderr";
        String stdoutDestination = "+MQ_Q_MGR_DATA_PATH+/mqxr.stdout";
        int platform = dmQueueManager.getPlatform();
        switch (platform) {
            case 11: {
                startCommand = "+MQ_INSTALL_PATH+\\mqxr\\bin\\runMQXRService.bat";
                startArguments = "-m +QMNAME+ -d \"+MQ_Q_MGR_DATA_PATH+\\.\" -g \"+MQ_DATA_PATH+\\.\"";
                stopCommand = "+MQ_INSTALL_PATH+\\mqxr\\bin\\endMQXRService.bat";
                stopArguments = "-m +QMNAME+ -d \"+MQ_Q_MGR_DATA_PATH+\\.\" -g \"+MQ_DATA_PATH+\\.\"";
                stderrDestination = "+MQ_Q_MGR_DATA_PATH+\\mqxr.stderr";
                stdoutDestination = "+MQ_Q_MGR_DATA_PATH+\\mqxr.stdout";
            }
        }
        String defaultLikeObjectName = newObjectProvider.getDefaultLikeObjectName(t, newObjectTypeId);
        int dataModelObjectType = newObjectProvider.getDataModelObjectType(t, newObjectTypeId);
        int dataModelObjectSubType = newObjectProvider.getDataModelObjectSubType(t, newObjectTypeId);
        DmObject likeObject = DmObject.clone((Trace)t, (DmQueueManager)dmQueueManager, (String)defaultLikeObjectName, (int)dataModelObjectType, (int)dataModelObjectSubType);
        IDmObject dmObject = likeObject.clone(t, "SYSTEM.MQXR.SERVICE");
        DmService dmService = (DmService)dmObject;
        Object job = dmService.beginUpdate(t);
        int[] attrs = dmService.getAllAttributes(t);
        int i = 0;
        while (i < attrs.length) {
            int id = attrs[i];
            Object value = null;
            switch (id) {
                case 2077: {
                    value = serviceName;
                    break;
                }
                case 139: {
                    value = serviceControl;
                    break;
                }
                case 2078: {
                    value = serviceDescription;
                    break;
                }
                case 2079: {
                    value = startCommand;
                    break;
                }
                case 2080: {
                    value = startArguments;
                    break;
                }
                case 2081: {
                    value = stopCommand;
                    break;
                }
                case 2082: {
                    value = stopArguments;
                    break;
                }
                case 121: {
                    value = serviceType;
                    break;
                }
                case 2083: {
                    value = stdoutDestination;
                    break;
                }
                case 2084: {
                    value = stderrDestination;
                    break;
                }
                default: {
                    String message = "Attribute not set";
                    String attrName = PCFConstants.lookupParameter((int)id);
                    StringBuffer sb = new StringBuffer();
                    sb.append(message);
                    sb.append(": ");
                    sb.append(id);
                    sb.append(":");
                    sb.append(attrName);
                    System.out.println(sb.toString());
                    t.FFST(67, "DefineService.start", 10, 2195, id, 0, message, attrName, null);
                }
            }
            if (value != null) {
                dmService.setAttributeValue(t, job, id, 0, value);
            }
            ++i;
        }
        dmService.actionCreate(t, (DmActionListener)this, job);
        dmService.endUpdate(t, job);
    }
}

