/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.steps;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.Common;
import com.ibm.mq.explorer.telemetry.ui.internal.DataModelListener;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.UiTelemetryChannelNewObjectProvider;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.Step;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.pcf.PCFConstants;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DefineChannel
extends Step {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/steps/DefineChannel.java";
    public static final int MILLI_SECONDS = 1000;
    private int portUsed;

    public DefineChannel(DataModelListener dataModelListener) {
        super(dataModelListener);
    }

    @Override
    public String getTitle() {
        return Messages.SampleConfigWizMainPage_DefineChannelStep_title;
    }

    @Override
    public String getDescription() {
        return Messages.SampleConfigWizMainPage_DefineChannelStep_description;
    }

    @Override
    public void start() {
        Trace t = Trace.getDefault();
        DmQueueManager dmQueueManager = this.getDmQueueManager();
        UiTelemetryChannelNewObjectProvider newObjectProvider = new UiTelemetryChannelNewObjectProvider();
        String newObjectTypeId = "com.ibm.mq.explorer.channel.mqtt";
        String defaultLikeObjectName = newObjectProvider.getDefaultLikeObjectName(t, newObjectTypeId);
        int dataModelObjectType = newObjectProvider.getDataModelObjectType(t, newObjectTypeId);
        int dataModelObjectSubType = newObjectProvider.getDataModelObjectSubType(t, newObjectTypeId);
        DmObject likeObject = null;
        int i = 0;
        while (i < 30 && likeObject == null) {
            if (i > 0) {
                this.sleep(1000L);
            }
            likeObject = DmTelemetryChannel.clone((Trace)t, (DmQueueManager)dmQueueManager, (String)defaultLikeObjectName, (int)dataModelObjectType, (int)dataModelObjectSubType);
            ++i;
        }
        if (likeObject == null) {
            t.data(67, "DefineChannel.start", "Could not create the like object");
            return;
        }
        IDmObject dmObject = likeObject.clone(t, "PlainText");
        DmTelemetryChannel dmTelemetryChannel = (DmTelemetryChannel)dmObject;
        Object job = dmTelemetryChannel.beginUpdate(t);
        int[] attrs = dmTelemetryChannel.getAllAttributes(t);
        int i2 = 0;
        while (i2 < attrs.length) {
            int id = attrs[i2];
            Object value = null;
            switch (id) {
                case 3501: {
                    value = "PlainText";
                    break;
                }
                case 1522: {
                    this.portUsed = Activator.getNextAvailablePort();
                    value = this.portUsed;
                    break;
                }
                case 3527: {
                    value = Common.getDefaultUser(dmQueueManager);
                    break;
                }
                case 1501: 
                case 1511: 
                case 1568: 
                case 1602: 
                case 1629: 
                case 2049: 
                case 3502: 
                case 3520: 
                case 3563: 
                case 3565: 
                case 3569: {
                    break;
                }
                default: {
                    String message = "Attribute not set";
                    String attrName = PCFConstants.lookupParameter((int)id);
                    StringBuffer sb = new StringBuffer();
                    sb.append(message);
                    sb.append(": ");
                    sb.append(id);
                    sb.append(":");
                    sb.append(attrName);
                    System.out.println(sb.toString());
                    t.FFST(67, "DefineChannel.start", 10, 2195, id, 0, message, attrName, null);
                }
            }
            if (value != null) {
                dmTelemetryChannel.setAttributeValue(t, job, id, 0, value);
            }
            ++i2;
        }
        dmTelemetryChannel.actionCreate(t, (DmActionListener)this, job);
        dmTelemetryChannel.endUpdate(t, job);
    }

    public int getPortUsed() {
        return this.portUsed;
    }

    private void sleep(long period) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    protected void handlePortInUseError(final Trace t, String fid, DmActionEvent event, int reasonCode) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Object[] inserts = new Object[]{"PlainText", Integer.toString(DefineChannel.this.getPortUsed())};
                int imgType = 4;
                Message msgFile = UiPlugin.getUIMessages((Trace)t, null);
                String message = MessageFormat.format(Messages.XrChannelPortInUse, inserts);
                String[] buttons = new String[]{msgFile.getMessage(t, "UI.GENERAL.CLOSE")};
                MessageBox.showMessage((Trace)t, (Shell)display.getActiveShell(), (String)message, (int)imgType, (String[])buttons, (int)0, null);
            }
        });
    }
}

