/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal.channelstatus;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannelStatus;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.telemetry.ui.Common;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.channelstatus.PurgeChannelStatusAction;
import com.ibm.mq.explorer.telemetry.ui.internal.channelstatus.StopChannelStatusAction;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class UiTelemetryChannelStatus
extends UiMQObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/channelstatus/UiTelemetryChannelStatus.java";
    private UiQueueManager uiQueueManager = null;
    private Action actionStop = null;
    private Action actionPurge = null;

    public UiTelemetryChannelStatus() {
    }

    public UiTelemetryChannelStatus(Trace t, IDmObject dmChannelStatusObj, UiMQObject parent) {
        super(t, dmChannelStatusObj);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
    }

    public void appendToContextMenu(Shell theShell, IMenuManager manager, Object contextObject) {
        DmTelemetryChannelStatus dmChl;
        Attr a;
        Trace t = Trace.getDefault();
        if (this.actionStop == null) {
            this.actionStop = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiTelemetryChannelStatus.this.stopMenuAction(trace);
                }
            };
            this.actionStop.setText(Messages.Stop_MenuActionText);
        }
        if (this.actionPurge == null) {
            this.actionPurge = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiTelemetryChannelStatus.this.purgeMenuAction(trace);
                }
            };
            this.actionPurge.setText(Messages.Purge_MenuActionText);
        }
        if ((a = (dmChl = (DmTelemetryChannelStatus)this.getDmObject()).getAttribute(t, 1527, 0)) != null) {
            int i = (Integer)a.getValue(t);
            switch (i) {
                case 3: {
                    manager.add((IAction)this.actionStop);
                    manager.add((IAction)this.actionPurge);
                    break;
                }
            }
        }
        manager.add((IContributionItem)new Separator());
        super.appendToContextMenu(theShell, manager, contextObject);
    }

    private void stopMenuAction(Trace t) {
        String clientID = this.getDmObject().getAttributeValue(t, 3564, 0);
        int ret = MessageBox.showMessage((Trace)t, (Shell)this.shell, (String)Messages.Stop_ChannelStatusTitle, (Image)Icons.get((String)Icons.iconkeyExplorerSmall), (String)NLS.bind((String)Messages.Stop_ChannelStatusPrompt, (Object)clientID, (Object)this.toString()), (int)3, (String[])new String[]{Messages.Stop_OkButton, Messages.Stop_CancelButton}, (int)0, null);
        if (ret == 0) {
            StopChannelStatusAction action = new StopChannelStatusAction(t, this);
            action.stop(t);
        }
    }

    private void purgeMenuAction(Trace t) {
        String clientID = this.getDmObject().getAttributeValue(t, 3564, 0);
        int ret = MessageBox.showMessage((Trace)t, (Shell)this.shell, (String)Messages.Purge_ChannelStatusTitle, (Image)Icons.get((String)Icons.iconkeyExplorerSmall), (String)NLS.bind((String)Messages.Purge_ChannelStatusPrompt, (Object)clientID, (Object)this.toString()), (int)3, (String[])new String[]{Messages.Purge_OkButton, Messages.Purge_CancelButton}, (int)0, null);
        if (ret == 0) {
            PurgeChannelStatusAction action = new PurgeChannelStatusAction(t, this);
            action.purge(t);
        }
    }

    public int getDataModelObjectType(Trace t) {
        return 1027;
    }

    public String getHelpId(UiDisplayGroup uiDisplayGroup) {
        DisplayGroup displayGroup = uiDisplayGroup.getDisplayGroup();
        String helpId = displayGroup.getHelpId();
        return "com.ibm.mq.explorer.telemetry.ui." + helpId;
    }

    public boolean isSupportDelete() {
        return false;
    }

    public String getObjectType() {
        return Messages.TelemetryChanelStatusObjectType;
    }

    public String getNLSResourceFileKey() {
        return "KEY_Channels";
    }

    public void deleteMenuAction(Trace t) {
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public String getId() {
        return "com.ibm.mq.explorer.telemetry.channel.status";
    }

    public String toString() {
        Trace t = Trace.getDefault();
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getParentName(t);
        }
        return "";
    }

    public void updateIcon() {
        Trace t = Trace.getDefault();
        DmTelemetryChannelStatus dmChl = (DmTelemetryChannelStatus)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 1527, 0);
        int status = -1;
        if (a != null) {
            status = (Integer)a.getValue(t);
        }
        Image image = Icons.get((String)Common.iconkeyChannelStatus);
        switch (status) {
            case 3: {
                image = Icons.get((String)Common.iconkeyChannelStatusRunning);
                break;
            }
            case 6: {
                image = Icons.get((String)Common.iconkeyChannelStatusStopped);
                break;
            }
            case 9: {
                image = Icons.get((String)Common.iconkeyChannelStatusDisconnected);
                break;
            }
            default: {
                image = Icons.get((String)Common.iconkeyChannelStatusAlert);
            }
        }
        super.setImage(image);
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public boolean isAllowApplyProperties() {
        return true;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.uiQueueManager.isZOS(t);
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }
}

