/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.telemetry.ui.Common;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.PurgeChannelAction;
import com.ibm.mq.explorer.telemetry.ui.internal.StartChannelAction;
import com.ibm.mq.explorer.telemetry.ui.internal.StopChannelAction;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.status.StatusDialog;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public class UiTelemetryChannel
extends UiMQObject
implements IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/UiTelemetryChannel.java";
    private UiQueueManager uiQueueManager = null;
    private int channelType = -1;
    private Action actionStart = null;
    private Action actionStop = null;
    private Action actionPurge = null;
    private static String startMenuText = null;

    public UiTelemetryChannel() {
    }

    public UiTelemetryChannel(Trace t, IDmObject dmTelemetryChannelObj, UiMQObject parent) {
        super(t, dmTelemetryChannelObj);
        this.uiQueueManager = UiQueueManager.findOwningQueueManager((Trace)t, (UiMQObject)parent);
        if (startMenuText == null) {
            startMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_TelemetryChannels", (String)"UI.CHL.Start.Menu");
        }
    }

    public void appendToContextMenu(Shell theShell, IMenuManager manager, Object contextObject) {
        Trace t = Trace.getDefault();
        if (this.actionStart == null) {
            this.actionStart = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiTelemetryChannel.this.startMenuAction(trace);
                }
            };
            this.actionStart.setText(startMenuText);
        }
        if (this.actionStop == null) {
            this.actionStop = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiTelemetryChannel.this.stopMenuAction(trace);
                }
            };
            this.actionStop.setText(Messages.Stop_MenuActionText);
        }
        if (this.actionPurge == null) {
            this.actionPurge = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiTelemetryChannel.this.purgeMenuAction(trace);
                }
            };
            this.actionPurge.setText(Messages.Purge_MenuActionText);
        }
        DmTelemetryChannel dmChl = (DmTelemetryChannel)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 3501, 0);
        String name = (String)a.getValue(t);
        boolean isSystemDefaultChannel = false;
        if ("SYSTEM.DEF.MQTT".equals(name)) {
            isSystemDefaultChannel = true;
        }
        if (!isSystemDefaultChannel && (a = dmChl.getAttribute(t, 1527, 0)) != null) {
            int i = (Integer)a.getValue(t);
            switch (i) {
                case 3: {
                    manager.add((IAction)this.actionStop);
                    manager.add((IAction)this.actionPurge);
                    break;
                }
                case 6: {
                    manager.add((IAction)this.actionStart);
                }
            }
        }
        manager.add((IContributionItem)new Separator());
        super.appendToContextMenu(theShell, manager, contextObject);
    }

    public String getId() {
        return "com.ibm.mq.explorer.channel";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isCustom = false;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 10: 
            case 11: {
                isCustom = true;
            }
        }
        return isCustom;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public String getObjectType() {
        return Messages.TelemetryChanelObjectType;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public String getNLSResourceFileKey() {
        return "KEY_TelemetryChannels";
    }

    public void updateIcon() {
        Trace t = Trace.getDefault();
        int status = this.getChannelStatus(t);
        Image image = Icons.get((String)Common.iconkeyChannel);
        switch (status) {
            case 3: {
                image = Icons.get((String)Common.iconkeyChannelRunning);
                break;
            }
            case 6: {
                image = Icons.get((String)Common.iconkeyChannelStopped);
                break;
            }
            case 9: {
                image = Icons.get((String)Common.iconkeyChannelDisconnected);
                break;
            }
            default: {
                image = Icons.get((String)Common.iconkeyChannelAlert);
            }
        }
        super.setImage(image);
    }

    private int getChannelStatus(Trace t) {
        DmTelemetryChannel dmChl = (DmTelemetryChannel)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 1527, 0);
        int i = -999;
        if (a != null) {
            i = (Integer)a.getValue(t);
        }
        return i;
    }

    public int getDataModelObjectType(Trace t) {
        return 1026;
    }

    public boolean isSupportDelete() {
        Trace t = Trace.getDefault();
        DmTelemetryChannel dmChl = (DmTelemetryChannel)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 3501, 0);
        String name = (String)a.getValue(t);
        boolean isSystemDefaultChannel = false;
        if ("SYSTEM.DEF.MQTT".equals(name)) {
            isSystemDefaultChannel = true;
        }
        AttrInt attrInt = (AttrInt)dmChl.getAttribute(t, 1527, 0);
        int channelStatus = (Integer)attrInt.getValue(t);
        boolean isObjectDeletable = true;
        if (isSystemDefaultChannel) {
            isObjectDeletable = false;
        } else if (channelStatus == 3) {
            isObjectDeletable = false;
        }
        return isObjectDeletable;
    }

    public String getHelpId(UiDisplayGroup uiDisplayGroup) {
        DisplayGroup displayGroup = uiDisplayGroup.getDisplayGroup();
        String helpId = displayGroup.getHelpId();
        return "com.ibm.mq.explorer.telemetry.ui." + helpId;
    }

    private void startMenuAction(Trace t) {
        StartChannelAction action = new StartChannelAction(t, this);
        action.start(t);
    }

    private void stopMenuAction(Trace t) {
        int ret = MessageBox.showMessage((Trace)t, (Shell)this.shell, (String)Messages.Stop_ChannelTitle, (Image)Icons.get((String)Icons.iconkeyExplorerSmall), (String)NLS.bind((String)Messages.Stop_ChannelPrompt, (Object)this.toString()), (int)3, (String[])new String[]{Messages.Stop_OkButton, Messages.Stop_CancelButton}, (int)0, null);
        if (ret == 0) {
            StopChannelAction action = new StopChannelAction(t, this);
            action.stop(t);
        }
    }

    private void purgeMenuAction(Trace t) {
        int ret = MessageBox.showMessage((Trace)t, (Shell)this.shell, (String)Messages.Purge_ChannelTitle, (Image)Icons.get((String)Icons.iconkeyExplorerSmall), (String)NLS.bind((String)Messages.Purge_ChannelPrompt, (Object)this.toString()), (int)3, (String[])new String[]{Messages.Purge_OkButton, Messages.Purge_CancelButton}, (int)0, null);
        if (ret == 0) {
            PurgeChannelAction action = new PurgeChannelAction(t, this);
            action.purge(t);
        }
    }

    public UiQueueManager getOwningUiQueueManager() {
        return this.uiQueueManager;
    }

    public int getChannelType(Trace t) {
        if (this.channelType == -1) {
            this.channelType = ((DmTelemetryChannel)this.getDmObject()).getObjectSubType(t);
        }
        int chlType = this.channelType;
        return chlType;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        UiMQObject targetObject = null;
        if (target instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)target;
            targetObject = (UiMQObject)mqExtObject.getInternalObject();
        }
        if (targetObject != null && targetObject instanceof UiTelemetryChannel) {
            if (name.compareTo("ChannelType") == 0) {
                int chType = this.getChannelType(t);
                if (value.compareTo("Sender") == 0 && chType == 1) {
                    result = true;
                } else if (value.compareTo("Server") == 0 && chType == 2) {
                    result = true;
                } else if (value.compareTo("Receiver") == 0 && chType == 3) {
                    result = true;
                } else if (value.compareTo("Requester") == 0 && chType == 4) {
                    result = true;
                } else if (value.compareTo("ServerConnection") == 0 && chType == 7) {
                    result = true;
                } else if (value.compareTo("ClientConnection") == 0 && chType == 6) {
                    result = true;
                } else if (value.compareTo("ClusterSender") == 0 && chType == 9) {
                    result = true;
                } else if (value.compareTo("ClusterReceiver") == 0 && chType == 8) {
                    result = true;
                } else if (value.compareTo("AMQP") == 0 && chType == 11) {
                    result = true;
                }
            } else if (name.compareTo("ChannelOverallStatus") == 0) {
                Attr attr = this.getDmObject().getAttribute(t, 1527, 0);
                if (attr != null && attr instanceof AttrInt) {
                    Integer intStatus = (Integer)((AttrInt)attr).getValue(t);
                    int status = intStatus;
                    if (value.compareTo("Binding") == 0 && status == 1) {
                        result = true;
                    } else if (value.compareTo("Inactive") == 0 && status == 0) {
                        result = true;
                    } else if (value.compareTo("Initializing") == 0 && status == 13) {
                        result = true;
                    } else if (value.compareTo("Paused") == 0 && status == 8) {
                        result = true;
                    } else if (value.compareTo("Requesting") == 0 && status == 7) {
                        result = true;
                    } else if (value.compareTo("Retrying") == 0 && status == 5) {
                        result = true;
                    } else if (value.compareTo("Running") == 0 && status == 3) {
                        result = true;
                    } else if (value.compareTo("Starting") == 0 && status == 2) {
                        result = true;
                    } else if (value.compareTo("Stopped") == 0 && status == 6) {
                        result = true;
                    } else if (value.compareTo("Stopping") == 0 && status == 4) {
                        result = true;
                    } else if (value.compareTo("Switching") == 0 && status == 14) {
                        result = true;
                    }
                }
            } else {
                int iResult = this.uiQueueManager.testQmgrAttribute(t, (Object)this.uiQueueManager, name, value);
                switch (iResult) {
                    case 1: {
                        result = true;
                        break;
                    }
                    case 0: {
                        result = false;
                        break;
                    }
                    default: {
                        result = super.testAttribute(target, name, value);
                        break;
                    }
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(67, "UiTelemetryChannel.testAttribute", 900, "Object is not a UiTelemetryChannel");
            }
            result = super.testAttribute(target, name, value);
        }
        return result;
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public boolean isAllowProperties() {
        Trace t = Trace.getDefault();
        DmTelemetryChannel dmChl = (DmTelemetryChannel)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 3501, 0);
        String name = (String)a.getValue(t);
        boolean isSystemDefaultChannel = false;
        if ("SYSTEM.DEF.MQTT".equals(name)) {
            isSystemDefaultChannel = true;
        }
        boolean isPropertiesAllowed = true;
        if (isSystemDefaultChannel) {
            isPropertiesAllowed = false;
        }
        return isPropertiesAllowed;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.uiQueueManager.isZOS(t);
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public boolean isSelectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter) {
        return true;
    }

    public String selectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter, String currentSelection, String helpId, Shell sh) {
        String selectedAttributeObjectName = this.uiQueueManager.selectAttributeObjectFromDmObjectFilter(t, attrId, dmObjectFilter, currentSelection, helpId, sh, this.getSelectObjectDialogTitle(t, attrId), this.getSelectObjectDialogDescription(t, attrId), true);
        return selectedAttributeObjectName;
    }

    private String getSelectObjectDialogTitle(Trace t, int attrId) {
        String template = UiPlugin.getNLSString((Trace)t, (String)"KEY_Properties", (String)"UI.Objects.Select.Title");
        String title = Message.format((String)template, (String)DmTelemetryChannel.getAttributeTitle((Trace)t, (int)attrId));
        return title;
    }

    private String getSelectObjectDialogDescription(Trace t, int attrId) {
        return this.getSelectObjectDialogTitle(t, attrId);
    }

    public UiStatusProvider getStatusProvider(Trace t) {
        DmTelemetryChannel dmChl = (DmTelemetryChannel)this.getDmObject();
        Attr a = dmChl.getAttribute(t, 3501, 0);
        String name = (String)a.getValue(t);
        boolean isSystemDefaultChannel = false;
        if ("SYSTEM.DEF.MQTT".equals(name)) {
            isSystemDefaultChannel = true;
        }
        UiStatusProvider statusProvider = null;
        if (!isSystemDefaultChannel) {
            statusProvider = super.getStatusProvider(t);
        }
        return statusProvider;
    }

    public void showStatus(Trace t, String statusType, Object contextObject) {
        StatusDialog statusDialog = new StatusDialog(this.shell, 0);
        statusDialog.open(t, super.getStatusProvider(t), statusType, (UiMQObject)this, contextObject);
    }
}

