/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNode;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerServiceStatus;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedEvent;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class TelemetryNodeObject
extends MQExtObject
implements DmObjectListener,
TreeNodeDeletedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/TelemetryNodeObject.java";
    private DataModelListenerServiceStatus dataModelListenerServiceStatus;
    private boolean telemetryServiceIsStarted;

    public TelemetryNodeObject(String name) {
        super(null, null, "com.ibm.mq.explorer.ui.unittest.treenodes.treenodeobject", "com.ibm.mq.explorer.ui.unittest.treenodes.treenodeobject1", name);
        Trace t = Trace.getDefault();
        UiPlugin.addITreeNodeDeletedListener((Trace)t, (TreeNodeDeletedListener)this);
    }

    public TelemetryNode getTreeNode() {
        return (TelemetryNode)((Object)this.getInternalDataObject());
    }

    public void setTreeNode(TelemetryNode node) {
        this.setInternalDataObject((Object)node);
    }

    public MQQmgrExtObject getQueueManager() {
        return (MQQmgrExtObject)this.getInternalObject();
    }

    public void setQueueManager(MQQmgrExtObject qmgr) {
        this.setInternalObject(qmgr);
        this.startListening();
    }

    public void startListening() {
        Trace t = Trace.getDefault();
        MQQmgrExtObject qmgr = this.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        if (this.dataModelListenerServiceStatus == null) {
            DmObjectFilter filter = new DmObjectFilter(t, "SYSTEM.MQXR.SERVICE", 154);
            this.dataModelListenerServiceStatus = new DataModelListenerServiceStatus(this);
            dmQueueManager.addObserver(t, (DmObjectListener)this.dataModelListenerServiceStatus, filter);
        }
    }

    public void stopListening() {
        Trace t = Trace.getDefault();
        MQQmgrExtObject qmgr = this.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        if (this.dataModelListenerServiceStatus != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerServiceStatus);
            this.dataModelListenerServiceStatus = null;
        }
    }

    public void dmObjectAdded(DmObjectEvent event) {
        int type = event.getObjectType();
        switch (type) {
            case 154: {
                this.telemetryServiceIsStarted = true;
                this.updateStatus();
                MQQmgrExtObject qmgr = this.getQueueManager();
                UiQueueManager uiQM = (UiQueueManager)qmgr.getInternalObject();
                DmQueueManager dmQM = uiQM.getDmQueueManagerObject();
                dmQM.updateSslCipherSuites();
            }
        }
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        int type = event.getObjectType();
        switch (type) {
            case 154: {
                this.telemetryServiceIsStarted = false;
                this.updateStatus();
                break;
            }
            case 161: {
                this.stopListening();
                break;
            }
        }
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public boolean isTelemetryServiceStarted() {
        return this.telemetryServiceIsStarted;
    }

    private void updateStatus() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TelemetryNodeObject.this.updateServiceUiThread();
            }
        });
    }

    private void updateServiceUiThread() {
        Trace t = Trace.getDefault();
        TelemetryNode treeNode = this.getTreeNode();
        TreeNode[] children = treeNode.getChildren();
        if (!this.telemetryServiceIsStarted) {
            int i = 0;
            while (i < children.length) {
                TreeNode child = children[i];
                treeNode.removeChildFromNode(child);
                ++i;
            }
        }
        UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
    }

    public void treeNodeDeleted(TreeNodeDeletedEvent event) {
        Trace t = Trace.getDefault();
        TreeNode treeNode = event.getDeletedTreeNode();
        Object otherObject = treeNode.getObject();
        if (this.equals(otherObject)) {
            UiPlugin.removeTreeNodeDeletedListener((Trace)t, (TreeNodeDeletedListener)this);
            this.stopListening();
        }
    }

    public boolean equals(Object object) {
        MQQmgrExtObject otherExtObject;
        UiQueueManager otherUiQueueManager;
        String otherTreeName;
        TelemetryNode otherTreeNode;
        String otherTreeNodeId;
        if (!(object instanceof TelemetryNodeObject)) {
            return false;
        }
        TelemetryNodeObject otherNodeObject = (TelemetryNodeObject)((Object)object);
        TelemetryNode thisTreeNode = this.getTreeNode();
        String thisTreeNodeId = thisTreeNode.getId();
        if (!thisTreeNodeId.equals(otherTreeNodeId = (otherTreeNode = otherNodeObject.getTreeNode()).getId())) {
            return false;
        }
        MQQmgrExtObject thisExtObject = this.getQueueManager();
        UiQueueManager thisUiQueueManager = (UiQueueManager)thisExtObject.getInternalObject();
        String thisTreeName = thisUiQueueManager.getTreeName();
        return thisTreeName.equals(otherTreeName = (otherUiQueueManager = (UiQueueManager)(otherExtObject = otherNodeObject.getQueueManager()).getInternalObject()).getTreeName());
    }
}

