/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryChannelsNode;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryChannelsNodeObject;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNode;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNodeObject;
import com.ibm.mq.explorer.telemetry.ui.internal.channelstatus.TelemetryChannelStatusNode;
import com.ibm.mq.explorer.telemetry.ui.internal.channelstatus.TelemetryChannelStatusNodeObject;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class TelemetryNodeFactory
implements IExecutableExtension,
ITreeNodeFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/TelemetryNodeFactory.java";

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addChildrenToTreeNode(TreeNode parent) {
        Trace t = Trace.getDefault();
        String parentId = parent.getId();
        if (parentId.startsWith("com.ibm.mq.explorer.treenode.qm.")) {
            boolean nodeAlreadyExists;
            MQQmgrExtObject qmgr = (MQQmgrExtObject)parent.getObject();
            UiQueueManager uiQM = (UiQueueManager)qmgr.getInternalObject();
            DmQueueManager dmQM = uiQM.getDmQueueManagerObject();
            boolean doit = uiQM.isConnected();
            if (doit && (nodeAlreadyExists = parent.isChildExist("com.ibm.mq.explorer.telemetry.node.main"))) {
                doit = false;
            }
            if (doit) {
                Boolean isSupported = Activator.isTelemetrySupported(t, dmQM);
                if (isSupported == null) {
                    doit = false;
                    Activator.setTelemetryChannelSupported(dmQM, false);
                    TelemetryNodeFactory.updateTelemetryChannelSupported(t, qmgr, parent);
                } else {
                    doit = isSupported;
                }
            }
            if (doit) {
                TelemetryNodeFactory.addMainTelemetryTreeNode(t, qmgr, parent);
            }
        } else if (parentId.equals("com.ibm.mq.explorer.telemetry.node.main")) {
            boolean serviceIsRunning;
            boolean nodeAlreadyExists;
            TelemetryNodeObject telemetryNodeObject = (TelemetryNodeObject)((Object)parent.getObject());
            MQQmgrExtObject qmgr = telemetryNodeObject.getQueueManager();
            UiQueueManager uiQM = (UiQueueManager)qmgr.getInternalObject();
            boolean doit = true;
            if (doit && (nodeAlreadyExists = parent.isChildExist("com.ibm.mq.explorer.telemetry.node.channels"))) {
                doit = false;
            }
            if (doit && !(serviceIsRunning = telemetryNodeObject.isTelemetryServiceStarted())) {
                doit = false;
            }
            if (doit) {
                TelemetryChannelsNodeObject treeNodeObjectChannel = new TelemetryChannelsNodeObject(Messages.TelemetryNodeFactory_ChannelsNodeName);
                TelemetryChannelsNode node = new TelemetryChannelsNode(parent, treeNodeObjectChannel, "com.ibm.mq.explorer.telemetry.ui");
                treeNodeObjectChannel.setTreeNode(node);
                treeNodeObjectChannel.setInternalObject(uiQM);
                parent.addChildToNode((TreeNode)node, 0);
                TelemetryChannelStatusNodeObject treeNodeObjectCS = new TelemetryChannelStatusNodeObject(Messages.TelemetryNodeFactory_ChannelStatusNodeName);
                TelemetryChannelStatusNode node2 = new TelemetryChannelStatusNode(parent, treeNodeObjectCS, "com.ibm.mq.explorer.telemetry.ui");
                treeNodeObjectCS.setTreeNode(node2);
                treeNodeObjectCS.setInternalObject(uiQM);
                parent.addChildToNode((TreeNode)node2, 0);
            }
        }
    }

    public static void updateTelemetryChannelSupported(final Trace t, final MQQmgrExtObject qmgr, final TreeNode parent) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                UiQueueManager uiQM = (UiQueueManager)qmgr.getInternalObject();
                DmQueueManager dmQM = uiQM.getDmQueueManagerObject();
                boolean isTelemetrySupported = Activator.isTelemetryCommandQueueExists(t, dmQM);
                if (!isTelemetrySupported) {
                    isTelemetrySupported = Activator.isCommandForwardingCodeInstalled(t, dmQM);
                }
                if (isTelemetrySupported) {
                    TelemetryNodeFactory.addMainTelemetryTreeNodeOnGuiThread(t, qmgr, parent);
                    Activator.setTelemetryChannelSupported(dmQM, Boolean.TRUE);
                }
                if (Trace.isTracing) {
                    t.data(67, "TelemetryNodeFactory.updateTelemetryChannelSupported.run", "isSupported:" + isTelemetrySupported);
                }
            }
        };
        thread.setName("TelemetrySupportChecker");
        thread.start();
    }

    public static void addMainTelemetryTreeNodeOnGuiThread(final Trace t, final MQQmgrExtObject qmgr, final TreeNode parent) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                TelemetryNodeFactory.addMainTelemetryTreeNode(t, qmgr, parent);
                UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
            }
        });
    }

    public static void addMainTelemetryTreeNode(Trace t, MQQmgrExtObject qmgr, TreeNode parent) {
        TelemetryNodeObject treeNodeObject1Telemetry = new TelemetryNodeObject("Telemetry");
        TelemetryNode node = new TelemetryNode(parent, treeNodeObject1Telemetry, "com.ibm.mq.explorer.telemetry.ui");
        treeNodeObject1Telemetry.setTreeNode(node);
        treeNodeObject1Telemetry.setQueueManager(qmgr);
        parent.addChildToNode((TreeNode)node, 6);
    }
}

