/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.extensions.IChannelWizardContribution;
import com.ibm.mq.explorer.telemetry.ui.internal.DataModelListener;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNodeObject;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.SampleConfigWiz;
import com.ibm.mq.explorer.telemetry.ui.internal.wizards.SampleConfigWizDlg;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.content.TextOnlyContentPage;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class TelemetryContentPage
extends TextOnlyContentPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/TelemetryContentPage.java";
    private static final int DESCRIPTION_WIDTH_HINT = 500;
    private Composite defaultConfigComposite;
    private TelemetryNodeObject telemetryNodeObject;
    private DataModelListener dataModelListener = new DataModelListener(this);
    private Text configText;
    private StackLayout stackLayout;
    private Composite stack;
    private Composite linkComp;
    private IChannelWizardContribution clientUtilityAction;

    public TelemetryContentPage(Composite parent, int style) {
        super(parent, style);
    }

    public void setActive(boolean isActive) {
        super.setActive(isActive);
        this.dataModelListener.setActive(isActive);
    }

    public void setObject(MQExtObject object) {
        this.telemetryNodeObject = (TelemetryNodeObject)object;
        this.dataModelListener.setObject(object);
    }

    public void init() {
        Label label;
        Text text;
        ContentTitleBar contentTitleBar;
        GridData gridData;
        Trace t = Trace.getDefault();
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        int COL_SPAN = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = COL_SPAN;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Composite bannerComp = null;
        if (this.isCreateBanner()) {
            bannerComp = new Composite(composite, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginBottom = 0;
            bannerComp.setLayoutData((Object)gridData);
            this.createBanner(bannerComp);
        }
        Composite compMain = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = COL_SPAN;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginTop = 3;
        gridLayout.marginLeft = 3;
        gridLayout.marginBottom = 3;
        gridLayout.marginRight = 3;
        compMain.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = COL_SPAN;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        compMain.setLayoutData((Object)gridData);
        if (this.getPageTitle() != null) {
            contentTitleBar = new ContentTitleBar(compMain, 0);
            contentTitleBar.setText(this.getPageTitle());
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            contentTitleBar.setLayoutData((Object)gridData);
            if (this.getPageDescription() != null) {
                text = new Text(compMain, 66);
                text.setText(this.getPageDescription());
                gridData = new GridData(4, 1, true, false);
                gridData.horizontalSpan = COL_SPAN;
                gridData.widthHint = 500;
                gridLayout.marginRight = 30;
                text.setLayoutData((Object)gridData);
                UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
            }
            HyperlinkGroup linkGroup = new HyperlinkGroup(Display.getCurrent());
            this.stack = new Composite(compMain, 0);
            this.stackLayout = new StackLayout();
            this.stack.setLayout((Layout)this.stackLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            this.stack.setLayoutData((Object)gridData);
            this.configText = new Text(this.stack, 4);
            this.configText.setText("");
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.configText, (boolean)true);
            this.stackLayout.topControl = this.configText;
            this.linkComp = new Composite(this.stack, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkComp.setLayout((Layout)layout);
            Hyperlink configlink = new Hyperlink(this.linkComp, 0);
            configlink.setText(Messages.TelemetryContentPage_DefConfig);
            configlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TelemetryContentPage.this.configButtonPressed();
                }
            });
            linkGroup.add(configlink);
            String additionalButtonText = this.getAdditionalButtonText();
            this.clientUtilityAction = this.getMainUtilityContribution();
            if (additionalButtonText != null && this.clientUtilityAction != null) {
                Hyperlink extralink = new Hyperlink(compMain, 0);
                extralink.setText(additionalButtonText);
                gridData = new GridData();
                gridData.horizontalSpan = COL_SPAN;
                extralink.setLayoutData((Object)gridData);
                extralink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        TelemetryContentPage.this.additionalButtonPressed();
                    }
                });
                linkGroup.add(extralink);
            }
            Hyperlink helplink = new Hyperlink(compMain, 0);
            helplink.setText(this.getPageButtonText());
            gridData = new GridData();
            gridData.horizontalSpan = COL_SPAN;
            helplink.setLayoutData((Object)gridData);
            helplink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    UiPlugin.showBusyCursor((Trace)Trace.getDefault(), (Shell)TelemetryContentPage.this.getShell(), (boolean)true);
                    UiPlugin.getHelpSystem().displayHelpResource(TelemetryContentPage.this.getPageButtonHelpTopic());
                    UiPlugin.showBusyCursor((Trace)Trace.getDefault(), (Shell)TelemetryContentPage.this.getShell(), (boolean)false);
                }
            });
            linkGroup.add(helplink);
            if (this.getIconsTitle() != null) {
                Hyperlink iconHelplink = new Hyperlink(compMain, 0);
                iconHelplink.setText(this.getIconsButtonText());
                gridData = new GridData();
                gridData.horizontalSpan = COL_SPAN;
                iconHelplink.setLayoutData((Object)gridData);
                iconHelplink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        UiPlugin.showBusyCursor((Trace)Trace.getDefault(), (Shell)TelemetryContentPage.this.getShell(), (boolean)true);
                        UiPlugin.getHelpSystem().displayHelpResource(TelemetryContentPage.this.getIconsButtonHelpTopic());
                        UiPlugin.showBusyCursor((Trace)Trace.getDefault(), (Shell)TelemetryContentPage.this.getShell(), (boolean)false);
                    }
                });
                linkGroup.add(iconHelplink);
            }
            Composite parent = new Composite(compMain, 0);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            parent.setLayout((Layout)gridLayout);
            gridData = new GridData(4, 4, true, false);
            gridData.grabExcessHorizontalSpace = true;
            parent.setLayoutData((Object)gridData);
            label = new Label(parent, 0);
            gridData = new GridData(768);
            gridData.widthHint = 0;
            label.setLayoutData((Object)gridData);
            this.defaultConfigComposite = this.dataModelListener.makeComposite(parent);
            gridData = new GridData(16384, 4, false, false);
            this.defaultConfigComposite.setLayoutData((Object)gridData);
            label = new Label(compMain, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            label.setLayoutData((Object)gridData);
        }
        if (this.getIconsTitle() != null) {
            contentTitleBar = new ContentTitleBar(compMain, 0);
            contentTitleBar.setText(this.getIconsTitle());
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            contentTitleBar.setLayoutData((Object)gridData);
            if (this.getIconsDescription() != null) {
                text = new Text(compMain, 2);
                text.setText(this.getIconsDescription());
                gridData = new GridData(768);
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalSpan = COL_SPAN;
                text.setLayoutData((Object)gridData);
                UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
                Composite iconComp = new Composite(compMain, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 5;
                iconComp.setLayoutData((Object)gridData);
                GridLayout gl = new GridLayout(2, false);
                gl.numColumns = 2;
                iconComp.setLayout((Layout)gl);
                Image[] icons = this.getIcons();
                String[] iconsText = this.getIconsText();
                int k = 0;
                while (k < icons.length) {
                    label = new Label(iconComp, 0);
                    label.setImage(icons[k]);
                    Label label2 = new Label(iconComp, 0);
                    label2.setText(iconsText[k]);
                    ++k;
                }
            }
        }
        if (this.getBottomTitle() != null) {
            Label fill = new Label(compMain, 0);
            gridData = new GridData(1808);
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = COL_SPAN;
            fill.setLayoutData((Object)gridData);
            label = new Label(compMain, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            label.setLayoutData((Object)gridData);
            ContentTitleBar contentTitleBar2 = new ContentTitleBar(compMain, 0);
            contentTitleBar2.setText(this.getBottomTitle());
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            contentTitleBar2.setLayoutData((Object)gridData);
            Text text2 = new Text(compMain, 66);
            text2.setText(this.getBottomText());
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = COL_SPAN;
            gridData.widthHint = 400;
            text2.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)text2, (boolean)true);
        }
        ButtonTools.makeEqualWidthGridData((Trace)t, (Composite)compMain);
        if (bannerComp != null) {
            bannerComp.layout();
        }
        compMain.layout();
        composite.layout();
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        UiUtils.addScrollListeners((ScrolledComposite)scrolledComposite);
    }

    public String getId() {
        return "com.ibm.mq.explorer.telemetry.contentpage.main";
    }

    public boolean isCreateBanner() {
        return true;
    }

    public String getPageTitle() {
        return Messages.TelemetryContentPage_Title;
    }

    public String getPageDescription() {
        return Messages.TelemetryContentPage_Description;
    }

    public String getPageButtonText() {
        return Messages.TelemetryContentPage_HelpText;
    }

    public String getIconsTitle() {
        return null;
    }

    public String getIconsDescription() {
        return null;
    }

    public String[] getIconsText() {
        return new String[]{""};
    }

    public Image[] getIcons() {
        Image[] images = new Image[]{};
        return images;
    }

    public String getIconsButtonText() {
        return null;
    }

    public String getBottomTitle() {
        return null;
    }

    public String getBottomText() {
        return null;
    }

    public String getPageButtonHelpTopic() {
        return "/com.ibm.mq.explorer.doc/x_intro.html";
    }

    public String getIconsButtonHelpTopic() {
        return "";
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }

    public String getAdditionalButtonText() {
        return Messages.TelemetryContentPage_RunClientUtility;
    }

    private IChannelWizardContribution getMainUtilityContribution() {
        String searchPrefix = "class com.ibm.mq.explorer.telemetry.mqtt.utility";
        List<IChannelWizardContribution> list = Activator.getDefault().getFinishWizardActions();
        for (IChannelWizardContribution action : list) {
            if (!action.getClass().toString().startsWith(searchPrefix)) continue;
            return action;
        }
        return null;
    }

    public void additionalButtonPressed() {
        DmQueueManager dmQueueManager;
        MQQmgrExtObject qmgr;
        Object uiObj;
        Trace t = Trace.getDefault();
        String hostname = "localhost";
        if (this.telemetryNodeObject != null && (uiObj = (qmgr = this.telemetryNodeObject.getQueueManager()).getInternalObject()) instanceof UiQueueManager && (dmQueueManager = ((UiQueueManager)uiObj).getDmQueueManagerObject()).isClient(t)) {
            DmQueueManagerHandle dmhandle = dmQueueManager.getConnectionHandle();
            QueueManagerHandle connectionHandle = dmhandle.getQueueManagerHandle(t);
            hostname = connectionHandle.getHostName(t);
        }
        try {
            this.clientUtilityAction.performFinishAction("", hostname, 0, false);
        }
        catch (Exception e) {
            Activator.logException(e);
            t.FFST(67, "TelemetryContentPage.additionalButtonPressed", 10, 2195, 0, 0, e.getClass().getName(), e.getMessage(), "", (Throwable)e);
        }
    }

    public void configButtonPressed() {
        Trace t = Trace.getDefault();
        SampleConfigWiz createConfigWiz = new SampleConfigWiz(t, this);
        SampleConfigWizDlg createConfigWizDlg = new SampleConfigWizDlg(UiPlugin.getShell(), (IWizard)createConfigWiz);
        createConfigWizDlg.create();
        createConfigWizDlg.open();
    }

    public TelemetryNodeObject getTelemetryNodeObject() {
        return this.telemetryNodeObject;
    }

    public DataModelListener getDefaultConfiguration() {
        return this.dataModelListener;
    }

    public void showConfigButton_runSampleConfig() {
        this.stackLayout.topControl = this.linkComp;
        this.stack.layout();
    }

    public void showConfigButton_text(String text) {
        this.configText.setText(text);
        this.stackLayout.topControl = this.configText;
        this.stack.layout();
    }
}

