/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.trace.GenerateFFST;
import com.ibm.mq.explorer.qmgradmin.internal.base.QmgradminPlugin;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.ProcessResponse;
import com.ibm.mq.explorer.telemetry.ui.internal.UiTelemetryChannel;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StartChannelAction
implements DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/StartChannelAction.java";
    private UiTelemetryChannel uiTelemetryChannel = null;
    private String queueManagerName;
    private BusyDialog busyDialog = null;
    private String Start_CmdBusy;

    public StartChannelAction(Trace t, UiTelemetryChannel channel) {
        this.uiTelemetryChannel = channel;
        Message msgFile = QmgradminPlugin.getMessages((Trace)t, null);
        this.Start_CmdBusy = msgFile.getMessage(t, "UI.CHL.Busy.Starting");
    }

    public void start(Trace t) {
        int returnCode = 0;
        this.busyDialog = new BusyDialog(UiPlugin.getShell(), this.Start_CmdBusy);
        DmTelemetryChannel dmTelemetryChannel = (DmTelemetryChannel)this.uiTelemetryChannel.getDmObject();
        this.queueManagerName = this.uiTelemetryChannel.getDmObject().getQueueManager().toString(t);
        GenerateFFST.addReturnCodeToIgnoreList((int)3008);
        GenerateFFST.addReturnCodeToIgnoreList((int)3324);
        returnCode = dmTelemetryChannel.actionStart(t, (DmActionListener)this);
        if (returnCode == 0) {
            this.busyDialog.showDialog(t);
        } else {
            Vector<String> msgString = ProcessResponse.Getinsert(t, returnCode, this.queueManagerName);
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgString.elementAt(0), (String)msgString.elementAt(1));
        }
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        GenerateFFST.removeReturnCodeFromIgnoreList((int)3008);
        GenerateFFST.removeReturnCodeFromIgnoreList((int)3324);
        final int rc = event.getReasonCode();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                StartChannelAction.this.busyDialog.closeDialog(trace);
                if (rc == 0) {
                    String msgText = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4008");
                    MessageBox.showMessageSuccess((Trace)trace, (Shell)UiPlugin.getShell(), (String)msgText, (String)"AMQ4008", null);
                } else if (rc == 3324) {
                    String message = Messages.MQRCCF_PORT_IN_USE;
                    Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_General");
                    String[] buttons = new String[]{msgFile.getMessage(t, "UI.GENERAL.CLOSE")};
                    MessageBox.showMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)message, (int)4, (String[])buttons, (int)0, null);
                } else {
                    Vector<String> msgString = ProcessResponse.Getinsert(t, rc, StartChannelAction.this.queueManagerName);
                    MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgString.elementAt(0), (String)msgString.elementAt(1));
                }
            }
        });
    }
}

