/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.telemetry.ui.extensions.IChannelWizardContribution;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class InquireChannelAndPerformFinishAction
implements DmObjectListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/InquireChannelAndPerformFinishAction.java";
    private DmQueueManager dmQueueManager = null;
    private String channelName = null;
    private IChannelWizardContribution action;

    public void setDmQueueManager(DmQueueManager dmQueueManager) {
        this.dmQueueManager = dmQueueManager;
    }

    public void setChannelName(String channelNamer) {
        this.channelName = channelNamer;
    }

    public void setFinishWizardAction(IChannelWizardContribution action) {
        this.action = action;
    }

    public void start() {
        Trace t = Trace.getDefault();
        DmObjectFilter filter = new DmObjectFilter(t, this.channelName, 1026);
        this.dmQueueManager.addObserver(t, (DmObjectListener)this, filter);
    }

    public void stop() {
        Trace t = Trace.getDefault();
        this.dmQueueManager.deleteObserver(t, (DmObjectListener)this);
    }

    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        this.stop();
        DmTelemetryChannel dmTelemetryChannel = (DmTelemetryChannel)event.getSource();
        AttrInt attrInt = (AttrInt)dmTelemetryChannel.getAttribute(t, 1522, 0);
        Integer value = (Integer)attrInt.getValue(t);
        final int channelPort = value;
        final String channelHostname = this.getChannelHostname();
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                InquireChannelAndPerformFinishAction.this.action.performFinishAction(InquireChannelAndPerformFinishAction.this.channelName, channelHostname, channelPort, false);
            }
        });
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
        this.stop();
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    private String getChannelHostname() {
        Trace t = Trace.getDefault();
        String machineaddr = "";
        if (this.dmQueueManager.isLocal()) {
            machineaddr = "localhost";
        } else {
            DmQueueManagerHandle hnd = this.dmQueueManager.getConnectionHandle();
            QueueManagerHandle connhandle = hnd.getQueueManagerHandle(t);
            String conname = connhandle.getConnectionName();
            if (conname != null && !conname.equals("[not_defined]") && conname.length() > 0 && (machineaddr = this.getHostName(conname)).equals("127.0.0.1")) {
                machineaddr = "localhost";
            }
        }
        return machineaddr;
    }

    private String getHostName(String conname) {
        String hostname = conname;
        int index = conname.lastIndexOf("(");
        if (index != -1) {
            hostname = conname.substring(0, index);
        }
        return hostname;
    }
}

