/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.telemetry.ui.Activator;
import com.ibm.mq.explorer.telemetry.ui.Common;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryContentPage;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNode;
import com.ibm.mq.explorer.telemetry.ui.internal.TelemetryNodeObject;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerAuthQueue;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerAuthTopic;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerQmgr;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerQueue;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerQueueManager;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerService;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerServiceStatus;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerTelemetryChannel;
import com.ibm.mq.explorer.telemetry.ui.internal.listener.DataModelListenerTopic;
import com.ibm.mq.explorer.telemetry.ui.internal.preference.TelemetryPreferencePage;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.CreateTopicAuthority;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.CreateXmitQAuthority;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.DefineChannel;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.DefineService;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.DefineXmitQ;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.IStep;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.MakeXmitQDefault;
import com.ibm.mq.explorer.telemetry.ui.internal.steps.StartService;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import com.ibm.mq.pcf.event.PCFFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DataModelListener
implements DmObjectListener,
DmActionListener,
Observer {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/internal/DataModelListener.java";
    private static boolean showFullDefaultConfiguration = Activator.getBooleanOption("com.ibm.mq.explorer.telemetry.showfullstatus");
    private TelemetryNodeObject telemetryNodeObject;
    private TelemetryContentPage telemetryContentPage;
    private Composite defaultConfigComposite;
    private boolean isDefaultUserDefined;
    private boolean isContentPageActive;
    private boolean isQueueManagerConnected;
    private Object queueManagerListenerId;
    private DataModelListenerQueueManager dataModelListenerQueueManager;
    private DataModelListenerService dataModelListenerService;
    private DataModelListenerServiceStatus dataModelListenerServiceStatus;
    private DataModelListenerQueue dataModelListenerQueue;
    private DataModelListenerTopic dataModelListenerTopic;
    private DataModelListenerQmgr dataModelListenerQmgr;
    private DataModelListenerAuthQueue dataModelListenerAuthQueue;
    private DataModelListenerAuthTopic dataModelListenerAuthTopic;
    private DataModelListenerTelemetryChannel dataModelListenerTelemetryChannel;
    private Text serviceLabel;
    private Text serviceStatusLabel;
    private Text serviceStatusField;
    private Button defineServiceButton;
    private Button startServiceButton;
    private boolean telemetryServiceIsDefined;
    private boolean telemetryServiceIsStarted;
    private DefineService defineService;
    private StartService startService;
    private Text xmitQLabel;
    private Text xmitQStatusLabel;
    private Text xmitQStatusField;
    private Button defineXmitQButton;
    private Button alterDefaultXmitQButton;
    private Button setAuthorityXmitQButton;
    private boolean telemetryXmitQIsDefined;
    private boolean telemetryXmitQIsDefault;
    private boolean guestHasPutAuthorityToXmitQ;
    private DefineXmitQ defineXmitQ;
    private MakeXmitQDefault makeXmitQDefault;
    private CreateXmitQAuthority createXmitQAuthority;
    private Text baseTopicLabel;
    private Text baseTopicStatusLabel;
    private Text baseTopicStatusField;
    private Button setAuthorityBaseTopicButton;
    private boolean baseTopicIsDefined;
    private boolean guestHasAuthorityPublishToAnyTopic;
    private boolean guestHasAuthoritySubscribeToAnyTopic;
    private CreateTopicAuthority createTopicAuthority;
    private Text channelLabel;
    private Text channelStatusLabel;
    private Text channelStatusField;
    private Button defineChannelButton;
    private boolean channelIsDefined;
    private DefineChannel defineChannel;

    public DataModelListener(TelemetryContentPage page) {
        Trace t = Trace.getDefault();
        this.telemetryContentPage = page;
        TelemetryPreferencePage.addObserver(this);
        this.defineService = new DefineService(this);
        this.startService = new StartService(this);
        this.defineXmitQ = new DefineXmitQ(this);
        this.makeXmitQDefault = new MakeXmitQDefault(this);
        this.createXmitQAuthority = new CreateXmitQAuthority(this);
        this.createTopicAuthority = new CreateTopicAuthority(this);
        this.defineChannel = new DefineChannel(this);
        this.dataModelListenerQueueManager = new DataModelListenerQueueManager(this);
        this.queueManagerListenerId = DmMonitor.addQueueManagerListener((Trace)t, (DmQueueManagerListener)this.dataModelListenerQueueManager, (boolean)true);
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public TelemetryNodeObject getTelemetryNodeObject() {
        return this.telemetryNodeObject;
    }

    public void setObject(MQExtObject object) {
        this.telemetryNodeObject = (TelemetryNodeObject)object;
        MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        this.isQueueManagerConnected = dmQueueManager.isConnected();
    }

    public void setActive(boolean isActive) {
        this.isContentPageActive = isActive;
        if (isActive) {
            if (this.isQueueManagerConnected) {
                this.startListening();
            }
        } else {
            this.stopListening();
        }
    }

    private void startListening() {
        final Trace t = Trace.getDefault();
        MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        final DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        final String qmgrName = dmQueueManager.getTitle();
        final DataModelListener listener = this;
        int platform = dmQueueManager.getPlatform();
        final int platformEntityType = platform == 11 ? 1 : 2;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String statusText = Messages.DefaultConfiguration_ServiceNotDefined;
                DataModelListener.this.serviceStatusField.setText(statusText);
                DataModelListener.this.defaultConfigComposite.layout();
            }
        });
        this.clearState();
        final String jobText = Messages.TelemetryContentPage_UpdateJob;
        Job job = new Job(jobText){

            protected IStatus run(IProgressMonitor monitor) {
                DmObjectFilter filter;
                PCFFilter pcfFilter;
                DmObjectFilter filter2;
                monitor.beginTask(jobText, -1);
                DataModelListener.this.isDefaultUserDefined(t, dmQueueManager);
                if (DataModelListener.this.dataModelListenerService == null) {
                    filter2 = new DmObjectFilter(t, "SYSTEM.MQXR.SERVICE", 153);
                    DataModelListener.this.dataModelListenerService = new DataModelListenerService(listener);
                    dmQueueManager.addObserver(t, (DmObjectListener)DataModelListener.this.dataModelListenerService, filter2);
                }
                if (DataModelListener.this.dataModelListenerServiceStatus == null) {
                    filter2 = new DmObjectFilter(t, "SYSTEM.MQXR.SERVICE", 154);
                    DataModelListener.this.dataModelListenerServiceStatus = new DataModelListenerServiceStatus(listener);
                    dmQueueManager.addObserver(t, (DmObjectListener)DataModelListener.this.dataModelListenerServiceStatus, filter2);
                }
                if (DataModelListener.this.dataModelListenerQueue == null) {
                    filter2 = new DmObjectFilter(t, "SYSTEM.MQTT.TRANSMIT.QUEUE", 13);
                    DataModelListener.this.dataModelListenerQueue = new DataModelListenerQueue(listener);
                    dmQueueManager.addObserver(t, (DmObjectListener)DataModelListener.this.dataModelListenerQueue, filter2);
                }
                if (DataModelListener.this.dataModelListenerTopic == null) {
                    filter2 = new DmObjectFilter(t, "SYSTEM.BASE.TOPIC", 174);
                    DataModelListener.this.dataModelListenerTopic = new DataModelListenerTopic(listener);
                    dmQueueManager.addObserver(t, (DmObjectListener)DataModelListener.this.dataModelListenerTopic, filter2);
                }
                if (DataModelListener.this.dataModelListenerQmgr == null) {
                    filter2 = new DmObjectFilter(t, qmgrName, 2);
                    DataModelListener.this.dataModelListenerQmgr = new DataModelListenerQmgr(listener);
                    dmQueueManager.addObserver(t, (DmObjectListener)DataModelListener.this.dataModelListenerQmgr, filter2);
                }
                if (DataModelListener.this.dataModelListenerAuthQueue == null) {
                    pcfFilter = PCFFilter.getFilter((int)1118, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)platformEntityType);
                    filter = new DmObjectFilter(t, "SYSTEM.MQTT.TRANSMIT.QUEUE", 87, 1, pcfFilter);
                    filter.setAuthorityOptions(t, 17);
                    DataModelListener.this.dataModelListenerAuthQueue = new DataModelListenerAuthQueue(listener);
                    dmQueueManager.addObserver(t, (DmObjectListener)DataModelListener.this.dataModelListenerAuthQueue, filter);
                }
                if (DataModelListener.this.dataModelListenerAuthTopic == null) {
                    pcfFilter = PCFFilter.getFilter((int)1118, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)platformEntityType);
                    filter = new DmObjectFilter(t, "SYSTEM.BASE.TOPIC", 87, 8, pcfFilter);
                    filter.setAuthorityOptions(t, 17);
                    DataModelListener.this.dataModelListenerAuthTopic = new DataModelListenerAuthTopic(listener);
                    dmQueueManager.addObserver(t, (DmObjectListener)DataModelListener.this.dataModelListenerAuthTopic, filter);
                }
                DataModelListener.this.updateStatus();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void stopListening() {
        Trace t = Trace.getDefault();
        MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        if (this.dataModelListenerService != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerService);
            this.dataModelListenerService = null;
        }
        if (this.dataModelListenerServiceStatus != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerServiceStatus);
            this.dataModelListenerServiceStatus = null;
        }
        if (this.dataModelListenerQueue != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerQueue);
            this.dataModelListenerQueue = null;
        }
        if (this.dataModelListenerTopic != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerTopic);
            this.dataModelListenerTopic = null;
        }
        if (this.dataModelListenerQmgr != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerQmgr);
            this.dataModelListenerQmgr = null;
        }
        if (this.dataModelListenerAuthQueue != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerAuthQueue);
            this.dataModelListenerAuthQueue = null;
        }
        if (this.dataModelListenerAuthTopic != null) {
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerAuthTopic);
            this.dataModelListenerAuthTopic = null;
        }
        this.stopListeningForSampleTelemetryChannel();
    }

    private void startListeningForSampleTelemetryChannel() {
        Trace t = Trace.getDefault();
        if (this.dataModelListenerTelemetryChannel == null) {
            MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
            UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
            DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
            DmObjectFilter filter = new DmObjectFilter(t, "PlainText", 1026);
            this.dataModelListenerTelemetryChannel = new DataModelListenerTelemetryChannel(this);
            dmQueueManager.addObserver(t, (DmObjectListener)this.dataModelListenerTelemetryChannel, filter);
        }
    }

    private void stopListeningForSampleTelemetryChannel() {
        Trace t = Trace.getDefault();
        if (this.dataModelListenerTelemetryChannel != null) {
            MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
            UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
            DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
            dmQueueManager.deleteObserver(t, (DmObjectListener)this.dataModelListenerTelemetryChannel);
            this.dataModelListenerTelemetryChannel = null;
        }
    }

    public Composite makeComposite(Composite parent) {
        Trace t = Trace.getDefault();
        int COL_SPAN = 5;
        this.defaultConfigComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = COL_SPAN;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.defaultConfigComposite.setLayout((Layout)gridLayout);
        this.serviceLabel = new Text(this.defaultConfigComposite, 4);
        this.serviceLabel.setText(Messages.DefaultConfiguration_ServiceNameLable);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        this.serviceLabel.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.serviceLabel, (boolean)true);
        this.serviceStatusField = new Text(this.defaultConfigComposite, 2052);
        this.serviceStatusField.setText("SYSTEM.MQXR.SERVICE");
        gridData = new GridData(16384, 0x1000000, false, false);
        this.serviceStatusField.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.serviceStatusField, (boolean)true);
        Label padding = new Label(this.defaultConfigComposite, 4);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 10;
        padding.setLayoutData((Object)gridData);
        this.serviceStatusLabel = new Text(this.defaultConfigComposite, 4);
        this.serviceStatusLabel.setText(Messages.DefaultConfiguration_StatusLable);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.serviceStatusLabel.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.serviceStatusLabel, (boolean)true);
        this.serviceStatusField = new Text(this.defaultConfigComposite, 2052);
        this.serviceStatusField.setText(Messages.DefaultConfiguration_ServiceNotDefined);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.serviceStatusField.setLayoutData((Object)gridData);
        gridData.widthHint = 100;
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.serviceStatusField, (boolean)true);
        if (showFullDefaultConfiguration) {
            padding = new Label(this.defaultConfigComposite, 4);
            gridData = new GridData(0x1000000, 0x1000000, true, false);
            padding.setLayoutData((Object)gridData);
            Composite serviceButtonComposite = new Composite(this.defaultConfigComposite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 5;
            gridLayout.makeColumnsEqualWidth = false;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginRight = 0;
            serviceButtonComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = 4;
            serviceButtonComposite.setLayoutData((Object)gridData);
            this.defineServiceButton = new Button(serviceButtonComposite, 8);
            this.defineServiceButton.setText(Messages.DefaultConfiguration_DefineServiceButton);
            gridData = new GridData(0x1000000, 0x1000000, false, false);
            this.defineServiceButton.setLayoutData((Object)gridData);
            this.defineServiceButton.setEnabled(true);
            this.defineServiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataModelListener.this.defineService.perform();
                }
            });
            this.startServiceButton = new Button(serviceButtonComposite, 8);
            this.startServiceButton.setText(Messages.DefaultConfiguration_StartServiceButton);
            gridData = new GridData(0x1000000, 0x1000000, false, false);
            this.startServiceButton.setLayoutData((Object)gridData);
            this.startServiceButton.setEnabled(false);
            this.startServiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataModelListener.this.startService.perform();
                }
            });
            this.xmitQLabel = new Text(this.defaultConfigComposite, 4);
            this.xmitQLabel.setText(Messages.DefaultConfiguration_XmitQNameLable);
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.xmitQLabel.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.xmitQLabel, (boolean)true);
            this.xmitQStatusField = new Text(this.defaultConfigComposite, 2052);
            this.xmitQStatusField.setText("SYSTEM.MQTT.TRANSMIT.QUEUE");
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.xmitQStatusField.setLayoutData((Object)gridData);
            gridData.widthHint = 180;
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.xmitQStatusField, (boolean)true);
            padding = new Label(this.defaultConfigComposite, 4);
            gridData = new GridData(0x1000000, 0x1000000, true, false);
            gridData.widthHint = 20;
            padding.setLayoutData((Object)gridData);
            this.xmitQStatusLabel = new Text(this.defaultConfigComposite, 4);
            this.xmitQStatusLabel.setText(Messages.DefaultConfiguration_StatusLable);
            gridData = new GridData(131072, 0x1000000, false, false);
            this.xmitQStatusLabel.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.xmitQStatusLabel, (boolean)true);
            this.xmitQStatusField = new Text(this.defaultConfigComposite, 2052);
            this.xmitQStatusField.setText(Messages.DefaultConfiguration_NotDefined);
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.xmitQStatusField.setLayoutData((Object)gridData);
            gridData.widthHint = 100;
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.xmitQStatusField, (boolean)true);
            padding = new Label(this.defaultConfigComposite, 4);
            gridData = new GridData(0x1000000, 0x1000000, true, false);
            padding.setLayoutData((Object)gridData);
            Composite xmitQButtonComposite = new Composite(this.defaultConfigComposite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 5;
            gridLayout.makeColumnsEqualWidth = false;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginRight = 0;
            xmitQButtonComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = 4;
            xmitQButtonComposite.setLayoutData((Object)gridData);
            this.defineXmitQButton = new Button(xmitQButtonComposite, 8);
            this.defineXmitQButton.setText(Messages.DefaultConfiguration_DefineXmitQButton);
            gridData = new GridData(0x1000000, 0x1000000, false, false);
            gridData.horizontalSpan = 1;
            this.defineXmitQButton.setLayoutData((Object)gridData);
            this.defineXmitQButton.setEnabled(true);
            this.defineXmitQButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataModelListener.this.defineXmitQ.perform();
                }
            });
            this.alterDefaultXmitQButton = new Button(xmitQButtonComposite, 8);
            this.alterDefaultXmitQButton.setText(Messages.DefaultConfiguration_MakeDefaultButton);
            gridData = new GridData(0x1000000, 0x1000000, false, false);
            gridData.horizontalSpan = 1;
            this.alterDefaultXmitQButton.setLayoutData((Object)gridData);
            this.alterDefaultXmitQButton.setEnabled(false);
            this.alterDefaultXmitQButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataModelListener.this.makeXmitQDefault.perform();
                }
            });
            this.setAuthorityXmitQButton = new Button(xmitQButtonComposite, 8);
            this.setAuthorityXmitQButton.setText(Messages.DefaultConfiguration_SetAuthorityButton);
            gridData = new GridData(0x1000000, 0x1000000, false, false);
            gridData.horizontalSpan = 1;
            this.setAuthorityXmitQButton.setLayoutData((Object)gridData);
            this.setAuthorityXmitQButton.setEnabled(false);
            this.setAuthorityXmitQButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataModelListener.this.createXmitQAuthority.perform();
                }
            });
            this.baseTopicLabel = new Text(this.defaultConfigComposite, 4);
            this.baseTopicLabel.setText(Messages.DefaultConfiguration_BaseTopicNameLable);
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.baseTopicLabel.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.baseTopicLabel, (boolean)true);
            this.baseTopicStatusField = new Text(this.defaultConfigComposite, 2052);
            this.baseTopicStatusField.setText("SYSTEM.BASE.TOPIC");
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.baseTopicStatusField.setLayoutData((Object)gridData);
            gridData.widthHint = 180;
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.baseTopicStatusField, (boolean)true);
            padding = new Label(this.defaultConfigComposite, 4);
            gridData = new GridData(0x1000000, 0x1000000, true, false);
            gridData.widthHint = 20;
            padding.setLayoutData((Object)gridData);
            this.baseTopicStatusLabel = new Text(this.defaultConfigComposite, 4);
            this.baseTopicStatusLabel.setText(Messages.DefaultConfiguration_StatusLable);
            gridData = new GridData(131072, 0x1000000, false, false);
            this.baseTopicStatusLabel.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.baseTopicStatusLabel, (boolean)true);
            this.baseTopicStatusField = new Text(this.defaultConfigComposite, 2052);
            this.baseTopicStatusField.setText(Messages.DefaultConfiguration_NotDefined);
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.baseTopicStatusField.setLayoutData((Object)gridData);
            gridData.widthHint = 100;
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.baseTopicStatusField, (boolean)true);
            padding = new Label(this.defaultConfigComposite, 4);
            gridData = new GridData(0x1000000, 0x1000000, true, false);
            padding.setLayoutData((Object)gridData);
            Composite defTopicButtonComposite = new Composite(this.defaultConfigComposite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 5;
            gridLayout.makeColumnsEqualWidth = false;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginRight = 0;
            defTopicButtonComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = 4;
            defTopicButtonComposite.setLayoutData((Object)gridData);
            this.setAuthorityBaseTopicButton = new Button(defTopicButtonComposite, 8);
            this.setAuthorityBaseTopicButton.setText(Messages.DefaultConfiguration_SetAuthorityButton);
            gridData = new GridData(0x1000000, 0x1000000, false, false);
            gridData.horizontalSpan = 1;
            this.setAuthorityBaseTopicButton.setLayoutData((Object)gridData);
            this.setAuthorityBaseTopicButton.setEnabled(false);
            this.setAuthorityBaseTopicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataModelListener.this.createTopicAuthority.perform();
                }
            });
            this.channelLabel = new Text(this.defaultConfigComposite, 4);
            this.channelLabel.setText(Messages.DefaultConfiguration_ChannelNameLable);
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.channelLabel.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.channelLabel, (boolean)true);
            this.channelStatusField = new Text(this.defaultConfigComposite, 2052);
            this.channelStatusField.setText("PlainText");
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.channelStatusField.setLayoutData((Object)gridData);
            gridData.widthHint = 180;
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.channelStatusField, (boolean)true);
            padding = new Label(this.defaultConfigComposite, 4);
            gridData = new GridData(0x1000000, 0x1000000, true, false);
            gridData.widthHint = 20;
            padding.setLayoutData((Object)gridData);
            this.channelStatusLabel = new Text(this.defaultConfigComposite, 4);
            this.channelStatusLabel.setText(Messages.DefaultConfiguration_StatusLable);
            gridData = new GridData(131072, 0x1000000, false, false);
            this.channelStatusLabel.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.channelStatusLabel, (boolean)true);
            this.channelStatusField = new Text(this.defaultConfigComposite, 2052);
            this.channelStatusField.setText(Messages.DefaultConfiguration_NotDefined);
            gridData = new GridData(0x1000008, 0x1000000, false, false);
            this.channelStatusField.setLayoutData((Object)gridData);
            gridData.widthHint = 100;
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.channelStatusField, (boolean)true);
            padding = new Label(this.defaultConfigComposite, 4);
            gridData = new GridData(0x1000000, 0x1000000, true, false);
            padding.setLayoutData((Object)gridData);
            Composite channelButtonComposite = new Composite(this.defaultConfigComposite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 5;
            gridLayout.makeColumnsEqualWidth = false;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginRight = 0;
            channelButtonComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = 4;
            channelButtonComposite.setLayoutData((Object)gridData);
            this.defineChannelButton = new Button(channelButtonComposite, 8);
            this.defineChannelButton.setText(Messages.DefaultConfiguration_DefineChannelButton);
            gridData = new GridData(0x1000000, 0x1000000, false, false);
            gridData.horizontalSpan = 1;
            this.defineChannelButton.setLayoutData((Object)gridData);
            this.defineChannelButton.setEnabled(false);
            this.defineChannelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataModelListener.this.defineChannel.perform();
                }
            });
        }
        return this.defaultConfigComposite;
    }

    private void updateStatus() {
        Trace t = Trace.getDefault();
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            t.data(67, "DataModelListener.updateStatus", "workbench == null");
            return;
        }
        UiPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DataModelListener.this.updateBaseTopicUiThread();
                DataModelListener.this.updateServiceUiThread();
                DataModelListener.this.updateXmitQStatusUiThread();
                DataModelListener.this.updateSampleChannelUiThread();
                if (!DataModelListener.this.isDefaultUserDefined) {
                    MQQmgrExtObject qmgr = DataModelListener.this.telemetryNodeObject.getQueueManager();
                    UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
                    DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
                    String text = Messages.TelemetryContentPage_DefaultUserNotDefined;
                    Object[] inserts = new Object[]{Common.getDefaultUser(dmQueueManager)};
                    String message = MessageFormat.format(text, inserts);
                    DataModelListener.this.telemetryContentPage.showConfigButton_text(message);
                } else {
                    boolean showButton;
                    List<IStep> steps = DataModelListener.this.getSteps();
                    boolean bl = showButton = steps.size() > 0;
                    if (showButton) {
                        DataModelListener.this.telemetryContentPage.showConfigButton_runSampleConfig();
                    } else {
                        String text = Messages.TelemetryContentPage_DefConfigDone;
                        DataModelListener.this.telemetryContentPage.showConfigButton_text(text);
                    }
                }
            }
        });
    }

    private void updateBaseTopicUiThread() {
        if (showFullDefaultConfiguration) {
            String text = Messages.DefaultConfiguration_IsConfigured;
            boolean needToSetAuthority = false;
            if (!this.baseTopicIsDefined) {
                text = Messages.DefaultConfiguration_NotDefined;
            }
            if (!this.guestHasAuthorityPublishToAnyTopic) {
                needToSetAuthority = true;
                text = Messages.DefaultConfiguration_NotAuthorised;
            }
            if (!this.guestHasAuthoritySubscribeToAnyTopic) {
                needToSetAuthority = true;
                text = Messages.DefaultConfiguration_NotAuthorised;
            }
            this.setAuthorityBaseTopicButton.setEnabled(needToSetAuthority);
            this.baseTopicStatusField.setText(text);
        }
    }

    private void updateServiceUiThread() {
        Trace t = Trace.getDefault();
        String text = Messages.DefaultConfiguration_ServiceStarted;
        boolean needToDefineService = false;
        boolean needToStartService = false;
        boolean needToRemoveChildTreeNodes = false;
        if (!this.telemetryServiceIsDefined) {
            needToDefineService = true;
            text = Messages.DefaultConfiguration_ServiceNotDefined;
        } else if (!this.telemetryServiceIsStarted) {
            needToStartService = true;
            needToRemoveChildTreeNodes = true;
            text = Messages.DefaultConfiguration_ServiceStopped;
        }
        if (showFullDefaultConfiguration) {
            this.defineServiceButton.setEnabled(needToDefineService);
            this.startServiceButton.setEnabled(needToStartService);
        }
        this.serviceStatusField.setText(text);
        TelemetryNode treeNode = this.telemetryNodeObject.getTreeNode();
        TreeNode[] children = treeNode.getChildren();
        if (needToRemoveChildTreeNodes) {
            int i = 0;
            while (i < children.length) {
                TreeNode child = children[i];
                treeNode.removeChildFromNode(child);
                ++i;
            }
        }
        UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
    }

    private void updateXmitQStatusUiThread() {
        if (showFullDefaultConfiguration) {
            String text = Messages.DefaultConfiguration_IsConfigured;
            boolean needToDefineXmitQ = false;
            boolean needToAlterDefaultXmitQ = false;
            boolean needToSetAuthorityToXmitQ = false;
            if (!this.telemetryXmitQIsDefined) {
                needToDefineXmitQ = true;
                text = Messages.DefaultConfiguration_NotDefined;
            } else {
                if (!this.guestHasPutAuthorityToXmitQ) {
                    needToSetAuthorityToXmitQ = true;
                    text = Messages.DefaultConfiguration_NotAuthorised;
                }
                if (!this.telemetryXmitQIsDefault) {
                    needToAlterDefaultXmitQ = true;
                    text = Messages.DefaultConfiguration_NotDefault;
                }
            }
            this.defineXmitQButton.setEnabled(needToDefineXmitQ);
            this.alterDefaultXmitQButton.setEnabled(needToAlterDefaultXmitQ);
            this.setAuthorityXmitQButton.setEnabled(needToSetAuthorityToXmitQ);
            this.xmitQStatusField.setText(text);
        }
    }

    private void updateSampleChannelUiThread() {
        if (showFullDefaultConfiguration) {
            String text = Messages.DefaultConfiguration_NotDefined;
            boolean needToDefineChannel = true;
            if (this.channelIsDefined) {
                needToDefineChannel = false;
                text = Messages.DefaultConfiguration_IsConfigured;
            }
            if (!this.telemetryServiceIsStarted) {
                needToDefineChannel = false;
            }
            this.defineChannelButton.setEnabled(needToDefineChannel);
            this.channelStatusField.setText(text);
        }
    }

    public List<IStep> getSteps() {
        ArrayList<IStep> list = new ArrayList<IStep>();
        if (!this.telemetryServiceIsDefined) {
            list.add(this.defineService);
        }
        if (!this.telemetryServiceIsStarted) {
            list.add(this.startService);
        }
        if (!this.telemetryXmitQIsDefined) {
            list.add(this.defineXmitQ);
        }
        if (!this.telemetryXmitQIsDefault) {
            list.add(this.makeXmitQDefault);
        }
        if (!this.guestHasPutAuthorityToXmitQ) {
            list.add(this.createXmitQAuthority);
        }
        if (!this.guestHasAuthorityPublishToAnyTopic || !this.guestHasAuthoritySubscribeToAnyTopic) {
            list.add(this.createTopicAuthority);
        }
        if (!this.channelIsDefined) {
            list.add(this.defineChannel);
        }
        return list;
    }

    public void clearState() {
        this.telemetryServiceIsDefined = false;
        this.telemetryServiceIsStarted = false;
        this.telemetryXmitQIsDefined = false;
        this.baseTopicIsDefined = false;
        this.guestHasPutAuthorityToXmitQ = false;
        this.guestHasAuthorityPublishToAnyTopic = false;
        this.guestHasAuthoritySubscribeToAnyTopic = false;
        this.channelIsDefined = false;
        this.isDefaultUserDefined = false;
    }

    public void dmObjectAdded(DmObjectEvent event) {
        int type = event.getObjectType();
        switch (type) {
            case 153: {
                this.telemetryServiceIsDefined = true;
                break;
            }
            case 154: {
                this.startListeningForSampleTelemetryChannel();
                this.telemetryServiceIsStarted = true;
                break;
            }
            case 13: {
                this.telemetryXmitQIsDefined = true;
                break;
            }
            case 174: {
                this.baseTopicIsDefined = true;
                break;
            }
            case 87: {
                this.processAuthorityEvent(event);
                break;
            }
            case 1026: {
                this.channelIsDefined = true;
            }
        }
        this.updateStatus();
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        int type = event.getObjectType();
        switch (type) {
            case 153: {
                this.telemetryServiceIsDefined = false;
                break;
            }
            case 154: {
                this.stopListeningForSampleTelemetryChannel();
                this.telemetryServiceIsStarted = false;
                break;
            }
            case 13: {
                this.telemetryXmitQIsDefined = false;
                break;
            }
            case 174: {
                this.baseTopicIsDefined = false;
                break;
            }
            case 87: {
                this.processAuthorityEvent(event);
                break;
            }
            case 1026: {
                this.channelIsDefined = false;
            }
        }
        this.updateStatus();
    }

    public void dmObjectChanged(DmObjectEvent event) {
        int type = event.getObjectType();
        switch (type) {
            case 2: {
                this.processQueueManagerEvent(event);
                break;
            }
            case 87: {
                this.processAuthorityEvent(event);
            }
        }
        this.updateStatus();
    }

    private void processQueueManagerEvent(DmObjectEvent event) {
        DmQueueManager source;
        String sourceUUID;
        Trace t = Trace.getDefault();
        MQQmgrExtObject qmgr = this.telemetryNodeObject.getQueueManager();
        UiQueueManager uiQueueManager = (UiQueueManager)qmgr.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        String thisUUID = dmQueueManager.getUUID();
        if (thisUUID.equals(sourceUUID = (source = (DmQueueManager)event.getSource()).getUUID())) {
            Attr attr = source.getAttribute(t, 2025, 0);
            AttrString attrString = (AttrString)attr;
            String defaultXmitQName = (String)attrString.getValue(t);
            this.telemetryXmitQIsDefault = false;
            if ("SYSTEM.MQTT.TRANSMIT.QUEUE".equals(defaultXmitQName)) {
                this.telemetryXmitQIsDefault = true;
            }
        }
    }

    private void processAuthorityEvent(DmObjectEvent event) {
        int entityType;
        Trace t = Trace.getDefault();
        DmAuthorityRecord dmAuthorityRecord = (DmAuthorityRecord)event.getSource();
        Attr attr = dmAuthorityRecord.getAttribute(t, 1016, 0);
        AttrInt attrInt = (AttrInt)attr;
        int objectType = (Integer)attrInt.getValue(t);
        DmQueueManager dmQueueManager = dmAuthorityRecord.getQueueManager();
        int platform = dmQueueManager.getPlatform();
        int platformEntityType = 2;
        if (platform == 11) {
            platformEntityType = 1;
        }
        if ((entityType = dmAuthorityRecord.getEntityType(t)) != platformEntityType) {
            return;
        }
        String defaultUser = Common.getDefaultUser(dmQueueManager);
        String entityName = dmAuthorityRecord.getEntityName(t);
        if (platform == 11 ? !entityName.startsWith(String.valueOf(defaultUser) + "@") : !entityName.equals(defaultUser)) {
            return;
        }
        int eventType = event.getEventType();
        block0 : switch (eventType) {
            case 1: 
            case 4: {
                attr = dmAuthorityRecord.getAttribute(t, 1115, 0);
                AttrIntArrayEnum attrAuthorizationList = (AttrIntArrayEnum)attr;
                List authorizationList = (List)attrAuthorizationList.getValue(t);
                switch (objectType) {
                    case 1: {
                        this.guestHasPutAuthorityToXmitQ = false;
                        int i = 0;
                        while (i < authorizationList.size()) {
                            int auth = (Integer)authorizationList.get(i);
                            switch (auth) {
                                case 11: {
                                    this.guestHasPutAuthorityToXmitQ = true;
                                }
                            }
                            ++i;
                        }
                        break block0;
                    }
                    case 8: {
                        this.guestHasAuthorityPublishToAnyTopic = false;
                        this.guestHasAuthoritySubscribeToAnyTopic = false;
                        int i = 0;
                        while (i < authorizationList.size()) {
                            int auth = (Integer)authorizationList.get(i);
                            switch (auth) {
                                case 19: {
                                    this.guestHasAuthorityPublishToAnyTopic = true;
                                    break;
                                }
                                case 20: {
                                    this.guestHasAuthoritySubscribeToAnyTopic = true;
                                }
                            }
                            ++i;
                        }
                        break block4;
                    }
                }
                break;
            }
            case 2: {
                switch (objectType) {
                    case 1: {
                        this.guestHasPutAuthorityToXmitQ = false;
                        break block0;
                    }
                    case 8: {
                        this.guestHasAuthorityPublishToAnyTopic = false;
                        this.guestHasAuthoritySubscribeToAnyTopic = false;
                    }
                }
            }
        }
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void isDefaultUserDefined(Trace t, DmQueueManager dmQueueManager) {
        DataModelListener listener = this;
        String queueName = "x";
        DmAuthorityRecord dmAuthorityRecord = (DmAuthorityRecord)DmObjectFactory.create((Trace)t, (DmQueueManager)dmQueueManager, (int)87, (String)queueName);
        String entityName = Common.getDefaultUser(dmQueueManager);
        dmAuthorityRecord.addAttr(t, 3068, 0, (Object)entityName);
        dmAuthorityRecord.addAttr(t, 1016, 0, (Object)1);
        dmAuthorityRecord.addAttr(t, 1118, 0, (Object)1);
        Object job = dmAuthorityRecord.beginUpdate(t);
        String[] al = new String[]{entityName};
        dmAuthorityRecord.createAttribute(t, job, 3065, 0, (Object)al);
        int[] adds = new int[]{11};
        dmAuthorityRecord.createAttribute(t, job, 1116, 0, (Object)adds);
        dmAuthorityRecord.actionCreate(t, (DmActionListener)listener, job);
        dmAuthorityRecord.endUpdate(t, job);
    }

    public void dmActionDone(DmActionEvent event) {
        Trace t = Trace.getDefault();
        int reason = event.getReasonCode();
        switch (reason) {
            case 0: 
            case 2085: {
                this.isDefaultUserDefined = true;
                break;
            }
            case 2292: {
                this.isDefaultUserDefined = false;
            }
        }
        this.updateStatus();
        if (Trace.isTracing) {
            int command = event.getCommand();
            String commandString = MQConstants.lookup((int)command, (String)"MQCMD.*");
            String reasonString = MQConstants.lookupReasonCode((int)reason);
            StringBuffer sb = new StringBuffer();
            sb.append("command=");
            sb.append(command);
            sb.append(":");
            sb.append(commandString);
            sb.append(" reason=");
            sb.append(reason);
            sb.append(":");
            sb.append(reasonString);
            sb.append(" --> isDefaultUserDefined=");
            sb.append(this.isDefaultUserDefined);
            t.data(67, "DataModelListener.dmActionDone", sb.toString());
        }
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        DmQueueManager source;
        String sourceUUID;
        MQQmgrExtObject qmgr;
        UiQueueManager uiQueueManager;
        DmQueueManager dmQueueManager;
        String thisUUID;
        Trace t = Trace.getDefault();
        if (this.telemetryNodeObject != null && (thisUUID = (dmQueueManager = (uiQueueManager = (UiQueueManager)(qmgr = this.telemetryNodeObject.getQueueManager()).getInternalObject()).getDmQueueManagerObject()).getUUID()).equals(sourceUUID = (source = (DmQueueManager)event.getSource()).getUUID())) {
            t.data(67, "DataModelListener.dmQueueManagerConnected", "QueueManager Connected: " + thisUUID);
            this.isQueueManagerConnected = true;
            if (this.isContentPageActive) {
                this.startListening();
            }
        }
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        DmQueueManager source;
        String sourceUUID;
        MQQmgrExtObject qmgr;
        UiQueueManager uiQueueManager;
        DmQueueManager dmQueueManager;
        String thisUUID;
        Trace t = Trace.getDefault();
        if (this.telemetryNodeObject != null && (thisUUID = (dmQueueManager = (uiQueueManager = (UiQueueManager)(qmgr = this.telemetryNodeObject.getQueueManager()).getInternalObject()).getDmQueueManagerObject()).getUUID()).equals(sourceUUID = (source = (DmQueueManager)event.getSource()).getUUID())) {
            t.data(67, "DataModelListener.dmQueueManagerDisconnected", "QueueManager Disconnected: " + thisUUID);
            this.isQueueManagerConnected = false;
            this.stopListening();
        }
    }
}

