/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.ui;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmServiceStatus;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannelStatus;
import com.ibm.mq.explorer.core.internal.trace.GenerateFFST;
import com.ibm.mq.explorer.telemetry.ui.TelemetryExplorerNotify;
import com.ibm.mq.explorer.telemetry.ui.extensions.IChannelWizardContribution;
import com.ibm.mq.explorer.telemetry.ui.internal.ChannelWizardContributionManager;
import com.ibm.mq.explorer.telemetry.ui.internal.Messages;
import com.ibm.mq.explorer.telemetry.ui.internal.preference.TelemetryPreferencePage;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotify;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.DefaultObjectAttributeDetails;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;
import com.ibm.mq.explorer.ui.internal.base.NotificationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFMonitorAgent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.ui/src/com/ibm/mq/explorer/telemetry/ui/Activator.java";
    private static final String NL = System.getProperty("line.separator");
    public static final String PLUGIN_ID = "com.ibm.mq.explorer.telemetry.ui";
    private static String nameDist = null;
    private static String nameZOS = null;
    private static String copyDistToZos = null;
    private static String copyZosToDist = null;
    private static DefaultObjectAttributeDetails attrDetails = null;
    private ChannelWizardContributionManager finishWizardActionManager = new ChannelWizardContributionManager();
    private static Activator plugin;
    private ResourceBundle resourceBundle;
    private static boolean initialized;
    public static Hashtable<String, Boolean> telemetryChannelSupportedTable;
    public static HashMap<String, String> optionsMap;
    public static final String SHOW_FULL_STATUS = "com.ibm.mq.explorer.telemetry.showfullstatus";

    static {
        initialized = false;
        telemetryChannelSupportedTable = new Hashtable();
        optionsMap = new HashMap();
        String options = System.getProperty(SHOW_FULL_STATUS);
        if (options != null) {
            optionsMap.put(SHOW_FULL_STATUS, options);
        }
    }

    public static boolean getBooleanOption(String key) {
        boolean result = false;
        String string = optionsMap.get(key);
        if (string != null) {
            result = Boolean.parseBoolean(string);
        }
        return result;
    }

    public static int getIntOption(String key) {
        int result = 0;
        String string = optionsMap.get(key);
        if (string != null) {
            result = Integer.parseInt(string);
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Trace t = Trace.getDefault();
        Bundle core = Platform.getBundle((String)"com.ibm.mq.explorer.core");
        Bundle telemetry = Platform.getBundle((String)PLUGIN_ID);
        String coreV = (String)core.getHeaders().get("Bundle-Version");
        String telemetryV = (String)telemetry.getHeaders().get("Bundle-Version");
        int ind = coreV.lastIndexOf(46);
        final String coreVersion = coreV.substring(0, ind);
        ind = telemetryV.lastIndexOf(46);
        final String telemetryVersion = telemetryV.substring(0, ind);
        boolean goodVersion = false;
        if (coreVersion.equals("99.99.99") || telemetryVersion.equals("99.99.99")) {
            goodVersion = true;
        } else if (coreVersion.equals(telemetryVersion)) {
            goodVersion = true;
        }
        if (!goodVersion && UiPlugin.getPluginRegistrationManager().isPluginEnabled(PLUGIN_ID)) {
            UiPlugin.getPluginRegistrationManager().enablePlugin(PLUGIN_ID, false);
            IPreferenceStore store = UiPlugin.getPrefStore();
            store.setValue("EnablePlugin_com.ibm.mq.explorer.telemetry.ui", false);
            UiPlugin.getPluginRegistrationManager().enablementUpdateComplete();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox.showMessageFailure((Trace)Trace.getDefault(), (Shell)UiPlugin.getShell(), (String)NLS.bind((String)Messages.Activator_IncompatibleVersionsFound, (Object)telemetryVersion, (Object)coreVersion));
                }
            });
            if (Trace.isTracing) {
                t.data(67, "Activator.start", 900, "Error: MQ Telemetry version (" + telemetryVersion + ") incompatible with MQ Explorer version (" + coreVersion + ")");
            }
        }
        TelemetryPreferencePage.start(t);
        NotificationManager notificationManager = UiPlugin.getNotificationManager();
        notificationManager.addListener(t, (IExplorerNotify)new TelemetryExplorerNotify(), PLUGIN_ID);
        GenerateFFST.addReturnCodeToIgnoreList((int)4044);
    }

    public void initialise() throws Exception {
        Trace t = Trace.getDefault();
        if (initialized) {
            return;
        }
        if (!UiPlugin.getPluginRegistrationManager().isPluginEnabled(PLUGIN_ID)) {
            return;
        }
        Message uiMsgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Schemes");
        nameDist = uiMsgFile.getMessage(t, "UI.SCHEMES.Distrib.Name");
        nameZOS = uiMsgFile.getMessage(t, "UI.SCHEMES.zOS.Name");
        copyDistToZos = uiMsgFile.getMessage(t, "UI.SCHEMES.Button.CopyDistToZos");
        copyZosToDist = uiMsgFile.getMessage(t, "UI.SCHEMES.Button.CopyZosToDist");
        attrDetails = new DefaultObjectAttributeDetails();
        this.finishWizardActionManager.loadPlugins(t);
        initialized = true;
    }

    public static void registerTelemetryChannels(Trace t, AttributeOrderManager attrOrderManager) {
        int[] orderZOS;
        int[] orderDistributed;
        String[] names;
        int[] allAttrs = DmTelemetryChannel.getAllAttributesByType((Trace)t);
        boolean result = attrOrderManager.register(t, (IAttributeDetails)attrDetails, "com.ibm.mq.explorer.orderid.telemetry.channels", Messages.TelemetryChannels_SchemesDefault, "com.ibm.mq.explorer.telemetry.channel", allAttrs, names = new String[allAttrs.length], orderDistributed = DmTelemetryChannel.getDisplayColumnSequence((Trace)t, (int[])allAttrs, (boolean)false), orderZOS = DmTelemetryChannel.getDisplayColumnSequence((Trace)t, (int[])allAttrs, (boolean)true), nameDist, nameZOS, copyDistToZos, copyZosToDist);
        if (!result && Trace.isTracing) {
            t.data(67, "Activator.registerTelemetryChannels", 900, "Error: failed to register Attribute Order for Channels");
        }
    }

    public static void registerTelemetryChannelStatus(Trace t, AttributeOrderManager attrOrderManager) {
        int[] orderZOS;
        int[] orderDistributed;
        String[] names;
        int[] allAttrs = DmTelemetryChannelStatus.getAllAttributesByType((Trace)t);
        boolean result = attrOrderManager.register(t, (IAttributeDetails)attrDetails, "com.ibm.mq.explorer.orderid.telemetry.channel.status", Messages.TelemetryChannelStatus_SchemesDefault, "com.ibm.mq.explorer.telemetry.channel.status", allAttrs, names = new String[allAttrs.length], orderDistributed = DmTelemetryChannelStatus.getDisplayColumnSequence((Trace)t, (int[])allAttrs, (boolean)false), orderZOS = DmTelemetryChannelStatus.getDisplayColumnSequence((Trace)t, (int[])allAttrs, (boolean)true), nameDist, nameZOS, copyDistToZos, copyZosToDist);
        if (!result && Trace.isTracing) {
            t.data(67, "Activator.registerTelemetryChannelStatus", 900, "Error: failed to register Attribute Order for Channel Status");
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logException(Exception e) {
        Status status = new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public static boolean isTelemetryChannelSupported(Trace t, UiQueueManager uiQM) {
        DmQueueManager dmQmgr = uiQM.getDmQueueManagerObject();
        Boolean isSupported = Activator.isTelemetrySupported(t, dmQmgr);
        if (isSupported == null) {
            return false;
        }
        return isSupported;
    }

    public static Boolean isTelemetrySupported(Trace t, DmQueueManager dmQmgr) {
        Boolean result = null;
        int commandLevel = dmQmgr.getCommandLevel();
        result = commandLevel >= 710 ? Boolean.valueOf(Activator.isTelemetrySupportedByQmgr(t, dmQmgr)) : Boolean.valueOf(false);
        if (result == null) {
            int platform = dmQmgr.getPlatform();
            switch (platform) {
                case 3: 
                case 11: {
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        if (result == null) {
            result = Activator.getTelemetryChannelSupported(dmQmgr);
        }
        return result;
    }

    public static boolean isTelemetryCommandQueueExists(Trace t, DmQueueManager dmQM) {
        boolean exists = false;
        try {
            DmObjectFilter filter = new DmObjectFilter(t, "SYSTEM.MQXR.COMMAND.QUEUE", 13);
            ArrayList objects = dmQM.getObjects(t, filter, false);
            if (objects.size() > 0) {
                exists = true;
            }
        }
        catch (DmCoreException dmCoreException) {}
        return exists;
    }

    public static boolean isTelemetryChannelsExist(Trace t, DmQueueManager dmQM) {
        boolean exists = false;
        try {
            DmObjectFilter filter = new DmObjectFilter(t, "SYSTEM.MQXR.COMMAND.QUEUE", 1026);
            ArrayList objects = dmQM.getObjects(t, filter);
            if (objects.size() >= 0) {
                exists = true;
            }
        }
        catch (DmCoreException dmCoreException) {}
        return exists;
    }

    public static boolean isTelemetryServiceDefined(Trace t, DmQueueManager dmQM) {
        boolean exists = false;
        try {
            DmObjectFilter filter = new DmObjectFilter(t, "SYSTEM.MQXR.SERVICE", 153);
            ArrayList objects = dmQM.getObjects(t, filter);
            if (objects.size() > 0) {
                exists = true;
            }
        }
        catch (DmCoreException dmCoreException) {}
        return exists;
    }

    public static boolean isCommandForwardingCodeInstalled(Trace t, DmQueueManager dmQM) {
        boolean commandForwardingWasAttempted = false;
        PCFMessage request = new PCFMessage(22);
        request.addParameter(3007, "");
        request.addParameter(3008, "");
        request.addParameter(1511, 10);
        try {
            PCFMonitorAgent monitorAgent = dmQM.getPcfMonitorAgent(t);
            try {
                PCFMessage[] replies = monitorAgent.send(request);
                if (replies.length > 0) {
                    PCFMessage reply = replies[0];
                    int rc = reply.getReason();
                    if (Trace.isTracing) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("reply.getReason:");
                        sb.append(MQConstants.lookupReasonCode((int)rc));
                        t.data(67, "Activator.isCommandForwardingCodeInstalled", sb.toString());
                    }
                    commandForwardingWasAttempted = true;
                }
            }
            catch (PCFException e) {
                int rc = e.getReason();
                if (Trace.isTracing) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("PCFException.rc:");
                    sb.append(MQConstants.lookupReasonCode((int)rc));
                    t.data(67, "Activator.isCommandForwardingCodeInstalled", sb.toString());
                }
                switch (rc) {
                    case 2085: {
                        commandForwardingWasAttempted = true;
                        break;
                    }
                    case 3034: {
                        commandForwardingWasAttempted = false;
                    }
                }
            }
            catch (MQException e) {
                int rc = e.getReason();
                if (Trace.isTracing) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("MQException.rc:");
                    sb.append(MQConstants.lookupReasonCode((int)rc));
                    t.data(67, "Activator.isCommandForwardingCodeInstalled", sb.toString());
                }
                switch (rc) {
                    case 2051: 
                    case 2053: {
                        commandForwardingWasAttempted = true;
                        break;
                    }
                    case 2033: {
                        commandForwardingWasAttempted = true;
                    }
                }
            }
            catch (IOException e) {
                Activator.logException(e);
                t.FFST(67, "Activator.isCommandForwardingCodeInstalled", 10, 50999, 0, 0, e.getClass().getName(), e.getMessage(), null, (Throwable)e);
            }
        }
        catch (DmCoreException e) {
            Activator.logException((Exception)((Object)e));
            t.FFST(67, "Activator.isCommandForwardingCodeInstalled", 11, 50999, 0, 0, ((Object)((Object)e)).getClass().getName(), e.getMessage(), null, (Throwable)e);
        }
        if (Trace.isTracing) {
            t.data(67, "Activator.isCommandForwardingCodeInstalled", "commandForwardingWasAttempted:" + commandForwardingWasAttempted);
        }
        t.data(67, "Activator.isCommandForwardingCodeInstalled", Boolean.toString(commandForwardingWasAttempted));
        return commandForwardingWasAttempted;
    }

    public static boolean isTelemetrySupportedByQmgr(Trace t, DmQueueManager dmQM) {
        Integer value;
        boolean isTelemetrySupported = false;
        Attr at = dmQM.getAttribute(t, 243, 0);
        if (at != null && (value = (Integer)at.getValue(t)) != null && value == 1) {
            isTelemetrySupported = true;
        }
        return isTelemetrySupported;
    }

    public static Boolean getTelemetryChannelSupported(DmQueueManager dmQM) {
        String UID = dmQM.getUUID();
        return telemetryChannelSupportedTable.get(UID);
    }

    public static void setTelemetryChannelSupported(DmQueueManager dmQM, Boolean value) {
        String UID = dmQM.getUUID();
        telemetryChannelSupportedTable.put(UID, value);
    }

    public List<IChannelWizardContribution> getFinishWizardActions() {
        return this.finishWizardActionManager.getFinishWizardActions();
    }

    public static int getNextAvailablePort() {
        return Activator.getNextAvailablePort(1883);
    }

    public static int getNextAvailablePort(int startingValue) {
        Set<Integer> usedPorts = Activator.getUsedPorts();
        return Activator.getNextAvailablePort(usedPorts, startingValue);
    }

    public static int getNextAvailablePort(Set<Integer> usedPorts, int startingValue) {
        boolean used;
        int port = startingValue;
        while (used = usedPorts.contains(port)) {
            ++port;
        }
        return port;
    }

    public static Set<Integer> getUsedPorts() {
        Trace t = Trace.getDefault();
        DmObjectFilter serviceFilter = new DmObjectFilter(t, "SYSTEM.MQXR.SERVICE", 154);
        DmObjectFilter channelFilter = new DmObjectFilter(t, 1026);
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        ArrayList qmgrs = UiPlugin.getTheDataModel().getQueueManagers(t);
        int i = 0;
        while (i < qmgrs.size()) {
            DmQueueManager qmgr = (DmQueueManager)qmgrs.get(i);
            if (qmgr.isLocal() && qmgr.isConnected()) {
                try {
                    DmServiceStatus dmServiceStatus;
                    AttrInt statusAttr;
                    int statusValue;
                    ArrayList serviceStatusList = qmgr.getObjects(t, serviceFilter);
                    if (serviceStatusList.size() > 0 && (statusValue = ((Integer)(statusAttr = (AttrInt)(dmServiceStatus = (DmServiceStatus)serviceStatusList.get(0)).getAttribute(t, 1260, 0)).getValue(t)).intValue()) == 2) {
                        ArrayList channelList = qmgr.getObjects(t, channelFilter);
                        for (DmTelemetryChannel dmTelemetryChannel : channelList) {
                            AttrInt portAttr;
                            String channelName = dmTelemetryChannel.getTitle();
                            if ("SYSTEM.DEF.MQTT".equals(channelName) || (portAttr = (AttrInt)dmTelemetryChannel.getAttribute(t, 1522, 0)) == null) continue;
                            int port = (Integer)portAttr.getValue(t);
                            usedPorts.add(port);
                        }
                    }
                }
                catch (DmCoreException e) {
                    Activator.logException((Exception)((Object)e));
                    t.FFST(67, "Activator.getUsedPorts", 10, 2195, 0, 0, ((Object)((Object)e)).getClass().getName(), e.getMessage(), null);
                }
            }
            ++i;
        }
        return usedPorts;
    }
}

