/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class QueueManagerHandleList
extends DefaultHandler {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/utils/QueueManagerHandleList.java";
    public static final String QMGRHANDLES_KEY = "QueueManagerHandles";
    private transient Vector<QueueManagerHandle> queueManagerHandleList = new Vector();
    private boolean parseSuccessfull = true;
    private boolean verifyHandles = false;
    private static Integer lock = 0;

    public QueueManagerHandleList(Trace t) {
    }

    public Vector<QueueManagerHandle> getHandleList(Trace t) {
        return this.queueManagerHandleList;
    }

    public QueueManagerHandle getHandle(Trace t, int index, boolean remove) {
        t.data(65, "QueueManagerHandleList.getHandle", 300, Integer.toString(index));
        QueueManagerHandle o = this.queueManagerHandleList.elementAt(index);
        if (remove) {
            this.queueManagerHandleList.remove(index);
        }
        return o;
    }

    public boolean contains(Trace t, QueueManagerHandle obj) {
        boolean retValue = false;
        retValue = this.queueManagerHandleList.contains(obj);
        return retValue;
    }

    public boolean containsUUID(Trace t, QueueManagerHandle obj) {
        boolean retValue = false;
        for (QueueManagerHandle curHandle : this.queueManagerHandleList) {
            if (!curHandle.compareUUID(t, obj)) continue;
            retValue = true;
        }
        return retValue;
    }

    public boolean containsUniqueID(Trace t, QueueManagerHandle obj) {
        boolean retValue = false;
        for (QueueManagerHandle curHandle : this.queueManagerHandleList) {
            if (!curHandle.compareUniqueID(t, obj)) continue;
            retValue = true;
        }
        return retValue;
    }

    public int indexOf(Trace t, QueueManagerHandle obj) {
        int retValue = -1;
        retValue = this.queueManagerHandleList.indexOf(obj);
        return retValue;
    }

    public boolean addHandle(Trace t, QueueManagerHandle obj) {
        boolean addObj = false;
        int i = this.queueManagerHandleList.indexOf(obj);
        if (i == -1) {
            if (Trace.isTracing) {
                t.data(65, "QueueManagerHandleList.addHandle", 300, "Adding new handle : " + obj.toString(t));
            }
            addObj = this.queueManagerHandleList.add(obj);
            if (Trace.isTracing) {
                t.data(65, "QueueManagerHandleList.addHandle", 300, "Handle added : " + addObj);
            }
        } else if (Trace.isTracing) {
            t.data(65, "QueueManagerHandleList.addHandle", 300, "Handle already in list : " + obj.toString(t));
        }
        return addObj;
    }

    public boolean removeHandle(Trace t, int index) {
        boolean success = true;
        try {
            this.queueManagerHandleList.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            success = false;
            t.data(65, "QueueManagerHandleList.removeHandle", "index is out of bounds");
        }
        return success;
    }

    public boolean removeHandle(Trace t, QueueManagerHandle obj) {
        boolean success = this.queueManagerHandleList.remove(obj);
        return success;
    }

    public int size(Trace t) {
        int size = this.queueManagerHandleList.size();
        return size;
    }

    public void debug(Trace t) {
        System.out.println("----------------------------------------------------------------------------");
        String first = "QueueManagerHandleList: " + this.getClass().getName();
        String second = Integer.toHexString(this.hashCode());
        System.out.println(String.valueOf(first) + "@" + second);
        System.out.println("                  Size: " + this.queueManagerHandleList.size());
    }

    public void dump(Trace t) {
        System.out.println("----------------------------------------------------------------------------");
        int i = 0;
        while (i < this.queueManagerHandleList.size()) {
            QueueManagerHandle h = this.queueManagerHandleList.get(i);
            h.debug(t);
            ++i;
        }
        String first = "QueueManagerHandleList: " + this.getClass().getName();
        String second = Integer.toHexString(this.hashCode());
        System.out.println(String.valueOf(first) + "@" + second);
        System.out.println("                  Size: " + this.queueManagerHandleList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(Trace t) {
        boolean result = false;
        Integer n = lock;
        synchronized (n) {
            block21: {
                OutputStreamWriter writer = null;
                try {
                    try {
                        File file = new File(PersistQueueManagerHandles.getFileName());
                        FileOutputStream output = new FileOutputStream(file);
                        writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
                        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        writer.write(Common.LINE_SEPARATOR);
                        writer.write("<!DOCTYPE QueueManagerHandles SYSTEM \"WMQ_Handles.dtd\">");
                        writer.write(Common.LINE_SEPARATOR);
                        writer.write("<QueueManagerHandles>");
                        writer.write(Common.LINE_SEPARATOR);
                        int i = 0;
                        while (i < this.queueManagerHandleList.size()) {
                            QueueManagerHandle h = this.queueManagerHandleList.get(i);
                            if (h.getConnectionType() != 1 || !h.requiresVerify()) {
                                h.serialize(t, writer);
                            }
                            ++i;
                        }
                        writer.write("</QueueManagerHandles>");
                        writer.write(Common.LINE_SEPARATOR);
                        result = true;
                    }
                    catch (Exception e) {
                        if (Trace.isTracing) {
                            t.data(65, "QueueManagerHandleList.save", 900, e.toString());
                        }
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            break block21;
                        }
                        catch (IOException e1) {
                            if (Trace.isTracing) {
                                t.data(65, "QueueManagerHandleList.save", 900, e1.toString());
                            }
                            break block21;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block22: {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e1) {
                            if (!Trace.isTracing) break block22;
                            t.data(65, "QueueManagerHandleList.save", 900, e1.toString());
                        }
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    if (!Trace.isTracing) break block21;
                    t.data(65, "QueueManagerHandleList.save", 900, e1.toString());
                }
            }
        }
        return result;
    }

    public XMLMemento saveQMsToXML(Trace t, boolean remoteQMgrs) {
        XMLMemento rootWrite = XMLMemento.createWriteRoot((String)QMGRHANDLES_KEY);
        int i = 0;
        while (i < this.queueManagerHandleList.size()) {
            QueueManagerHandle h = this.queueManagerHandleList.get(i);
            if (h.getConnectionType() == 1 ^ remoteQMgrs) {
                h.serializeXml(t, (IMemento)rootWrite);
            }
            ++i;
        }
        return rootWrite;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        QueueManagerHandle queueManagerHandle;
        Trace t = Trace.getInstance();
        if ("QueueManagerHandle".equals(qName) && (queueManagerHandle = QueueManagerHandle.startElement(t, qName, atts)) != null) {
            queueManagerHandle.setRequiresVerify(this.verifyHandles);
            this.addHandle(t, queueManagerHandle);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.parseSuccessfull = false;
        super.error(e);
    }

    public boolean isParseSuccessfull() {
        return this.parseSuccessfull;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource is;
        block4: {
            is = null;
            if (systemId.indexOf("WMQ_Handles.dtd") != -1) {
                String dtd = this.handlesDtd();
                char[] aryDtd = dtd.toCharArray();
                CharArrayReader charReader = new CharArrayReader(aryDtd);
                is = new InputSource(charReader);
            } else {
                try {
                    is = super.resolveEntity(publicId, systemId);
                }
                catch (Throwable e) {
                    if (!Trace.isTracing) break block4;
                    Trace.data((Level)Level.WARNING, (String)"QueueManagerHandleList", (String)"resolveEntity", (String)e.toString());
                }
            }
        }
        return is;
    }

    public void invalidateHandles() {
        this.verifyHandles = true;
    }

    private String handlesDtd() {
        String dtd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!ELEMENT QueueManagerHandles (QueueManagerHandle*)>\n\n<!ELEMENT QueueManagerHandle EMPTY>\n<!ATTLIST QueueManagerHandle commandLevel CDATA #REQUIRED\n                       connnectionType CDATA #REQUIRED\n                       name CDATA #REQUIRED\n                       platform CDATA #REQUIRED\n                       uuid CDATA #REQUIRED\n                       visible (1|0) #REQUIRED\n                       refreshInterval CDATA #REQUIRED\n                       expiryInterval CDATA #REQUIRED\n                       waitInterval CDATA #REQUIRED\n                       autoReconnect (1|0) #REQUIRED\n                       connName CDATA #IMPLIED\n                       connNames CDATA #IMPLIED\n                       channel CDATA #IMPLIED\n                       commandQueue CDATA #IMPLIED\n                       viaUUID CDATA #IMPLIED\n                       viaQueueManagerName CDATA #IMPLIED\n                       viaConnectionType CDATA #IMPLIED\n                       channelDefTable CDATA #IMPLIED\n                       securityExitName CDATA #IMPLIED\n                       securityExitLocation CDATA #IMPLIED\n                       securityExitData CDATA #IMPLIED\n                       userIdState CDATA #IMPLIED\n                       useridCompatibilityMode CDATA #IMPLIED\n                       passwordMode CDATA #IMPLIED\n                       userid CDATA #IMPLIED\n                       password CDATA #IMPLIED\n                       sslCipherSuite CDATA #IMPLIED\n                       sslFipsRequired (1|0) #IMPLIED\n                       sslPeerName CDATA #IMPLIED\n                       sslResetCount CDATA #IMPLIED\n                       sslPersonalStore CDATA #IMPLIED\n                       sslPersonalStorePw CDATA #IMPLIED\n                       sslTrustedStore CDATA #IMPLIED\n                       sslTrustedStorePw CDATA #IMPLIED\n                       uniqueId CDATA #IMPLIED>";
        return dtd;
    }
}

