/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.ConnectionNameList;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.passwords.DmPasswordStoreManager;
import com.ibm.mq.explorer.core.internal.ssl.DmSSLSocketFactory;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultCredentials;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ui.IMemento;
import org.xml.sax.Attributes;

public class QueueManagerHandle {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/utils/QueueManagerHandle.java";
    private static final String JSSE_FIPS_SYSTEM_PROPERTY = "com.ibm.jsse2.usefipsprovider";
    public static final String QMHANDLE_KEY = "QueueManagerHandle";
    private static final String NAME_KEY = "name";
    private static final String CONNECTION_TYPE_KEY = "connnectionType";
    private static final String COMMAND_QUEUE_NAME_KEY = "commandQueue";
    private static final String CONN_NAME_KEY = "connName";
    private static final String CONN_NAMES_KEY = "connNames";
    private static final String CHANNEL_KEY = "channel";
    private static final String VISIBLE_KEY = "visible";
    private static final String PLATFORM_KEY = "platform";
    private static final String COMMAND_LEVEL_KEY = "commandLevel";
    private static final String UUID_KEY = "uuid";
    private static final String VIA_UUID_KEY = "viaUUID";
    private static final String VIA_QM_NAME_KEY = "viaQueueManagerName";
    private static final String VIA_CONN_TYPE_KEY = "viaConnectionType";
    private static final String CHANNEL_DEF_TABLE_KEY = "channelDefTable";
    public static final String REFRESH_INTERVAL = "refreshInterval";
    private static final String REFRESH_INTERVAL_KEY = "refreshInterval";
    private static final String EXPIRY_INTERVAL_KEY = "expiryInterval";
    private static final String WAIT_INTERVAL_KEY = "waitInterval";
    public static final String AUTO_RECONNECT = "autoReconnect";
    private static final String AUTO_RECONNECT_KEY = "autoReconnect";
    private static final String SECURITY_EXIT_NAME = "securityExitName";
    private static final String SECURITY_EXIT_LOCATION = "securityExitLocation";
    private static final String SECURITY_EXIT_DATA = "securityExitData";
    public static final String USERID_STATE = "userIdState";
    public static final String USERID_STATE_KEY = "userIdState";
    private static final String COMPATIBILITY_MODE = "useridCompatibilityMode";
    public static final String PASSWORD_MODE = "passwordMode";
    private static final String USERID = "userid";
    private static final String PASSWORD = "password";
    private static final String SSL_CIPHER_SUITE = "sslCipherSuite";
    private static final String SSL_FIPS_REQUIRE = "sslFipsRequired";
    private static final String SSL_PEER_NAME = "sslPeerName";
    private static final String CERTIFICATE_VAL_POLICY = "certvpol";
    private static final String SSL_RESET_COUNT = "sslResetCount";
    public static final String SSL_PERSONAL_STORE = "sslPersonalStore";
    public static final String SSL_PERSONAL_STORE_PW = "sslPersonalStorePw";
    public static final String SSL_TRUSTED_STORE = "sslTrustedStore";
    public static final String SSL_TRUSTED_STORE_PW = "sslTrustedStorePw";
    public static final String UNIQUE_ID = "uniqueId";
    private static int defaultRefreshInterval = 15;
    private static int defaultRemoteRefreshInterval = 300;
    private static int defaultWaitInterval = 30;
    private static int defaultExpiryInterval = 30;
    private static int defaultRemoteWaitInterval = 30;
    private static int defaultRemoteExpiryInterval = 300;
    private static int defaultUserIdState = 1;
    private static String defaultUserId = "";
    private static String defaultPassword = null;
    private static int defaultCompatMode = 1;
    public static final int PASSWORD_NO = 0;
    public static final int PASSWORD_PROMPT = 1;
    public static final int PASSWORD_STORED = 2;
    private static int defaultPasswordMode = 1;
    private int connectionType = 0;
    private String queueManagerName = "[not_defined]";
    private String commandQueueName = "[not_defined]";
    private int refreshInterval = defaultRefreshInterval;
    private int waitInterval = defaultWaitInterval;
    private int expiryInterval = defaultExpiryInterval;
    private String connName = "[not_defined]";
    private ConnectionNameList connNames = null;
    private String channel = "[not_defined]";
    private String channelDefTable = "[not_defined]";
    private int visible = 1;
    private int autoReconnect = 1;
    private int userIdState = 1;
    public static final int TYPE_SERVER = 1;
    public static final int TYPE_CLIENT = 2;
    public static final int TYPE_COMMAND_Q = 3;
    public static final int TYPE_CHANNEL_DEF_TABLE = 4;
    public static final int TYPE_CLIENT_MULTI_INSTANCE = 5;
    public static final int INVALID_PORT_NO = -1;
    public static final int INVALID_TIME_INTERVAL = -1;
    public static final int VISIBILITY_SHOW = 1;
    public static final int VISIBILITY_HIDE = 0;
    public static final int AUTO_RECONNECT_ON = 1;
    public static final int AUTO_RECONNECT_OFF = 0;
    public static final int USER_ID_ENABLED = 1;
    public static final int USER_ID_DISABLED = 0;
    public static final int COMPATIBILITY_MODE_ENABLED = 1;
    public static final int COMPATIBILITY_MODE_DISABLED = 0;
    public static final int FIPS_REQUIRE_YES = 1;
    public static final int FIPS_REQUIRE_NO = 0;
    private int platform = 0;
    private int commandLevel = 0;
    private String uuid = "[not_defined]";
    private String viaUUID = "[not_defined]";
    private String viaQueueManagerName = "[not_defined]";
    private int viaConnectionType = 0;
    private String securityExitName = "";
    private String securityExitLocation = "";
    private String securityExitData = "";
    private int compatMode = 1;
    private int passwordMode = 1;
    private String userid = "";
    private String password = null;
    private String sslCipherSuite = "";
    private int sslFipsRequired = 0;
    private String sslPeerName = "";
    private int certvpol = -1;
    private int sslResetCount = 0;
    private String sslPersonalStore = "";
    private String sslPersonalStorePassword = "";
    private String sslTrustedStore = "";
    private String sslTrustedStorePassword = "";
    private String tempSSLTrustedStorePassword = "";
    private String tempSSLPersonalStorePassword = "";
    private String tempPassword = null;
    private String uniqueId = "";
    private boolean requiresVerify = false;

    public QueueManagerHandle(Trace t, String QMName) {
        this(t, QMName, true);
    }

    public QueueManagerHandle(Trace t, String QMName, boolean applyDefaultSecurity) {
        this.connectionType = 1;
        this.queueManagerName = QMName;
        this.refreshInterval = defaultRefreshInterval;
        this.expiryInterval = defaultExpiryInterval;
        this.waitInterval = defaultWaitInterval;
        this.setUniqueId(t);
        if (applyDefaultSecurity) {
            this.setDefaultUserIdOptions(t);
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.QueueManagerHandle", 300, "Creating " + this.toString(t));
        }
    }

    public QueueManagerHandle(Trace t, String qmName, String cName, String chl, Hashtable<String, Object> secOptions) {
        this.connectionType = 2;
        this.queueManagerName = qmName;
        this.connName = cName;
        this.channel = chl;
        this.refreshInterval = defaultRemoteRefreshInterval;
        this.expiryInterval = defaultRemoteExpiryInterval;
        this.waitInterval = defaultRemoteWaitInterval;
        this.setUniqueId(t);
        if (secOptions != null) {
            this.setSecurityOptions(t, secOptions);
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.QueueManagerHandle", 300, "Creating " + this.toString(t));
        }
    }

    public QueueManagerHandle(Trace t, String qmName, String[] cName, String chl, Hashtable<String, Object> secOptions) {
        this.connectionType = 5;
        this.queueManagerName = qmName;
        this.channel = chl;
        this.connNames = new ConnectionNameList(t, cName);
        this.connName = this.connNames.get(0).toString();
        this.refreshInterval = defaultRemoteRefreshInterval;
        this.expiryInterval = defaultRemoteExpiryInterval;
        this.waitInterval = defaultRemoteWaitInterval;
        this.setUniqueId(t);
        if (secOptions != null) {
            this.setSecurityOptions(t, secOptions);
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.QueueManagerHandle", 300, "Creating " + this.toString(t));
        }
    }

    public QueueManagerHandle(Trace t, DmQueueManager via, String cmdQ, String QMName) {
        this.connectionType = 3;
        this.queueManagerName = QMName;
        this.commandQueueName = cmdQ;
        this.viaUUID = via.getUUID();
        this.viaQueueManagerName = via.getTitle();
        this.viaConnectionType = via.getConnectionHandle().getQueueManagerHandle(t).getConnectionType();
        this.refreshInterval = defaultRemoteRefreshInterval;
        this.expiryInterval = defaultRemoteExpiryInterval;
        this.waitInterval = defaultRemoteWaitInterval;
        this.setUniqueId(t);
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.QueueManagerHandle", 300, "Creating " + this.toString(t));
        }
    }

    public QueueManagerHandle(Trace t, String QMName, URL chanDefTable, Hashtable<String, Object> secOptions) {
        this.connectionType = 4;
        this.queueManagerName = QMName;
        this.channelDefTable = chanDefTable.toString();
        this.refreshInterval = defaultRemoteRefreshInterval;
        this.expiryInterval = defaultRemoteExpiryInterval;
        this.waitInterval = defaultRemoteWaitInterval;
        this.setUniqueId(t);
        if (secOptions != null) {
            this.setSecurityOptions(t, secOptions);
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.QueueManagerHandle", 300, "Creating " + this.toString(t));
        }
    }

    public void setRefreshInterval(Trace t, int value) {
        this.refreshInterval = value == 0 ? 15 : value;
    }

    public void setWaitInterval(Trace t, int value) {
        this.waitInterval = value == 0 ? 30 : value;
    }

    public void setExpiryInterval(Trace t, int value) {
        this.expiryInterval = value == 0 ? 30 : value;
    }

    public void setAutoConnect(Trace t, int value) {
        this.autoReconnect = value;
    }

    public void setAutoConnect(Trace t, boolean value) {
        this.autoReconnect = value ? 1 : 0;
    }

    public static void setDefaultUseridState(int value) {
        defaultUserIdState = value;
    }

    public void setUserIdState(Trace t, int value) {
        this.userIdState = value;
    }

    public void setVisible(Trace t, int i) {
        this.visible = i;
    }

    public boolean equals(Object obj) {
        Trace t;
        QueueManagerHandle qmh;
        boolean retValue;
        block16: {
            retValue = false;
            qmh = null;
            t = Trace.getInstance();
            if (obj == this) {
                if (Trace.isTracing) {
                    t.data(65, "QueueManagerHandle.equals", 300, "Comparing the same object\n" + this.toString(t));
                }
                return true;
            }
            if (!(obj instanceof QueueManagerHandle)) {
                if (Trace.isTracing) {
                    t.data(65, "QueueManagerHandle.equals", 900, "Not comparing same object types");
                }
                return false;
            }
            try {
                qmh = (QueueManagerHandle)obj;
                switch (this.connectionType) {
                    case 5: {
                        if (this.connectionType == qmh.getConnectionType() && this.queueManagerName.equals(qmh.getQueueManagerName()) && this.connNames.equals((Object)qmh.getConnNames())) {
                            retValue = true;
                        }
                        break;
                    }
                    default: {
                        if (this.connectionType == qmh.getConnectionType() && this.queueManagerName.equals(qmh.getQueueManagerName()) && this.uniqueId.equals(qmh.getUniqueId(t))) {
                            retValue = true;
                        }
                        break;
                    }
                }
            }
            catch (NullPointerException npe) {
                if (!Trace.isTracing) break block16;
                t.data(65, "QueueManagerHandle.equals", 900, "Property error : " + npe.getMessage());
            }
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "QueueManagerHandle.equals", 300, "Objects are equal\n" + this.toString(t));
            } else if (qmh != null) {
                t.data(65, "QueueManagerHandle.equals", 300, "Objects are not equal\n" + this.toString(t) + "\n" + qmh.toString(t));
            } else {
                t.data(65, "QueueManagerHandle.equals", 300, "Objects are not equal\n" + this.toString(t) + "\n" + "null");
            }
        }
        return retValue;
    }

    public String getConnectionName() {
        return this.connName;
    }

    public String[] getConnectionNames() {
        String[] s = new String[1];
        if (this.connNames != null) {
            s = new String[this.connNames.size()];
            int i = 0;
            while (i < this.connNames.size()) {
                s[i] = this.connNames.get(i).toString();
                ++i;
            }
        } else {
            s[0] = this.connName;
        }
        return s;
    }

    public void setConnectionNames(Trace t, ArrayList<String> n) {
        this.connNames = new ConnectionNameList(t, n);
    }

    public void setConnectionNames(Trace t, String n) {
        this.connNames = new ConnectionNameList(t, n);
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String getQueueManagerName() {
        return this.queueManagerName;
    }

    public void resetQueueManagerName(String s) {
        this.queueManagerName = s;
    }

    public String getCommandQueueName() {
        return this.commandQueueName;
    }

    public void setCommandQueueName(String n) {
        this.commandQueueName = n;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getWaitInterval() {
        return this.waitInterval;
    }

    public int getExpiryInterval() {
        return this.expiryInterval;
    }

    public int getAutoReconnect() {
        return this.autoReconnect;
    }

    public int getUserIdState() {
        return this.userIdState;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String n) {
        this.channel = n;
    }

    public int getVisible() {
        return this.visible;
    }

    public int getPlatform() {
        return this.platform;
    }

    public int getCommandLevel() {
        return this.commandLevel;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getViaUUID() {
        return this.viaUUID;
    }

    public int getViaConnectionType() {
        return this.viaConnectionType;
    }

    public void setViaConnectionType(int i) {
        this.viaConnectionType = i;
    }

    public String getViaQueueManagerName() {
        return this.viaQueueManagerName;
    }

    public void setViaQueueManagerName(String s) {
        this.viaQueueManagerName = s;
    }

    public String getChannelDefTable() {
        return this.channelDefTable;
    }

    public void setChannelDefTable(String fn) {
        this.channelDefTable = fn;
    }

    public void setPlatform(int i) {
        this.platform = i;
    }

    public void setCommandLevel(int i) {
        this.commandLevel = i;
    }

    public void setUuid(String s) {
        this.uuid = s;
    }

    public void setViaUUID(String s) {
        this.viaUUID = s;
    }

    public void setSecurityExitName(String s) {
        this.securityExitName = s;
    }

    public void setSecurityExitLocation(String s) {
        this.securityExitLocation = s;
    }

    public void setSecurityExitData(String s) {
        this.securityExitData = s;
    }

    public static void setDefaultCompatMode(int v) {
        defaultCompatMode = v;
    }

    public static void setDefaultPasswordMode(int v) {
        defaultPasswordMode = v;
    }

    public void setCompatMode(int value) {
        this.compatMode = value;
    }

    public void setPasswordMode(int value) {
        this.passwordMode = value;
    }

    public static void setDefaultUserid(String s) {
        defaultUserId = s;
    }

    public void setUserid(String s) {
        this.userid = s;
    }

    public static void setDefaultPassword(String s) {
        defaultPassword = s;
    }

    public void setPassword(String s) {
        this.password = s;
        this.tempPassword = s;
    }

    public void setSSLCipherSuite(String s) {
        this.sslCipherSuite = s;
    }

    public void setSSLFIPSRequired(int i) {
        this.sslFipsRequired = i;
    }

    public void setSSLPeerName(String s) {
        this.sslPeerName = s;
    }

    public void setCertValPolicy(int i) {
        this.certvpol = i;
    }

    public void setSSLPersonalStore(String s) {
        this.sslPersonalStore = s;
    }

    public void setSSLPersonalStorePassword(String s) {
        this.sslPersonalStorePassword = s;
        this.tempSSLPersonalStorePassword = s;
    }

    public void setSSLTrustedStore(String s) {
        this.sslTrustedStore = s;
    }

    public void setSSLTrustedStorePassword(String s) {
        this.sslTrustedStorePassword = s;
        this.tempSSLTrustedStorePassword = s;
    }

    public void setSSLResetCount(int i) {
        this.sslResetCount = i;
    }

    public String getSecurityExitName() {
        return this.securityExitName;
    }

    public String getSecurityExitLocation() {
        return this.securityExitLocation;
    }

    public String getSecurityExitData() {
        return this.securityExitData;
    }

    public int getCompatMode() {
        return this.compatMode;
    }

    public int getPasswordMode() {
        return this.passwordMode;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSSLCipherSuite() {
        return this.sslCipherSuite;
    }

    public int getSSLFIPSRequired() {
        return this.sslFipsRequired;
    }

    public String getSSLPeerName() {
        return this.sslPeerName;
    }

    public int getCertValPol() {
        return this.certvpol;
    }

    public int getSSLResetCount() {
        return this.sslResetCount;
    }

    public String getSSLPersonalStore() {
        return this.sslPersonalStore;
    }

    public String getSSLPersonalStorePassword() {
        return this.sslPersonalStorePassword;
    }

    public String getSSLTrustedStore() {
        return this.sslTrustedStore;
    }

    public String getSSLTrustedStorePassword() {
        return this.sslTrustedStorePassword;
    }

    public String getHostName(Trace t) {
        String retValue = "";
        int i = this.connName.indexOf("(");
        if (i < 0) {
            if (Trace.isTracing) {
                t.data(65, "QueueManagerHandle.getHostName", 300, "Host name : " + this.connName.trim());
            }
            return this.connName.trim();
        }
        retValue = this.connName.substring(0, i).trim();
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.getHostName", 300, "Host name : " + retValue);
        }
        return retValue;
    }

    public int getPortAddress(Trace t) {
        int retValue;
        block5: {
            retValue = 1414;
            int i = this.connName.lastIndexOf(")");
            if (i < 0) {
                if (Trace.isTracing) {
                    t.data(65, "QueueManagerHandle.getPortAddress", 300, "Using default port address");
                }
                return retValue;
            }
            int j = this.connName.indexOf("(");
            String temp = this.connName.substring(j + 1, i);
            try {
                retValue = Integer.parseInt(temp);
            }
            catch (NumberFormatException numberFormatException) {
                if (!Trace.isTracing) break block5;
                t.data(65, "QueueManagerHandle.getPortAddress", 900, "Invalid port address in " + this.connName);
            }
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.getPortAddress", 300, "Port address : " + retValue);
        }
        return retValue;
    }

    protected String toString(Trace t) {
        String retValue = null;
        switch (this.connectionType) {
            case 2: 
            case 5: {
                retValue = "QueueManagerHandle name : " + this.queueManagerName + ", at " + this.connName + ", using channel " + this.channel;
                break;
            }
            case 3: {
                retValue = "QueueManagerHandle name : " + this.queueManagerName + ", using " + this.commandQueueName + ", via " + this.viaQueueManagerName + ", conntype" + this.viaConnectionType;
                break;
            }
            case 4: {
                retValue = "QueueManagerHandle name : " + this.queueManagerName + ", using table " + this.channelDefTable;
                break;
            }
            case 1: {
                retValue = "QueueManagerHandle name : " + this.queueManagerName;
                break;
            }
            default: {
                retValue = "Unknown QueueManagerHandle type : " + this.connectionType;
            }
        }
        return retValue;
    }

    public void debug(Trace t) {
        System.out.println("----------------------------------------------------------------------------");
        System.out.println("QueueManagerHandle: " + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
        System.out.println("      QueueManager: " + this.queueManagerName);
        System.out.println("          connType: " + this.connectionType);
        System.out.println("          connName: " + this.connName);
        System.out.println("      commandQueue: " + this.commandQueueName);
        System.out.println("   refreshInterval: " + this.refreshInterval);
        System.out.println("    expiryInterval: " + this.expiryInterval);
        System.out.println("      waitInterval: " + this.waitInterval);
        System.out.println("           channel: " + this.channel);
        System.out.println("           visible: " + this.visible);
        System.out.println("          platform: " + this.platform);
        System.out.println("              uuid: " + this.uuid);
        System.out.println("          via uuid: " + this.viaUUID);
        System.out.println("       via QM name: " + this.viaQueueManagerName);
        System.out.println("  via QM conn type: " + this.viaConnectionType);
        System.out.println("     autoReconnect: " + this.autoReconnect);
        System.out.println("      chanDefTable: " + this.channelDefTable);
        System.out.println("     security exit: " + this.securityExitName);
        System.out.println(" security exit loc: " + this.securityExitLocation);
        System.out.println("     security data: " + this.securityExitData);
        System.out.println("       userIdState: " + this.userIdState);
        System.out.println("        compatMode: " + this.compatMode);
        System.out.println("      passwordMode: " + this.passwordMode);
        System.out.println("            userid: " + this.userid);
        System.out.println("          password: " + this.password);
        System.out.println("      cipher suite: " + this.sslCipherSuite);
        System.out.println("     FIPS required: " + this.sslFipsRequired);
        System.out.println("         peer name: " + this.sslPeerName);
        System.out.println("       reset count: " + this.sslResetCount);
        System.out.println("    ssl pers store: " + this.sslPersonalStore);
        System.out.println(" ssl trusted store: " + this.sslTrustedStore);
        System.out.println("         unique id: " + this.uniqueId);
        System.out.println("certificate val po: " + this.certvpol);
    }

    public void serialize(Trace t, Writer writer) throws Exception {
        writer.write("<QueueManagerHandle");
        this.writeKeyValue(writer, COMMAND_LEVEL_KEY, String.valueOf(this.commandLevel));
        this.writeKeyValue(writer, CONNECTION_TYPE_KEY, String.valueOf(this.connectionType));
        this.writeKeyValue(writer, NAME_KEY, this.queueManagerName);
        this.writeKeyValue(writer, PLATFORM_KEY, String.valueOf(this.platform));
        this.writeKeyValue(writer, UUID_KEY, this.uuid);
        this.writeKeyValue(writer, VISIBLE_KEY, String.valueOf(this.visible));
        this.writeKeyValue(writer, "refreshInterval", String.valueOf(this.refreshInterval));
        this.writeKeyValue(writer, "autoReconnect", String.valueOf(this.autoReconnect));
        this.writeKeyValue(writer, "userIdState", String.valueOf(this.userIdState));
        this.writeKeyValue(writer, EXPIRY_INTERVAL_KEY, String.valueOf(this.expiryInterval));
        this.writeKeyValue(writer, WAIT_INTERVAL_KEY, String.valueOf(this.waitInterval));
        if (QueueManagerHandle.addAttribute(t, this, 11002)) {
            this.writeKeyValue(writer, CONN_NAME_KEY, this.connName);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11029)) {
            this.writeKeyValue(writer, CONN_NAMES_KEY, this.connNames.toString());
        }
        if (QueueManagerHandle.addAttribute(t, this, 11013)) {
            this.writeKeyValue(writer, COMMAND_QUEUE_NAME_KEY, this.commandQueueName);
            this.writeKeyValue(writer, VIA_UUID_KEY, this.viaUUID);
            this.writeKeyValue(writer, VIA_QM_NAME_KEY, this.viaQueueManagerName);
            this.writeKeyValue(writer, VIA_CONN_TYPE_KEY, String.valueOf(this.viaConnectionType));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11003)) {
            this.writeKeyValue(writer, CHANNEL_KEY, this.channel);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11010)) {
            this.writeKeyValue(writer, CHANNEL_DEF_TABLE_KEY, this.channelDefTable);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11016)) {
            this.writeKeyValue(writer, SECURITY_EXIT_NAME, this.securityExitName);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11024)) {
            this.writeKeyValue(writer, SECURITY_EXIT_LOCATION, this.securityExitLocation);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11017)) {
            this.writeKeyValue(writer, SECURITY_EXIT_DATA, this.securityExitData);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11033)) {
            this.writeKeyValue(writer, COMPATIBILITY_MODE, String.valueOf(this.compatMode));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11034)) {
            this.writeKeyValue(writer, PASSWORD_MODE, String.valueOf(this.passwordMode));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11018)) {
            this.writeKeyValue(writer, USERID, this.userid);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11019) && this.password != null) {
            if (!this.password.equals("")) {
                this.writeKeyValue(writer, PASSWORD, "********");
            } else {
                this.writeKeyValue(writer, PASSWORD, this.password);
            }
        }
        if (QueueManagerHandle.addAttribute(t, this, 11020)) {
            this.writeKeyValue(writer, SSL_CIPHER_SUITE, this.sslCipherSuite);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11021)) {
            this.writeKeyValue(writer, SSL_FIPS_REQUIRE, String.valueOf(this.sslFipsRequired));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11023)) {
            this.writeKeyValue(writer, SSL_PEER_NAME, this.sslPeerName);
        }
        if (QueueManagerHandle.addAttribute(t, this, 13086)) {
            this.writeKeyValue(writer, CERTIFICATE_VAL_POLICY, String.valueOf(this.certvpol));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11020)) {
            this.writeKeyValue(writer, SSL_RESET_COUNT, String.valueOf(this.sslResetCount));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11025)) {
            this.writeKeyValue(writer, SSL_PERSONAL_STORE, this.sslPersonalStore);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11026)) {
            if (!this.sslPersonalStorePassword.equals("")) {
                this.writeKeyValue(writer, SSL_PERSONAL_STORE_PW, "********");
            } else {
                this.writeKeyValue(writer, SSL_PERSONAL_STORE_PW, this.sslPersonalStorePassword);
            }
        }
        if (QueueManagerHandle.addAttribute(t, this, 11027)) {
            this.writeKeyValue(writer, SSL_TRUSTED_STORE, this.sslTrustedStore);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11028)) {
            if (this.sslTrustedStorePassword != "") {
                this.writeKeyValue(writer, SSL_TRUSTED_STORE_PW, "********");
            } else {
                this.writeKeyValue(writer, SSL_TRUSTED_STORE_PW, this.sslTrustedStorePassword);
            }
        }
        if (this.uniqueId == null || this.uniqueId.equals("")) {
            this.setUniqueId(t);
        }
        this.writeKeyValue(writer, UNIQUE_ID, this.uniqueId);
        writer.write("/>");
        writer.write(Common.LINE_SEPARATOR);
    }

    public void serializeXml(Trace t, IMemento rootWrite) {
        IMemento qmHandle = rootWrite.createChild(QMHANDLE_KEY);
        qmHandle.putString(COMMAND_LEVEL_KEY, String.valueOf(this.commandLevel));
        qmHandle.putString(CONNECTION_TYPE_KEY, String.valueOf(this.connectionType));
        qmHandle.putString(NAME_KEY, this.queueManagerName);
        qmHandle.putString(PLATFORM_KEY, String.valueOf(this.platform));
        qmHandle.putString(UUID_KEY, this.uuid);
        qmHandle.putString(VISIBLE_KEY, String.valueOf(this.visible));
        qmHandle.putString("refreshInterval", String.valueOf(this.refreshInterval));
        qmHandle.putString("autoReconnect", String.valueOf(this.autoReconnect));
        qmHandle.putString("userIdState", String.valueOf(this.userIdState));
        qmHandle.putString(EXPIRY_INTERVAL_KEY, String.valueOf(this.expiryInterval));
        qmHandle.putString(WAIT_INTERVAL_KEY, String.valueOf(this.waitInterval));
        if (QueueManagerHandle.addAttribute(t, this, 11002)) {
            qmHandle.putString(CONN_NAME_KEY, this.connName);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11029)) {
            qmHandle.putString(CONN_NAMES_KEY, this.connNames.toString());
        }
        if (QueueManagerHandle.addAttribute(t, this, 11013)) {
            qmHandle.putString(COMMAND_QUEUE_NAME_KEY, this.commandQueueName);
            qmHandle.putString(VIA_UUID_KEY, this.viaUUID);
            qmHandle.putString(VIA_QM_NAME_KEY, this.viaQueueManagerName);
            qmHandle.putString(VIA_CONN_TYPE_KEY, String.valueOf(this.viaConnectionType));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11003)) {
            qmHandle.putString(CHANNEL_KEY, this.channel);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11010)) {
            qmHandle.putString(CHANNEL_DEF_TABLE_KEY, this.channelDefTable);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11016)) {
            qmHandle.putString(SECURITY_EXIT_NAME, this.securityExitName);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11024)) {
            qmHandle.putString(SECURITY_EXIT_LOCATION, this.securityExitLocation);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11017)) {
            qmHandle.putString(SECURITY_EXIT_DATA, this.securityExitData);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11033)) {
            qmHandle.putString(COMPATIBILITY_MODE, String.valueOf(this.compatMode));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11034)) {
            qmHandle.putString(PASSWORD_MODE, String.valueOf(this.passwordMode));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11018)) {
            qmHandle.putString(USERID, this.userid);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11019) && this.password != null) {
            if (!this.password.equals("")) {
                qmHandle.putString(PASSWORD, "********");
            } else {
                qmHandle.putString(PASSWORD, this.password);
            }
        }
        if (QueueManagerHandle.addAttribute(t, this, 11020)) {
            qmHandle.putString(SSL_CIPHER_SUITE, this.sslCipherSuite);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11021)) {
            qmHandle.putString(SSL_FIPS_REQUIRE, String.valueOf(this.sslFipsRequired));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11023)) {
            qmHandle.putString(SSL_PEER_NAME, this.sslPeerName);
        }
        if (QueueManagerHandle.addAttribute(t, this, 13086)) {
            qmHandle.putString(CERTIFICATE_VAL_POLICY, String.valueOf(this.certvpol));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11020)) {
            qmHandle.putString(SSL_RESET_COUNT, String.valueOf(this.sslResetCount));
        }
        if (QueueManagerHandle.addAttribute(t, this, 11025)) {
            qmHandle.putString(SSL_PERSONAL_STORE, this.sslPersonalStore);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11026)) {
            if (!this.sslPersonalStorePassword.equals("")) {
                qmHandle.putString(SSL_PERSONAL_STORE_PW, "********");
            } else {
                qmHandle.putString(SSL_PERSONAL_STORE_PW, this.sslPersonalStorePassword);
            }
        }
        if (QueueManagerHandle.addAttribute(t, this, 11027)) {
            qmHandle.putString(SSL_TRUSTED_STORE, this.sslTrustedStore);
        }
        if (QueueManagerHandle.addAttribute(t, this, 11028)) {
            if (this.sslTrustedStorePassword != "") {
                qmHandle.putString(SSL_TRUSTED_STORE_PW, "********");
            } else {
                qmHandle.putString(SSL_TRUSTED_STORE_PW, this.sslTrustedStorePassword);
            }
        }
        if (this.uniqueId == null || this.uniqueId.equals("")) {
            this.setUniqueId(t);
        }
        qmHandle.putString(UNIQUE_ID, this.uniqueId);
    }

    private void writeKeyValue(Writer writer, String key, Object object) throws Exception {
        if (object != null) {
            String value = object.toString();
            writer.write(" " + key + "=\"" + value + "\"");
        }
    }

    public static QueueManagerHandle startElement(Trace t, String qName, Attributes atts) {
        QueueManagerHandle queueManagerHandle = null;
        String strConnType = null;
        String strVisible = null;
        String strPlatform = null;
        String strCommandLevel = null;
        String strChannelDefTable = null;
        String strUuid = null;
        String strChannel = null;
        String strName = null;
        String strCommandQueue = null;
        String strConnName = "[not_defined]";
        String strConnNames = null;
        String strRefreshInterval = null;
        String strExpiryInterval = null;
        String strWaitInterval = null;
        String strAutoReconnect = null;
        String strViaUUID = null;
        String strViaQMName = null;
        String strViaConnType = null;
        String strSecurityExitName = null;
        String strSecurityExitData = null;
        String strUserIdState = null;
        String strCompatMode = null;
        String strPasswordMode = null;
        String strUserid = null;
        String strPassword = null;
        String strSSLCipherSuite = null;
        String strSSLFIPSRequired = null;
        String strSSLPeerName = null;
        String strSSLCertVPol = null;
        String strSSLResetCount = null;
        String strSecurityExitLocation = null;
        String strSSLPersonalStore = null;
        String strSSLPersonalStorePw = null;
        String strSSLTrustedStore = null;
        String strSSLTrustedStorePw = null;
        String strUniqueId = null;
        int i = 0;
        while (i < atts.getLength()) {
            String key = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (NAME_KEY.equals(key)) {
                strName = value;
            } else if (CHANNEL_KEY.equals(key)) {
                strChannel = value;
            } else if (COMMAND_LEVEL_KEY.equals(key)) {
                strCommandLevel = value;
            } else if (COMMAND_QUEUE_NAME_KEY.equals(key)) {
                strCommandQueue = value;
            } else if (CONN_NAME_KEY.equals(key)) {
                strConnName = value;
            } else if (CONN_NAMES_KEY.equals(key)) {
                strConnNames = value;
            } else if (CONNECTION_TYPE_KEY.equals(key)) {
                strConnType = value;
            } else if (PLATFORM_KEY.equals(key)) {
                strPlatform = value;
            } else if (UUID_KEY.equals(key)) {
                strUuid = value;
            } else if (VIA_UUID_KEY.equals(key)) {
                strViaUUID = value;
            } else if (VIA_QM_NAME_KEY.equals(key)) {
                strViaQMName = value;
            } else if (VIA_CONN_TYPE_KEY.equals(key)) {
                strViaConnType = value;
            } else if (VISIBLE_KEY.equals(key)) {
                strVisible = value;
            } else if ("refreshInterval".equals(key)) {
                strRefreshInterval = value;
            } else if (EXPIRY_INTERVAL_KEY.equals(key)) {
                strExpiryInterval = value;
            } else if (WAIT_INTERVAL_KEY.equals(key)) {
                strWaitInterval = value;
            } else if ("autoReconnect".equals(key)) {
                strAutoReconnect = value;
            } else if ("userIdState".equals(key)) {
                strUserIdState = value;
            } else if (CHANNEL_DEF_TABLE_KEY.equals(key)) {
                strChannelDefTable = value;
            } else if (SECURITY_EXIT_NAME.equals(key)) {
                strSecurityExitName = value;
            } else if (SECURITY_EXIT_LOCATION.equals(key)) {
                strSecurityExitLocation = value;
            } else if (SECURITY_EXIT_DATA.equals(key)) {
                strSecurityExitData = value;
            } else if (COMPATIBILITY_MODE.equals(key)) {
                strCompatMode = value;
            } else if (PASSWORD_MODE.equals(key)) {
                strPasswordMode = value;
            } else if (USERID.equals(key)) {
                strUserid = value;
            } else if (PASSWORD.equals(key)) {
                strPassword = value;
            } else if (SSL_CIPHER_SUITE.equals(key)) {
                strSSLCipherSuite = value;
            } else if (SSL_FIPS_REQUIRE.equals(key)) {
                strSSLFIPSRequired = value;
            } else if (SSL_PEER_NAME.equals(key)) {
                strSSLPeerName = value;
            } else if (CERTIFICATE_VAL_POLICY.equals(key)) {
                strSSLCertVPol = value;
            } else if (SSL_RESET_COUNT.equals(key)) {
                strSSLResetCount = value;
            } else if (SSL_PERSONAL_STORE.equals(key)) {
                strSSLPersonalStore = value;
            } else if (SSL_PERSONAL_STORE_PW.equals(key)) {
                strSSLPersonalStorePw = value;
            } else if (SSL_TRUSTED_STORE.equals(key)) {
                strSSLTrustedStore = value;
            } else if (SSL_TRUSTED_STORE_PW.equals(key)) {
                strSSLTrustedStorePw = value;
            } else if (UNIQUE_ID.equals(key)) {
                strUniqueId = value;
            }
            ++i;
        }
        queueManagerHandle = new QueueManagerHandle(t, strName, false);
        queueManagerHandle.connectionType = Integer.parseInt(strConnType);
        queueManagerHandle.commandQueueName = strCommandQueue;
        queueManagerHandle.connName = strConnName;
        queueManagerHandle.channel = strChannel;
        queueManagerHandle.visible = Integer.parseInt(strVisible);
        queueManagerHandle.platform = Integer.parseInt(strPlatform);
        queueManagerHandle.commandLevel = Integer.parseInt(strCommandLevel);
        queueManagerHandle.uuid = strUuid;
        queueManagerHandle.refreshInterval = Integer.parseInt(strRefreshInterval);
        queueManagerHandle.expiryInterval = Integer.parseInt(strExpiryInterval);
        queueManagerHandle.waitInterval = Integer.parseInt(strWaitInterval);
        queueManagerHandle.autoReconnect = Integer.parseInt(strAutoReconnect);
        queueManagerHandle.channelDefTable = strChannelDefTable;
        queueManagerHandle.viaUUID = strViaUUID;
        queueManagerHandle.viaQueueManagerName = strViaQMName;
        queueManagerHandle.uniqueId = strUniqueId;
        if (queueManagerHandle.uniqueId == null) {
            queueManagerHandle.uniqueId = strName;
        }
        if (strViaConnType != null) {
            queueManagerHandle.viaConnectionType = Integer.parseInt(strViaConnType);
        }
        if (strSecurityExitName != null) {
            queueManagerHandle.securityExitName = strSecurityExitName;
        }
        if (strSecurityExitLocation != null) {
            queueManagerHandle.securityExitLocation = strSecurityExitLocation;
        }
        if (strSecurityExitData != null) {
            queueManagerHandle.securityExitData = strSecurityExitData;
        }
        if (strUserIdState != null) {
            queueManagerHandle.userIdState = Integer.parseInt(strUserIdState);
        } else {
            queueManagerHandle.userIdState = 0;
            if (strUserid != null && strUserid != "") {
                queueManagerHandle.userIdState = 1;
            }
        }
        if (strCompatMode != null) {
            queueManagerHandle.compatMode = Integer.parseInt(strCompatMode);
        }
        if (strPasswordMode != null) {
            queueManagerHandle.passwordMode = Integer.parseInt(strPasswordMode);
        } else {
            queueManagerHandle.passwordMode = 0;
            if (strUserid != null && strUserid != "" && strPassword != null && strPassword != "") {
                queueManagerHandle.passwordMode = 2;
            }
        }
        if (strUserid != null) {
            queueManagerHandle.userid = strUserid;
        }
        if (strPassword != null) {
            queueManagerHandle.password = strPassword;
        }
        if (strSSLCipherSuite != null) {
            queueManagerHandle.sslCipherSuite = strSSLCipherSuite;
        }
        if (strSSLFIPSRequired != null) {
            queueManagerHandle.sslFipsRequired = Integer.parseInt(strSSLFIPSRequired);
        }
        if (strSSLPeerName != null) {
            queueManagerHandle.sslPeerName = strSSLPeerName;
        }
        if (strSSLCertVPol != null) {
            queueManagerHandle.certvpol = Integer.parseInt(strSSLCertVPol);
        }
        if (strSSLResetCount != null) {
            queueManagerHandle.sslResetCount = Integer.parseInt(strSSLResetCount);
        }
        if (strSSLPersonalStore != null) {
            queueManagerHandle.sslPersonalStore = strSSLPersonalStore;
        }
        if (strSSLPersonalStorePw != null) {
            queueManagerHandle.sslPersonalStorePassword = strSSLPersonalStorePw;
            queueManagerHandle.tempSSLPersonalStorePassword = strSSLPersonalStorePw;
        }
        if (strSSLTrustedStore != null) {
            queueManagerHandle.sslTrustedStore = strSSLTrustedStore;
        }
        if (strSSLTrustedStorePw != null) {
            queueManagerHandle.sslTrustedStorePassword = strSSLTrustedStorePw;
            queueManagerHandle.tempSSLTrustedStorePassword = strSSLTrustedStorePw;
        }
        if (strConnNames != null) {
            queueManagerHandle.setConnectionNames(t, strConnNames);
        }
        return queueManagerHandle;
    }

    public static QueueManagerHandle createFromMemento(Trace t, IMemento qmHandleMemento) {
        return QueueManagerHandle.createFromMemento(t, qmHandleMemento, null);
    }

    public static QueueManagerHandle createFromMemento(Trace t, IMemento qmHandleMemento, Integer currentFipsMode) {
        String userID;
        String strName = qmHandleMemento.getString(NAME_KEY);
        QueueManagerHandle queueManagerHandle = new QueueManagerHandle(t, strName, false);
        queueManagerHandle.connectionType = qmHandleMemento.getInteger(CONNECTION_TYPE_KEY);
        queueManagerHandle.commandQueueName = qmHandleMemento.getString(COMMAND_QUEUE_NAME_KEY);
        queueManagerHandle.connName = qmHandleMemento.getString(CONN_NAME_KEY);
        queueManagerHandle.channel = qmHandleMemento.getString(CHANNEL_KEY);
        queueManagerHandle.visible = qmHandleMemento.getInteger(VISIBLE_KEY);
        queueManagerHandle.platform = qmHandleMemento.getInteger(PLATFORM_KEY);
        queueManagerHandle.commandLevel = qmHandleMemento.getInteger(COMMAND_LEVEL_KEY);
        queueManagerHandle.uuid = qmHandleMemento.getString(UUID_KEY);
        queueManagerHandle.refreshInterval = qmHandleMemento.getInteger("refreshInterval");
        queueManagerHandle.expiryInterval = qmHandleMemento.getInteger(EXPIRY_INTERVAL_KEY);
        queueManagerHandle.waitInterval = qmHandleMemento.getInteger(WAIT_INTERVAL_KEY);
        queueManagerHandle.autoReconnect = qmHandleMemento.getInteger("autoReconnect");
        queueManagerHandle.channelDefTable = qmHandleMemento.getString(CHANNEL_DEF_TABLE_KEY);
        queueManagerHandle.viaUUID = qmHandleMemento.getString(VIA_UUID_KEY);
        queueManagerHandle.viaQueueManagerName = qmHandleMemento.getString(VIA_QM_NAME_KEY);
        queueManagerHandle.uniqueId = qmHandleMemento.getString(UNIQUE_ID);
        if (queueManagerHandle.uniqueId == null) {
            queueManagerHandle.setUniqueId(t);
        }
        if (qmHandleMemento.getInteger(VIA_CONN_TYPE_KEY) != null) {
            queueManagerHandle.viaConnectionType = qmHandleMemento.getInteger(VIA_CONN_TYPE_KEY);
        }
        if (qmHandleMemento.getString(SECURITY_EXIT_NAME) != null) {
            queueManagerHandle.securityExitName = qmHandleMemento.getString(SECURITY_EXIT_NAME);
        }
        if (qmHandleMemento.getString(SECURITY_EXIT_LOCATION) != null) {
            queueManagerHandle.securityExitLocation = qmHandleMemento.getString(SECURITY_EXIT_LOCATION);
        }
        if (qmHandleMemento.getString(SECURITY_EXIT_DATA) != null) {
            queueManagerHandle.securityExitData = qmHandleMemento.getString(SECURITY_EXIT_DATA);
        }
        if (qmHandleMemento.getInteger("userIdState") != null) {
            queueManagerHandle.userIdState = qmHandleMemento.getInteger("userIdState");
        } else {
            queueManagerHandle.userIdState = 0;
            userID = qmHandleMemento.getString(USERID);
            if (userID != null && userID != "") {
                queueManagerHandle.userIdState = 1;
            }
        }
        if (qmHandleMemento.getInteger(COMPATIBILITY_MODE) != null) {
            queueManagerHandle.compatMode = qmHandleMemento.getInteger(COMPATIBILITY_MODE);
        }
        if (qmHandleMemento.getInteger(PASSWORD_MODE) != null) {
            queueManagerHandle.passwordMode = qmHandleMemento.getInteger(PASSWORD_MODE);
        } else {
            queueManagerHandle.passwordMode = 0;
            userID = qmHandleMemento.getString(USERID);
            String password = qmHandleMemento.getString(PASSWORD);
            if (userID != null && userID != "" && password != null && password != "") {
                queueManagerHandle.passwordMode = 2;
            }
        }
        if (qmHandleMemento.getString(USERID) != null) {
            queueManagerHandle.userid = qmHandleMemento.getString(USERID);
        }
        if (qmHandleMemento.getString(PASSWORD) != null) {
            queueManagerHandle.password = qmHandleMemento.getString(PASSWORD);
        }
        if (qmHandleMemento.getString(SSL_CIPHER_SUITE) != null) {
            queueManagerHandle.sslCipherSuite = qmHandleMemento.getString(SSL_CIPHER_SUITE);
        }
        if (currentFipsMode != null) {
            queueManagerHandle.sslFipsRequired = currentFipsMode;
        }
        if (qmHandleMemento.getString(SSL_PEER_NAME) != null) {
            queueManagerHandle.sslPeerName = qmHandleMemento.getString(SSL_PEER_NAME);
        }
        if (qmHandleMemento.getString(CERTIFICATE_VAL_POLICY) != null) {
            queueManagerHandle.certvpol = qmHandleMemento.getInteger(CERTIFICATE_VAL_POLICY);
        }
        if (qmHandleMemento.getInteger(SSL_RESET_COUNT) != null) {
            queueManagerHandle.sslResetCount = qmHandleMemento.getInteger(SSL_RESET_COUNT);
        }
        if (qmHandleMemento.getString(SSL_PERSONAL_STORE) != null) {
            queueManagerHandle.sslPersonalStore = qmHandleMemento.getString(SSL_PERSONAL_STORE);
        }
        if (qmHandleMemento.getString(SSL_PERSONAL_STORE_PW) != null) {
            queueManagerHandle.sslPersonalStorePassword = qmHandleMemento.getString(SSL_PERSONAL_STORE_PW);
            queueManagerHandle.tempSSLPersonalStorePassword = qmHandleMemento.getString(SSL_PERSONAL_STORE_PW);
        }
        if (qmHandleMemento.getString(SSL_TRUSTED_STORE) != null) {
            queueManagerHandle.sslTrustedStore = qmHandleMemento.getString(SSL_TRUSTED_STORE);
        }
        if (qmHandleMemento.getString(SSL_TRUSTED_STORE_PW) != null) {
            queueManagerHandle.sslTrustedStorePassword = qmHandleMemento.getString(SSL_TRUSTED_STORE_PW);
            queueManagerHandle.tempSSLTrustedStorePassword = qmHandleMemento.getString(SSL_TRUSTED_STORE_PW);
        }
        if (qmHandleMemento.getString(CONN_NAMES_KEY) != null) {
            queueManagerHandle.setConnectionNames(t, qmHandleMemento.getString(CONN_NAMES_KEY));
        }
        return queueManagerHandle;
    }

    public static synchronized boolean addAttribute(Trace t, QueueManagerHandle handle, int id) {
        boolean addAttribute = false;
        int connType = handle.getConnectionType();
        block0 : switch (connType) {
            case 2: {
                switch (id) {
                    case 11002: 
                    case 11003: 
                    case 11016: 
                    case 11017: 
                    case 11018: 
                    case 11019: 
                    case 11020: 
                    case 11021: 
                    case 11022: 
                    case 11023: 
                    case 11024: 
                    case 11025: 
                    case 11026: 
                    case 11027: 
                    case 11028: 
                    case 11033: 
                    case 11034: {
                        addAttribute = true;
                        break block0;
                    }
                }
                if (!Trace.isTracing) break;
                t.data(65, "QueueManagerHandle.addAttribute", 900, "Unknown attribute id " + id);
                break;
            }
            case 5: {
                switch (id) {
                    case 11002: 
                    case 11003: 
                    case 11016: 
                    case 11017: 
                    case 11018: 
                    case 11019: 
                    case 11020: 
                    case 11021: 
                    case 11022: 
                    case 11023: 
                    case 11024: 
                    case 11025: 
                    case 11026: 
                    case 11027: 
                    case 11028: 
                    case 11029: 
                    case 11033: 
                    case 11034: {
                        addAttribute = true;
                        break block0;
                    }
                }
                if (!Trace.isTracing) break;
                t.data(65, "QueueManagerHandle.addAttribute", 900, "Unknown attribute id " + id);
                break;
            }
            case 3: {
                if (id != 11013) break;
                addAttribute = true;
                break;
            }
            case 4: {
                switch (id) {
                    case 11010: 
                    case 11020: 
                    case 11021: 
                    case 11022: 
                    case 11023: 
                    case 11025: 
                    case 11026: 
                    case 11027: 
                    case 11028: {
                        addAttribute = true;
                        break block0;
                    }
                }
                if (!Trace.isTracing) break;
                t.data(65, "QueueManagerHandle.addAttribute", 900, "Unknown attribute id " + id);
                break;
            }
            case 1: {
                switch (id) {
                    case 11018: 
                    case 11019: 
                    case 11033: 
                    case 11034: {
                        addAttribute = true;
                    }
                }
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "QueueManagerHandle.addAttribute", 900, "Unknown connection type " + connType);
            }
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.addAttribute", 300, "Connection type = " + connType + ", id = " + id + ", add = " + addAttribute);
        }
        return addAttribute;
    }

    public boolean compareUUID(Trace t, QueueManagerHandle qmh) {
        boolean same = false;
        if (this.uuid.equals(qmh.getUuid())) {
            same = true;
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.compareUUID", 300, "Comparing " + this.uuid + " with " + qmh.getUuid() + ", same = " + same);
        }
        return same;
    }

    public boolean compareUniqueID(Trace t, QueueManagerHandle qmh) {
        boolean same = false;
        if (this.uniqueId.equals(qmh.getUniqueId(t))) {
            same = true;
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.compareUniqueID", 300, "Comparing " + this.uniqueId + " with " + qmh.getUniqueId(t) + ", same = " + same);
        }
        return same;
    }

    public String getTreeName(Trace t) {
        String retValue = this.queueManagerName;
        switch (this.getConnectionType()) {
            case 2: {
                retValue = CoreServices.message.getMessage(t, "TREENAME_ON.title", this.queueManagerName, "'" + this.getConnectionName() + "'");
                break;
            }
            case 5: {
                retValue = CoreServices.message.getMessage(t, "TREENAME_ON.title", this.queueManagerName, "'" + this.getConnectionName() + "'");
                break;
            }
            case 4: {
                retValue = CoreServices.message.getMessage(t, "TREENAME_USING.title", this.queueManagerName, "'" + this.getChannelDefTable() + "'");
                break;
            }
            case 3: {
                retValue = CoreServices.message.getMessage(t, "TREENAME_VIA.title", this.queueManagerName, "'" + this.getViaQueueManagerName() + "'");
            }
        }
        return retValue;
    }

    public static void setDefaultQueueManagerRefreshInterval(int i) {
        defaultRefreshInterval = i;
    }

    public static void setDefaultRemoteQueueManagerRefreshInterval(int i) {
        defaultRemoteRefreshInterval = i;
    }

    public static int getDefaultQueueManagerRefreshInterval() {
        return defaultRefreshInterval;
    }

    public static int getDefaultRemoteQueueManagerRefreshInterval() {
        return defaultRemoteRefreshInterval;
    }

    public static int getDefaultQueueManagerExpiryInterval() {
        return defaultExpiryInterval;
    }

    public static int getDefaultRemoteQueueManagerExpiryInterval() {
        return defaultRemoteExpiryInterval;
    }

    public static int getDefaultQueueManagerWaitInterval() {
        return defaultWaitInterval;
    }

    public static int getDefaultRemoteQueueManagerWaitInterval() {
        return defaultRemoteWaitInterval;
    }

    public static void setDefaultQueueManagerExpiryInterval(int i) {
        defaultExpiryInterval = i;
    }

    public static void setDefaultQueueManagerWaitInterval(int i) {
        defaultWaitInterval = i;
    }

    public static void setDefaultRemoteQueueManagerExpiryInterval(int i) {
        defaultRemoteExpiryInterval = i;
    }

    public static void setDefaultRemoteQueueManagerWaitInterval(int i) {
        defaultRemoteWaitInterval = i;
    }

    private void setSecurityOptions(Trace t, Hashtable<String, Object> secOptions) {
        Enumeration<String> keys = secOptions.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = (String)secOptions.get(key);
            if (Trace.isTracing && !PASSWORD.equals(key)) {
                t.data(65, "QueueManagerHandle.setSecurityOptions", 300, "Key = " + key + ", value = " + value);
            }
            if (value == null) continue;
            if (key.equals("channelSecurityExit")) {
                this.securityExitName = value;
                continue;
            }
            if (key.equals("channelSecurityExitUserData")) {
                this.securityExitData = value;
                continue;
            }
            if (key.equals("exitClasspath")) {
                this.securityExitLocation = value;
                continue;
            }
            if (key.equals("userIdState")) {
                this.userIdState = Boolean.parseBoolean(value) ? 1 : 0;
                continue;
            }
            if (key.equals("Use MQCSP authentication")) {
                this.compatMode = Boolean.parseBoolean(value) ? 0 : 1;
                continue;
            }
            if (key.equals(PASSWORD_MODE)) {
                this.passwordMode = Integer.parseInt(value);
                continue;
            }
            if (key.equals("userID")) {
                this.userid = value;
                continue;
            }
            if (key.equals(PASSWORD)) {
                this.password = value;
                this.tempPassword = value;
                continue;
            }
            if (key.equals("SSL Cipher Suite")) {
                this.sslCipherSuite = value;
                continue;
            }
            if (key.equals("SSL Peer Name")) {
                this.sslPeerName = value;
                continue;
            }
            if (key.equals("SSL Fips Required")) {
                this.sslFipsRequired = Integer.parseInt(value);
                continue;
            }
            if (key.equals("KeyResetCount")) {
                this.sslResetCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals(SSL_TRUSTED_STORE)) {
                this.sslTrustedStore = value;
                continue;
            }
            if (key.equals(SSL_TRUSTED_STORE_PW)) {
                this.sslTrustedStorePassword = value;
                this.tempSSLTrustedStorePassword = value;
                continue;
            }
            if (key.equals(SSL_PERSONAL_STORE)) {
                this.sslPersonalStore = value;
                continue;
            }
            if (key.equals(SSL_PERSONAL_STORE_PW)) {
                this.sslPersonalStorePassword = value;
                this.tempSSLPersonalStorePassword = value;
                continue;
            }
            if (key.equals("certificateValPolicy")) {
                if (value.equalsIgnoreCase("ANY")) {
                    this.certvpol = 0;
                    continue;
                }
                if (value.equalsIgnoreCase("NONE")) {
                    this.certvpol = 2;
                    continue;
                }
                this.certvpol = -1;
                continue;
            }
            if (!Trace.isTracing) continue;
            t.data(65, "QueueManagerHandle.setSecurityOptions", 900, "Unknown security attribute key " + key);
        }
    }

    public Hashtable<String, Object> getUserIdOptions(Trace t) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (this.getUserIdState() != 0) {
            int mode;
            table.put("Use MQCSP authentication", this.compatMode != 1);
            if (!this.userid.equals("")) {
                table.put("userID", this.userid);
            }
            if ((mode = this.getPasswordMode()) == 1) {
                if (this.tempPassword != null) {
                    table.put(PASSWORD, this.tempPassword);
                }
            } else if (mode == 2 && this.password != null) {
                if (DmPasswordStoreManager.isSavingPasswordsPreference(t)) {
                    String pw = null;
                    pw = this.getPassword(t, "com.ibm.mq.explorer.addqm.conn.details.userid.pw", this.userid);
                    if (pw == null) {
                        pw = this.checkGlobalPreferencePassword(t, this.userid);
                    }
                    table.put(PASSWORD, pw);
                } else if (this.tempPassword != null) {
                    table.put(PASSWORD, this.tempPassword);
                }
            }
        }
        return table;
    }

    public void setDefaultUserIdOptions(Trace t) {
        this.userid = defaultUserId;
        this.userIdState = defaultUserIdState;
        this.password = defaultPassword;
        this.compatMode = defaultCompatMode;
        this.passwordMode = defaultPasswordMode;
    }

    public Hashtable<String, Object> getSecurityOptions(Trace t) throws DmCoreException {
        Hashtable<String, Object> table = this.getUserIdOptions(t);
        if (!this.securityExitName.equals("")) {
            table.put("channelSecurityExit", this.securityExitName);
        }
        if (!this.securityExitData.equals("")) {
            table.put("channelSecurityExitUserData", this.securityExitData);
        }
        if (!this.securityExitLocation.equals("")) {
            table.put("exitClasspath", this.securityExitLocation);
        }
        if (!this.sslCipherSuite.equals("")) {
            table.put("SSL Cipher Suite", this.sslCipherSuite);
        }
        if (!this.sslPeerName.equals("")) {
            table.put("SSL Peer Name", this.sslPeerName);
        }
        if (this.certvpol != -1) {
            table.put("certificateValPolicy", this.certvpol);
        }
        if (this.sslFipsRequired != 0 && CommonServices.isSSLFIPSSupported()) {
            table.put("SSL Fips Required", true);
            table.put("JMQI FLAGS", 16);
        }
        if (this.sslResetCount != 0) {
            table.put("KeyResetCount", this.sslResetCount);
        }
        if (!this.sslTrustedStore.equals("")) {
            try {
                String trustedPw = null;
                String personalPw = null;
                if (DmPasswordStoreManager.isSavingPasswordsPreference(t)) {
                    trustedPw = this.getPassword(t, "com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", this.sslTrustedStore);
                    personalPw = this.getPassword(t, "com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", this.sslPersonalStore);
                } else {
                    trustedPw = this.tempSSLTrustedStorePassword;
                    personalPw = this.tempSSLPersonalStorePassword;
                }
                if (this.sslFipsRequired != 0 && CommonServices.isSSLFIPSSupported()) {
                    System.setProperty(JSSE_FIPS_SYSTEM_PROPERTY, "true");
                }
                DmSSLSocketFactory sslSocketFactory = new DmSSLSocketFactory(t, this.queueManagerName, this.sslPersonalStore, personalPw, this.sslTrustedStore, trustedPw, this.sslFipsRequired, this.sslCipherSuite);
                table.put("SSL Socket Factory", sslSocketFactory.getSSLSocketFactory());
            }
            finally {
                if (this.sslFipsRequired != 0 && CommonServices.isSSLFIPSSupported()) {
                    System.setProperty(JSSE_FIPS_SYSTEM_PROPERTY, "false");
                }
            }
        }
        return table;
    }

    private String getPassword(Trace t, String objectId, String resourceId) {
        String pw = null;
        String ownerId = this.getUniqueId(t);
        IPwCredentials c = DmPasswordStoreManager.getStoreManager(t).getCredentials(t, ownerId, objectId, resourceId);
        if (c != null) {
            pw = c.getPassword();
        }
        return pw;
    }

    private String checkGlobalPreferencePassword(Trace t, String userId) {
        String pw = "";
        String ownerId = this.getUniqueId(t);
        IPwCredentials c = DmPasswordStoreManager.getStoreManager(t).getCredentials(t, "com.ibm.mq.explorer.prefs.conn.details", "com.ibm.mq.explorer.prefs.conn.details.userid.pw", userId);
        if (c != null && (pw = c.getPassword()) != null) {
            c = new PwDefaultCredentials(t, ownerId, "com.ibm.mq.explorer.addqm.conn.details.userid.pw", userId, pw);
            DmPasswordStoreManager.getStoreManager(t).saveCredentials(t, c);
        }
        return pw;
    }

    public void setTempSSLPersonalStorePassword(String s) {
        this.tempSSLPersonalStorePassword = s;
    }

    public void setTempSSLTrustedStorePassword(String s) {
        this.tempSSLTrustedStorePassword = s;
    }

    public void setTempPassword(String s) {
        this.tempPassword = s;
    }

    private void setUniqueId(Trace t) {
        if (this.uniqueId == null || this.uniqueId.equals("")) {
            switch (this.connectionType) {
                case 1: {
                    this.uniqueId = this.queueManagerName;
                    break;
                }
                case 2: 
                case 5: {
                    this.uniqueId = String.valueOf(this.queueManagerName) + "/" + this.getHostName(t) + "/" + this.getPortAddress(t) + "/" + this.channel;
                    break;
                }
                case 4: {
                    this.uniqueId = String.valueOf(this.queueManagerName) + "/" + this.getChannelDefTable();
                    break;
                }
                case 3: {
                    this.uniqueId = String.valueOf(this.queueManagerName) + "/" + this.commandQueueName + "/" + this.uuid;
                    break;
                }
                default: {
                    if (!Trace.isTracing) break;
                    t.data(65, "QueueManagerHandle.setUniqueId", Integer.MIN_VALUE, "unique id not defined");
                }
            }
        }
        if (Trace.isTracing) {
            t.data(65, "QueueManagerHandle.setUniqueId", 300, "unique id : " + this.uniqueId);
        }
    }

    public String getUniqueId(Trace t) {
        return this.uniqueId;
    }

    public boolean interateConnName(Trace t) {
        boolean another = false;
        if (this.connNames != null) {
            int i = 0;
            while (i < this.connNames.size()) {
                if (this.connName.equals(this.connNames.get(i).toString())) {
                    if (i + 1 >= this.connNames.size()) break;
                    if (Trace.isTracing) {
                        t.data(65, "QueueManagerHandle.interateConnName", 300, "Resetting connName from " + this.connName + " to " + this.connNames.get(i + 1));
                    }
                    this.connName = this.connNames.get(i + 1).toString();
                    another = true;
                    break;
                }
                ++i;
            }
        }
        return another;
    }

    public void setFirstConnName(Trace t) {
        if (this.connNames != null && this.connNames.size() > 0) {
            if (Trace.isTracing) {
                t.data(65, "QueueManagerHandle.setFirstConnName", 300, "Resetting connName from " + this.connName + " to " + this.connNames.get(0).toString());
            }
            this.connName = this.connNames.get(0).toString();
        }
    }

    public void resetConnectionTypeMi() {
        if (this.connectionType == 2) {
            this.connectionType = 5;
        }
    }

    public ConnectionNameList getConnNames() {
        return this.connNames;
    }

    public void setRequiresVerify(boolean verifyHandle) {
        this.requiresVerify = verifyHandle;
    }

    public boolean requiresVerify() {
        return this.requiresVerify;
    }

    public String getMFTSSLPersonalStorePassword(Trace t) {
        String password = null;
        if (!this.getSSLPersonalStore().equals("")) {
            password = DmPasswordStoreManager.isSavingPasswordsPreference(t) ? this.getPassword(t, "com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", this.sslPersonalStore) : this.tempSSLPersonalStorePassword;
        }
        return password;
    }

    public String getMFTSSLTrustedStorePassword(Trace t) {
        String password = null;
        if (!this.getSSLTrustedStore().equals("")) {
            password = DmPasswordStoreManager.isSavingPasswordsPreference(t) ? this.getPassword(t, "com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", this.sslTrustedStore) : this.tempSSLTrustedStorePassword;
        }
        return password;
    }
}

