/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.CreateDmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandleList;
import java.io.File;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class PersistQueueManagerHandles
extends Thread {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/utils/PersistQueueManagerHandles.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String MY_NAME = "IBM MQ Persist Queue Manager Handles";
    private static boolean closing = false;
    private static boolean save = true;
    private static int REFRESH_INTEVAL;
    private static int refreshInterval;
    private static PersistQueueManagerHandles workerThread;
    private static String handlesFilename;
    private static boolean verifyHandles;
    private static Integer lock;
    private static QueueManagerHandleList queueManagerHandleList;

    static {
        refreshInterval = REFRESH_INTEVAL = 3600;
        workerThread = null;
        handlesFilename = null;
        verifyHandles = false;
        lock = 0;
        queueManagerHandleList = null;
    }

    protected PersistQueueManagerHandles(Trace t, int ri) {
        if (Trace.isTracing) {
            t.data(65, "PersistQueueManagerHandles.PersistQueueManagerHandles", 300, "IBM MQ Persist Queue Manager Handles created");
        }
        workerThread = this;
        refreshInterval = ri;
        queueManagerHandleList = PersistQueueManagerHandles.load(t);
        if (queueManagerHandleList == null) {
            if (Trace.isTracing) {
                t.data(65, "PersistQueueManagerHandles.PersistQueueManagerHandles", 300, "Creating new QueueManagerHandleList");
            }
            queueManagerHandleList = new QueueManagerHandleList(t);
        }
        this.setDaemon(true);
        this.setName(MY_NAME);
        this.start();
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        while (!closing) {
            block5: {
                try {
                    if (Trace.isTracing) {
                        t.data(65, "PersistQueueManagerHandles.run", 300, "IBM MQ Persist Queue Manager Handles sleeping for " + refreshInterval + " seconds");
                    }
                    Thread.sleep(refreshInterval * 1000);
                }
                catch (InterruptedException interruptedException) {
                    if (!Trace.isTracing) break block5;
                    t.data(65, "PersistQueueManagerHandles.run", 300, "IBM MQ Persist Queue Manager Handles interrupted");
                }
            }
            this.saveToDisk(t);
            if (closing) break;
        }
        if (Trace.isTracing) {
            t.data(65, "PersistQueueManagerHandles.run", 300, "IBM MQ Persist Queue Manager Handles ended");
        }
    }

    public static int getRefreshInterval() {
        return refreshInterval;
    }

    public void close(Trace t) {
        closing = true;
        workerThread.interrupt();
    }

    public void saveToDisk(Trace t) {
        if (save) {
            if (Trace.isTracing) {
                t.data(65, "PersistQueueManagerHandles.saveToDisk", 300, "IBM MQ Persist Queue Manager Handles saving handles to disk");
            }
            queueManagerHandleList.save(t);
        } else if (Trace.isTracing) {
            t.data(65, "PersistQueueManagerHandles.saveToDisk", 300, "IBM MQ Persist Queue Manager Handles NOT saving handles to disk");
        }
    }

    public static IMemento saveQMsToXml(Trace t, boolean remoteQMgrs) {
        XMLMemento rootWrite = queueManagerHandleList.saveQMsToXML(t, remoteQMgrs);
        return rootWrite;
    }

    public void mergeRemoteQMsHandlesFromXml(Trace t, IMemento rootRead, boolean addQMtoDM, Integer currentFipsMode) {
        IMemento[] qmHandles;
        IMemento[] iMementoArray = qmHandles = rootRead.getChildren("QueueManagerHandle");
        int n = qmHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento qmHandleMemento = iMementoArray[n2];
            QueueManagerHandle qmh = QueueManagerHandle.createFromMemento(t, qmHandleMemento, currentFipsMode);
            if (qmh.getConnectionType() != 1 && !queueManagerHandleList.containsUniqueID(t, qmh)) {
                queueManagerHandleList.addHandle(t, qmh);
                if (addQMtoDM && qmh.getConnectionType() != 1) {
                    CreateDmQueueManager job = new CreateDmQueueManager(t, new DmQueueManagerHandle(t, qmh), (Object)"ALL");
                    if (Trace.isTracing) {
                        t.data(65, "PersistQueueManagerHandles.mergeRemoteQMsHandlesFromXml", 300, "Adding queue manager : " + qmh.getQueueManagerName() + " with " + job.toString(t));
                    }
                }
            }
            ++n2;
        }
        this.saveToDisk(t);
    }

    private static String backupAndRemoveHandlesFile(Trace t) {
        File hf = new File(handlesFilename);
        int c = 1;
        boolean renamed = false;
        while (!renamed) {
            File nf = new File(String.valueOf(handlesFilename) + "bak" + c);
            if (hf.renameTo(nf)) {
                renamed = true;
                continue;
            }
            ++c;
        }
        return String.valueOf(handlesFilename) + "bak" + c;
    }

    private static boolean checkHandleList(Trace t, QueueManagerHandleList qmHandleList) {
        boolean isOK = false;
        if (qmHandleList == null) {
            isOK = true;
        } else if (!qmHandleList.isParseSuccessfull()) {
            String backupFile = PersistQueueManagerHandles.backupAndRemoveHandlesFile(t);
            String reason = "Failed to succesfully parse xml file using DTD - removing handle data and creating backup: " + backupFile;
            t.FFST(65, "PersistQueueManagerHandles.checkHandleList", 0, 50018, 0, 0, reason, backupFile, "");
            String msgText = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4127");
            CoreServices.notifySystemErrorListener(t, CoreServices.getMachine(t), new DmCoreException(t, msgText, "AMQ4127", 50018, 0, 10));
            isOK = false;
        } else {
            isOK = true;
        }
        return isOK;
    }

    /*
     * Exception decompiling
     */
    private static QueueManagerHandleList load(Trace t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setFileName(String fileName) {
        handlesFilename = fileName;
    }

    public static String getFileName() {
        return handlesFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean add(Trace t, DmQueueManagerHandle dmqmh) {
        boolean added = false;
        Integer n = lock;
        synchronized (n) {
            added = queueManagerHandleList.addHandle(t, dmqmh.getQueueManagerHandle(t));
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(Trace t, DmQueueManagerHandle dmqmh) {
        boolean removed = false;
        Integer n = lock;
        synchronized (n) {
            removed = queueManagerHandleList.removeHandle(t, dmqmh.getQueueManagerHandle(t));
        }
        return removed;
    }

    public static QueueManagerHandleList getHandleList(Trace t) {
        if (queueManagerHandleList == null) {
            queueManagerHandleList = new QueueManagerHandleList(t);
        }
        return queueManagerHandleList;
    }

    public static PersistQueueManagerHandles getInstance(Trace t) {
        if (workerThread == null) {
            workerThread = new PersistQueueManagerHandles(t, REFRESH_INTEVAL);
        }
        return workerThread;
    }

    public static void invalidateHandles() {
        verifyHandles = true;
    }

    public static void setSave(boolean b) {
        save = b;
    }
}

