/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.console.ConsoleCommand;
import com.ibm.mq.commonservices.internal.trace.EventLogger;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.BaseMQInstallationDetails;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmErrorEvent;
import com.ibm.mq.explorer.core.internal.event.DmErrorListener;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmObjectView;
import com.ibm.mq.explorer.core.internal.objects.CreateDmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.explorer.core.internal.passwords.DmPasswordStoreManager;
import com.ibm.mq.explorer.core.internal.utils.OtherQueueManager;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandleList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;

public final class CoreServices {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/utils/CoreServices.java";
    public static final String MESSAGE_FILE = "com.ibm.mq.explorer.core.internal.base.common";
    private static final String commandString = "dspmq -n";
    public static Message message = null;
    private static ArrayList<DmQueueManager> queueManagers = new ArrayList(10);
    private static List<OtherQueueManager> queueManagersFromOtherInstallations = new ArrayList<OtherQueueManager>();
    private static boolean queueManagerListInit = false;
    private static ArrayList<DmQueueManager> tempQueueManagers = new ArrayList(10);
    private static DmMachine machine = null;
    private static DmMonitor dmMonitor = null;
    private static DmErrorListener errorListener = null;
    public static boolean systemReset = false;
    private static boolean closing = false;
    private static Object lookupLock = new Object();
    public static DmPasswordStoreManager passwordStoreManager = null;

    private CoreServices() {
    }

    public static void init(Trace t) throws DmCoreException {
        try {
            message = new Message(t, MESSAGE_FILE, CorePlugin.class.getClassLoader());
        }
        catch (Throwable e) {
            if (Trace.isTracing) {
                t.data(65, "CoreServices.init", 900, "Error loading messages : " + e.toString());
            }
            throw new DmCoreException(t, CommonServices.getSystemMessage((Trace)t, (String)"AMQ4578", (String[])new String[]{MESSAGE_FILE}), "AMQ4578", 50026, 0, 40);
        }
        CommonServices.createEventLogger((Trace)t, (String)"com.ibm.mq.explorer.dm.event", (String)EventLogger.DM_EVENT_FILENAME, (int)1);
        passwordStoreManager = DmPasswordStoreManager.getStoreManager(t);
    }

    public static void setWorkingDir(File dir) {
        CommonServices.setWorkingDir((File)dir);
        PersistQueueManagerHandles.setFileName(dir + File.separator + "WMQ_Handles.xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMQ70installed(Trace t) {
        try {
            BaseMQInstallationDetails[] details;
            BaseMQInstallationDetails[] baseMQInstallationDetailsArray = details = NativeCalls.getInstallationDetails((Trace)t);
            int n = details.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                BaseMQInstallationDetails install = baseMQInstallationDetailsArray[n2];
                if (install.identifier == 0 && install.valid) {
                    if (!Trace.isTracing) return true;
                    t.data(65, "CoreServices.isMQ70installed", 300, "Found installation of MQ 7.0");
                    return true;
                }
                ++n2;
            }
        }
        catch (CommonServicesException e) {
            if (!Trace.isTracing) return false;
            t.data(67, "CoreServices.isMQ70installed", 900, "CommonServicesException from QueryValue.queryInstallName: " + e.getMessage());
        }
        return false;
    }

    private static boolean createListOfQueueManagers(Trace t) {
        int qmIndex = 0;
        int handleIndex = 0;
        QueueManagerHandle qmh = null;
        QueueManagerHandleList qmHandleList = null;
        if (queueManagers.size() > 0) {
            if (Trace.isTracing) {
                t.data(65, "CoreServices.createListOfQueueManagers", 300, "List of queue managers already created");
            }
            return true;
        }
        machine = CoreServices.getMachine(t);
        qmHandleList = PersistQueueManagerHandles.getHandleList(t);
        String thisInstall = CommonServices.getInstallationName((Trace)t);
        boolean got70 = CoreServices.isMQ70installed(t);
        String qm = machine.getAttributeValue(t, 10504, qmIndex);
        while (!qm.equals("[not_found]")) {
            String inst = machine.getAttributeValue(t, 10541, qmIndex);
            if (inst.length() == 0) {
                inst = "[not_found]";
            }
            boolean addQM = false;
            if (!inst.equals("[not_found]")) {
                addQM = inst.equals(thisInstall);
            } else {
                boolean bl = addQM = !got70;
            }
            if (addQM) {
                qmh = new QueueManagerHandle(t, qm);
                qmh.setAutoConnect(t, true);
                if (qmHandleList != null) {
                    int i = qmHandleList.indexOf(t, qmh);
                    if (i > -1) {
                        qmh = qmHandleList.getHandle(t, i, false);
                        if (qmh.requiresVerify() && qmh.getConnectionType() == 1) {
                            qmh.setCommandLevel(0);
                            qmh.setPlatform(0);
                        }
                        if (Trace.isTracing) {
                            t.data(65, "CoreServices.createListOfQueueManagers", 300, "Reusing handle from saved list : " + qmh.toString(t));
                        }
                    } else if (Trace.isTracing) {
                        t.data(65, "CoreServices.createListOfQueueManagers", 300, "Handle not in saved list : " + qmh.toString(t));
                    }
                }
                DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
                CreateDmQueueManager job = new CreateDmQueueManager(t, dmqmh, (Object)"ALL");
                if (Trace.isTracing) {
                    t.data(65, "CoreServices.createListOfQueueManagers", 300, "Adding queue manager : " + qm + " with " + job.toString(t));
                }
                qmh.setRequiresVerify(false);
            }
            qm = machine.getAttributeValue(t, 10504, ++qmIndex);
        }
        if (qmHandleList != null) {
            handleIndex = 0;
            while (handleIndex < qmHandleList.size(t)) {
                qmh = qmHandleList.getHandle(t, handleIndex, false);
                if (qmh.getConnectionType() != 1) {
                    CreateDmQueueManager job = new CreateDmQueueManager(t, new DmQueueManagerHandle(t, qmh), (Object)"ALL");
                    if (Trace.isTracing) {
                        t.data(65, "CoreServices.createListOfQueueManagers", 300, "Adding queue manager : " + qmh.getQueueManagerName() + " with " + job.toString(t));
                    }
                }
                ++handleIndex;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "CoreServices.createListOfQueueManagers", 300, String.valueOf(qmIndex + handleIndex) + " queue managers found");
        }
        return true;
    }

    public static synchronized ArrayList<DmQueueManager> getQueueManagers(Trace t) {
        if (!queueManagerListInit && DmPasswordStoreManager.isStoreOpen(t)) {
            queueManagerListInit = true;
            t.data(65, "CoreServices.getQueueManagers", 300, "queueManagers list not yet initialized");
            CoreServices.createListOfQueueManagers(t);
        }
        return queueManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<OtherQueueManager> getQueueManagersFromOtherInstallations(Trace t) {
        ArrayList<OtherQueueManager> clonedQueueMangers;
        if (!queueManagerListInit && DmPasswordStoreManager.isStoreOpen(t)) {
            queueManagerListInit = true;
            t.data(65, "CoreServices.getQueueManagersFromOtherInstallations", 300, "queueManagers list not yet initialized");
            CoreServices.createListOfQueueManagers(t);
        }
        List<OtherQueueManager> list = queueManagersFromOtherInstallations;
        synchronized (list) {
            clonedQueueMangers = new ArrayList<OtherQueueManager>(queueManagersFromOtherInstallations);
        }
        return clonedQueueMangers;
    }

    public static synchronized List<OtherQueueManager> getQueueManagersWithStatusFromOtherInstallations() {
        List<OtherQueueManager> qmgrs = CoreServices.getQueueManagersFromOtherInstallations(Trace.getInstance());
        String output = null;
        if (Trace.isTracing) {
            Trace.data((Level)Level.FINEST, (String)"CoreServices", (String)"getQueueManagersWithStatusFromOtherInstallations", (String)"Invoking command: dspmq -n");
        }
        ConsoleCommand command = new ConsoleCommand(Trace.getInstance(), null, null, commandString);
        String cmdLine = command.getCommand();
        try {
            Process process = Runtime.getRuntime().exec(cmdLine);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((output = stdInput.readLine()) != null) {
                int endIndex;
                int startIndex = output.indexOf(40);
                String qmgrName = output.substring(startIndex + 1, endIndex = output.indexOf(41));
                int indexOfQmgr = qmgrs.indexOf(new OtherQueueManager(qmgrName, null));
                if (indexOfQmgr < 0) continue;
                OtherQueueManager qmgr = qmgrs.get(indexOfQmgr);
                String nextPart = output.substring(endIndex + 1);
                String status = nextPart.substring((startIndex = nextPart.indexOf(40)) + 1, endIndex = nextPart.indexOf(41));
                if (status.equalsIgnoreCase("RUNNING")) {
                    qmgr.setStatus(0);
                    continue;
                }
                if (status.equalsIgnoreCase("RUNNING ELSEWHERE")) {
                    qmgr.setStatus(14);
                    continue;
                }
                if (status.equalsIgnoreCase("QUIESCING")) {
                    qmgr.setStatus(6);
                    continue;
                }
                if (status.equalsIgnoreCase("RUNNING AS STANDBY")) {
                    qmgr.setStatus(13);
                    continue;
                }
                qmgr.setStatus(DmQueueManager.MQQMSTA_STOPPED);
            }
        }
        catch (IOException e) {
            Trace.data((Level)Level.FINEST, (String)"CoreServices", (String)"getQueueManagersWithStatusFromOtherInstallations", (String)("Error while running 'dspmq -n' command: " + e.getMessage()));
        }
        return qmgrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setQueueManagersFromOtherInstallations(List<OtherQueueManager> otherQueueManagers) {
        List<OtherQueueManager> list = queueManagersFromOtherInstallations;
        synchronized (list) {
            queueManagersFromOtherInstallations = new ArrayList<OtherQueueManager>(otherQueueManagers);
        }
    }

    public static ArrayList<DmQueueManager> getTempQueueManagers(Trace t) {
        return tempQueueManagers;
    }

    public static synchronized DmMachine getMachine(Trace t) {
        if (machine == null) {
            machine = new DmMachine(t);
        }
        return machine;
    }

    public static ArrayList<DmQueueManagerHandle> getQueueManagerHandles(Trace t) {
        ArrayList<DmQueueManagerHandle> qmhs = new ArrayList<DmQueueManagerHandle>();
        int j = 0;
        while (j < queueManagers.size()) {
            DmQueueManager qm = queueManagers.get(j);
            qmhs.add(qm.getConnectionHandle());
            ++j;
        }
        return qmhs;
    }

    public static synchronized void resetTable(Trace t, ArrayList<DmQueueManager> al) {
        if (Trace.isTracing) {
            t.data(65, "CoreServices.resetTable", 300, "Resetting table, size = " + al.size());
        }
        int j = 0;
        while (j < al.size()) {
            block5: {
                try {
                    DmObject o = al.get(j);
                    if (Trace.isTracing) {
                        t.data(65, "CoreServices.resetTable", 300, "Calling close for " + o.getTitle());
                    }
                    o.close(t);
                }
                catch (ClassCastException cce) {
                    if (!Trace.isTracing) break block5;
                    t.data(65, "CoreServices.resetTable", 1000, cce.getMessage());
                    t.FFST(65, "CoreServices.resetTable", 0, 0, 0, 0, cce.getMessage(), "", "");
                }
            }
            ++j;
        }
        al.clear();
    }

    public static void resetBlockedConnections(Trace t, ArrayList<DmQueueManager> al) {
        if (Trace.isTracing) {
            t.data(65, "CoreServices.resetBlockedConnections", 300, "Resetting any blocked connections, list size = " + al.size());
        }
        int j = 0;
        while (j < al.size()) {
            block8: {
                try {
                    DmQueueManager qm = al.get(j);
                    if (qm.getConnectionThread(t) != null) {
                        if (Trace.isTracing) {
                            t.data(65, "CoreServices.resetBlockedConnections", 300, "Calling stop for connection thread to " + qm.getTreeName(t));
                        }
                        qm.getConnectionThread(t).stop(t);
                    }
                }
                catch (ClassCastException e) {
                    if (Trace.isTracing) {
                        t.data(65, "CoreServices.resetBlockedConnections", 1000, e.getMessage());
                        t.FFST(65, "CoreServices.resetBlockedConnections", 0, 50022, 0, 0, e.getMessage(), "", "");
                    }
                }
                catch (NullPointerException e) {
                    if (!Trace.isTracing) break block8;
                    t.data(65, "CoreServices.resetBlockedConnections", 1000, e.getMessage());
                    t.FFST(65, "CoreServices.resetBlockedConnections", 0, 50020, 0, 0, e.getMessage(), "", "");
                }
            }
            ++j;
        }
    }

    public static DmQueueManagerHandle addQueueManager(Trace t, DmQueueManager existingQM, String targetQ, String targetQM, int refreshInt, boolean autoConnect, boolean connectNow) {
        QueueManagerHandle qmh = new QueueManagerHandle(t, existingQM, targetQ, targetQM);
        qmh.setRefreshInterval(t, refreshInt);
        qmh.setAutoConnect(t, autoConnect);
        DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
        dmqmh.setConnectNow(t, connectNow);
        if (!CoreServices.handleAlreadyExists(t, dmqmh)) {
            DmQueueManager qm = new DmQueueManager(t, dmqmh, "ALL");
            qm.connectSynchronously(t);
            queueManagers.add(qm);
        }
        return dmqmh;
    }

    public static void addQueueManager(Trace t, DmQueueManager existingQM, String targetQ, String targetQM, Object id, int refreshInt, boolean autoConnect, boolean connectNow) {
        CreateDmQueueManager job = null;
        QueueManagerHandle qmh = new QueueManagerHandle(t, existingQM, targetQ, targetQM);
        qmh.setRefreshInterval(t, refreshInt);
        qmh.setAutoConnect(t, autoConnect);
        DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
        dmqmh.setConnectNow(t, connectNow);
        job = new CreateDmQueueManager(t, dmqmh, id);
        if (Trace.isTracing) {
            t.data(65, "CoreServices.addQueueManager", 300, "Adding queue manager : " + targetQM + " with " + job.toString(t));
        }
    }

    public static void addQueueManager(Trace t, String QMName, String connName, String chl, Object id, int refreshInt, boolean autoConnect, boolean connectNow) {
        CreateDmQueueManager job = null;
        QueueManagerHandle qmh = new QueueManagerHandle(t, QMName, connName, chl, null);
        qmh.setRefreshInterval(t, refreshInt);
        qmh.setAutoConnect(t, autoConnect);
        DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
        dmqmh.setConnectNow(t, connectNow);
        job = new CreateDmQueueManager(t, dmqmh, id);
        if (Trace.isTracing) {
            t.data(65, "CoreServices.addQueueManager", 300, "Adding queue manager : " + QMName + " with " + job.toString(t));
        }
    }

    public static void addQueueManager(Trace t, String QMName, URL chanDefTable, Object id, int refreshInt, boolean autoConnect, boolean connectNow) {
        CreateDmQueueManager job = null;
        QueueManagerHandle qmh = new QueueManagerHandle(t, QMName, chanDefTable, null);
        qmh.setRefreshInterval(t, refreshInt);
        qmh.setAutoConnect(t, autoConnect);
        DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
        dmqmh.setConnectNow(t, connectNow);
        job = new CreateDmQueueManager(t, dmqmh, id);
        if (Trace.isTracing) {
            t.data(65, "CoreServices.addQueueManager", 300, "Adding queue manager : " + QMName + " with " + job.toString(t));
        }
    }

    public static void addQueueManager(Trace t, String QMName, URL chanDefTable, Hashtable<String, Object> secOptions, Object id, int refreshInt, boolean autoConnect, boolean connectNow) {
        CreateDmQueueManager job = null;
        QueueManagerHandle qmh = new QueueManagerHandle(t, QMName, chanDefTable, secOptions);
        qmh.setRefreshInterval(t, refreshInt);
        qmh.setAutoConnect(t, autoConnect);
        DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
        dmqmh.setConnectNow(t, connectNow);
        job = new CreateDmQueueManager(t, dmqmh, id);
        if (Trace.isTracing) {
            t.data(65, "CoreServices.addQueueManager", 300, "Adding queue manager : " + QMName + " with " + job.toString(t));
        }
    }

    public static boolean removeQueueManager(Trace t, DmQueueManagerHandle dmqmh) {
        boolean retValue = true;
        DmQueueManager qm = dmqmh.getQueueManager();
        PersistQueueManagerHandles.remove(t, dmqmh);
        if (qm != null) {
            qm.close(t);
            CoreServices.getTempQueueManagers(t).remove(qm);
            CoreServices.getQueueManagers(t).remove(qm);
        }
        return retValue;
    }

    public static DmMonitor getDmMonitor(Trace t) {
        return dmMonitor;
    }

    public static void setDmMonitor(Trace t, DmMonitor dm) {
        if (dmMonitor == null) {
            if (Trace.isTracing) {
                t.data(65, "CoreServices.setDmMonitor", 300, "New DmMonitor set");
            }
            dmMonitor = dm;
        } else if (Trace.isTracing) {
            t.data(65, "CoreServices.setDmMonitor", 900, "New DmMonitor ignored");
        }
    }

    public static void setDmMonitorRefreshInterval(Trace t, int i) {
        if (i == -1) {
            if (dmMonitor != null) {
                if (Trace.isTracing) {
                    t.data(65, "CoreServices.setDmMonitorRefreshInterval", 300, "Stopping DmMonitor");
                }
                dmMonitor.close(t);
                dmMonitor = null;
            } else if (Trace.isTracing) {
                t.data(65, "CoreServices.setDmMonitorRefreshInterval", 300, "DmMonitor already stopped");
            }
        } else if (dmMonitor == null) {
            if (Trace.isTracing) {
                t.data(65, "CoreServices.setDmMonitorRefreshInterval", 300, "Starting a new DmMonitor");
            }
            DmMonitor.setRefreshInterval(t, i);
            CoreServices.getDmMonitor(t);
        } else {
            DmMonitor.setRefreshInterval(t, i);
        }
    }

    public static void close(Trace t) {
        closing = true;
        dmMonitor.close(t);
        CoreServices.resetBlockedConnections(t, queueManagers);
        CoreServices.resetBlockedConnections(t, tempQueueManagers);
        CoreServices.resetTable(t, queueManagers);
        CoreServices.resetTable(t, tempQueueManagers);
    }

    public static void refreshDmMonitor(Trace t) {
        dmMonitor.refresh(t);
    }

    public static boolean checkHostname(Trace t, String hostName) {
        boolean localConnection;
        block4: {
            InetAddress address = null;
            localConnection = false;
            if (Common.MY_LOCAL_ADDRESS == null) {
                t.data(65, "CoreServices.checkHostname", 900, "MY_LOCAL_ADDRESS has not be resolved");
                return localConnection;
            }
            try {
                address = InetAddress.getByName(hostName);
                if (Common.MY_LOCAL_ADDRESS.getHostAddress().equals(address.getHostAddress()) || address.isLoopbackAddress()) {
                    localConnection = true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (!Trace.isTracing) break block4;
                t.data(65, "CoreServices.checkHostname", 900, "Host <" + hostName + "> name cannot be resolved");
            }
        }
        return localConnection;
    }

    public static int determineWMQPlatform() {
        int retValue = 11;
        if (Common.osName.startsWith("WINDOWS")) {
            return 11;
        }
        if (Common.osName.startsWith("AIX")) {
            return 3;
        }
        if (Common.osName.startsWith("LINUX")) {
            return 3;
        }
        if (Common.osName.startsWith("MAC")) {
            return 3;
        }
        return retValue;
    }

    public static boolean addSystemErrorListener(Trace t, DmErrorListener listener) {
        boolean added = false;
        if (errorListener != null) {
            String errMessage = "Error adding " + listener.toString() + ", listener " + errorListener.toString() + " already registered";
            DmCoreException exception = new DmCoreException(t, errMessage, "", 50030, 0, 0);
            CoreServices.notifySystemErrorListener(t, CoreServices.getMachine(t), exception);
            if (Trace.isTracing) {
                t.data(65, "CoreServices.addSystemErrorListener", 900, errMessage);
            }
        } else {
            errorListener = listener;
            added = true;
            if (Trace.isTracing) {
                t.data(65, "CoreServices.addSystemErrorListener", 300, "Listener added : " + listener.toString());
            }
        }
        return added;
    }

    public static boolean removeSystemErrorListener(Trace t, DmErrorListener listener) {
        boolean removed = false;
        if (errorListener != null) {
            errorListener = null;
            removed = true;
            if (Trace.isTracing) {
                t.data(65, "CoreServices.removeSystemErrorListener", 300, "Listener removed : " + listener.toString());
            }
        } else if (Trace.isTracing) {
            t.data(65, "CoreServices.removeSystemErrorListener", 900, "Listener not registered : " + listener.toString());
        }
        return removed;
    }

    public static void notifySystemErrorListener(Trace t, IDmObject dmObject, DmCoreException exception) {
        if (errorListener != null) {
            errorListener.dmOnError(new DmErrorEvent(dmObject, exception));
            if (Trace.isTracing) {
                t.data(65, "CoreServices.notifySystemErrorListener", 300, "Listener notified : " + errorListener.toString());
            }
        } else if (Trace.isTracing) {
            t.data(65, "CoreServices.notifySystemErrorListener", 900, "No listener registered");
        }
    }

    public static void notifySystemErrorListener(Trace t, IDmObject dmObject, DmObjectView view, DmCoreException exception) {
        if (errorListener != null) {
            errorListener.dmOnError(new DmErrorEvent(dmObject, view, exception));
            if (Trace.isTracing) {
                t.data(65, "CoreServices.notifySystemErrorListener", 300, "Listener notified : " + errorListener.toString());
            }
        } else if (Trace.isTracing) {
            t.data(65, "CoreServices.notifySystemErrorListener", 900, "No listener registered");
        }
    }

    public static synchronized boolean handleAlreadyExists(Trace t, DmQueueManagerHandle handle) {
        boolean retValue = false;
        ArrayList<DmQueueManagerHandle> list = CoreServices.getQueueManagerHandles(t);
        retValue = list.contains(handle);
        if (Trace.isTracing) {
            t.data(65, "CoreServices.handleAlreadyExists", 300, "Connection to " + handle.getQueueManagerHandle(t).getQueueManagerName() + " already exists : " + retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DmQueueManager getMatchingQueueManager(Trace t, String uuid, boolean connected) {
        DmQueueManager owner = null;
        if (Trace.isTracing) {
            t.data(65, "CoreServices.getMatchingQueueManager", 300, "Looking for DmQueueManager with UUID of " + uuid + ", connected = " + connected);
        }
        Object object = lookupLock;
        synchronized (object) {
            owner = CoreServices.getMatchingQueueManager(t, CoreServices.getQueueManagers(t), uuid, connected);
            if (owner == null) {
                owner = CoreServices.getMatchingQueueManager(t, CoreServices.getTempQueueManagers(t), uuid, connected);
            }
        }
        if (Trace.isTracing) {
            if (owner == null) {
                t.data(65, "CoreServices.getMatchingQueueManager", 300, "Matching queue manager not found");
            } else {
                t.data(65, "CoreServices.getMatchingQueueManager", 300, "Queue manager found in list " + owner.getTreeName(t));
            }
        }
        return owner;
    }

    private static DmQueueManager getMatchingQueueManager(Trace t, ArrayList<DmQueueManager> qms, String uuid, boolean connected) {
        DmQueueManager owner = null;
        int i = 0;
        while (i < qms.size()) {
            DmQueueManager dmqm = qms.get(i);
            if (dmqm.getUUID().equals(uuid)) {
                if (!connected || connected && dmqm.isConnected()) {
                    owner = dmqm;
                    break;
                }
                if (Trace.isTracing) {
                    t.data(65, "CoreServices.getMatchingQueueManager", 300, "Matching queue manager found, but not connected");
                }
            }
            ++i;
        }
        return owner;
    }

    public static boolean isObjectSupported(Trace t, int objectType, int subType, int commandLevel, int platform) {
        boolean retValue = false;
        HashMap table = null;
        if (Trace.isTracing) {
            t.data(65, "CoreServices.isObjectSupported", 300, "Looking for object type " + objectType + ", subType " + subType + " for commandLevel " + commandLevel + " and platform " + platform);
        }
        if ((table = TableFactory.getHashMap(t, DmObject.getTypeName(t, objectType), commandLevel, platform)) != null) {
            if (subType != -2) {
                int[] subTypes = CoreServices.getSupportedSubTypes(t, objectType, commandLevel, platform);
                int i = 0;
                while (i < subTypes.length) {
                    if (subTypes[i] == subType) {
                        retValue = true;
                        break;
                    }
                    ++i;
                }
            } else {
                retValue = true;
            }
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "CoreServices.isObjectSupported", 300, "Object type/subType is supported");
            } else {
                t.data(65, "CoreServices.isObjectSupported", 300, "Object type/subType is not supported");
            }
        }
        return retValue;
    }

    public static int[] getSupportedSubTypes(Trace t, int objectType, int commandLevel, int platform) {
        int[] retValue = null;
        HashMap table = null;
        if (Trace.isTracing) {
            t.data(65, "CoreServices.getSupportedSubTypes", 300, "Given object type : " + objectType);
        }
        switch (objectType) {
            case 25: {
                table = TableFactory.getHashMap(t, DmObject.getTypeName(t, objectType), commandLevel, platform);
                retValue = CoreServices.getObjectSubTypes(t, table, 1511);
                break;
            }
            case 204: {
                table = TableFactory.getHashMap(t, DmObject.getTypeName(t, objectType), commandLevel, platform);
                retValue = CoreServices.getObjectSubTypes(t, table, 1352);
                break;
            }
            case 97: 
            case 1015: {
                table = TableFactory.getHashMap(t, DmObject.getTypeName(t, objectType), commandLevel, platform);
                retValue = CoreServices.getObjectSubTypes(t, table, 1501);
                break;
            }
            case 13: {
                table = TableFactory.getHashMap(t, DmObject.getTypeName(t, objectType), commandLevel, platform);
                retValue = CoreServices.getObjectSubTypes(t, table, 20);
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "CoreServices.getSupportedSubTypes", 300, "Using empty list of sub-types");
                }
                retValue = new int[]{};
            }
        }
        if (Trace.isTracing) {
            t.data(65, "CoreServices.getSupportedSubTypes", 300, "Supported sub-types are : " + retValue.toString());
        }
        return retValue;
    }

    private static int[] getObjectSubTypes(Trace t, HashMap table, int id) {
        int[] retValue = new int[]{};
        if (table == null) {
            if (Trace.isTracing) {
                t.data(65, "CoreServices.getObjectSubTypes", 900, "Table for attribute id " + id + " has not been created");
            }
            return retValue;
        }
        AttrType at = (AttrType)table.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(65, "CoreServices.getObjectSubTypes", 900, "No attribute type in table for attribute id " + id);
            }
            return retValue;
        }
        try {
            Integer[] enums = ((AttrTypeEnum)at).getEnumerationIds(t);
            if (Trace.isTracing) {
                t.data(65, "CoreServices.getObjectSubTypes", 300, String.valueOf(enums.length) + " types found");
            }
            retValue = new int[enums.length];
            int i = 0;
            while (i < enums.length) {
                retValue[i] = enums[i];
                if (Trace.isTracing) {
                    t.data(65, "CoreServices.getObjectSubTypes", 300, "Type " + retValue[i] + " found");
                }
                ++i;
            }
        }
        catch (ClassCastException classCastException) {
            if (Trace.isTracing) {
                t.data(65, "CoreServices.getObjectSubTypes", 900, "Conversion error for attribute type in table for attribute id " + id);
            }
            return retValue;
        }
        return retValue;
    }

    public static boolean isClosing(Trace t) {
        return closing;
    }

    public static void addQueueManager(Trace t, String QMName, String connName, String chl, Hashtable secOptions, Object id, int refreshInt, boolean autoConnect, boolean connectNow) {
        CreateDmQueueManager job = null;
        QueueManagerHandle qmh = new QueueManagerHandle(t, QMName, connName, chl, (Hashtable<String, Object>)secOptions);
        qmh.setRefreshInterval(t, refreshInt);
        qmh.setAutoConnect(t, autoConnect);
        DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
        dmqmh.setConnectNow(t, connectNow);
        job = new CreateDmQueueManager(t, dmqmh, id);
        if (Trace.isTracing) {
            t.data(65, "CoreServices.addQueueManager", 300, "Adding queue manager : " + QMName + " with " + job.toString(t));
        }
    }

    public static void addQueueManager(Trace t, String QMName, String[] connName, String chl, Hashtable secOptions, Object id, int refreshInt, boolean autoConnect, boolean connectNow) {
        CreateDmQueueManager job = null;
        QueueManagerHandle qmh = new QueueManagerHandle(t, QMName, connName, chl, (Hashtable<String, Object>)secOptions);
        qmh.setRefreshInterval(t, refreshInt);
        qmh.setAutoConnect(t, autoConnect);
        DmQueueManagerHandle dmqmh = new DmQueueManagerHandle(t, qmh);
        dmqmh.setConnectNow(t, connectNow);
        job = new CreateDmQueueManager(t, dmqmh, id);
        if (Trace.isTracing) {
            t.data(65, "CoreServices.addQueueManager", 300, "Adding queue manager : " + QMName + " with " + job.toString(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean sameTreeNameExists(Trace t, DmQueueManager qm) {
        boolean retValue = false;
        Object object = lookupLock;
        synchronized (object) {
            QueueManagerHandle qmh = qm.getConnectionHandle().getQueueManagerHandle(t);
            int i = 0;
            while (i < queueManagers.size()) {
                DmQueueManager qm1 = queueManagers.get(i);
                if (qm1.isClient(t) && !qm.equals(qm1)) {
                    QueueManagerHandle qmh1 = qm1.getConnectionHandle().getQueueManagerHandle(t);
                    if (qmh.getQueueManagerName().equals(qmh1.getQueueManagerName()) && qmh.getConnectionName().equals(qmh1.getConnectionName())) {
                        retValue = true;
                        break;
                    }
                }
                ++i;
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enableFips(Trace t, int fips) {
        Object object = lookupLock;
        synchronized (object) {
            int i = 0;
            while (i < queueManagers.size()) {
                DmQueueManagerHandle qmh1;
                Attr attr;
                DmQueueManager qm1 = queueManagers.get(i);
                if (!qm1.isLocal(t) && (attr = (qmh1 = qm1.getConnectionHandle()).getAttribute(t, 11021, 0)) != null) {
                    Object job = qmh1.beginUpdate(t);
                    qmh1.setAttributeValue(t, job, 11021, 0, fips, false);
                    qmh1.actionChange(t, null, job, false);
                }
                ++i;
            }
        }
    }
}

