/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.objects.DmObject;

public class ConvertReasonCode {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/utils/ConvertReasonCode.java";
    public static final String GENERIC_MESSAGE = "AMQ4999";

    private ConvertReasonCode() {
    }

    public static String getSystemMessage(Trace t, DmObject object, int command, int reasonCode, int compCode) {
        return ConvertReasonCode.getSystemMessage(t, object.getTitle(), command, reasonCode, compCode);
    }

    public static String getSystemMessage(Trace t, String name, int command, int reasonCode, int compCode) {
        String message = null;
        String[] inserts = null;
        String messageId = CommonServices.getSystemMessageId((Trace)t, (int)reasonCode);
        if (messageId.equalsIgnoreCase("AMQ4043")) {
            message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4043", (String)String.valueOf(reasonCode));
        } else if (messageId.equalsIgnoreCase("AMQ4059")) {
            message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4059", (String)String.valueOf(reasonCode));
        } else if (messageId.equalsIgnoreCase("RC_" + reasonCode) || messageId.equalsIgnoreCase(GENERIC_MESSAGE)) {
            message = CommonServices.getSystemMessage((Trace)t, (String)GENERIC_MESSAGE, (String)String.valueOf(reasonCode));
        } else {
            switch (reasonCode) {
                case 3007: {
                    inserts = new String[]{String.valueOf(command), name};
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                    break;
                }
                case 3242: 
                case 3243: 
                case 3247: {
                    inserts = new String[]{name};
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                    break;
                }
                case 2278: 
                case 2322: 
                case 2397: {
                    inserts = new String[]{name};
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                    break;
                }
                case 2195: {
                    inserts = new String[]{String.valueOf(reasonCode)};
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                    break;
                }
                case 2092: {
                    inserts = new String[]{String.valueOf(reasonCode)};
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                    break;
                }
                case 2051: {
                    inserts = new String[]{command == 16 ? "SYSTEM.INTER.QMGR.FANREQ" : "SYSTEM.ADMIN.COMMAND.QUEUE"};
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                    break;
                }
                case 3021: {
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId);
                    break;
                }
                case 2162: {
                    inserts = new String[]{name};
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                    break;
                }
                default: {
                    message = CommonServices.getSystemMessage((Trace)t, (String)messageId);
                }
            }
        }
        return message;
    }
}

