/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.exits.MQCD;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.internal.MQCommonServices;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.internal.CCDT;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ChannelTable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/utils/ChannelTable.java";
    private URL url = null;
    public static final String URL_ERROR = "AMQ4586";
    public static final String IO_ERROR = "AMQ4587";

    public ChannelTable(Trace t, String channelFile) throws DmCoreException {
        String fid = "ChannelTable.constructor";
        try {
            File file = new File(channelFile);
            this.url = file.toURL();
            if (Trace.isTracing) {
                t.data(65, fid, 300, "URL: " + this.url.getFile());
            }
        }
        catch (IOException e) {
            String txt = CommonServices.getSystemMessage((Trace)t, (String)URL_ERROR, (String)channelFile);
            DmCoreException ce = new DmCoreException(txt, e, URL_ERROR, 50032, 0, 40);
            t.FFST(65, fid, 10, 50032, 0, 0, "Failed to create channel table URL from '" + channelFile + "' - " + e.getMessage(), null, null);
            throw ce;
        }
    }

    public int load(Trace t) throws DmCoreException {
        String fid = "ChannelTable.load";
        CCDT ccdt = null;
        JmqiSystemEnvironment spiJmqiEnv = null;
        MQCD[] allChannels = null;
        if (Trace.isTracing) {
            t.data(65, fid, 300, "ClientConnectionTable: " + this.url);
        }
        spiJmqiEnv = (JmqiSystemEnvironment)MQCommonServices.jmqiEnv;
        try {
            ccdt = spiJmqiEnv.newCCDT(this.url);
        }
        catch (JmqiException e) {
            String txt = CommonServices.getSystemMessage((Trace)t, (String)IO_ERROR, (String)this.url.toString());
            DmCoreException ce = new DmCoreException(txt, e, IO_ERROR, 50033, 0, 40);
            t.FFST(65, fid, 10, 50033, 0, 0, "Failed to get channel table using URL: " + this.url + " - " + e.getMessage(), null, null);
            throw ce;
        }
        try {
            allChannels = ccdt.getChannels("*", 2);
        }
        catch (JmqiException e) {
            String txt = CommonServices.getSystemMessage((Trace)t, (String)IO_ERROR, (String)this.url.toString());
            DmCoreException ce = new DmCoreException(txt, e, IO_ERROR, 50033, 0, 40);
            t.FFST(65, fid, 10, 50033, 0, 0, "Failed to get channels from " + this.url + " - " + e.getMessage(), null, null);
            throw ce;
        }
        if (Trace.isTracing) {
            int i = 0;
            while (i < allChannels.length) {
                t.data(65, fid, 300, "CCDT Information:");
                ++i;
            }
        }
        return 0;
    }

    public URL getURL(Trace t) {
        return this.url;
    }
}

