/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.ssl;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.passwords.internal.utils.PwUtils;
import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class DmSSLSocketFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/ssl/DmSSLSocketFactory.java";
    private static final String KEY_STORE_TYPE = "JKS";
    private static final String JCE_PLUS_FIPS_PROVIDER = "com.ibm.crypto.plus.provider.IBMJCEPlusFIPS";
    private static final String JCE_FIPS_PROVIDER = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static final Class<JmqiUtils> LOADING_CLASS = JmqiUtils.class;
    private static final String KEY_STORE_NOT_FOUND = "AMQ4596";
    private static final String KEY_STORE_TYPE_NOT_AVAIL = "AMQ4199";
    private static final String KEY_STORE_NO_CERTS_LOADED = "AMQ4597";
    private static final String KEY_STORE_ALGORITHM_NOT_FOUND = "AMQ4199";
    private static final String KEY_STORE_PASSWORD_ERROR = "AMQ4598";
    private static final String KEY_STORE_FORMAT_ERROR = "AMQ4598";
    private static final String KEY_MANAGER_FACTORY_ERROR = "AMQ4199";
    private static final String TRUST_MANAGER_FACTORY_ERROR = "AMQ4199";
    private static final String SSL_CONTEXT_ERROR = "AMQ4199";
    private KeyStore personalKeyStore = null;
    private KeyStore trustedKeyStore = null;
    private FileInputStream personalStoreInput = null;
    private FileInputStream trustedStoreInput = null;
    private TrustManagerFactory trustedManagerFactory = null;
    private KeyManagerFactory personalManagerFactory = null;
    private SSLContext sslContext = null;
    private SSLSocketFactory sslSocketFactory = null;
    private Provider provider = null;

    public DmSSLSocketFactory(Trace t, String qmgr, String personalStoreFile, String personalStorePassword, String trustedStoreFile, String trustedStorePassword, int fips, String sslCipherSuite) throws DmCoreException {
        try {
            try {
                if (fips != 1 || !CommonServices.isSSLFIPSSupported()) {
                    this.provider = SSLContext.getDefault().getProvider();
                } else {
                    Class<?> providerClass = Class.forName("com.ibm.jsse2.IBMJSSEProvider2");
                    this.provider = (Provider)providerClass.newInstance();
                    Class cls = null;
                    cls = Security.getProvider("IBMJCEPlusFIPS") != null ? CSSystem.dynamicLoadClass((String)JCE_PLUS_FIPS_PROVIDER, LOADING_CLASS) : CSSystem.dynamicLoadClass((String)JCE_FIPS_PROVIDER, LOADING_CLASS);
                    Provider p = (Provider)cls.newInstance();
                    Security.insertProviderAt(p, 1);
                }
                String sslProtocol = this.getProtocol(sslCipherSuite, fips);
                if (personalStoreFile != null && !personalStoreFile.equals("")) {
                    try {
                        this.personalKeyStore = KeyStore.getInstance(KEY_STORE_TYPE);
                        this.personalStoreInput = new FileInputStream(personalStoreFile);
                        if (personalStorePassword == null || personalStorePassword.equals("")) {
                            this.personalKeyStore.load(this.personalStoreInput, null);
                        } else {
                            this.personalKeyStore.load(this.personalStoreInput, personalStorePassword.toCharArray());
                        }
                    }
                    catch (KeyStoreException e) {
                        throw this.createException(t, e, "AMQ4199", qmgr);
                    }
                    catch (FileNotFoundException e) {
                        throw this.createException(t, e, KEY_STORE_NOT_FOUND, PwUtils.formatPasswordStoreName((String)personalStoreFile));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw this.createException(t, e, "AMQ4199", qmgr);
                    }
                    catch (CertificateException e) {
                        throw this.createException(t, e, KEY_STORE_NO_CERTS_LOADED, PwUtils.formatPasswordStoreName((String)personalStoreFile));
                    }
                    catch (IOException e) {
                        throw this.createException(t, e, "AMQ4598", PwUtils.formatPasswordStoreName((String)personalStoreFile));
                    }
                    try {
                        this.personalManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm(), this.provider);
                        this.personalManagerFactory.init(this.personalKeyStore, personalStorePassword.toCharArray());
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw this.createException(t, e, "AMQ4199", qmgr);
                    }
                    catch (KeyStoreException e) {
                        throw this.createException(t, e, "AMQ4199", qmgr);
                    }
                    catch (UnrecoverableKeyException e) {
                        throw this.createException(t, e, "AMQ4598", PwUtils.formatPasswordStoreName((String)personalStoreFile));
                    }
                }
                try {
                    this.trustedKeyStore = KeyStore.getInstance(KEY_STORE_TYPE);
                    this.trustedStoreInput = new FileInputStream(trustedStoreFile);
                    if (trustedStorePassword == null || trustedStorePassword.equals("")) {
                        this.trustedKeyStore.load(this.trustedStoreInput, null);
                    } else {
                        this.trustedKeyStore.load(this.trustedStoreInput, trustedStorePassword.toCharArray());
                    }
                }
                catch (KeyStoreException e) {
                    throw this.createException(t, e, "AMQ4199", qmgr);
                }
                catch (FileNotFoundException e) {
                    throw this.createException(t, e, KEY_STORE_NOT_FOUND, PwUtils.formatPasswordStoreName((String)trustedStoreFile));
                }
                catch (NoSuchAlgorithmException e) {
                    throw this.createException(t, e, "AMQ4199", qmgr);
                }
                catch (CertificateException e) {
                    throw this.createException(t, e, KEY_STORE_NO_CERTS_LOADED, PwUtils.formatPasswordStoreName((String)trustedStoreFile));
                }
                catch (IOException e) {
                    throw this.createException(t, e, "AMQ4598", PwUtils.formatPasswordStoreName((String)trustedStoreFile));
                }
                try {
                    this.trustedManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), this.provider);
                    this.trustedManagerFactory.init(this.trustedKeyStore);
                }
                catch (NoSuchAlgorithmException e) {
                    throw this.createException(t, e, "AMQ4199", qmgr);
                }
                catch (KeyStoreException e) {
                    throw this.createException(t, e, "AMQ4199", qmgr);
                }
                try {
                    this.sslContext = SSLContext.getInstance(sslProtocol, this.provider);
                    if (this.personalManagerFactory != null) {
                        this.sslContext.init(this.personalManagerFactory.getKeyManagers(), this.trustedManagerFactory.getTrustManagers(), null);
                    } else {
                        this.sslContext.init(null, this.trustedManagerFactory.getTrustManagers(), null);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw this.createException(t, e, "AMQ4199", qmgr);
                }
                catch (KeyManagementException e) {
                    throw this.createException(t, e, "AMQ4199", qmgr);
                }
                this.sslSocketFactory = this.sslContext.getSocketFactory();
            }
            catch (DmCoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.createException(t, e, "AMQ4199", qmgr);
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.trustedStoreInput != null) {
                    this.trustedStoreInput.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.personalStoreInput != null) {
                    this.personalStoreInput.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (this.trustedStoreInput != null) {
                this.trustedStoreInput.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.personalStoreInput != null) {
                this.personalStoreInput.close();
            }
        }
        catch (IOException iOException) {}
    }

    private String getProtocol(String sslCipherSuite, int fips) {
        String protocol = "TLSv1.2";
        if (!sslCipherSuite.equals("")) {
            boolean fipsRequired = false;
            if (fips != 0) {
                fipsRequired = CommonServices.isSSLFIPSSupported();
            }
            String sslCipherSpec = JmqiUtils.toCipherSpec((String)sslCipherSuite, (boolean)fipsRequired);
            protocol = JmqiUtils.getProtocol((String)sslCipherSpec);
        }
        return protocol;
    }

    public TrustManagerFactory getTrustedManagerFactory() {
        return this.trustedManagerFactory;
    }

    public KeyManagerFactory getPersonalManagerFactory() {
        return this.personalManagerFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    private DmCoreException createException(Trace t, Exception e, String messageId, String insert) {
        DmCoreException ex = null;
        String message = null;
        message = insert == null ? CommonServices.getSystemMessage((Trace)t, (String)messageId) : CommonServices.getSystemMessage((Trace)t, (String)messageId, (String)insert);
        ex = new DmCoreException(t, message, e, messageId, 2393, 2, 30);
        return ex;
    }
}

