/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.report;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.report.IReportListener;
import com.ibm.mq.explorer.core.internal.report.ReportEvent;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFQuery;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReportManager
extends Thread {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/report/ReportManager.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    private static final String MY_NAME = "IBM MQ Explorer ReportManager";
    private static final String ALL = "*";
    private static boolean closing = false;
    private static boolean open = false;
    private static int refreshInterval = 60000;
    private Hashtable<Integer, ReportEvent> stack = new Hashtable();
    private int itemCounter = 0;
    private static ReportManager reportManager = null;
    private static Hashtable<IReportListener, String> listeners = new Hashtable();

    private ReportManager(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "ReportManager.ReportManager", 300, "New ReportManager created");
        }
        this.setDaemon(true);
        this.setName(MY_NAME);
        this.start();
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        open = true;
        while (!closing) {
            block5: {
                try {
                    Thread.sleep(refreshInterval);
                }
                catch (InterruptedException interruptedException) {
                    if (!Trace.isTracing) break block5;
                    t.data(65, "ReportManager.run", 900, "ReportManager interrupted");
                }
            }
            if (Trace.isTracing) {
                t.data(65, "ReportManager.run", 900, "ReportManager checking for work");
            }
            this.processStack(t);
            if (closing) break;
        }
        listeners.clear();
        this.stack.clear();
        open = false;
        reportManager = null;
        if (Trace.isTracing) {
            t.data(65, "ReportManager.run", 300, "ReportManager ended");
        }
    }

    public boolean add(Trace t, String qmName, PCFMessage command) {
        boolean add;
        boolean bl = add = open && listeners.size() > 0;
        if (add) {
            this.stack.put(this.itemCounter++, new ReportEvent(this, qmName, 0, command));
        }
        return add;
    }

    public boolean add(Trace t, String qmName, PCFQuery query) {
        boolean add;
        boolean bl = add = open && listeners.size() > 0;
        if (add) {
            this.stack.put(this.itemCounter++, new ReportEvent(this, qmName, 0, query.createPCFRequest(true)));
        }
        return add;
    }

    public void close(Trace t) {
        closing = true;
        reportManager.interrupt();
    }

    public void wakeup() {
        if (reportManager != null) {
            reportManager.interrupt();
        }
    }

    private void processStack(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "ReportManager.processStack", 300, "ReportManager processing " + this.stack.size() + " items");
        }
        Enumeration<Integer> en = this.stack.keys();
        while (en.hasMoreElements()) {
            Integer key = en.nextElement();
            ReportEvent event = this.stack.get(key);
            this.stack.remove(key);
            this.notifyListeners(t, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Trace t, ReportEvent event) {
        Hashtable<IReportListener, String> hashtable = listeners;
        synchronized (hashtable) {
            if (listeners.size() > 0) {
                Enumeration<IReportListener> en = listeners.keys();
                while (en.hasMoreElements()) {
                    IReportListener key = en.nextElement();
                    key.actionReport(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addListener(IReportListener rl) {
        if (open) {
            Hashtable<IReportListener, String> hashtable = listeners;
            synchronized (hashtable) {
                listeners.put(rl, ALL);
            }
        }
        return open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addListener(String qm, IReportListener rl) {
        if (open) {
            Hashtable<IReportListener, String> hashtable = listeners;
            synchronized (hashtable) {
                listeners.put(rl, qm);
            }
        }
        return open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(IReportListener rl) {
        Hashtable<IReportListener, String> hashtable = listeners;
        synchronized (hashtable) {
            listeners.remove(rl);
        }
    }

    public static ReportManager getDefault() {
        if (reportManager == null) {
            reportManager = new ReportManager(Trace.getInstance());
        }
        return reportManager;
    }

    public static void setRefreshInterval(int i) {
        refreshInterval = i;
        ReportManager.getDefault().wakeup();
    }
}

